% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipelines.R
\name{mlr_graphs_survtoclassif_IPCW}
\alias{mlr_graphs_survtoclassif_IPCW}
\alias{pipeline_survtoclassif_IPCW}
\title{Survival to Classification Reduction using IPCW Pipeline}
\usage{
pipeline_survtoclassif_IPCW(
  learner,
  tau = NULL,
  eps = 0.001,
  graph_learner = FALSE
)
}
\arguments{
\item{learner}{\link[mlr3:LearnerClassif]{LearnerClassif}\cr
Classification learner to fit the transformed \link[mlr3:TaskClassif]{TaskClassif}.}

\item{tau}{(\code{numeric()})\cr
Predefined time point for IPCW. Observations with time larger than \eqn{\tau} are censored.
Must be less or equal to the maximum event time.}

\item{eps}{(\code{numeric()})\cr
Small value to replace \eqn{G(t) = 0} censoring probabilities to prevent infinite
weights (a warning is triggered if this happens).}

\item{graph_learner}{(\code{logical(1)})\cr
If \code{TRUE} returns wraps the \link[mlr3pipelines:Graph]{Graph} as a
\link[mlr3pipelines:mlr_learners_graph]{GraphLearner} otherwise (default) returns as a \code{Graph}.}
}
\value{
\link[mlr3pipelines:Graph]{mlr3pipelines::Graph} or \link[mlr3pipelines:mlr_learners_graph]{mlr3pipelines::GraphLearner}
}
\description{
Wrapper around \link{PipeOpTaskSurvClassifIPCW} and \link{PipeOpPredClassifSurvIPCW} to simplify \link[mlr3pipelines:Graph]{Graph} creation.
}
\details{
The pipeline consists of the following steps:
\enumerate{
\item \link{PipeOpTaskSurvClassifIPCW} Converts \link{TaskSurv} to a \link[mlr3:TaskClassif]{TaskClassif}.
\item A \link{LearnerClassif} is fit and predicted on the new \code{TaskClassif}.
\item \link{PipeOpPredClassifSurvIPCW} transforms the resulting \link[mlr3:PredictionClassif]{PredictionClassif}
to \link{PredictionSurv}.
}
}
\section{Dictionary}{

This \link[mlr3pipelines:Graph]{Graph} can be instantiated via the \link[mlr3misc:Dictionary]{dictionary}
\link[mlr3pipelines:mlr_graphs]{mlr_graphs} or with the associated sugar function \link[mlr3pipelines:ppl]{ppl()}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_graphs$get("survtoclassif_IPCW")
ppl("survtoclassif_IPCW")
}\if{html}{\out{</div>}}


Additional alias id for pipeline construction:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ppl("survtoclassif_vock")
}\if{html}{\out{</div>}}
}

\examples{
\dontshow{if (mlr3misc::require_namespaces(c("mlr3pipelines", "mlr3learners"), quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
  library(mlr3)
  library(mlr3learners)
  library(mlr3pipelines)

  task = tsk("lung")
  part = partition(task)

  grlrn = ppl(
    "survtoclassif_IPCW",
    learner = lrn("classif.rpart"),
    tau = 500, # Observations after 500 days are censored
    graph_learner = TRUE
  )
  grlrn$train(task, row_ids = part$train)
  pred = grlrn$predict(task, row_ids = part$test)
  pred # crank and distr at the cutoff time point included

  # score predictions
  pred$score() # C-index
  pred$score(msr("surv.brier", times = 500, integrated = FALSE)) # Brier score at tau
}
\dontshow{\}) # examplesIf}
}
\references{
Vock, M D, Wolfson, Julian, Bandyopadhyay, Sunayan, Adomavicius, Gediminas, Johnson, E P, Vazquez-Benitez, Gabriela, O'Connor, J P (2016).
\dQuote{Adapting machine learning techniques to censored time-to-event health record data: A general-purpose approach using inverse probability of censoring weighting.}
\emph{Journal of Biomedical Informatics}, \bold{61}, 119--131.
\doi{https://doi.org/10.1016/j.jbi.2016.03.009}, \url{https://www.sciencedirect.com/science/article/pii/S1532046416000496}.
}
\seealso{
Other pipelines: 
\code{\link{mlr_graphs_crankcompositor}},
\code{\link{mlr_graphs_distrcompositor}},
\code{\link{mlr_graphs_probregr}},
\code{\link{mlr_graphs_responsecompositor}},
\code{\link{mlr_graphs_survaverager}},
\code{\link{mlr_graphs_survbagging}},
\code{\link{mlr_graphs_survtoclassif_disctime}}
}
\concept{pipelines}
