/** does what is says on the tin */
export const ALL_NIST_FAMILIES: Readonly<string[]> = [
  "AC",
  "AP",
  "AR",
  "AT",
  "AU",
  "CA",
  "CM",
  "CP",
  "DI",
  "DM",
  "IA",
  "IP",
  "IR",
  "MA",
  "MP",
  "PE",
  "PL",
  "PM",
  "PS",
  "RA",
  "SA",
  "SC",
  "SE",
  "SI",
  "TR",
  "UL",
  "UM" // We added this - it is not official
];

export const ALL_NIST_CONTROL_NUMBERS: Readonly<string[]> = [
  "UM-1", // We added this - it is not official
  "AC-1",
  "AC-10",
  "AC-11",
  "AC-11 (1)",
  "AC-11a.",
  "AC-11b.",
  "AC-12",
  "AC-12 (1)",
  "AC-12 (1)(a)",
  "AC-12 (1)(b)",
  "AC-13",
  "AC-14",
  "AC-14 (1)",
  "AC-14a.",
  "AC-14b.",
  "AC-15",
  "AC-16",
  "AC-16 (1)",
  "AC-16 (10)",
  "AC-16 (2)",
  "AC-16 (3)",
  "AC-16 (4)",
  "AC-16 (5)",
  "AC-16 (6)",
  "AC-16 (7)",
  "AC-16 (8)",
  "AC-16 (9)",
  "AC-16a.",
  "AC-16b.",
  "AC-16c.",
  "AC-16d.",
  "AC-17",
  "AC-17 (1)",
  "AC-17 (2)",
  "AC-17 (3)",
  "AC-17 (4)",
  "AC-17 (4)(a)",
  "AC-17 (4)(b)",
  "AC-17 (5)",
  "AC-17 (6)",
  "AC-17 (7)",
  "AC-17 (8)",
  "AC-17 (9)",
  "AC-17a.",
  "AC-17b.",
  "AC-18",
  "AC-18 (1)",
  "AC-18 (2)",
  "AC-18 (3)",
  "AC-18 (4)",
  "AC-18 (5)",
  "AC-18a.",
  "AC-18b.",
  "AC-19",
  "AC-19 (1)",
  "AC-19 (2)",
  "AC-19 (3)",
  "AC-19 (4)",
  "AC-19 (4)(a)",
  "AC-19 (4)(b)",
  "AC-19 (4)(b)(1)",
  "AC-19 (4)(b)(2)",
  "AC-19 (4)(b)(3)",
  "AC-19 (4)(b)(4)",
  "AC-19 (4)(c)",
  "AC-19 (5)",
  "AC-19a.",
  "AC-19b.",
  "AC-1a.",
  "AC-1a.1.",
  "AC-1a.2.",
  "AC-1b.",
  "AC-1b.1.",
  "AC-1b.2.",
  "AC-2",
  "AC-2 (1)",
  "AC-2 (10)",
  "AC-2 (11)",
  "AC-2 (12)",
  "AC-2 (12)(a)",
  "AC-2 (12)(b)",
  "AC-2 (13)",
  "AC-2 (2)",
  "AC-2 (3)",
  "AC-2 (4)",
  "AC-2 (5)",
  "AC-2 (6)",
  "AC-2 (7)",
  "AC-2 (7)(a)",
  "AC-2 (7)(b)",
  "AC-2 (7)(c)",
  "AC-2 (8)",
  "AC-2 (9)",
  "AC-20",
  "AC-20 (1)",
  "AC-20 (1)(a)",
  "AC-20 (1)(b)",
  "AC-20 (2)",
  "AC-20 (3)",
  "AC-20 (4)",
  "AC-20a.",
  "AC-20b.",
  "AC-21",
  "AC-21 (1)",
  "AC-21 (2)",
  "AC-21a.",
  "AC-21b.",
  "AC-22",
  "AC-22a.",
  "AC-22b.",
  "AC-22c.",
  "AC-22d.",
  "AC-23",
  "AC-24",
  "AC-24 (1)",
  "AC-24 (2)",
  "AC-25",
  "AC-2a.",
  "AC-2b.",
  "AC-2c.",
  "AC-2d.",
  "AC-2e.",
  "AC-2f.",
  "AC-2g.",
  "AC-2h.",
  "AC-2h.1.",
  "AC-2h.2.",
  "AC-2h.3.",
  "AC-2i.",
  "AC-2i.1.",
  "AC-2i.2.",
  "AC-2i.3.",
  "AC-2j.",
  "AC-2k.",
  "AC-3",
  "AC-3 (1)",
  "AC-3 (10)",
  "AC-3 (2)",
  "AC-3 (3)",
  "AC-3 (3)(a)",
  "AC-3 (3)(b)",
  "AC-3 (3)(b)(1)",
  "AC-3 (3)(b)(2)",
  "AC-3 (3)(b)(3)",
  "AC-3 (3)(b)(4)",
  "AC-3 (3)(b)(5)",
  "AC-3 (3)(c)",
  "AC-3 (4)",
  "AC-3 (4)(a)",
  "AC-3 (4)(b)",
  "AC-3 (4)(c)",
  "AC-3 (4)(d)",
  "AC-3 (4)(e)",
  "AC-3 (5)",
  "AC-3 (6)",
  "AC-3 (7)",
  "AC-3 (8)",
  "AC-3 (9)",
  "AC-3 (9)(a)",
  "AC-3 (9)(b)",
  "AC-4",
  "AC-4 (1)",
  "AC-4 (10)",
  "AC-4 (11)",
  "AC-4 (12)",
  "AC-4 (13)",
  "AC-4 (14)",
  "AC-4 (15)",
  "AC-4 (16)",
  "AC-4 (17)",
  "AC-4 (18)",
  "AC-4 (19)",
  "AC-4 (2)",
  "AC-4 (20)",
  "AC-4 (21)",
  "AC-4 (22)",
  "AC-4 (3)",
  "AC-4 (4)",
  "AC-4 (5)",
  "AC-4 (6)",
  "AC-4 (7)",
  "AC-4 (8)",
  "AC-4 (9)",
  "AC-5",
  "AC-5a.",
  "AC-5b.",
  "AC-5c.",
  "AC-6",
  "AC-6 (1)",
  "AC-6 (10)",
  "AC-6 (2)",
  "AC-6 (3)",
  "AC-6 (4)",
  "AC-6 (5)",
  "AC-6 (6)",
  "AC-6 (7)",
  "AC-6 (7)(a)",
  "AC-6 (7)(b)",
  "AC-6 (8)",
  "AC-6 (9)",
  "AC-7",
  "AC-7 (1)",
  "AC-7 (2)",
  "AC-7a.",
  "AC-7b.",
  "AC-8",
  "AC-8a.",
  "AC-8a.1.",
  "AC-8a.2.",
  "AC-8a.3.",
  "AC-8a.4.",
  "AC-8b.",
  "AC-8c.",
  "AC-8c.1.",
  "AC-8c.2.",
  "AC-8c.3.",
  "AC-9",
  "AC-9 (1)",
  "AC-9 (2)",
  "AC-9 (3)",
  "AC-9 (4)",
  "AP-1",
  "AP-2",
  "AR-1",
  "AR-1a.",
  "AR-1b.",
  "AR-1c.",
  "AR-1d.",
  "AR-1e.",
  "AR-1f.",
  "AR-2",
  "AR-2a.",
  "AR-2b.",
  "AR-3",
  "AR-3a.",
  "AR-3b.",
  "AR-4",
  "AR-5",
  "AR-5a.",
  "AR-5b.",
  "AR-5c.",
  "AR-6",
  "AR-7",
  "AR-8",
  "AR-8a.",
  "AR-8a.1.",
  "AR-8a.2.",
  "AR-8b.",
  "AR-8c.",
  "AT-1",
  "AT-1a.",
  "AT-1a.1.",
  "AT-1a.2.",
  "AT-1b.",
  "AT-1b.1.",
  "AT-1b.2.",
  "AT-2",
  "AT-2 (1)",
  "AT-2 (2)",
  "AT-2a.",
  "AT-2b.",
  "AT-2c.",
  "AT-3",
  "AT-3 (1)",
  "AT-3 (2)",
  "AT-3 (3)",
  "AT-3 (4)",
  "AT-3a.",
  "AT-3b.",
  "AT-3c.",
  "AT-4",
  "AT-4a.",
  "AT-4b.",
  "AT-5",
  "AU-1",
  "AU-10",
  "AU-10 (1)",
  "AU-10 (1)(a)",
  "AU-10 (1)(b)",
  "AU-10 (2)",
  "AU-10 (2)(a)",
  "AU-10 (2)(b)",
  "AU-10 (3)",
  "AU-10 (4)",
  "AU-10 (4)(a)",
  "AU-10 (4)(b)",
  "AU-10 (5)",
  "AU-11",
  "AU-11 (1)",
  "AU-12",
  "AU-12 (1)",
  "AU-12 (2)",
  "AU-12 (3)",
  "AU-12a.",
  "AU-12b.",
  "AU-12c.",
  "AU-13",
  "AU-13 (1)",
  "AU-13 (2)",
  "AU-14",
  "AU-14 (1)",
  "AU-14 (2)",
  "AU-14 (3)",
  "AU-15",
  "AU-16",
  "AU-16 (1)",
  "AU-16 (2)",
  "AU-1a.",
  "AU-1a.1.",
  "AU-1a.2.",
  "AU-1b.",
  "AU-1b.1.",
  "AU-1b.2.",
  "AU-2",
  "AU-2 (1)",
  "AU-2 (2)",
  "AU-2 (3)",
  "AU-2 (4)",
  "AU-2a.",
  "AU-2b.",
  "AU-2c.",
  "AU-2d.",
  "AU-3",
  "AU-3 (1)",
  "AU-3 (2)",
  "AU-4",
  "AU-4 (1)",
  "AU-5",
  "AU-5 (1)",
  "AU-5 (2)",
  "AU-5 (3)",
  "AU-5 (4)",
  "AU-5a.",
  "AU-5b.",
  "AU-6",
  "AU-6 (1)",
  "AU-6 (10)",
  "AU-6 (2)",
  "AU-6 (3)",
  "AU-6 (4)",
  "AU-6 (5)",
  "AU-6 (6)",
  "AU-6 (7)",
  "AU-6 (8)",
  "AU-6 (9)",
  "AU-6a.",
  "AU-6b.",
  "AU-7",
  "AU-7 (1)",
  "AU-7 (2)",
  "AU-7a.",
  "AU-7b.",
  "AU-8",
  "AU-8 (1)",
  "AU-8 (1)(a)",
  "AU-8 (1)(b)",
  "AU-8 (2)",
  "AU-8a.",
  "AU-8b.",
  "AU-9",
  "AU-9 (1)",
  "AU-9 (2)",
  "AU-9 (3)",
  "AU-9 (4)",
  "AU-9 (5)",
  "AU-9 (6)",
  "CA-1",
  "CA-1a.",
  "CA-1a.1.",
  "CA-1a.2.",
  "CA-1b.",
  "CA-1b.1.",
  "CA-1b.2.",
  "CA-2",
  "CA-2 (1)",
  "CA-2 (2)",
  "CA-2 (3)",
  "CA-2a.",
  "CA-2a.1.",
  "CA-2a.2.",
  "CA-2a.3.",
  "CA-2b.",
  "CA-2c.",
  "CA-2d.",
  "CA-3",
  "CA-3 (1)",
  "CA-3 (2)",
  "CA-3 (3)",
  "CA-3 (4)",
  "CA-3 (5)",
  "CA-3a.",
  "CA-3b.",
  "CA-3c.",
  "CA-4",
  "CA-5",
  "CA-5 (1)",
  "CA-5a.",
  "CA-5b.",
  "CA-6",
  "CA-6a.",
  "CA-6b.",
  "CA-6c.",
  "CA-7",
  "CA-7 (1)",
  "CA-7 (2)",
  "CA-7 (3)",
  "CA-7a.",
  "CA-7b.",
  "CA-7c.",
  "CA-7d.",
  "CA-7e.",
  "CA-7f.",
  "CA-7g.",
  "CA-8",
  "CA-8 (1)",
  "CA-8 (2)",
  "CA-9",
  "CA-9 (1)",
  "CA-9a.",
  "CA-9b.",
  "CM-1",
  "CM-10",
  "CM-10 (1)",
  "CM-10a.",
  "CM-10b.",
  "CM-10c.",
  "CM-11",
  "CM-11 (1)",
  "CM-11 (2)",
  "CM-11a.",
  "CM-11b.",
  "CM-11c.",
  "CM-1a.",
  "CM-1a.1.",
  "CM-1a.2.",
  "CM-1b.",
  "CM-1b.1.",
  "CM-1b.2.",
  "CM-2",
  "CM-2 (1)",
  "CM-2 (1)(a)",
  "CM-2 (1)(b)",
  "CM-2 (1)(c)",
  "CM-2 (2)",
  "CM-2 (3)",
  "CM-2 (4)",
  "CM-2 (5)",
  "CM-2 (6)",
  "CM-2 (7)",
  "CM-2 (7)(a)",
  "CM-2 (7)(b)",
  "CM-3",
  "CM-3 (1)",
  "CM-3 (1)(a)",
  "CM-3 (1)(b)",
  "CM-3 (1)(c)",
  "CM-3 (1)(d)",
  "CM-3 (1)(e)",
  "CM-3 (1)(f)",
  "CM-3 (2)",
  "CM-3 (3)",
  "CM-3 (4)",
  "CM-3 (5)",
  "CM-3 (6)",
  "CM-3a.",
  "CM-3b.",
  "CM-3c.",
  "CM-3d.",
  "CM-3e.",
  "CM-3f.",
  "CM-3g.",
  "CM-4",
  "CM-4 (1)",
  "CM-4 (2)",
  "CM-5",
  "CM-5 (1)",
  "CM-5 (2)",
  "CM-5 (3)",
  "CM-5 (4)",
  "CM-5 (5)",
  "CM-5 (5)(a)",
  "CM-5 (5)(b)",
  "CM-5 (6)",
  "CM-5 (7)",
  "CM-6",
  "CM-6 (1)",
  "CM-6 (2)",
  "CM-6 (3)",
  "CM-6 (4)",
  "CM-6a.",
  "CM-6b.",
  "CM-6c.",
  "CM-6d.",
  "CM-7",
  "CM-7 (1)",
  "CM-7 (1)(a)",
  "CM-7 (1)(b)",
  "CM-7 (2)",
  "CM-7 (3)",
  "CM-7 (4)",
  "CM-7 (4)(a)",
  "CM-7 (4)(b)",
  "CM-7 (4)(c)",
  "CM-7 (5)",
  "CM-7 (5)(a)",
  "CM-7 (5)(b)",
  "CM-7 (5)(c)",
  "CM-7a.",
  "CM-7b.",
  "CM-8",
  "CM-8 (1)",
  "CM-8 (2)",
  "CM-8 (3)",
  "CM-8 (3)(a)",
  "CM-8 (3)(b)",
  "CM-8 (4)",
  "CM-8 (5)",
  "CM-8 (6)",
  "CM-8 (7)",
  "CM-8 (8)",
  "CM-8 (9)",
  "CM-8 (9)(a)",
  "CM-8 (9)(b)",
  "CM-8a.",
  "CM-8a.1.",
  "CM-8a.2.",
  "CM-8a.3.",
  "CM-8a.4.",
  "CM-8b.",
  "CM-9",
  "CM-9 (1)",
  "CM-9a.",
  "CM-9b.",
  "CM-9c.",
  "CM-9d.",
  "CP-1",
  "CP-10",
  "CP-10 (1)",
  "CP-10 (2)",
  "CP-10 (3)",
  "CP-10 (4)",
  "CP-10 (5)",
  "CP-10 (6)",
  "CP-11",
  "CP-12",
  "CP-13",
  "CP-1a.",
  "CP-1a.1.",
  "CP-1a.2.",
  "CP-1b.",
  "CP-1b.1.",
  "CP-1b.2.",
  "CP-2",
  "CP-2 (1)",
  "CP-2 (2)",
  "CP-2 (3)",
  "CP-2 (4)",
  "CP-2 (5)",
  "CP-2 (6)",
  "CP-2 (7)",
  "CP-2 (8)",
  "CP-2a.",
  "CP-2a.1.",
  "CP-2a.2.",
  "CP-2a.3.",
  "CP-2a.4.",
  "CP-2a.5.",
  "CP-2a.6.",
  "CP-2b.",
  "CP-2c.",
  "CP-2d.",
  "CP-2e.",
  "CP-2f.",
  "CP-2g.",
  "CP-3",
  "CP-3 (1)",
  "CP-3 (2)",
  "CP-3a.",
  "CP-3b.",
  "CP-3c.",
  "CP-4",
  "CP-4 (1)",
  "CP-4 (2)",
  "CP-4 (2)(a)",
  "CP-4 (2)(b)",
  "CP-4 (3)",
  "CP-4 (4)",
  "CP-4a.",
  "CP-4b.",
  "CP-4c.",
  "CP-5",
  "CP-6",
  "CP-6 (1)",
  "CP-6 (2)",
  "CP-6 (3)",
  "CP-6a.",
  "CP-6b.",
  "CP-7",
  "CP-7 (1)",
  "CP-7 (2)",
  "CP-7 (3)",
  "CP-7 (4)",
  "CP-7 (5)",
  "CP-7 (6)",
  "CP-7a.",
  "CP-7b.",
  "CP-7c.",
  "CP-8",
  "CP-8 (1)",
  "CP-8 (1)(a)",
  "CP-8 (1)(b)",
  "CP-8 (2)",
  "CP-8 (3)",
  "CP-8 (4)",
  "CP-8 (4)(a)",
  "CP-8 (4)(b)",
  "CP-8 (4)(c)",
  "CP-8 (5)",
  "CP-9",
  "CP-9 (1)",
  "CP-9 (2)",
  "CP-9 (3)",
  "CP-9 (4)",
  "CP-9 (5)",
  "CP-9 (6)",
  "CP-9 (7)",
  "CP-9a.",
  "CP-9b.",
  "CP-9c.",
  "CP-9d.",
  "DI-1",
  "DI-1a.",
  "DI-1b.",
  "DI-1c.",
  "DI-1d.",
  "DI-1 (1)",
  "DI-1 (2)",
  "DI-2",
  "DI-2a.",
  "DI-2b.",
  "DI-2 (1)",
  "DM-1",
  "DM-1a.",
  "DM-1b.",
  "DM-1c.",
  "DM-1 (1)",
  "DM-2",
  "DM-2a.",
  "DM-2b.",
  "DM-2c.",
  "DM-2 (1)",
  "DM-3",
  "DM-3a.",
  "DM-3b.",
  "DM-3 (1)",
  "IA-1",
  "IA-10",
  "IA-11",
  "IA-1a.",
  "IA-1a.1.",
  "IA-1a.2.",
  "IA-1b.",
  "IA-1b.1.",
  "IA-1b.2.",
  "IA-2",
  "IA-2 (1)",
  "IA-2 (10)",
  "IA-2 (11)",
  "IA-2 (12)",
  "IA-2 (13)",
  "IA-2 (2)",
  "IA-2 (3)",
  "IA-2 (4)",
  "IA-2 (5)",
  "IA-2 (6)",
  "IA-2 (7)",
  "IA-2 (8)",
  "IA-2 (9)",
  "IA-3",
  "IA-3 (1)",
  "IA-3 (2)",
  "IA-3 (3)",
  "IA-3 (3)(a)",
  "IA-3 (3)(b)",
  "IA-3 (4)",
  "IA-4",
  "IA-4 (1)",
  "IA-4 (2)",
  "IA-4 (3)",
  "IA-4 (4)",
  "IA-4 (5)",
  "IA-4 (6)",
  "IA-4 (7)",
  "IA-4a.",
  "IA-4b.",
  "IA-4c.",
  "IA-4d.",
  "IA-4e.",
  "IA-5",
  "IA-5 (1)",
  "IA-5 (1)(a)",
  "IA-5 (1)(b)",
  "IA-5 (1)(c)",
  "IA-5 (1)(d)",
  "IA-5 (1)(e)",
  "IA-5 (1)(f)",
  "IA-5 (10)",
  "IA-5 (11)",
  "IA-5 (12)",
  "IA-5 (13)",
  "IA-5 (14)",
  "IA-5 (15)",
  "IA-5 (2)",
  "IA-5 (2)(a)",
  "IA-5 (2)(b)",
  "IA-5 (2)(c)",
  "IA-5 (2)(d)",
  "IA-5 (3)",
  "IA-5 (4)",
  "IA-5 (5)",
  "IA-5 (6)",
  "IA-5 (7)",
  "IA-5 (8)",
  "IA-5 (9)",
  "IA-5a.",
  "IA-5b.",
  "IA-5c.",
  "IA-5d.",
  "IA-5e.",
  "IA-5f.",
  "IA-5g.",
  "IA-5h.",
  "IA-5i.",
  "IA-5j.",
  "IA-6",
  "IA-7",
  "IA-8",
  "IA-8 (1)",
  "IA-8 (2)",
  "IA-8 (3)",
  "IA-8 (4)",
  "IA-8 (5)",
  "IA-9",
  "IA-9 (1)",
  "IA-9 (2)",
  "IP-1",
  "IP-1a.",
  "IP-1b.",
  "IP-1c.",
  "IP-1d.",
  "IP-1 (1)",
  "IP-2",
  "IP-2a.",
  "IP-2b.",
  "IP-2c.",
  "IP-2d.",
  "IP-3",
  "IP-3a.",
  "IP-3b.",
  "IP-4",
  "IP-4 (1)",
  "IR-1",
  "IR-10",
  "IR-1a.",
  "IR-1a.1.",
  "IR-1a.2.",
  "IR-1b.",
  "IR-1b.1.",
  "IR-1b.2.",
  "IR-2",
  "IR-2 (1)",
  "IR-2 (2)",
  "IR-2a.",
  "IR-2b.",
  "IR-2c.",
  "IR-3",
  "IR-3 (1)",
  "IR-3 (2)",
  "IR-4",
  "IR-4 (1)",
  "IR-4 (10)",
  "IR-4 (2)",
  "IR-4 (3)",
  "IR-4 (4)",
  "IR-4 (5)",
  "IR-4 (6)",
  "IR-4 (7)",
  "IR-4 (8)",
  "IR-4 (9)",
  "IR-4a.",
  "IR-4b.",
  "IR-4c.",
  "IR-5",
  "IR-5 (1)",
  "IR-6",
  "IR-6 (1)",
  "IR-6 (2)",
  "IR-6 (3)",
  "IR-6a.",
  "IR-6b.",
  "IR-7",
  "IR-7 (1)",
  "IR-7 (2)",
  "IR-7 (2)(a)",
  "IR-7 (2)(b)",
  "IR-8",
  "IR-8a.",
  "IR-8a.1.",
  "IR-8a.2.",
  "IR-8a.3.",
  "IR-8a.4.",
  "IR-8a.5.",
  "IR-8a.6.",
  "IR-8a.7.",
  "IR-8a.8.",
  "IR-8b.",
  "IR-8c.",
  "IR-8d.",
  "IR-8e.",
  "IR-8f.",
  "IR-9",
  "IR-9 (1)",
  "IR-9 (2)",
  "IR-9 (3)",
  "IR-9 (4)",
  "IR-9a.",
  "IR-9b.",
  "IR-9c.",
  "IR-9d.",
  "IR-9e.",
  "IR-9f.",
  "MA-1",
  "MA-1a.",
  "MA-1a.1.",
  "MA-1a.2.",
  "MA-1b.",
  "MA-1b.1.",
  "MA-1b.2.",
  "MA-2",
  "MA-2 (1)",
  "MA-2 (2)",
  "MA-2 (2)(a)",
  "MA-2 (2)(b)",
  "MA-2a.",
  "MA-2b.",
  "MA-2c.",
  "MA-2d.",
  "MA-2e.",
  "MA-2f.",
  "MA-3",
  "MA-3 (1)",
  "MA-3 (2)",
  "MA-3 (3)",
  "MA-3 (3)(a)",
  "MA-3 (3)(b)",
  "MA-3 (3)(c)",
  "MA-3 (3)(d)",
  "MA-3 (4)",
  "MA-4",
  "MA-4 (1)",
  "MA-4 (1)(a)",
  "MA-4 (1)(b)",
  "MA-4 (2)",
  "MA-4 (3)",
  "MA-4 (3)(a)",
  "MA-4 (3)(b)",
  "MA-4 (4)",
  "MA-4 (4)(a)",
  "MA-4 (4)(b)",
  "MA-4 (4)(b)(1)",
  "MA-4 (4)(b)(2)",
  "MA-4 (5)",
  "MA-4 (5)(a)",
  "MA-4 (5)(b)",
  "MA-4 (6)",
  "MA-4 (7)",
  "MA-4a.",
  "MA-4b.",
  "MA-4c.",
  "MA-4d.",
  "MA-4e.",
  "MA-5",
  "MA-5 (1)",
  "MA-5 (1)(a)",
  "MA-5 (1)(a)(1)",
  "MA-5 (1)(a)(2)",
  "MA-5 (1)(b)",
  "MA-5 (2)",
  "MA-5 (3)",
  "MA-5 (4)",
  "MA-5 (4)(a)",
  "MA-5 (4)(b)",
  "MA-5 (5)",
  "MA-5a.",
  "MA-5b.",
  "MA-5c.",
  "MA-6",
  "MA-6 (1)",
  "MA-6 (2)",
  "MA-6 (3)",
  "MP-1",
  "MP-1a.",
  "MP-1a.1.",
  "MP-1a.2.",
  "MP-1b.",
  "MP-1b.1.",
  "MP-1b.2.",
  "MP-2",
  "MP-2 (1)",
  "MP-2 (2)",
  "MP-3",
  "MP-3a.",
  "MP-3b.",
  "MP-4",
  "MP-4 (1)",
  "MP-4 (2)",
  "MP-4a.",
  "MP-4b.",
  "MP-5",
  "MP-5 (1)",
  "MP-5 (2)",
  "MP-5 (3)",
  "MP-5 (4)",
  "MP-5a.",
  "MP-5b.",
  "MP-5c.",
  "MP-5d.",
  "MP-6",
  "MP-6 (1)",
  "MP-6 (2)",
  "MP-6 (3)",
  "MP-6 (4)",
  "MP-6 (5)",
  "MP-6 (6)",
  "MP-6 (7)",
  "MP-6 (8)",
  "MP-6a.",
  "MP-6b.",
  "MP-7",
  "MP-7 (1)",
  "MP-7 (2)",
  "MP-8",
  "MP-8 (1)",
  "MP-8 (2)",
  "MP-8 (3)",
  "MP-8 (4)",
  "MP-8a.",
  "MP-8b.",
  "MP-8c.",
  "MP-8d.",
  "PE-1",
  "PE-10",
  "PE-10 (1)",
  "PE-10a.",
  "PE-10b.",
  "PE-10c.",
  "PE-11",
  "PE-11 (1)",
  "PE-11 (2)",
  "PE-11 (2)(a)",
  "PE-11 (2)(b)",
  "PE-11 (2)(c)",
  "PE-12",
  "PE-12 (1)",
  "PE-13",
  "PE-13 (1)",
  "PE-13 (2)",
  "PE-13 (3)",
  "PE-13 (4)",
  "PE-14",
  "PE-14 (1)",
  "PE-14 (2)",
  "PE-14a.",
  "PE-14b.",
  "PE-15",
  "PE-15 (1)",
  "PE-16",
  "PE-17",
  "PE-17a.",
  "PE-17b.",
  "PE-17c.",
  "PE-18",
  "PE-18 (1)",
  "PE-19",
  "PE-19 (1)",
  "PE-1a.",
  "PE-1a.1.",
  "PE-1a.2.",
  "PE-1b.",
  "PE-1b.1.",
  "PE-1b.2.",
  "PE-2",
  "PE-2 (1)",
  "PE-2 (2)",
  "PE-2 (3)",
  "PE-20",
  "PE-20a.",
  "PE-20b.",
  "PE-2a.",
  "PE-2b.",
  "PE-2c.",
  "PE-2d.",
  "PE-3",
  "PE-3 (1)",
  "PE-3 (2)",
  "PE-3 (3)",
  "PE-3 (4)",
  "PE-3 (5)",
  "PE-3 (6)",
  "PE-3a.",
  "PE-3a.1.",
  "PE-3a.2.",
  "PE-3b.",
  "PE-3c.",
  "PE-3d.",
  "PE-3e.",
  "PE-3f.",
  "PE-3g.",
  "PE-4",
  "PE-5",
  "PE-5 (1)",
  "PE-5 (1)(a)",
  "PE-5 (1)(b)",
  "PE-5 (2)",
  "PE-5 (2)(a)",
  "PE-5 (2)(b)",
  "PE-5 (3)",
  "PE-6",
  "PE-6 (1)",
  "PE-6 (2)",
  "PE-6 (3)",
  "PE-6 (4)",
  "PE-6a.",
  "PE-6b.",
  "PE-6c.",
  "PE-7",
  "PE-8",
  "PE-8 (1)",
  "PE-8 (2)",
  "PE-8a.",
  "PE-8b.",
  "PE-9",
  "PE-9 (1)",
  "PE-9 (2)",
  "PL-1",
  "PL-1a.",
  "PL-1a.1.",
  "PL-1a.2.",
  "PL-1b.",
  "PL-1b.1.",
  "PL-1b.2.",
  "PL-2",
  "PL-2 (1)",
  "PL-2 (2)",
  "PL-2 (3)",
  "PL-2a.",
  "PL-2a.1.",
  "PL-2a.2.",
  "PL-2a.3.",
  "PL-2a.4.",
  "PL-2a.5.",
  "PL-2a.6.",
  "PL-2a.7.",
  "PL-2a.8.",
  "PL-2a.9.",
  "PL-2b.",
  "PL-2c.",
  "PL-2d.",
  "PL-2e.",
  "PL-3",
  "PL-4",
  "PL-4 (1)",
  "PL-4a.",
  "PL-4b.",
  "PL-4c.",
  "PL-4d.",
  "PL-5",
  "PL-6",
  "PL-7",
  "PL-7a.",
  "PL-7b.",
  "PL-8",
  "PL-8 (1)",
  "PL-8 (1)(a)",
  "PL-8 (1)(b)",
  "PL-8 (2)",
  "PL-8a.",
  "PL-8a.1.",
  "PL-8a.2.",
  "PL-8a.3.",
  "PL-8b.",
  "PL-8c.",
  "PL-9",
  "PM-1",
  "PM-10",
  "PM-10a.",
  "PM-10b.",
  "PM-10c.",
  "PM-11",
  "PM-11a.",
  "PM-11b.",
  "PM-12",
  "PM-13",
  "PM-14",
  "PM-14a.",
  "PM-14a.1.",
  "PM-14a.2.",
  "PM-14b.",
  "PM-15",
  "PM-15a.",
  "PM-15b.",
  "PM-15c.",
  "PM-16",
  "PM-1a.",
  "PM-1a.1.",
  "PM-1a.2.",
  "PM-1a.3.",
  "PM-1a.4.",
  "PM-1b.",
  "PM-1c.",
  "PM-1d.",
  "PM-2",
  "PM-3",
  "PM-3a.",
  "PM-3b.",
  "PM-3c.",
  "PM-4",
  "PM-4a.",
  "PM-4a.1.",
  "PM-4a.2.",
  "PM-4a.3.",
  "PM-4b.",
  "PM-5",
  "PM-6",
  "PM-7",
  "PM-8",
  "PM-9",
  "PM-9a.",
  "PM-9b.",
  "PM-9c.",
  "PS-1",
  "PS-1a.",
  "PS-1a.1.",
  "PS-1a.2.",
  "PS-1b.",
  "PS-1b.1.",
  "PS-1b.2.",
  "PS-2",
  "PS-2a.",
  "PS-2b.",
  "PS-2c.",
  "PS-3",
  "PS-3 (1)",
  "PS-3 (2)",
  "PS-3 (3)",
  "PS-3 (3)(a)",
  "PS-3 (3)(b)",
  "PS-3a.",
  "PS-3b.",
  "PS-4",
  "PS-4 (1)",
  "PS-4 (1)(a)",
  "PS-4 (1)(b)",
  "PS-4 (2)",
  "PS-4a.",
  "PS-4b.",
  "PS-4c.",
  "PS-4d.",
  "PS-4e.",
  "PS-4f.",
  "PS-5",
  "PS-5a.",
  "PS-5b.",
  "PS-5c.",
  "PS-5d.",
  "PS-6",
  "PS-6 (1)",
  "PS-6 (2)",
  "PS-6 (2)(a)",
  "PS-6 (2)(b)",
  "PS-6 (2)(c)",
  "PS-6 (3)",
  "PS-6 (3)(a)",
  "PS-6 (3)(b)",
  "PS-6a.",
  "PS-6b.",
  "PS-6c.",
  "PS-6c.1.",
  "PS-6c.2.",
  "PS-7",
  "PS-7a.",
  "PS-7b.",
  "PS-7c.",
  "PS-7d.",
  "PS-7e.",
  "PS-8",
  "PS-8a.",
  "PS-8b.",
  "RA-1",
  "RA-1a.",
  "RA-1a.1.",
  "RA-1a.2.",
  "RA-1b.",
  "RA-1b.1.",
  "RA-1b.2.",
  "RA-2",
  "RA-2a.",
  "RA-2b.",
  "RA-2c.",
  "RA-3",
  "RA-3a.",
  "RA-3b.",
  "RA-3c.",
  "RA-3d.",
  "RA-3e.",
  "RA-4",
  "RA-5",
  "RA-5 (1)",
  "RA-5 (10)",
  "RA-5 (2)",
  "RA-5 (3)",
  "RA-5 (4)",
  "RA-5 (5)",
  "RA-5 (6)",
  "RA-5 (7)",
  "RA-5 (8)",
  "RA-5 (9)",
  "RA-5a.",
  "RA-5b.",
  "RA-5b.1.",
  "RA-5b.2.",
  "RA-5b.3.",
  "RA-5c.",
  "RA-5d.",
  "RA-5e.",
  "RA-6",
  "SA-1",
  "SA-10",
  "SA-10 (1)",
  "SA-10 (2)",
  "SA-10 (3)",
  "SA-10 (4)",
  "SA-10 (5)",
  "SA-10 (6)",
  "SA-10a.",
  "SA-10b.",
  "SA-10c.",
  "SA-10d.",
  "SA-10e.",
  "SA-11",
  "SA-11 (1)",
  "SA-11 (2)",
  "SA-11 (3)",
  "SA-11 (3)(a)",
  "SA-11 (3)(b)",
  "SA-11 (4)",
  "SA-11 (5)",
  "SA-11 (6)",
  "SA-11 (7)",
  "SA-11 (8)",
  "SA-11a.",
  "SA-11b.",
  "SA-11c.",
  "SA-11d.",
  "SA-11e.",
  "SA-12",
  "SA-12 (1)",
  "SA-12 (10)",
  "SA-12 (11)",
  "SA-12 (12)",
  "SA-12 (13)",
  "SA-12 (14)",
  "SA-12 (15)",
  "SA-12 (2)",
  "SA-12 (3)",
  "SA-12 (4)",
  "SA-12 (5)",
  "SA-12 (6)",
  "SA-12 (7)",
  "SA-12 (8)",
  "SA-12 (9)",
  "SA-13",
  "SA-13a.",
  "SA-13b.",
  "SA-14",
  "SA-14 (1)",
  "SA-15",
  "SA-15 (1)",
  "SA-15 (1)(a)",
  "SA-15 (1)(b)",
  "SA-15 (10)",
  "SA-15 (11)",
  "SA-15 (2)",
  "SA-15 (3)",
  "SA-15 (4)",
  "SA-15 (4)(a)",
  "SA-15 (4)(b)",
  "SA-15 (4)(c)",
  "SA-15 (5)",
  "SA-15 (6)",
  "SA-15 (7)",
  "SA-15 (7)(a)",
  "SA-15 (7)(b)",
  "SA-15 (7)(c)",
  "SA-15 (7)(d)",
  "SA-15 (8)",
  "SA-15 (9)",
  "SA-15a.",
  "SA-15a.1.",
  "SA-15a.2.",
  "SA-15a.3.",
  "SA-15a.4.",
  "SA-15b.",
  "SA-16",
  "SA-17",
  "SA-17 (1)",
  "SA-17 (1)(a)",
  "SA-17 (1)(b)",
  "SA-17 (2)",
  "SA-17 (2)(a)",
  "SA-17 (2)(b)",
  "SA-17 (3)",
  "SA-17 (3)(a)",
  "SA-17 (3)(b)",
  "SA-17 (3)(c)",
  "SA-17 (3)(d)",
  "SA-17 (3)(e)",
  "SA-17 (4)",
  "SA-17 (4)(a)",
  "SA-17 (4)(b)",
  "SA-17 (4)(c)",
  "SA-17 (4)(d)",
  "SA-17 (4)(e)",
  "SA-17 (5)",
  "SA-17 (5)(a)",
  "SA-17 (5)(b)",
  "SA-17 (6)",
  "SA-17 (7)",
  "SA-17a.",
  "SA-17b.",
  "SA-17c.",
  "SA-18",
  "SA-18 (1)",
  "SA-18 (2)",
  "SA-19",
  "SA-19 (1)",
  "SA-19 (2)",
  "SA-19 (3)",
  "SA-19 (4)",
  "SA-19a.",
  "SA-19b.",
  "SA-1a.",
  "SA-1a.1.",
  "SA-1a.2.",
  "SA-1b.",
  "SA-1b.1.",
  "SA-1b.2.",
  "SA-2",
  "SA-20",
  "SA-21",
  "SA-21 (1)",
  "SA-21a.",
  "SA-21b.",
  "SA-22",
  "SA-22 (1)",
  "SA-22a.",
  "SA-22b.",
  "SA-2a.",
  "SA-2b.",
  "SA-2c.",
  "SA-3",
  "SA-3a.",
  "SA-3b.",
  "SA-3c.",
  "SA-3d.",
  "SA-4",
  "SA-4 (1)",
  "SA-4 (10)",
  "SA-4 (2)",
  "SA-4 (3)",
  "SA-4 (4)",
  "SA-4 (5)",
  "SA-4 (5)(a)",
  "SA-4 (5)(b)",
  "SA-4 (6)",
  "SA-4 (6)(a)",
  "SA-4 (6)(b)",
  "SA-4 (7)",
  "SA-4 (7)(a)",
  "SA-4 (7)(b)",
  "SA-4 (8)",
  "SA-4 (9)",
  "SA-4a.",
  "SA-4b.",
  "SA-4c.",
  "SA-4d.",
  "SA-4e.",
  "SA-4f.",
  "SA-4g.",
  "SA-5",
  "SA-5 (1)",
  "SA-5 (2)",
  "SA-5 (3)",
  "SA-5 (4)",
  "SA-5 (5)",
  "SA-5a.",
  "SA-5a.1.",
  "SA-5a.2.",
  "SA-5a.3.",
  "SA-5b.",
  "SA-5b.1.",
  "SA-5b.2.",
  "SA-5b.3.",
  "SA-5c.",
  "SA-5d.",
  "SA-5e.",
  "SA-6",
  "SA-7",
  "SA-8",
  "SA-9",
  "SA-9 (1)",
  "SA-9 (1)(a)",
  "SA-9 (1)(b)",
  "SA-9 (2)",
  "SA-9 (3)",
  "SA-9 (4)",
  "SA-9 (5)",
  "SA-9a.",
  "SA-9b.",
  "SA-9c.",
  "SC-1",
  "SC-10",
  "SC-11",
  "SC-11 (1)",
  "SC-12",
  "SC-12 (1)",
  "SC-12 (2)",
  "SC-12 (3)",
  "SC-12 (4)",
  "SC-12 (5)",
  "SC-13",
  "SC-13 (1)",
  "SC-13 (2)",
  "SC-13 (3)",
  "SC-13 (4)",
  "SC-14",
  "SC-15",
  "SC-15 (1)",
  "SC-15 (2)",
  "SC-15 (3)",
  "SC-15 (4)",
  "SC-15a.",
  "SC-15b.",
  "SC-16",
  "SC-16 (1)",
  "SC-17",
  "SC-18",
  "SC-18 (1)",
  "SC-18 (2)",
  "SC-18 (3)",
  "SC-18 (4)",
  "SC-18 (5)",
  "SC-18a.",
  "SC-18b.",
  "SC-18c.",
  "SC-19",
  "SC-19a.",
  "SC-19b.",
  "SC-1a.",
  "SC-1a.1.",
  "SC-1a.2.",
  "SC-1b.",
  "SC-1b.1.",
  "SC-1b.2.",
  "SC-2",
  "SC-2 (1)",
  "SC-20",
  "SC-20 (1)",
  "SC-20 (2)",
  "SC-20a.",
  "SC-20b.",
  "SC-21",
  "SC-21 (1)",
  "SC-22",
  "SC-23",
  "SC-23 (1)",
  "SC-23 (2)",
  "SC-23 (3)",
  "SC-23 (4)",
  "SC-23 (5)",
  "SC-24",
  "SC-25",
  "SC-26",
  "SC-26 (1)",
  "SC-27",
  "SC-28",
  "SC-28 (1)",
  "SC-28 (2)",
  "SC-29",
  "SC-29 (1)",
  "SC-3",
  "SC-3 (1)",
  "SC-3 (2)",
  "SC-3 (3)",
  "SC-3 (4)",
  "SC-3 (5)",
  "SC-30",
  "SC-30 (1)",
  "SC-30 (2)",
  "SC-30 (3)",
  "SC-30 (4)",
  "SC-30 (5)",
  "SC-31",
  "SC-31 (1)",
  "SC-31 (2)",
  "SC-31 (3)",
  "SC-31a.",
  "SC-31b.",
  "SC-32",
  "SC-33",
  "SC-34",
  "SC-34 (1)",
  "SC-34 (2)",
  "SC-34 (3)",
  "SC-34 (3)(a)",
  "SC-34 (3)(b)",
  "SC-34a.",
  "SC-34b.",
  "SC-35",
  "SC-36",
  "SC-36 (1)",
  "SC-37",
  "SC-37 (1)",
  "SC-38",
  "SC-39",
  "SC-39 (1)",
  "SC-39 (2)",
  "SC-4",
  "SC-4 (1)",
  "SC-4 (2)",
  "SC-40",
  "SC-40 (1)",
  "SC-40 (2)",
  "SC-40 (3)",
  "SC-40 (4)",
  "SC-41",
  "SC-42",
  "SC-42 (1)",
  "SC-42 (2)",
  "SC-42 (3)",
  "SC-42a.",
  "SC-42b.",
  "SC-43",
  "SC-43a.",
  "SC-43b.",
  "SC-44",
  "SC-5",
  "SC-5 (1)",
  "SC-5 (2)",
  "SC-5 (3)",
  "SC-5 (3)(a)",
  "SC-5 (3)(b)",
  "SC-6",
  "SC-7",
  "SC-7 (1)",
  "SC-7 (10)",
  "SC-7 (11)",
  "SC-7 (12)",
  "SC-7 (13)",
  "SC-7 (14)",
  "SC-7 (15)",
  "SC-7 (16)",
  "SC-7 (17)",
  "SC-7 (18)",
  "SC-7 (19)",
  "SC-7 (2)",
  "SC-7 (20)",
  "SC-7 (21)",
  "SC-7 (22)",
  "SC-7 (23)",
  "SC-7 (3)",
  "SC-7 (4)",
  "SC-7 (4)(a)",
  "SC-7 (4)(b)",
  "SC-7 (4)(c)",
  "SC-7 (4)(d)",
  "SC-7 (4)(e)",
  "SC-7 (5)",
  "SC-7 (6)",
  "SC-7 (7)",
  "SC-7 (8)",
  "SC-7 (9)",
  "SC-7 (9)(a)",
  "SC-7 (9)(b)",
  "SC-7a.",
  "SC-7b.",
  "SC-7c.",
  "SC-8",
  "SC-8 (1)",
  "SC-8 (2)",
  "SC-8 (3)",
  "SC-8 (4)",
  "SC-9",
  "SE-1",
  "SE-1a.",
  "SE-1b.",
  "SE-2",
  "SE-2a.",
  "SE-2b.",
  "SI-1",
  "SI-10",
  "SI-10 (1)",
  "SI-10 (1)(a)",
  "SI-10 (1)(b)",
  "SI-10 (1)(c)",
  "SI-10 (2)",
  "SI-10 (3)",
  "SI-10 (4)",
  "SI-10 (5)",
  "SI-11",
  "SI-11a.",
  "SI-11b.",
  "SI-12",
  "SI-13",
  "SI-13 (1)",
  "SI-13 (2)",
  "SI-13 (3)",
  "SI-13 (4)",
  "SI-13 (4)(a)",
  "SI-13 (4)(b)",
  "SI-13 (5)",
  "SI-13a.",
  "SI-13b.",
  "SI-14",
  "SI-14 (1)",
  "SI-15",
  "SI-16",
  "SI-17",
  "SI-1a.",
  "SI-1a.1.",
  "SI-1a.2.",
  "SI-1b.",
  "SI-1b.1.",
  "SI-1b.2.",
  "SI-2",
  "SI-2 (1)",
  "SI-2 (2)",
  "SI-2 (3)",
  "SI-2 (3)(a)",
  "SI-2 (3)(b)",
  "SI-2 (4)",
  "SI-2 (5)",
  "SI-2 (6)",
  "SI-2a.",
  "SI-2b.",
  "SI-2c.",
  "SI-2d.",
  "SI-3",
  "SI-3 (1)",
  "SI-3 (10)",
  "SI-3 (10)(a)",
  "SI-3 (10)(b)",
  "SI-3 (2)",
  "SI-3 (3)",
  "SI-3 (4)",
  "SI-3 (5)",
  "SI-3 (6)",
  "SI-3 (6)(a)",
  "SI-3 (6)(b)",
  "SI-3 (7)",
  "SI-3 (8)",
  "SI-3 (9)",
  "SI-3a.",
  "SI-3b.",
  "SI-3c.",
  "SI-3c.1.",
  "SI-3c.2.",
  "SI-3d.",
  "SI-4",
  "SI-4 (1)",
  "SI-4 (10)",
  "SI-4 (11)",
  "SI-4 (12)",
  "SI-4 (13)",
  "SI-4 (13)(a)",
  "SI-4 (13)(b)",
  "SI-4 (13)(c)",
  "SI-4 (14)",
  "SI-4 (15)",
  "SI-4 (16)",
  "SI-4 (17)",
  "SI-4 (18)",
  "SI-4 (19)",
  "SI-4 (2)",
  "SI-4 (20)",
  "SI-4 (21)",
  "SI-4 (22)",
  "SI-4 (23)",
  "SI-4 (24)",
  "SI-4 (3)",
  "SI-4 (4)",
  "SI-4 (5)",
  "SI-4 (6)",
  "SI-4 (7)",
  "SI-4 (8)",
  "SI-4 (9)",
  "SI-4a.",
  "SI-4a.1.",
  "SI-4a.2.",
  "SI-4b.",
  "SI-4c.",
  "SI-4c.1.",
  "SI-4c.2.",
  "SI-4d.",
  "SI-4e.",
  "SI-4f.",
  "SI-4g.",
  "SI-5",
  "SI-5 (1)",
  "SI-5a.",
  "SI-5b.",
  "SI-5c.",
  "SI-5d.",
  "SI-6",
  "SI-6 (1)",
  "SI-6 (2)",
  "SI-6 (3)",
  "SI-6a.",
  "SI-6b.",
  "SI-6c.",
  "SI-6d.",
  "SI-7",
  "SI-7 (1)",
  "SI-7 (10)",
  "SI-7 (11)",
  "SI-7 (12)",
  "SI-7 (13)",
  "SI-7 (14)",
  "SI-7 (14)(a)",
  "SI-7 (14)(b)",
  "SI-7 (15)",
  "SI-7 (16)",
  "SI-7 (2)",
  "SI-7 (3)",
  "SI-7 (4)",
  "SI-7 (5)",
  "SI-7 (6)",
  "SI-7 (7)",
  "SI-7 (8)",
  "SI-7 (9)",
  "SI-8",
  "SI-8 (1)",
  "SI-8 (2)",
  "SI-8 (3)",
  "SI-8a.",
  "SI-8b.",
  "SI-9",
  "TR-1",
  "TR-1a.",
  "TR-1b.",
  "TR-1c.",
  "TR-1 (1)",
  "TR-2",
  "TR-2a.",
  "TR-2b.",
  "TR-2c.",
  "TR-1 (1)",
  "TR-3",
  "TR-3a.",
  "TR-3b.",
  "UL-1",
  "UL-2",
  "UL-2a.",
  "UL-2b.",
  "UL-2c.",
  "UL-2d."
];
