![GitHub](https://img.shields.io/github/license/milanvarady/Applite)
![GitHub release (with filter)](https://img.shields.io/github/v/release/milanvarady/Applite)
![GitHub all releases](https://img.shields.io/github/downloads/milanvarady/Applite/total)
![GitHub contributors](https://img.shields.io/github/contributors/milanvarady/Applite)
![GitHub commits since latest release (by SemVer including pre-releases)](https://img.shields.io/github/commits-since/milanvarady/Applite/latest)


# Applite

User-friendly GUI macOS application for Homebrew Casks

## Table of Contents

1. [Key Features](#key-features)
2. [About](#about)
3. [Screenshots](#screenshots)
4. [Download](#download)
5. [Contact](#contact)
6. [Contributing](#contributing)
7. [Acknowledgements](#acknowledgements)
8. [License](#license)
9. [Alternatives](#alternatives)

## Key Features

- Install, update and uninstall apps with a single click
- Clean and simple UI designed for non-technical users
- Free and open-source
- Handpicked gallery of awesome apps
- Can be used with existing brew installation

## About

Applite is a free and open-source macOS application that streamlines the installation and management of third-party apps using [Homebrew](https://brew.sh/). The app is built using [Swift](https://developer.apple.com/swift/) and [SwiftUI](https://developer.apple.com/xcode/swiftui/).

The main goal of the application is to bring the convenience of [Homebrew casks](https://github.com/Homebrew/homebrew-cask) to the non-technical user. So the UI was designed with simplicity and ease of use in mind.

FAQ on the [official website](https://aerolite.dev/applite).

## Screenshots

![Discover Page Screenshot](https://aerolite.dev/applite/assets/img/screenshots/discover-lg.png)
![Productivity Category Screenshot](https://aerolite.dev/applite/assets/img/screenshots/productivity-lg.png)

## Download

[Download DMG](https://github.com/milanvarady/applite/releases/latest/download/Applite.dmg)

or

`$ brew install --cask applite`

Minimum OS version: **macOS 13+**

## Contact

If you have any questions, feel free to e-mail me: [milan@aerolite.dev](mailto:milan@aerolite.dev)

Or join the [Official Discord Server](https://discord.gg/ZgB6pRE8Qx).

## Contributing

The project is open to contributions. See the [Contribution Guidelines](docs/CONTRIBUTING.md) for more information.

## Acknowledgements

 - [Homebrew](https://github.com/homebrew)
 - [Fuse](https://github.com/krisk/fuse-swift), Kiro Risk - search result filtering
 - [SwiftUI CachedAsyncImage](https://github.com/lorenzofiamingo/swiftui-cached-async-image), Lorenzo Fiamingo
 - [SwiftUI-Shimmer](https://github.com/markiv/SwiftUI-Shimmer), Vikram Kriplaney
 - [CircularProgressSwiftUI](https://github.com/ArnavMotwani/CircularProgressSwiftUI), Arnav Motwani
 - [Sparkle](https://github.com/sparkle-project/Sparkle) - app updates
 - [Appcasks](https://github.com/App-Fair/appcasks/) ([App Fair](https://github.com/App-Fair/App) project) - app icons
 - [pinentry-mac](https://github.com/GPGTools/pinentry), GPGTools - for secure admin password retrieval

## License

Applite is licensed under the [MIT](https://choosealicense.com/licenses/mit/) License. See [LICENSE](LICENSE.txt) for more details.

## Alternatives

- [Cork](https://github.com/buresdv/Cork)
- [Cakebrew](https://github.com/brunophilipe/Cakebrew)
- [App Fair](https://github.com/App-Fair/App)
- [Brewlet](https://github.com/zkokaja/Brewlet)
- [BrewMate](https://github.com/romankurnovskii/BrewMate)
