package net.corda.behave.monitoring

import net.corda.behave.await
import java.time.Duration
import java.util.concurrent.CountDownLatch

class ConjunctiveWatch(
        private val left: Watch,
        private val right: Watch
) : Watch {

    override fun ready() = left.ready() && right.ready()

    override fun await(timeout: Duration): Boolean {
        val countDownLatch = CountDownLatch(2)
        listOf(left, right).parallelStream().forEach {
            if (it.await(timeout)) {
                countDownLatch.countDown()
            }
        }
        return countDownLatch.await(timeout)
    }
}