/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.zip;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.EOFException;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;
import sandbox.java.util.zip.DataFormatException;
import sandbox.java.util.zip.Inflater;
import sandbox.java.util.zip.ZipException;

public class InflaterInputStream
extends FilterInputStream {
    protected Inflater inf;
    protected byte[] buf;
    protected int len;
    private boolean closed;
    private boolean reachEOF;
    boolean usesDefaultInflater;
    private byte[] singleByteBuf;
    private byte[] b;

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.closed) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater, int n) {
        block5: {
            block4: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
                super(inputStream);
                this.closed = false;
                this.reachEOF = false;
                this.usesDefaultInflater = false;
                RuntimeCostAccounter.recordArrayAllocation((int)1, (int)1);
                this.singleByteBuf = new byte[1];
                RuntimeCostAccounter.recordArrayAllocation((int)512, (int)1);
                this.b = new byte[512];
                RuntimeCostAccounter.recordJump();
                if (inputStream == null) break block4;
                RuntimeCostAccounter.recordJump();
                if (inflater != null) break block5;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
            NullPointerException nullPointerException = new NullPointerException();
            RuntimeCostAccounter.recordThrow();
            throw nullPointerException;
        }
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("buffer size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.inf = inflater;
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
    }

    public InflaterInputStream(InputStream inputStream, Inflater inflater) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Inflater;I)V");
        this(inputStream, inflater, 512);
    }

    public InflaterInputStream(InputStream inputStream) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/zip/Inflater");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.<init>:()V");
        Inflater inflater = new Inflater();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.<init>:(Ljava/io/InputStream;Ljava/util/zip/Inflater;)V");
        this(inputStream, inflater);
        this.usesDefaultInflater = true;
    }

    @Override
    public int read() throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.read:([BII)I");
        int n2 = this.read(this.singleByteBuf, 0, 1);
        RuntimeCostAccounter.recordJump();
        if (n2 == -1) {
            n = -1;
            RuntimeCostAccounter.recordJump();
        } else {
            byte by = this.singleByteBuf[0];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Byte.toUnsignedInt:(B)I");
            n = Byte.toUnsignedInt(by);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        block14: {
            block13: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block13;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block13;
                int n3 = byArray.length - n;
                RuntimeCostAccounter.recordJump();
                if (n2 <= n3) break block14;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        try {
            int n4;
            while (true) {
                block16: {
                    block15: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.inflate:([BII)I");
                        n4 = this.inf.inflate(byArray, n, n2);
                        RuntimeCostAccounter.recordJump();
                        if (n4 != 0) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.finished:()Z");
                        boolean bl = this.inf.finished();
                        RuntimeCostAccounter.recordJump();
                        if (bl) break block15;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.needsDictionary:()Z");
                        boolean bl2 = this.inf.needsDictionary();
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break block16;
                    }
                    this.reachEOF = true;
                    return -1;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.needsInput:()Z");
                boolean bl = this.inf.needsInput();
                RuntimeCostAccounter.recordJump();
                if (!bl) continue;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.fill:()V");
                this.fill();
                RuntimeCostAccounter.recordJump();
            }
            return n4;
        }
        catch (DataFormatException dataFormatException) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/DataFormatException.getMessage:()Ljava/lang/String;");
            String string2 = dataFormatException.getMessage();
            RuntimeCostAccounter.recordAllocation((String)"java/util/zip/ZipException");
            RuntimeCostAccounter.recordJump();
            if (string2 != null) {
                string = string2;
                RuntimeCostAccounter.recordJump();
            } else {
                string = "Invalid ZLIB data format";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/ZipException.<init>:(Ljava/lang/String;)V");
            ZipException zipException = new ZipException(string);
            RuntimeCostAccounter.recordThrow();
            throw zipException;
        }
    }

    @Override
    public int available() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.reachEOF) {
            return 0;
        }
        return 1;
    }

    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("negative skip length");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(JJ)J");
        int n = (int)Math.min(l, Integer.MAX_VALUE);
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            int n3 = n - n2;
            int n4 = this.b.length;
            RuntimeCostAccounter.recordJump();
            if (n3 > n4) {
                n3 = this.b.length;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.read:([BII)I");
            n3 = this.read(this.b, 0, n3);
            RuntimeCostAccounter.recordJump();
            if (n3 == -1) {
                this.reachEOF = true;
                RuntimeCostAccounter.recordJump();
                break;
            }
            n2 += n3;
            RuntimeCostAccounter.recordJump();
        }
        return n2;
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (!this.closed) {
            RuntimeCostAccounter.recordJump();
            if (this.usesDefaultInflater) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.end:()V");
                this.inf.end();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
            this.in.close();
            this.closed = true;
        }
    }

    protected void fill() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/InflaterInputStream.ensureOpen:()V");
        this.ensureOpen();
        int n = this.buf.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.read:([BII)I");
        this.len = this.in.read(this.buf, 0, n);
        RuntimeCostAccounter.recordJump();
        if (this.len == -1) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/EOFException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/EOFException.<init>:(Ljava/lang/String;)V");
            EOFException eOFException = new EOFException("Unexpected end of ZLIB input stream");
            RuntimeCostAccounter.recordThrow();
            throw eOFException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/zip/Inflater.setInput:([BII)V");
        this.inf.setInput(this.buf, 0, this.len);
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("mark/reset not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }
}

