/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.concurrent;

import java.lang.reflect.Field;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.IOException;
import sandbox.java.io.ObjectOutputStream;
import sandbox.java.io.ObjectStreamField;
import sandbox.java.net.NetworkInterface;
import sandbox.java.security.AccessController;
import sandbox.java.security.PrivilegedAction;
import sandbox.java.security.SecureRandom;
import sandbox.java.util.Enumeration;
import sandbox.java.util.Random;
import sandbox.java.util.Spliterator;
import sandbox.java.util.concurrent.atomic.AtomicInteger;
import sandbox.java.util.concurrent.atomic.AtomicLong;
import sandbox.java.util.function.DoubleConsumer;
import sandbox.java.util.function.IntConsumer;
import sandbox.java.util.function.LongConsumer;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.StreamSupport;
import sandbox.sun.misc.Unsafe;
import sandbox.sun.security.action.GetPropertyAction;

public class ThreadLocalRandom
extends Random {
    private static final AtomicInteger probeGenerator;
    private static final AtomicLong seeder;
    private static final long GAMMA = -7046029254386353131L;
    private static final int PROBE_INCREMENT = -1640531527;
    private static final long SEEDER_INCREMENT = -4942790177534073029L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private static final float FLOAT_UNIT = 5.9604645E-8f;
    private static final ThreadLocal<Double> nextLocalGaussian;
    boolean initialized;
    static final ThreadLocalRandom instance;
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";
    private static final long serialVersionUID = -5851777807851030925L;
    private static final ObjectStreamField[] serialPersistentFields;
    private static final Unsafe UNSAFE;
    private static final long SEED;
    private static final long PROBE;
    private static final long SECONDARY;

    private static long initialSeed() {
        RuntimeCostAccounter.recordAllocation((String)"sun/security/action/GetPropertyAction");
        RuntimeCostAccounter.recordMethodCall((String)"sun/security/action/GetPropertyAction.<init>:(Ljava/lang/String;)V");
        GetPropertyAction getPropertyAction = new GetPropertyAction("java.util.secureRandomSeed");
        RuntimeCostAccounter.recordMethodCall((String)"java/security/AccessController.doPrivileged:(Ljava/security/PrivilegedAction;)Ljava/lang/Object;");
        String string = (String)AccessController.doPrivileged((PrivilegedAction)getPropertyAction);
        RuntimeCostAccounter.recordJump();
        if (string != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equalsIgnoreCase:(Ljava/lang/String;)Z");
            boolean bl = string.equalsIgnoreCase("true");
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/security/SecureRandom.getSeed:(I)[B");
                byte[] byArray = SecureRandom.getSeed((int)8);
                long l = (long)byArray[0] & 0xFFL;
                int n = 1;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= 8) break;
                    l = l << 8 | (long)byArray[n] & 0xFFL;
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                return l;
            }
        }
        long l = 0L;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/net/NetworkInterface.getNetworkInterfaces:()Ljava/util/Enumeration;");
            Enumeration enumeration = NetworkInterface.getNetworkInterfaces();
            boolean bl = false;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.hasMoreElements:()Z");
                boolean bl2 = enumeration.hasMoreElements();
                RuntimeCostAccounter.recordJump();
                if (!bl2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Enumeration.nextElement:()Ljava/lang/Object;");
                NetworkInterface networkInterface = (NetworkInterface)enumeration.nextElement();
                RuntimeCostAccounter.recordMethodCall((String)"java/net/NetworkInterface.isVirtual:()Z");
                boolean bl3 = networkInterface.isVirtual();
                RuntimeCostAccounter.recordJump();
                if (!bl3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/net/NetworkInterface.getHardwareAddress:()[B");
                    byte[] byArray = networkInterface.getHardwareAddress();
                    RuntimeCostAccounter.recordJump();
                    if (byArray != null) {
                        int n = byArray.length;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                        int n2 = Math.min(n >>> 1, 4);
                        int n3 = 0;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (n3 >= n2) break;
                            l = l << 16 ^ (long)(byArray[n3] << 8) ^ (long)byArray[n - 1 - n3];
                            ++n3;
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n2 < 4) {
                            l = l << 8 ^ (long)byArray[n - 1 - n2];
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
                        l = ThreadLocalRandom.mix64(l);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                    bl = true;
                }
                RuntimeCostAccounter.recordJump();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        RuntimeCostAccounter.recordJump();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.currentTimeMillis:()J");
        long l2 = System.currentTimeMillis();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        long l3 = l ^ ThreadLocalRandom.mix64(l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.nanoTime:()J");
        long l4 = System.nanoTime();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        return l3 ^ ThreadLocalRandom.mix64(l4);
    }

    private static long mix64(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        return l ^ l >>> 33;
    }

    private static int mix32(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        return (int)((l ^ l >>> 33) * -4265267296055464877L >>> 32);
    }

    private ThreadLocalRandom() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Random.<init>:()V");
        this.initialized = true;
    }

    static final void localInit() {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.addAndGet:(I)I");
        int n2 = probeGenerator.addAndGet(-1640531527);
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            n = 1;
            RuntimeCostAccounter.recordJump();
        } else {
            n = n2;
        }
        int n3 = n;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.getAndAdd:(J)J");
        long l = seeder.getAndAdd(-4942790177534073029L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        long l2 = ThreadLocalRandom.mix64(l);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putLong:(Ljava/lang/Object;JJ)V");
        UNSAFE.putLong((Object)thread, SEED, l2);
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putInt:(Ljava/lang/Object;JI)V");
        UNSAFE.putInt((Object)thread, PROBE, n3);
    }

    public static ThreadLocalRandom current() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getInt:(Ljava/lang/Object;J)I");
        int n = UNSAFE.getInt((Object)thread, PROBE);
        RuntimeCostAccounter.recordJump();
        if (n == 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.localInit:()V");
            ThreadLocalRandom.localInit();
        }
        return instance;
    }

    @Override
    public void setSeed(long l) {
        RuntimeCostAccounter.recordJump();
        if (this.initialized) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/UnsupportedOperationException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/UnsupportedOperationException.<init>:()V");
            UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
            RuntimeCostAccounter.recordThrow();
            throw unsupportedOperationException;
        }
    }

    final long nextSeed() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getLong:(Ljava/lang/Object;J)J");
        long l = UNSAFE.getLong((Object)thread, SEED) + -7046029254386353131L;
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putLong:(Ljava/lang/Object;JJ)V");
        UNSAFE.putLong((Object)thread, SEED, l);
        return l;
    }

    @Override
    protected int next(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        return (int)(ThreadLocalRandom.mix64(l) >>> 64 - n);
    }

    final long internalNextLong(long l, long l2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l3 = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        long l4 = ThreadLocalRandom.mix64(l3);
        RuntimeCostAccounter.recordJump();
        if (l < l2) {
            long l5 = l2 - l;
            long l6 = l5 - 1L;
            RuntimeCostAccounter.recordJump();
            if ((l5 & l6) == 0L) {
                l4 = (l4 & l6) + l;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (l5 > 0L) {
                    long l7 = l4 >>> 1;
                    while (true) {
                        l4 = l7 % l5;
                        RuntimeCostAccounter.recordJump();
                        if (l7 + l6 - l4 >= 0L) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
                        long l8 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
                        l7 = ThreadLocalRandom.mix64(l8) >>> 1;
                        RuntimeCostAccounter.recordJump();
                    }
                    l4 += l;
                    RuntimeCostAccounter.recordJump();
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (l4 >= l) {
                            RuntimeCostAccounter.recordJump();
                            if (l4 < l2) break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
                        long l9 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
                        l4 = ThreadLocalRandom.mix64(l9);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return l4;
    }

    final int internalNextInt(int n, int n2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
        int n3 = ThreadLocalRandom.mix32(l);
        RuntimeCostAccounter.recordJump();
        if (n < n2) {
            int n4 = n2 - n;
            int n5 = n4 - 1;
            RuntimeCostAccounter.recordJump();
            if ((n4 & n5) == 0) {
                n3 = (n3 & n5) + n;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    int n6 = n3 >>> 1;
                    while (true) {
                        n3 = n6 % n4;
                        RuntimeCostAccounter.recordJump();
                        if (n6 + n5 - n3 >= 0) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
                        long l2 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
                        n6 = ThreadLocalRandom.mix32(l2) >>> 1;
                        RuntimeCostAccounter.recordJump();
                    }
                    n3 += n;
                    RuntimeCostAccounter.recordJump();
                } else {
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n3 >= n) {
                            RuntimeCostAccounter.recordJump();
                            if (n3 < n2) break;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
                        long l3 = this.nextSeed();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
                        n3 = ThreadLocalRandom.mix32(l3);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }
        return n3;
    }

    final double internalNextDouble(double d, double d2) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextLong:()J");
        double d3 = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        RuntimeCostAccounter.recordJump();
        if (d < d2) {
            d3 = d3 * (d2 - d) + d;
            RuntimeCostAccounter.recordJump();
            if (d3 >= d2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
                long l = Double.doubleToLongBits(d2) - 1L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
                d3 = Double.longBitsToDouble(l);
            }
        }
        return d3;
    }

    @Override
    public int nextInt() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
        return ThreadLocalRandom.mix32(l);
    }

    @Override
    public int nextInt(int n) {
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
        int n2 = ThreadLocalRandom.mix32(l);
        int n3 = n - 1;
        RuntimeCostAccounter.recordJump();
        if ((n & n3) == 0) {
            n2 &= n3;
            RuntimeCostAccounter.recordJump();
        } else {
            int n4 = n2 >>> 1;
            while (true) {
                n2 = n4 % n;
                RuntimeCostAccounter.recordJump();
                if (n4 + n3 - n2 >= 0) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
                long l2 = this.nextSeed();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
                n4 = ThreadLocalRandom.mix32(l2) >>> 1;
                RuntimeCostAccounter.recordJump();
            }
        }
        return n2;
    }

    public int nextInt(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextInt:(II)I");
        return this.internalNextInt(n, n2);
    }

    @Override
    public long nextLong() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        return ThreadLocalRandom.mix64(l);
    }

    public long nextLong(long l) {
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l2 = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        long l3 = ThreadLocalRandom.mix64(l2);
        long l4 = l - 1L;
        RuntimeCostAccounter.recordJump();
        if ((l & l4) == 0L) {
            l3 &= l4;
            RuntimeCostAccounter.recordJump();
        } else {
            long l5 = l3 >>> 1;
            while (true) {
                l3 = l5 % l;
                RuntimeCostAccounter.recordJump();
                if (l5 + l4 - l3 >= 0L) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
                long l6 = this.nextSeed();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
                l5 = ThreadLocalRandom.mix64(l6) >>> 1;
                RuntimeCostAccounter.recordJump();
            }
        }
        return l3;
    }

    public long nextLong(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextLong:(JJ)J");
        return this.internalNextLong(l, l2);
    }

    @Override
    public double nextDouble() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        return (double)(ThreadLocalRandom.mix64(l) >>> 11) * (double)1.110223E-16f;
    }

    public double nextDouble(double d) {
        double d2;
        RuntimeCostAccounter.recordJump();
        if (!(d > 0.0)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadBound);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix64:(J)J");
        double d3 = (double)(ThreadLocalRandom.mix64(l) >>> 11) * (double)1.110223E-16f * d;
        RuntimeCostAccounter.recordJump();
        if (d3 < d) {
            d2 = d3;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleToLongBits:(D)J");
            long l2 = Double.doubleToLongBits(d) - 1L;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.longBitsToDouble:(J)D");
            d2 = Double.longBitsToDouble(l2);
        }
        return d2;
    }

    public double nextDouble(double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextDouble:(DD)D");
        return this.internalNextDouble(d, d2);
    }

    @Override
    public boolean nextBoolean() {
        boolean bl;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
        int n = ThreadLocalRandom.mix32(l);
        RuntimeCostAccounter.recordJump();
        if (n < 0) {
            bl = true;
            RuntimeCostAccounter.recordJump();
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    public float nextFloat() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextSeed:()J");
        long l = this.nextSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.mix32:(J)I");
        return (float)(ThreadLocalRandom.mix32(l) >>> 8) * 5.9604645E-8f;
    }

    @Override
    public double nextGaussian() {
        double d;
        double d2;
        double d3;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.get:()Ljava/lang/Object;");
        Double d4 = nextLocalGaussian.get();
        RuntimeCostAccounter.recordJump();
        if (d4 != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.set:(Ljava/lang/Object;)V");
            nextLocalGaussian.set(null);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.doubleValue:()D");
            return d4;
        }
        while (true) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextDouble:()D");
            d3 = 2.0 * this.nextDouble() - 1.0;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.nextDouble:()D");
            d2 = 2.0 * this.nextDouble() - 1.0;
            d = d3 * d3 + d2 * d2;
            RuntimeCostAccounter.recordJump();
            if (d >= 1.0) continue;
            RuntimeCostAccounter.recordJump();
            if (d != 0.0) break;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StrictMath.log:(D)D");
        double d5 = -2.0 * StrictMath.log(d) / d;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StrictMath.sqrt:(D)D");
        double d6 = StrictMath.sqrt(d5);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/Double");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Double.<init>:(D)V");
        Double d7 = new Double(d2 * d6);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.set:(Ljava/lang/Object;)V");
        nextLocalGaussian.set(d7);
        return d3 * d6;
    }

    @Override
    public IntStream ints(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator.<init>:(JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(0L, l, Integer.MAX_VALUE, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    @Override
    public IntStream ints() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator.<init>:(JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    @Override
    public IntStream ints(long l, int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator.<init>:(JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(0L, l, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    @Override
    public IntStream ints(int n, int n2) {
        RuntimeCostAccounter.recordJump();
        if (n >= n2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator.<init>:(JJII)V");
        RandomIntsSpliterator randomIntsSpliterator = new RandomIntsSpliterator(0L, Long.MAX_VALUE, n, n2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.intStream:(Ljava/util/Spliterator$OfInt;Z)Ljava/util/stream/IntStream;");
        return StreamSupport.intStream(randomIntsSpliterator, false);
    }

    @Override
    public LongStream longs(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator.<init>:(JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(0L, l, Long.MAX_VALUE, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    @Override
    public LongStream longs() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator.<init>:(JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    @Override
    public LongStream longs(long l, long l2, long l3) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (l2 >= l3) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator.<init>:(JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(0L, l, l2, l3);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    @Override
    public LongStream longs(long l, long l2) {
        RuntimeCostAccounter.recordJump();
        if (l >= l2) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator.<init>:(JJJJ)V");
        RandomLongsSpliterator randomLongsSpliterator = new RandomLongsSpliterator(0L, Long.MAX_VALUE, l, l2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.longStream:(Ljava/util/Spliterator$OfLong;Z)Ljava/util/stream/LongStream;");
        return StreamSupport.longStream(randomLongsSpliterator, false);
    }

    @Override
    public DoubleStream doubles(long l) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator.<init>:(JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(0L, l, Double.MAX_VALUE, 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    @Override
    public DoubleStream doubles() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator.<init>:(JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    @Override
    public DoubleStream doubles(long l, double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadSize);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator.<init>:(JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(0L, l, d, d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    @Override
    public DoubleStream doubles(double d, double d2) {
        RuntimeCostAccounter.recordJump();
        if (!(d < d2)) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(BadRange);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator.<init>:(JJDD)V");
        RandomDoublesSpliterator randomDoublesSpliterator = new RandomDoublesSpliterator(0L, Long.MAX_VALUE, d, d2);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamSupport.doubleStream:(Ljava/util/Spliterator$OfDouble;Z)Ljava/util/stream/DoubleStream;");
        return StreamSupport.doubleStream(randomDoublesSpliterator, false);
    }

    static final int getProbe() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getInt:(Ljava/lang/Object;J)I");
        return UNSAFE.getInt((Object)thread, PROBE);
    }

    static final int advanceProbe(int n) {
        n ^= n << 13;
        n ^= n >>> 17;
        n ^= n << 5;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putInt:(Ljava/lang/Object;JI)V");
        UNSAFE.putInt((Object)thread, PROBE, n);
        return n;
    }

    static final int nextSecondarySeed() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getInt:(Ljava/lang/Object;J)I");
        int n = UNSAFE.getInt((Object)thread, SECONDARY);
        RuntimeCostAccounter.recordJump();
        if (n != 0) {
            n ^= n << 13;
            n ^= n >>> 17;
            n ^= n << 5;
            RuntimeCostAccounter.recordJump();
        } else {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.localInit:()V");
            ThreadLocalRandom.localInit();
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getLong:(Ljava/lang/Object;J)J");
            n = (int)UNSAFE.getLong((Object)thread, SEED);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                n = 1;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.putInt:(Ljava/lang/Object;JI)V");
        UNSAFE.putInt((Object)thread, SECONDARY, n);
        return n;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.putFields:()Ljava/io/ObjectOutputStream$PutField;");
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Thread.currentThread:()Ljava/lang/Thread;");
        Thread thread = Thread.currentThread();
        RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getLong:(Ljava/lang/Object;J)J");
        long l = UNSAFE.getLong((Object)thread, SEED);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;J)V");
        putField.put("rnd", l);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream$PutField.put:(Ljava/lang/String;Z)V");
        putField.put("initialized", true);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectOutputStream.writeFields:()V");
        objectOutputStream.writeFields();
    }

    private Object readResolve() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
        return ThreadLocalRandom.current();
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicInteger");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicInteger.<init>:()V");
        probeGenerator = new AtomicInteger();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/atomic/AtomicLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.initialSeed:()J");
        long l = ThreadLocalRandom.initialSeed();
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/atomic/AtomicLong.<init>:(J)V");
        seeder = new AtomicLong(l);
        RuntimeCostAccounter.recordAllocation((String)"java/lang/ThreadLocal");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/ThreadLocal.<init>:()V");
        nextLocalGaussian = new ThreadLocal();
        RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.<init>:()V");
        instance = new ThreadLocalRandom();
        RuntimeCostAccounter.recordArrayAllocation((int)2, (int)8);
        ObjectStreamField[] objectStreamFieldArray = new ObjectStreamField[2];
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[0] = new ObjectStreamField("rnd", Long.TYPE);
        RuntimeCostAccounter.recordAllocation((String)"java/io/ObjectStreamField");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/ObjectStreamField.<init>:(Ljava/lang/String;Ljava/lang/Class;)V");
        objectStreamFieldArray[1] = new ObjectStreamField("initialized", Boolean.TYPE);
        serialPersistentFields = objectStreamFieldArray;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.getUnsafe:()Lsun/misc/Unsafe;");
            UNSAFE = Unsafe.getUnsafe();
            Class<Thread> clazz = Thread.class;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field = clazz.getDeclaredField("threadLocalRandomSeed");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            SEED = UNSAFE.objectFieldOffset(field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field2 = clazz.getDeclaredField("threadLocalRandomProbe");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            PROBE = UNSAFE.objectFieldOffset(field2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Class.getDeclaredField:(Ljava/lang/String;)Ljava/lang/reflect/Field;");
            Field field3 = clazz.getDeclaredField("threadLocalRandomSecondarySeed");
            RuntimeCostAccounter.recordMethodCall((String)"sun/misc/Unsafe.objectFieldOffset:(Ljava/lang/reflect/Field;)J");
            SECONDARY = UNSAFE.objectFieldOffset(field3);
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/Error");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Error.<init>:(Ljava/lang/Throwable;)V");
            Error error = new Error(exception);
            RuntimeCostAccounter.recordThrow();
            throw error;
        }
        RuntimeCostAccounter.recordJump();
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(long l, long l2, double d, double d2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.index = l;
            this.fence = l2;
            this.origin = d;
            this.bound = d2;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomDoublesSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator");
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomDoublesSpliterator.<init>:(JJDD)V");
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(l, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextDouble:(DD)D");
                double d = threadLocalRandom.internalNextDouble(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                doubleConsumer.accept(d);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            RuntimeCostAccounter.recordJump();
            if (doubleConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                double d = this.origin;
                double d2 = this.bound;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextDouble:(DD)D");
                    double d3 = threadLocalRandom.internalNextDouble(d, d2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/DoubleConsumer.accept:(D)V");
                    doubleConsumer.accept(d3);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(long l, long l2, long l3, long l4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.index = l;
            this.fence = l2;
            this.origin = l3;
            this.bound = l4;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomLongsSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator");
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomLongsSpliterator.<init>:(JJJJ)V");
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(l, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextLong:(JJ)J");
                long l3 = threadLocalRandom.internalNextLong(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                longConsumer.accept(l3);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            RuntimeCostAccounter.recordJump();
            if (longConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                long l3 = this.origin;
                long l4 = this.bound;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextLong:(JJ)J");
                    long l5 = threadLocalRandom.internalNextLong(l3, l4);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/LongConsumer.accept:(J)V");
                    longConsumer.accept(l5);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(long l, long l2, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.index = l;
            this.fence = l2;
            this.origin = n;
            this.bound = n2;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            RuntimeCostAccounter.recordJump();
            if (l2 <= l) {
                randomIntsSpliterator = null;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator");
                this.index = l2;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom$RandomIntsSpliterator.<init>:(JJII)V");
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(l, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextInt:(II)I");
                int n = threadLocalRandom.internalNextInt(this.origin, this.bound);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                intConsumer.accept(n);
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            RuntimeCostAccounter.recordJump();
            if (intConsumer == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                NullPointerException nullPointerException = new NullPointerException();
                RuntimeCostAccounter.recordThrow();
                throw nullPointerException;
            }
            long l = this.index;
            long l2 = this.fence;
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                this.index = l2;
                int n = this.origin;
                int n2 = this.bound;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.current:()Ljava/util/concurrent/ThreadLocalRandom;");
                ThreadLocalRandom threadLocalRandom = ThreadLocalRandom.current();
                do {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ThreadLocalRandom.internalNextInt:(II)I");
                    int n3 = threadLocalRandom.internalNextInt(n, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/function/IntConsumer.accept:(I)V");
                    intConsumer.accept(n3);
                    RuntimeCostAccounter.recordJump();
                } while (++l < l2);
            }
        }
    }
}

