/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.zone;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.BufferedInputStream;
import sandbox.java.io.ByteArrayInputStream;
import sandbox.java.io.DataInputStream;
import sandbox.java.io.File;
import sandbox.java.io.FileInputStream;
import sandbox.java.io.StreamCorruptedException;
import sandbox.java.time.zone.Ser;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.time.zone.ZoneRulesException;
import sandbox.java.time.zone.ZoneRulesProvider;
import sandbox.java.util.Arrays;
import sandbox.java.util.HashSet;
import sandbox.java.util.List;
import sandbox.java.util.Map;
import sandbox.java.util.NavigableMap;
import sandbox.java.util.Set;
import sandbox.java.util.TreeMap;
import sandbox.java.util.concurrent.ConcurrentHashMap;

final class TzdbZoneRulesProvider
extends ZoneRulesProvider {
    private List<String> regionIds;
    private String versionId;
    private final Map<String, Object> regionToRules;

    public TzdbZoneRulesProvider() {
        block11: {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.<init>:()V");
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
            this.regionToRules = new ConcurrentHashMap<String, Object>();
            try {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.getProperty:(Ljava/lang/String;)Ljava/lang/String;");
                String string = System.getProperty("java.home");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(File.separator);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append("lib");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string2 = stringBuilder4.toString();
                RuntimeCostAccounter.recordAllocation((String)"java/io/DataInputStream");
                RuntimeCostAccounter.recordAllocation((String)"java/io/BufferedInputStream");
                RuntimeCostAccounter.recordAllocation((String)"java/io/FileInputStream");
                RuntimeCostAccounter.recordAllocation((String)"java/io/File");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/File.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
                File file = new File(string2, "tzdb.dat");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FileInputStream.<init>:(Ljava/io/File;)V");
                FileInputStream fileInputStream = new FileInputStream(file);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/BufferedInputStream.<init>:(Ljava/io/InputStream;)V");
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.<init>:(Ljava/io/InputStream;)V");
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                Throwable throwable = null;
                try {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/TzdbZoneRulesProvider.load:(Ljava/io/DataInputStream;)V");
                    this.load(dataInputStream);
                }
                catch (Throwable throwable2) {
                    try {
                        throwable = throwable2;
                        RuntimeCostAccounter.recordThrow();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        block12: {
                            block13: {
                                RuntimeCostAccounter.recordJump();
                                if (dataInputStream == null) break block12;
                                RuntimeCostAccounter.recordJump();
                                if (throwable == null) break block13;
                                try {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.close:()V");
                                    dataInputStream.close();
                                }
                                catch (Throwable throwable4) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                                    throwable.addSuppressed(throwable4);
                                    RuntimeCostAccounter.recordJump();
                                }
                                RuntimeCostAccounter.recordJump();
                                break block12;
                                break block12;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.close:()V");
                            dataInputStream.close();
                        }
                        RuntimeCostAccounter.recordThrow();
                        throw throwable3;
                    }
                }
                RuntimeCostAccounter.recordJump();
                if (dataInputStream == null) break block11;
                RuntimeCostAccounter.recordJump();
                if (throwable != null) {
                    try {
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.close:()V");
                        dataInputStream.close();
                    }
                    catch (Throwable throwable5) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Throwable.addSuppressed:(Ljava/lang/Throwable;)V");
                        throwable.addSuppressed(throwable5);
                        RuntimeCostAccounter.recordJump();
                        break block11;
                    }
                    RuntimeCostAccounter.recordJump();
                    break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.close:()V");
                dataInputStream.close();
                RuntimeCostAccounter.recordJump();
            }
            catch (Exception exception) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesException");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
                ZoneRulesException zoneRulesException = new ZoneRulesException("Unable to load TZDB time-zone rules", exception);
                RuntimeCostAccounter.recordThrow();
                throw zoneRulesException;
            }
        }
        RuntimeCostAccounter.recordJump();
    }

    @Override
    protected Set<String> provideZoneIds() {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:(Ljava/util/Collection;)V");
        return new HashSet<String>(this.regionIds);
    }

    @Override
    protected ZoneRules provideRules(String string, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
        Object object = this.regionToRules.get(string);
        RuntimeCostAccounter.recordJump();
        if (object == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Unknown time-zone ID: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string2 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesException.<init>:(Ljava/lang/String;)V");
            ZoneRulesException zoneRulesException = new ZoneRulesException(string2);
            RuntimeCostAccounter.recordThrow();
            throw zoneRulesException;
        }
        try {
            boolean bl2 = object instanceof byte[];
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                byte[] byArray = (byte[])object;
                RuntimeCostAccounter.recordAllocation((String)"java/io/DataInputStream");
                RuntimeCostAccounter.recordAllocation((String)"java/io/ByteArrayInputStream");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/ByteArrayInputStream.<init>:([B)V");
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.<init>:(Ljava/io/InputStream;)V");
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/Ser.read:(Ljava/io/DataInput;)Ljava/lang/Object;");
                object = Ser.read(dataInputStream);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.regionToRules.put(string, object);
            }
            return (ZoneRules)object;
        }
        catch (Exception exception) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/zone/ZoneRulesException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("Invalid binary time-zone data: TZDB:");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(", version: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(this.versionId);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesException.<init>:(Ljava/lang/String;Ljava/lang/Throwable;)V");
            ZoneRulesException zoneRulesException = new ZoneRulesException(string3, exception);
            RuntimeCostAccounter.recordThrow();
            throw zoneRulesException;
        }
    }

    @Override
    protected NavigableMap<String, ZoneRules> provideVersions(String string) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/TreeMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.<init>:()V");
        TreeMap<String, ZoneRules> treeMap = new TreeMap<String, ZoneRules>();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/TzdbZoneRulesProvider.getRules:(Ljava/lang/String;Z)Ljava/time/zone/ZoneRules;");
        ZoneRules zoneRules = TzdbZoneRulesProvider.getRules(string, false);
        RuntimeCostAccounter.recordJump();
        if (zoneRules != null) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/TreeMap.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
            treeMap.put(this.versionId, zoneRules);
        }
        return treeMap;
    }

    private void load(DataInputStream dataInputStream) throws Exception {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readByte:()B");
        byte by = dataInputStream.readByte();
        RuntimeCostAccounter.recordJump();
        if (by != 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException("File format not recognised");
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readUTF:()Ljava/lang/String;");
        String string = dataInputStream.readUTF();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
        boolean bl = "TZDB".equals(string);
        RuntimeCostAccounter.recordJump();
        if (!bl) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/StreamCorruptedException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/StreamCorruptedException.<init>:(Ljava/lang/String;)V");
            StreamCorruptedException streamCorruptedException = new StreamCorruptedException("File format not recognised");
            RuntimeCostAccounter.recordThrow();
            throw streamCorruptedException;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
        int n = dataInputStream.readShort();
        int n2 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n2 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readUTF:()Ljava/lang/String;");
            this.versionId = dataInputStream.readUTF();
            ++n2;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
        int n3 = n2 = dataInputStream.readShort();
        RuntimeCostAccounter.recordArrayAllocation((int)n3, (int)8);
        String[] stringArray = new String[n3];
        int n4 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n4 >= n2) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readUTF:()Ljava/lang/String;");
            stringArray[n4] = dataInputStream.readUTF();
            ++n4;
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.asList:([Ljava/lang/Object;)Ljava/util/List;");
        this.regionIds = Arrays.asList(stringArray);
        RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
        int n5 = n4 = (int)dataInputStream.readShort();
        RuntimeCostAccounter.recordArrayAllocation((int)n5, (int)8);
        Object[] objectArray = new Object[n5];
        int n6 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 >= n4) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
            short s = dataInputStream.readShort();
            RuntimeCostAccounter.recordArrayAllocation((int)s, (int)1);
            byte[] byArray = new byte[s];
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readFully:([B)V");
            dataInputStream.readFully(byArray);
            objectArray[n6] = byArray;
            ++n6;
            RuntimeCostAccounter.recordJump();
        }
        n6 = 0;
        while (true) {
            RuntimeCostAccounter.recordJump();
            if (n6 >= n) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
            int n7 = dataInputStream.readShort();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.clear:()V");
            this.regionToRules.clear();
            int n8 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n8 >= n7) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
                String string2 = stringArray[dataInputStream.readShort()];
                RuntimeCostAccounter.recordMethodCall((String)"java/io/DataInputStream.readShort:()S");
                Object object = objectArray[dataInputStream.readShort() & 0xFFFF];
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                this.regionToRules.put(string2, object);
                ++n8;
                RuntimeCostAccounter.recordJump();
            }
            ++n6;
            RuntimeCostAccounter.recordJump();
        }
    }

    public String toString() {
        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
        StringBuilder stringBuilder = new StringBuilder();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder2 = stringBuilder.append("TZDB[");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder3 = stringBuilder2.append(this.versionId);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        StringBuilder stringBuilder4 = stringBuilder3.append("]");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
        return stringBuilder4.toString();
    }
}

