/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts.asset;

import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.Attachment;
import net.corda.core.contracts.CommandAndState;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.CommandWithParties;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.MoveCommand;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.TimeWindow;
import net.corda.core.contracts.TypeOnlyCommandData;
import net.corda.core.crypto.SecureHash;
import net.corda.core.identity.AbstractParty;
import net.corda.core.internal.Emoji;
import net.corda.core.serialization.CordaSerializable;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.core.utilities.KotlinUtilsKt;
import net.corda.core.utilities.NonEmptySet;
import net.corda.finance.contracts.NetCommand;
import net.corda.finance.contracts.NetType;
import net.corda.finance.contracts.NettableState;
import net.corda.finance.contracts.asset.BilateralNetState;
import net.corda.finance.contracts.asset.MultilateralNetState;
import net.corda.finance.contracts.asset.NetState;
import net.corda.finance.contracts.asset.Obligation;
import net.corda.finance.contracts.asset.Obligation$Commands$SetLifecycle$WhenMappings;
import net.corda.finance.contracts.asset.Obligation$State$WhenMappings;
import net.corda.finance.contracts.asset.Obligation$WhenMappings;
import net.corda.finance.contracts.asset.ObligationKt;
import net.corda.finance.contracts.utils.StateSumming;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 !*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0005 !\"#$B\u0005\u00a2\u0006\u0002\u0010\u0004JX\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016Jf\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0012\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000fH\u0002J$\u0010\u0015\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00160\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00160\nH\u0002J\u001e\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0013H\u0002JR\u0010\u001a\u001a\u00020\u00062\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0013H\u0002Jl\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0018\u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000b0\n2\u0012\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001e0\u00132\u0012\u0010\u001f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\f0\u000fH\u0002\u00a8\u0006%"}, d2={"Lnet/corda/finance/contracts/asset/Obligation;", "P", "", "Lnet/corda/core/contracts/Contract;", "()V", "conserveAmount", "", "tx", "Lnet/corda/core/transactions/LedgerTransaction;", "inputs", "", "Lnet/corda/core/contracts/FungibleAsset;", "Lnet/corda/finance/contracts/asset/Obligation$Terms;", "outputs", "key", "Lnet/corda/core/contracts/Issued;", "verify", "verifyIssueCommand", "issueCommand", "Lnet/corda/core/contracts/CommandWithParties;", "Lnet/corda/finance/contracts/asset/Obligation$Commands$Issue;", "verifyLifecycleCommand", "Lnet/corda/core/contracts/ContractState;", "verifyNetCommand", "command", "Lnet/corda/finance/contracts/NetCommand;", "verifySetLifecycleCommand", "setLifecycleCommand", "Lnet/corda/finance/contracts/asset/Obligation$Commands$SetLifecycle;", "verifySettleCommand", "Lnet/corda/finance/contracts/asset/Obligation$Commands$Settle;", "groupingKey", "Commands", "Companion", "Lifecycle", "State", "Terms", "contracts"})
public final class Obligation<P>
implements Contract {
    @NotNull
    public static final String PROGRAM_ID = "net.corda.finance.contracts.asset.Obligation";
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull LedgerTransaction tx) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Collection $receiver$iv = tx.getCommands();
        PublicKey signer$iv = null;
        AbstractParty party$iv = null;
        CommandWithParties netCommand = (CommandWithParties)CollectionsKt.firstOrNull((List)ContractsDSL.select((Collection)$receiver$iv, Commands.Net.class, (PublicKey)signer$iv, (AbstractParty)party$iv));
        if (netCommand != null) {
            this.verifyLifecycleCommand(tx.getInputStates(), tx.getOutputStates());
            this.verifyNetCommand(tx, (CommandWithParties<NetCommand>)netCommand);
        } else {
            void this_$iv;
            signer$iv = tx;
            Function1 selector$iv = verify.groups.1.INSTANCE;
            List groups2 = this_$iv.groupStates(State.class, selector$iv);
            for (LedgerTransaction.InOutGroup inOutGroup : groups2) {
                AbstractParty party$iv2;
                PublicKey signer$iv2;
                AbstractParty party$iv3;
                PublicKey signer$iv3;
                Collection $receiver$iv2;
                void expr$iv;
                boolean bl;
                Iterable $receiver$iv222;
                Issued key;
                List outputs;
                List inputs;
                block10: {
                    inputs = inOutGroup.component1();
                    outputs = inOutGroup.component2();
                    key = (Issued)inOutGroup.component3();
                    Requirements $receiver = Requirements.INSTANCE;
                    String string = "there are no zero sized outputs";
                    Requirements requirements = $receiver;
                    $receiver$iv222 = outputs;
                    if ($receiver$iv222 instanceof Collection && ((Collection)$receiver$iv222).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $receiver$iv222) {
                            State it = (State)element$iv;
                            if (!(it.getAmount().getQuantity() == 0L)) continue;
                            bl = false;
                            break block10;
                        }
                        bl = true;
                    }
                }
                boolean $receiver$iv222 = bl;
                if (expr$iv == false) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)((Object)$receiver$iv2));
                }
                $receiver$iv2 = tx.getCommands();
                CommandWithParties setLifecycleCommand = (CommandWithParties)CollectionsKt.firstOrNull((List)ContractsDSL.select((Collection)$receiver$iv2, Commands.SetLifecycle.class, (PublicKey)(signer$iv3 = (PublicKey)null), (AbstractParty)(party$iv3 = (AbstractParty)null)));
                if (setLifecycleCommand != null) {
                    this.verifySetLifecycleCommand(inputs, outputs, tx, (CommandWithParties<Commands.SetLifecycle>)setLifecycleCommand);
                    continue;
                }
                this.verifyLifecycleCommand(inputs, outputs);
                Collection $receiver$iv3 = tx.getCommands();
                PublicKey signer$iv4 = null;
                AbstractParty party$iv4 = null;
                CommandWithParties settleCommand = (CommandWithParties)CollectionsKt.firstOrNull((List)ContractsDSL.select((Collection)$receiver$iv3, Commands.Settle.class, (PublicKey)signer$iv4, (AbstractParty)party$iv4));
                if (settleCommand != null) {
                    this.verifySettleCommand(tx, inputs, outputs, settleCommand, key);
                    continue;
                }
                $receiver$iv222 = tx.getCommands();
                CommandWithParties issueCommand = (CommandWithParties)CollectionsKt.firstOrNull((List)ContractsDSL.select((Collection)$receiver$iv222, Commands.Issue.class, (PublicKey)(signer$iv2 = (PublicKey)null), (AbstractParty)(party$iv2 = (AbstractParty)null)));
                if (issueCommand != null) {
                    this.verifyIssueCommand(tx, inputs, outputs, (CommandWithParties<Commands.Issue>)issueCommand, key);
                    continue;
                }
                this.conserveAmount(tx, inputs, outputs, key);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void conserveAmount(LedgerTransaction tx, List<? extends FungibleAsset<Terms<P>>> inputs, List<? extends FungibleAsset<Terms<P>>> outputs, Issued<Terms<P>> key) {
        Object item$iv$iv$iv2;
        void $receiver$iv$iv$iv;
        String $receiver$iv;
        boolean expr$iv;
        FungibleAsset it;
        boolean bl;
        Requirements $receiver;
        Object amountExitingLedger;
        Amount outputAmount;
        Amount inputAmount;
        PartyAndReference issuer;
        block13: {
            CommandWithParties exitCommand;
            Object object;
            Object v1;
            Object element$iv$iv2;
            Terms terms;
            block12: {
                Iterable $receiver$iv2;
                Collection $receiver$iv$iv;
                Iterable $receiver$iv3;
                issuer = key.getIssuer();
                terms = (Terms)key.getProduct();
                Amount amount = StateSumming.sumObligationsOrNull((Iterable<? extends ContractState>)inputs);
                if (amount == null) {
                    throw (Throwable)new IllegalArgumentException("there is at least one obligation input for this group");
                }
                inputAmount = amount;
                outputAmount = StateSumming.sumObligationsOrZero((Iterable<? extends ContractState>)outputs, new Issued(issuer, (Object)terms));
                Iterable iterable = $receiver$iv3 = (Iterable)inputs;
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv2 : $receiver$iv$iv) {
                    FungibleAsset it2 = (FungibleAsset)element$iv$iv2;
                    Iterable list$iv$iv = it2.getExitKeys();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                Set exitKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                $receiver$iv$iv = tx.getCommands();
                Collection parties$iv = null;
                $receiver$iv2 = ContractsDSL.select((Collection)$receiver$iv2, Commands.Exit.class, (Collection)exitKeys, parties$iv);
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $receiver$iv2) {
                    CommandWithParties it3 = (CommandWithParties)element$iv;
                    if (!Intrinsics.areEqual((Object)((Issued)((Commands.Exit)it3.getValue()).getAmount().getToken()), key)) continue;
                    if (found$iv) {
                        v1 = null;
                        break block12;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v1 = !found$iv ? null : single$iv;
            }
            if ((object = (exitCommand = (CommandWithParties)v1)) == null || (object = (Commands.Exit)object.getValue()) == null || (object = ((Commands.Exit)object).getAmount()) == null) {
                object = new Amount(0L, (Object)new Issued(issuer, (Object)terms));
            }
            amountExitingLedger = object;
            $receiver = Requirements.INSTANCE;
            String found$iv = "there are no zero sized inputs";
            element$iv$iv2 = $receiver;
            Iterable $receiver$iv4 = inputs;
            if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv4) {
                    it = (FungibleAsset)element$iv;
                    if (!(it.getAmount().getQuantity() == 0L)) continue;
                    bl = false;
                    break block13;
                }
                bl = true;
            }
        }
        boolean $receiver$iv4 = bl;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "for reference " + issuer.getReference() + " at issuer " + issuer.getParty().nameOrNull() + " the amounts balance";
        Object this_$iv = $receiver;
        expr$iv = Intrinsics.areEqual(inputAmount, (Object)outputAmount.plus((Amount)amountExitingLedger));
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        List commands$iv = tx.getCommands();
        Iterable $receiver$iv$iv = inputs;
        this_$iv = $receiver$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
        for (Object item$iv$iv$iv2 : $receiver$iv$iv$iv) {
            void it$iv;
            it = (OwnableState)item$iv$iv$iv2;
            Collection collection = destination$iv$iv$iv;
            PublicKey publicKey = it$iv.getOwner().getOwningKey();
            collection.add(publicKey);
        }
        Set owningPubKeys$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv$iv));
        Collection $receiver$iv$iv2 = commands$iv;
        CommandWithParties command$iv = ContractsDSL.requireSingleCommand((Collection)$receiver$iv$iv2, Commands.Move.class);
        Set keysThatSigned$iv = CollectionsKt.toSet((Iterable)command$iv.getSigners());
        Requirements $receiver$iv2 = Requirements.INSTANCE;
        String $i$f$using = "the owning keys are a subset of the signing keys";
        item$iv$iv$iv2 = $receiver$iv2;
        boolean expr$iv$iv = keysThatSigned$iv.containsAll(owningPubKeys$iv);
        if (!expr$iv$iv) {
            void $receiver$iv$iv3;
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv$iv3);
        }
        MoveCommand cfr_ignored_0 = (MoveCommand)command$iv.getValue();
    }

    private final void verifyIssueCommand(LedgerTransaction tx, List<? extends FungibleAsset<Terms<P>>> inputs, List<? extends FungibleAsset<Terms<P>>> outputs, CommandWithParties<Commands.Issue> issueCommand, Issued<Terms<P>> key) {
        String $receiver$iv;
        PartyAndReference issuer = key.getIssuer();
        Terms terms = (Terms)key.getProduct();
        Amount inputAmount = StateSumming.sumObligationsOrZero((Iterable<? extends ContractState>)inputs, new Issued(issuer, (Object)terms));
        Amount outputAmount = StateSumming.sumObligations((Iterable<? extends ContractState>)outputs);
        Collection $receiver$iv2 = tx.getCommands();
        Object signer$iv = null;
        AbstractParty party$iv = null;
        List issueCommands = ContractsDSL.select((Collection)$receiver$iv2, Commands.Issue.class, (PublicKey)signer$iv, (AbstractParty)party$iv);
        Requirements $receiver = Requirements.INSTANCE;
        signer$iv = "output states are issued by a command signer";
        party$iv = $receiver;
        boolean expr$iv = issueCommand.getSigners().contains(issuer.getParty().getOwningKey());
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "output values sum to more than the inputs";
        Requirements this_$iv = $receiver;
        boolean bl = expr$iv = outputAmount.compareTo(inputAmount) > 0;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "there is only a single issue command";
        this_$iv = $receiver;
        Collection expr$iv32 = issueCommands;
        boolean expr$iv32 = expr$iv32.size() == 1;
        if (!expr$iv32) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifySettleCommand(LedgerTransaction tx, List<? extends FungibleAsset<Terms<P>>> inputs, List<? extends FungibleAsset<Terms<P>>> outputs, CommandWithParties<Commands.Settle<P>> command, Issued<Terms<P>> groupingKey) {
        boolean bl;
        Requirements this_$iv;
        Requirements $receiver;
        Object $receiver$iv;
        long totalPenniesSettled;
        Amount<Issued<Terms<P>>> outputAmount;
        Amount inputAmount;
        AbstractParty obligor;
        block33: {
            void expr$iv;
            boolean bl2;
            Class clazz;
            void it;
            Collection collection;
            Object item$iv$iv;
            Iterator $receiver$iv$iv;
            Collection destination$iv$iv;
            Amount totalAmountSettled;
            Object it2;
            Set requiredSigners;
            Map amountReceivedByOwner;
            block32: {
                Amount<Issued<Terms<P>>> debt;
                List obligations;
                Object beneficiary;
                AbstractParty key$iv$iv;
                void $receiver$iv$iv2;
                Iterator it3;
                Iterator $receiver$iv$iv3;
                Map $receiver$iv$iv$iv;
                void $receiver$iv$iv4;
                Object $receiver$iv2;
                void expr$iv322;
                String $receiver$iv$iv5;
                Iterable $receiver$iv3;
                Object element$iv2;
                boolean bl3;
                List assetStates;
                Terms template;
                block31: {
                    obligor = groupingKey.getIssuer().getParty();
                    template = (Terms)groupingKey.getProduct();
                    Amount amount = StateSumming.sumObligationsOrNull((Iterable<? extends ContractState>)inputs);
                    if (amount == null) {
                        throw (Throwable)new IllegalArgumentException("there is at least one obligation input for this group");
                    }
                    inputAmount = amount;
                    outputAmount = StateSumming.sumObligationsOrZero((Iterable<? extends ContractState>)outputs, groupingKey);
                    LedgerTransaction this_$iv2 = tx;
                    assetStates = this_$iv2.outputsOfType(FungibleAsset.class);
                    Iterable $receiver$iv4 = tx.getAttachments();
                    if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                        bl3 = false;
                    } else {
                        for (Object element$iv2 : $receiver$iv4) {
                            Attachment it4 = (Attachment)element$iv2;
                            if (!template.getAcceptableContracts().contains((Object)it4.getId())) continue;
                            bl3 = true;
                            break block31;
                        }
                        bl3 = false;
                    }
                }
                boolean acceptableContract = bl3;
                Requirements $receiver2 = Requirements.INSTANCE;
                String string = "an acceptable contract is attached";
                element$iv2 = $receiver2;
                boolean expr$iv2 = acceptableContract;
                if (!expr$iv2) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)((Object)$receiver$iv3));
                }
                Iterable this_$iv3 = $receiver$iv3 = (Iterable)assetStates;
                Collection destination$iv$iv2 = new ArrayList();
                Object $i$f$using22 = $receiver$iv$iv5.iterator();
                while ($i$f$using22.hasNext()) {
                    Object element$iv$iv = $i$f$using22.next();
                    FungibleAsset it5 = (FungibleAsset)element$iv$iv;
                    if (!CollectionsKt.contains((Iterable)((Iterable)template.getAcceptableIssuedProducts()), (Object)it5.getAmount().getToken())) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                List acceptableAssetStates = (List)destination$iv$iv2;
                Requirements $receiver3 = Requirements.INSTANCE;
                $receiver$iv$iv5 = "there are fungible asset state outputs";
                destination$iv$iv2 = $receiver3;
                $i$f$using22 = assetStates;
                boolean $i$f$using22 = !$i$f$using22.isEmpty();
                if (expr$iv322 == false) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
                }
                $receiver$iv2 = "there are defined acceptable fungible asset states";
                Object this_$iv4 = $receiver3;
                Collection expr$iv322 = acceptableAssetStates;
                boolean expr$iv322 = !expr$iv322.isEmpty();
                if (!expr$iv322) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
                }
                $receiver$iv2 = acceptableAssetStates;
                this_$iv4 = $receiver$iv2;
                Map destination$iv$iv3 = new LinkedHashMap();
                Iterator $i$f$using = $receiver$iv$iv4.iterator();
                while ($i$f$using.hasNext()) {
                    Object object;
                    $receiver$iv$iv$iv = destination$iv$iv3;
                    Object element$iv$iv = $i$f$using.next();
                    FungibleAsset it6 = (FungibleAsset)element$iv$iv;
                    AbstractParty key$iv$iv2 = it6.getOwner();
                    Object value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv2);
                    if (value$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv.put(key$iv$iv2, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                amountReceivedByOwner = destination$iv$iv3;
                Collection $receiver$iv5 = tx.getCommands();
                PublicKey signer$iv = null;
                AbstractParty party$iv = null;
                List moveCommands = ContractsDSL.select((Collection)$receiver$iv5, MoveCommand.class, (PublicKey)signer$iv, (AbstractParty)party$iv);
                totalPenniesSettled = 0L;
                Object $receiver$iv6 = inputs;
                Iterable $i$f$select = $receiver$iv6;
                Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv6, (int)10));
                Object $i$a$1$groupBy = $receiver$iv$iv3.iterator();
                while ($i$a$1$groupBy.hasNext()) {
                    Object item$iv$iv2 = $i$a$1$groupBy.next();
                    $receiver$iv$iv$iv = (FungibleAsset)item$iv$iv2;
                    Collection collection2 = destination$iv$iv4;
                    PublicKey publicKey = ((Issued)it3.getAmount().getToken()).getIssuer().getParty().getOwningKey();
                    collection2.add(publicKey);
                }
                requiredSigners = CollectionsKt.toSet((Iterable)((List)destination$iv$iv4));
                $i$a$1$groupBy = $receiver$iv = (Iterable)inputs;
                Object destination$iv$iv5 = new LinkedHashMap();
                it3 = $receiver$iv$iv2.iterator();
                while (it3.hasNext()) {
                    Object object;
                    Object $receiver$iv$iv$iv2 = destination$iv$iv5;
                    Object element$iv$iv = it3.next();
                    it2 = (FungibleAsset)element$iv$iv;
                    key$iv$iv = it2.getOwner();
                    Object value$iv$iv$iv = $receiver$iv$iv$iv2.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        ArrayList answer$iv$iv$iv = new ArrayList();
                        $receiver$iv$iv$iv2.put(key$iv$iv, answer$iv$iv$iv);
                        object = answer$iv$iv$iv;
                    } else {
                        object = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object;
                    list$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = destination$iv$iv5;
                $receiver$iv$iv3 = $receiver$iv.entrySet().iterator();
                while ($receiver$iv$iv3.hasNext()) {
                    boolean element$iv$iv;
                    destination$iv$iv5 = $receiver$iv6 = $receiver$iv$iv3.next();
                    beneficiary = (AbstractParty)destination$iv$iv5.getKey();
                    destination$iv$iv5 = $receiver$iv6;
                    obligations = (List)destination$iv$iv5.getValue();
                    List list = (List)amountReceivedByOwner.get(beneficiary);
                    Object settled = list != null ? StateSumming.sumFungibleOrNull(list) : null;
                    if (settled == null) continue;
                    debt = StateSumming.sumObligationsOrZero(obligations, groupingKey);
                    boolean bl4 = element$iv$iv = settled.getQuantity() <= debt.getQuantity();
                    if (!element$iv$iv) {
                        String $i$a$3$groupBy = "Payment of " + settled + " must not exceed debt " + debt;
                        throw (Throwable)new IllegalArgumentException($i$a$3$groupBy.toString());
                    }
                    totalPenniesSettled += settled.getQuantity();
                }
                totalAmountSettled = new Amount(totalPenniesSettled, ((Commands.Settle)command.getValue()).getAmount().getToken());
                $receiver = Requirements.INSTANCE;
                beneficiary = "all move commands relate to this contract";
                obligations = $receiver;
                Object $receiver$iv7 = (Amount<Issued<Terms<P>>>)moveCommands;
                debt = $receiver$iv7;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv7, (int)10));
                Iterator $i$a$4$require = $receiver$iv$iv.iterator();
                while ($i$a$4$require.hasNext()) {
                    item$iv$iv = $i$a$4$require.next();
                    key$iv$iv = (CommandWithParties)item$iv$iv;
                    collection = destination$iv$iv;
                    clazz = ((MoveCommand)it.getValue()).getContract();
                    collection.add(clazz);
                }
                $receiver$iv7 = (List)destination$iv$iv;
                if ($receiver$iv7 instanceof Collection && ((Collection)$receiver$iv7).isEmpty()) {
                    bl2 = true;
                } else {
                    $receiver$iv$iv = $receiver$iv7.iterator();
                    while ($receiver$iv$iv.hasNext()) {
                        Object element$iv3 = $receiver$iv$iv.next();
                        it2 = (Class)element$iv3;
                        if (it2 == null || Intrinsics.areEqual((Object)it2, this.getClass())) continue;
                        bl2 = false;
                        break block32;
                    }
                    bl2 = true;
                }
            }
            boolean $receiver$iv8 = bl2;
            if (expr$iv == false) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = "amounts paid must match recipients to settle";
            this_$iv = $receiver;
            Iterable $receiver$iv2 = inputs;
            Iterable $i$f$using = $receiver$iv2;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
            it2 = $receiver$iv$iv.iterator();
            while (it2.hasNext()) {
                item$iv$iv = it2.next();
                FungibleAsset $i$f$all = (FungibleAsset)item$iv$iv;
                collection = destination$iv$iv;
                clazz = it.getOwner();
                collection.add(clazz);
            }
            boolean expr$iv2 = ((List)destination$iv$iv).containsAll(amountReceivedByOwner.keySet());
            if (!expr$iv2) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = "amount in settle command " + ((Commands.Settle)command.getValue()).getAmount() + " matches settled total " + totalAmountSettled;
            this_$iv = $receiver;
            expr$iv2 = Intrinsics.areEqual(((Commands.Settle)command.getValue()).getAmount(), (Object)totalAmountSettled);
            if (!expr$iv2) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = "signatures are present from all obligors";
            this_$iv = $receiver;
            expr$iv2 = command.getSigners().containsAll(requiredSigners);
            if (!expr$iv2) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = "there are no zero sized inputs";
            this_$iv = $receiver;
            Iterable $receiver$iv3 = inputs;
            if ($receiver$iv3 instanceof Collection && ((Collection)$receiver$iv3).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv3 : $receiver$iv3) {
                    it2 = (FungibleAsset)element$iv3;
                    if (!(it2.getAmount().getQuantity() == 0L)) continue;
                    bl = false;
                    break block33;
                }
                bl = true;
            }
        }
        boolean $receiver$iv3 = bl;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
        $receiver$iv = "at obligor " + obligor + " the obligations after settlement balance";
        this_$iv = $receiver;
        boolean expr$iv = Intrinsics.areEqual(inputAmount, (Object)outputAmount.plus(new Amount(totalPenniesSettled, groupingKey)));
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyLifecycleCommand(List<? extends ContractState> inputs, List<? extends ContractState> outputs) {
        void expr$iv;
        boolean bl;
        String $receiver$iv;
        block11: {
            void expr$iv2;
            State it;
            boolean bl2;
            Requirements $receiver;
            List filteredOutputs;
            block10: {
                String $receiver$iv$iv;
                Object element$iv$iv2;
                void $receiver$iv$iv2;
                Iterable $receiver$iv2;
                Iterable iterable = $receiver$iv2 = (Iterable)inputs;
                Iterable destination$iv$iv = new ArrayList();
                for (Object element$iv$iv2 : $receiver$iv$iv2) {
                    if (!(element$iv$iv2 instanceof State)) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                List filteredInputs = (List)destination$iv$iv;
                Iterable $receiver$iv3 = outputs;
                destination$iv$iv = $receiver$iv3;
                Collection destination$iv$iv2 = new ArrayList();
                element$iv$iv2 = $receiver$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv3 = element$iv$iv2.next();
                    if (!(element$iv$iv3 instanceof State)) continue;
                    destination$iv$iv2.add(element$iv$iv3);
                }
                filteredOutputs = (List)destination$iv$iv2;
                $receiver = Requirements.INSTANCE;
                $receiver$iv$iv = "all inputs are in the normal state ";
                destination$iv$iv2 = $receiver;
                Iterable $receiver$iv4 = filteredInputs;
                if ($receiver$iv4 instanceof Collection && ((Collection)$receiver$iv4).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $receiver$iv4) {
                        it = (State)element$iv;
                        if (it.getLifecycle() == Lifecycle.NORMAL) continue;
                        bl2 = false;
                        break block10;
                    }
                    bl2 = true;
                }
            }
            boolean $receiver$iv4 = bl2;
            if (expr$iv2 == false) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
            }
            $receiver$iv = "all outputs are in the normal state ";
            Requirements this_$iv = $receiver;
            Iterable $receiver$iv2 = filteredOutputs;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv2) {
                    it = (State)element$iv;
                    if (it.getLifecycle() == Lifecycle.NORMAL) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        boolean $receiver$iv2 = bl;
        if (expr$iv == false) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyNetCommand(LedgerTransaction tx, CommandWithParties<? extends NetCommand> command) {
        List list;
        switch (Obligation$WhenMappings.$EnumSwitchMapping$0[((NetCommand)command.getValue()).getType().ordinal()]) {
            case 1: {
                LedgerTransaction this_$iv;
                LedgerTransaction ledgerTransaction = tx;
                Function1 selector$iv = verifyNetCommand.groups.1.INSTANCE;
                list = this_$iv.groupStates(State.class, selector$iv);
                break;
            }
            case 2: {
                LedgerTransaction this_$iv = tx;
                Function1 selector$iv = verifyNetCommand.groups.2.INSTANCE;
                list = this_$iv.groupStates(State.class, selector$iv);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List groups2 = list;
        block8: for (LedgerTransaction ledgerTransaction : groups2) {
            Object object;
            Iterable iterable;
            Object item$iv$iv;
            Object $receiver$iv$iv;
            boolean expr$iv;
            boolean bl;
            Object this_$iv;
            Object $receiver$iv;
            State it;
            Object object2;
            Requirements $receiver;
            Map outputBalances;
            Map inputBalances;
            List groupInputs;
            block21: {
                void expr$iv2;
                boolean bl2;
                Terms template;
                List groupOutputs;
                block20: {
                    groupInputs = ledgerTransaction.component1();
                    groupOutputs = ledgerTransaction.component2();
                    NetState key = (NetState)ledgerTransaction.component3();
                    template = key.getTemplate();
                    inputBalances = ObligationKt.extractAmountsDue(template, groupInputs);
                    outputBalances = ObligationKt.extractAmountsDue(template, groupOutputs);
                    $receiver = Requirements.INSTANCE;
                    object2 = "all input states use the same template";
                    Requirements requirements = $receiver;
                    Iterable $receiver$iv2 = groupInputs;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $receiver$iv2) {
                            it = (State)element$iv;
                            if (Intrinsics.areEqual(it.getTemplate(), template)) continue;
                            bl2 = false;
                            break block20;
                        }
                        bl2 = true;
                    }
                }
                boolean $receiver$iv2 = bl2;
                if (expr$iv2 == false) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
                }
                $receiver$iv = "all output states use the same template";
                this_$iv = $receiver;
                Iterable $receiver$iv22 = groupOutputs;
                if ($receiver$iv22 instanceof Collection && ((Collection)$receiver$iv22).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv22) {
                        it = (State)element$iv;
                        if (Intrinsics.areEqual(it.getTemplate(), template)) continue;
                        bl = false;
                        break block21;
                    }
                    bl = true;
                }
            }
            boolean $receiver$iv22 = bl;
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = "amounts owed on input and output must match";
            this_$iv = $receiver;
            expr$iv = Intrinsics.areEqual(ObligationKt.sumAmountsDue(inputBalances), ObligationKt.sumAmountsDue(outputBalances));
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv);
            }
            $receiver$iv = groupInputs;
            this_$iv = $receiver$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            Iterator iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                it = (State)item$iv$iv;
                iterable = destination$iv$iv;
                object = it.getBeneficiary().getOwningKey();
                iterable.add(object);
            }
            $receiver$iv = groupInputs;
            iterable = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            iterator = $receiver$iv$iv.iterator();
            while (iterator.hasNext()) {
                item$iv$iv = iterator.next();
                it = (State)item$iv$iv;
                object = destination$iv$iv;
                PublicKey publicKey = it.getObligor().getOwningKey();
                object.add(publicKey);
            }
            object = (List)destination$iv$iv;
            Set involvedParties = CollectionsKt.toSet((Iterable)CollectionsKt.union((Iterable)iterable, (Iterable)((Iterable)object)));
            switch (Obligation$WhenMappings.$EnumSwitchMapping$1[((NetCommand)command.getValue()).getType().ordinal()]) {
                case 1: {
                    object2 = CollectionsKt.intersect((Iterable)command.getSigners(), (Iterable)involvedParties);
                    boolean bl3 = !object2.isEmpty();
                    if (bl3) continue block8;
                    String string = "any involved party has signed";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
                case 2: {
                    boolean bl4 = command.getSigners().containsAll(involvedParties);
                    if (bl4) break;
                    String string = "all involved parties have signed";
                    throw (Throwable)new IllegalArgumentException(string.toString());
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void verifySetLifecycleCommand(List<? extends FungibleAsset<Terms<P>>> inputs, List<? extends FungibleAsset<Terms<P>>> outputs, LedgerTransaction tx, CommandWithParties<Commands.SetLifecycle> setLifecycleCommand) {
        FungibleAsset it;
        Iterable $receiver$iv$iv;
        Requirements deadline;
        boolean bl;
        boolean bl2 = bl = inputs.size() == outputs.size();
        if (!bl) {
            String string = "Number of inputs and outputs must match";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Lifecycle expectedInputLifecycle = ((Commands.SetLifecycle)setLifecycleCommand.getValue()).getInverse();
        Lifecycle expectedOutputLifecycle = ((Commands.SetLifecycle)setLifecycleCommand.getValue()).getLifecycle();
        boolean bl3 = false;
        for (FungibleAsset input : (Iterable)inputs) {
            void stateIdx;
            if (input instanceof State) {
                String $receiver$iv;
                boolean expr$iv;
                FungibleAsset<Terms<P>> actualOutput = outputs.get((int)stateIdx);
                deadline = ((State)input).getDueBefore();
                TimeWindow timeWindow = tx.getTimeWindow();
                State expectedOutput = State.copy$default((State)input, expectedOutputLifecycle, null, null, 0L, null, 30, null);
                Requirements $receiver = Requirements.INSTANCE;
                String string = "there is a time-window from the authority";
                Requirements requirements = $receiver;
                boolean bl4 = expr$iv = timeWindow != null;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "the due date has passed";
                Requirements this_$iv = $receiver;
                TimeWindow timeWindow2 = timeWindow;
                if (timeWindow2 == null) {
                    Intrinsics.throwNpe();
                }
                Instant instant = timeWindow2.getFromTime();
                boolean bl5 = expr$iv = instant != null && instant.isAfter((Instant)deadline);
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "input state lifecycle is correct";
                this_$iv = $receiver;
                boolean bl6 = expr$iv = ((State)input).getLifecycle() == expectedInputLifecycle;
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
                $receiver$iv = "output state corresponds exactly to input state, with lifecycle changed";
                this_$iv = $receiver;
                expr$iv = Intrinsics.areEqual((Object)expectedOutput, actualOutput);
                if (!expr$iv) {
                    throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
                }
            }
            ++stateIdx;
        }
        Iterable $receiver$iv = inputs;
        Iterable iterable = $receiver$iv;
        Object destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (FungibleAsset)element$iv$iv;
            if (!(it instanceof State)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (FungibleAsset)item$iv$iv;
            Collection collection = destination$iv$iv;
            FungibleAsset fungibleAsset = it;
            if (fungibleAsset == null) {
                throw new TypeCastException("null cannot be cast to non-null type net.corda.finance.contracts.asset.Obligation.State<P>");
            }
            PublicKey publicKey = ((State)fungibleAsset).getBeneficiary().getOwningKey();
            collection.add(publicKey);
        }
        Set owningPubKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set keysThatSigned = CollectionsKt.toSet((Iterable)setLifecycleCommand.getSigners());
        Requirements $receiver = Requirements.INSTANCE;
        destination$iv$iv = "the owning keys are a subset of the signing keys";
        deadline = $receiver;
        boolean expr$iv = keysThatSigned.containsAll(owningPubKeys);
        if (!expr$iv) {
            void $receiver$iv2;
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv2);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;", "", "(Ljava/lang/String;I)V", "NORMAL", "DEFAULTED", "contracts"})
    public static final class Lifecycle
    extends Enum<Lifecycle> {
        public static final /* enum */ Lifecycle NORMAL;
        public static final /* enum */ Lifecycle DEFAULTED;
        private static final /* synthetic */ Lifecycle[] $VALUES;

        static {
            Lifecycle[] lifecycleArray = new Lifecycle[2];
            Lifecycle[] lifecycleArray2 = lifecycleArray;
            lifecycleArray[0] = NORMAL = new Lifecycle();
            lifecycleArray[1] = DEFAULTED = new Lifecycle();
            $VALUES = lifecycleArray;
        }

        public static Lifecycle[] values() {
            return (Lifecycle[])$VALUES.clone();
        }

        public static Lifecycle valueOf(String string) {
            return Enum.valueOf(Lifecycle.class, string);
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0002B9\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u00c6\u0003J\u0015\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0004H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u000bH\u00c6\u0003JI\u0010\u001b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00042\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00028\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006#"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Terms;", "P", "", "acceptableContracts", "Lnet/corda/core/utilities/NonEmptySet;", "Lnet/corda/core/crypto/SecureHash;", "acceptableIssuedProducts", "Lnet/corda/core/contracts/Issued;", "dueBefore", "Ljava/time/Instant;", "timeTolerance", "Ljava/time/Duration;", "(Lnet/corda/core/utilities/NonEmptySet;Lnet/corda/core/utilities/NonEmptySet;Ljava/time/Instant;Ljava/time/Duration;)V", "getAcceptableContracts", "()Lnet/corda/core/utilities/NonEmptySet;", "getAcceptableIssuedProducts", "getDueBefore", "()Ljava/time/Instant;", "product", "getProduct", "()Ljava/lang/Object;", "getTimeTolerance", "()Ljava/time/Duration;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "contracts"})
    public static final class Terms<P> {
        @NotNull
        private final NonEmptySet<SecureHash> acceptableContracts;
        @NotNull
        private final NonEmptySet<Issued<P>> acceptableIssuedProducts;
        @NotNull
        private final Instant dueBefore;
        @NotNull
        private final Duration timeTolerance;

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final P getProduct() {
            void var3_3;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)this.acceptableIssuedProducts;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                Issued issued = (Issued)item$iv$iv;
                Collection collection = destination$iv$iv;
                Object object = it.getProduct();
                collection.add(object);
            }
            return (P)CollectionsKt.single((Iterable)CollectionsKt.toSet((Iterable)((List)var3_3)));
        }

        @NotNull
        public final NonEmptySet<SecureHash> getAcceptableContracts() {
            return this.acceptableContracts;
        }

        @NotNull
        public final NonEmptySet<Issued<P>> getAcceptableIssuedProducts() {
            return this.acceptableIssuedProducts;
        }

        @NotNull
        public final Instant getDueBefore() {
            return this.dueBefore;
        }

        @NotNull
        public final Duration getTimeTolerance() {
            return this.timeTolerance;
        }

        public Terms(@NotNull NonEmptySet<SecureHash> acceptableContracts, @NotNull NonEmptySet<Issued<P>> acceptableIssuedProducts, @NotNull Instant dueBefore, @NotNull Duration timeTolerance) {
            Intrinsics.checkParameterIsNotNull(acceptableContracts, (String)"acceptableContracts");
            Intrinsics.checkParameterIsNotNull(acceptableIssuedProducts, (String)"acceptableIssuedProducts");
            Intrinsics.checkParameterIsNotNull((Object)dueBefore, (String)"dueBefore");
            Intrinsics.checkParameterIsNotNull((Object)timeTolerance, (String)"timeTolerance");
            this.acceptableContracts = acceptableContracts;
            this.acceptableIssuedProducts = acceptableIssuedProducts;
            this.dueBefore = dueBefore;
            this.timeTolerance = timeTolerance;
        }

        public /* synthetic */ Terms(NonEmptySet nonEmptySet, NonEmptySet nonEmptySet2, Instant instant, Duration duration, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                duration = KotlinUtilsKt.getSeconds((int)30);
            }
            this((NonEmptySet<SecureHash>)nonEmptySet, nonEmptySet2, instant, duration);
        }

        @NotNull
        public final NonEmptySet<SecureHash> component1() {
            return this.acceptableContracts;
        }

        @NotNull
        public final NonEmptySet<Issued<P>> component2() {
            return this.acceptableIssuedProducts;
        }

        @NotNull
        public final Instant component3() {
            return this.dueBefore;
        }

        @NotNull
        public final Duration component4() {
            return this.timeTolerance;
        }

        @NotNull
        public final Terms<P> copy(@NotNull NonEmptySet<SecureHash> acceptableContracts, @NotNull NonEmptySet<Issued<P>> acceptableIssuedProducts, @NotNull Instant dueBefore, @NotNull Duration timeTolerance) {
            Intrinsics.checkParameterIsNotNull(acceptableContracts, (String)"acceptableContracts");
            Intrinsics.checkParameterIsNotNull(acceptableIssuedProducts, (String)"acceptableIssuedProducts");
            Intrinsics.checkParameterIsNotNull((Object)dueBefore, (String)"dueBefore");
            Intrinsics.checkParameterIsNotNull((Object)timeTolerance, (String)"timeTolerance");
            return new Terms<P>(acceptableContracts, acceptableIssuedProducts, dueBefore, timeTolerance);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ Terms copy$default(Terms terms, NonEmptySet nonEmptySet, NonEmptySet nonEmptySet2, Instant instant, Duration duration, int n, Object object) {
            if ((n & 1) != 0) {
                nonEmptySet = terms.acceptableContracts;
            }
            if ((n & 2) != 0) {
                nonEmptySet2 = terms.acceptableIssuedProducts;
            }
            if ((n & 4) != 0) {
                instant = terms.dueBefore;
            }
            if ((n & 8) != 0) {
                duration = terms.timeTolerance;
            }
            return terms.copy(nonEmptySet, nonEmptySet2, instant, duration);
        }

        @NotNull
        public String toString() {
            return "Terms(acceptableContracts=" + this.acceptableContracts + ", acceptableIssuedProducts=" + this.acceptableIssuedProducts + ", dueBefore=" + this.dueBefore + ", timeTolerance=" + this.timeTolerance + ")";
        }

        public int hashCode() {
            NonEmptySet<SecureHash> nonEmptySet = this.acceptableContracts;
            NonEmptySet<Issued<P>> nonEmptySet2 = this.acceptableIssuedProducts;
            Instant instant = this.dueBefore;
            Duration duration = this.timeTolerance;
            return (((nonEmptySet != null ? nonEmptySet.hashCode() : 0) * 31 + (nonEmptySet2 != null ? nonEmptySet2.hashCode() : 0)) * 31 + (instant != null ? ((Object)instant).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Terms)) break block3;
                    Terms terms = (Terms)object;
                    if (!Intrinsics.areEqual(this.acceptableContracts, terms.acceptableContracts) || !Intrinsics.areEqual(this.acceptableIssuedProducts, terms.acceptableIssuedProducts) || !Intrinsics.areEqual((Object)this.dueBefore, (Object)terms.dueBefore) || !Intrinsics.areEqual((Object)this.timeTolerance, (Object)terms.timeTolerance)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00060\u0005B5\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000fJ\t\u00106\u001a\u00020\bH\u00c6\u0003J\t\u00107\u001a\u00020\nH\u00c6\u0003J\u000f\u00108\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u00c6\u0003J\t\u00109\u001a\u00020\rH\u00c6\u0003J\t\u0010:\u001a\u00020\nH\u00c6\u0003JG\u0010;\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\nH\u00c6\u0001J\u0013\u0010<\u001a\u00020=2\b\u0010>\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010?\u001a\u00020@H\u00d6\u0001J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\f\u0010>\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0016J\b\u0010B\u001a\u00020CH\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\nH\u0016J0\u0010G\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0018\u0010H\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00120\u00112\u0006\u0010F\u001a\u00020\nH\u0016R&\u0010\u0010\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00028\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0016R\u0014\u0010,\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u0016R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\n0/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105\u00a8\u0006I"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$State;", "P", "", "Lnet/corda/core/contracts/FungibleAsset;", "Lnet/corda/finance/contracts/asset/Obligation$Terms;", "Lnet/corda/finance/contracts/NettableState;", "Lnet/corda/finance/contracts/asset/MultilateralNetState;", "lifecycle", "Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;", "obligor", "Lnet/corda/core/identity/AbstractParty;", "template", "quantity", "", "beneficiary", "(Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;Lnet/corda/core/identity/AbstractParty;Lnet/corda/finance/contracts/asset/Obligation$Terms;JLnet/corda/core/identity/AbstractParty;)V", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "getAmount", "()Lnet/corda/core/contracts/Amount;", "getBeneficiary", "()Lnet/corda/core/identity/AbstractParty;", "bilateralNetState", "Lnet/corda/finance/contracts/asset/BilateralNetState;", "getBilateralNetState", "()Lnet/corda/finance/contracts/asset/BilateralNetState;", "dueBefore", "Ljava/time/Instant;", "getDueBefore", "()Ljava/time/Instant;", "exitKeys", "", "Ljava/security/PublicKey;", "getExitKeys", "()Ljava/util/Collection;", "getLifecycle", "()Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;", "setLifecycle", "(Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;)V", "multilateralNetState", "getMultilateralNetState", "()Lnet/corda/finance/contracts/asset/MultilateralNetState;", "getObligor", "owner", "getOwner", "participants", "", "getParticipants", "()Ljava/util/List;", "getQuantity", "()J", "getTemplate", "()Lnet/corda/finance/contracts/asset/Obligation$Terms;", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hashCode", "", "net", "toString", "", "withNewOwner", "Lnet/corda/core/contracts/CommandAndState;", "newOwner", "withNewOwnerAndAmount", "newAmount", "contracts"})
    public static final class State<P>
    implements FungibleAsset<Terms<P>>,
    NettableState<State<P>, MultilateralNetState<P>> {
        @NotNull
        private final Amount<Issued<Terms<P>>> amount;
        @NotNull
        private final Collection<PublicKey> exitKeys;
        @NotNull
        private final Instant dueBefore;
        @NotNull
        private final List<AbstractParty> participants;
        @NotNull
        private final AbstractParty owner;
        @NotNull
        private Lifecycle lifecycle;
        @NotNull
        private final AbstractParty obligor;
        @NotNull
        private final Terms<P> template;
        private final long quantity;
        @NotNull
        private final AbstractParty beneficiary;

        @NotNull
        public Amount<Issued<Terms<P>>> getAmount() {
            return this.amount;
        }

        @NotNull
        public Collection<PublicKey> getExitKeys() {
            return this.exitKeys;
        }

        @NotNull
        public final Instant getDueBefore() {
            return this.dueBefore;
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        @NotNull
        public AbstractParty getOwner() {
            return this.owner;
        }

        @NotNull
        public State<P> withNewOwnerAndAmount(@NotNull Amount<Issued<Terms<P>>> newAmount, @NotNull AbstractParty newOwner) {
            Intrinsics.checkParameterIsNotNull(newAmount, (String)"newAmount");
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return State.copy$default(this, null, null, null, newAmount.getQuantity(), newOwner, 7, null);
        }

        @NotNull
        public String toString() {
            String string;
            switch (Obligation$State$WhenMappings.$EnumSwitchMapping$0[this.lifecycle.ordinal()]) {
                case 1: {
                    string = Emoji.INSTANCE.getBagOfCash() + "Debt(" + this.getAmount() + " due " + this.dueBefore + " to " + this.beneficiary + ')';
                    break;
                }
                case 2: {
                    string = Emoji.INSTANCE.getBagOfCash() + "Debt(" + this.getAmount() + " unpaid by " + this.dueBefore + " to " + this.beneficiary + ')';
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @Override
        @NotNull
        public BilateralNetState<P> getBilateralNetState() {
            boolean bl;
            boolean bl2 = bl = this.lifecycle == Lifecycle.NORMAL;
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return new BilateralNetState<P>(SetsKt.setOf((Object[])new AbstractParty[]{this.obligor, this.beneficiary}), this.template);
        }

        @Override
        @NotNull
        public MultilateralNetState<P> getMultilateralNetState() {
            boolean bl;
            boolean bl2 = bl = this.lifecycle == Lifecycle.NORMAL;
            if (!bl) {
                String string = "Check failed.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return new MultilateralNetState<P>(this.template);
        }

        @Override
        @NotNull
        public State<P> net(@NotNull State<P> other) {
            Intrinsics.checkParameterIsNotNull(other, (String)"other");
            Object netA = this.getBilateralNetState();
            Object netB = other.getBilateralNetState();
            boolean bl = Intrinsics.areEqual((Object)netA, (Object)netB);
            if (!bl) {
                String string = "net substates of the two state objects must be identical";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            return Intrinsics.areEqual((Object)this.obligor.getOwningKey(), (Object)other.obligor.getOwningKey()) ? State.copy$default(this, null, null, null, this.quantity + other.quantity, null, 23, null) : State.copy$default(this, null, null, null, this.quantity - other.quantity, null, 23, null);
        }

        @NotNull
        public CommandAndState withNewOwner(@NotNull AbstractParty newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new CommandAndState((CommandData)new Commands.Move(null, 1, null), (OwnableState)State.copy$default(this, null, null, null, 0L, newOwner, 15, null));
        }

        @NotNull
        public final Lifecycle getLifecycle() {
            return this.lifecycle;
        }

        public final void setLifecycle(@NotNull Lifecycle lifecycle) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"<set-?>");
            this.lifecycle = lifecycle;
        }

        @NotNull
        public final AbstractParty getObligor() {
            return this.obligor;
        }

        @NotNull
        public final Terms<P> getTemplate() {
            return this.template;
        }

        public final long getQuantity() {
            return this.quantity;
        }

        @NotNull
        public final AbstractParty getBeneficiary() {
            return this.beneficiary;
        }

        public State(@NotNull Lifecycle lifecycle, @NotNull AbstractParty obligor, @NotNull Terms<P> template, long quantity, @NotNull AbstractParty beneficiary) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)obligor, (String)"obligor");
            Intrinsics.checkParameterIsNotNull(template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)beneficiary, (String)"beneficiary");
            this.lifecycle = lifecycle;
            this.obligor = obligor;
            this.template = template;
            this.quantity = quantity;
            this.beneficiary = beneficiary;
            this.amount = new Amount(this.quantity, (Object)new Issued(this.obligor.ref(new byte[]{0}), this.template));
            this.exitKeys = SetsKt.setOf((Object)this.beneficiary.getOwningKey());
            this.dueBefore = this.template.getDueBefore();
            this.participants = CollectionsKt.listOf((Object[])new AbstractParty[]{this.obligor, this.beneficiary});
            this.owner = this.beneficiary;
        }

        public /* synthetic */ State(Lifecycle lifecycle, AbstractParty abstractParty, Terms terms, long l, AbstractParty abstractParty2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                lifecycle = Lifecycle.NORMAL;
            }
            this(lifecycle, abstractParty, terms, l, abstractParty2);
        }

        @NotNull
        public final Lifecycle component1() {
            return this.lifecycle;
        }

        @NotNull
        public final AbstractParty component2() {
            return this.obligor;
        }

        @NotNull
        public final Terms<P> component3() {
            return this.template;
        }

        public final long component4() {
            return this.quantity;
        }

        @NotNull
        public final AbstractParty component5() {
            return this.beneficiary;
        }

        @NotNull
        public final State<P> copy(@NotNull Lifecycle lifecycle, @NotNull AbstractParty obligor, @NotNull Terms<P> template, long quantity, @NotNull AbstractParty beneficiary) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
            Intrinsics.checkParameterIsNotNull((Object)obligor, (String)"obligor");
            Intrinsics.checkParameterIsNotNull(template, (String)"template");
            Intrinsics.checkParameterIsNotNull((Object)beneficiary, (String)"beneficiary");
            return new State<P>(lifecycle, obligor, template, quantity, beneficiary);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, Lifecycle lifecycle, AbstractParty abstractParty, Terms terms, long l, AbstractParty abstractParty2, int n, Object object) {
            if ((n & 1) != 0) {
                lifecycle = state.lifecycle;
            }
            if ((n & 2) != 0) {
                abstractParty = state.obligor;
            }
            if ((n & 4) != 0) {
                terms = state.template;
            }
            if ((n & 8) != 0) {
                l = state.quantity;
            }
            if ((n & 0x10) != 0) {
                abstractParty2 = state.beneficiary;
            }
            return state.copy(lifecycle, abstractParty, terms, l, abstractParty2);
        }

        public int hashCode() {
            Lifecycle lifecycle = this.lifecycle;
            AbstractParty abstractParty = this.obligor;
            Terms<P> terms = this.template;
            AbstractParty abstractParty2 = this.beneficiary;
            return ((((lifecycle != null ? ((Object)((Object)lifecycle)).hashCode() : 0) * 31 + (abstractParty != null ? abstractParty.hashCode() : 0)) * 31 + (terms != null ? ((Object)terms).hashCode() : 0)) * 31 + Long.hashCode(this.quantity)) * 31 + (abstractParty2 != null ? abstractParty2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual((Object)((Object)this.lifecycle), (Object)((Object)state.lifecycle)) || !Intrinsics.areEqual((Object)this.obligor, (Object)state.obligor) || !Intrinsics.areEqual(this.template, state.template) || !(this.quantity == state.quantity) || !Intrinsics.areEqual((Object)this.beneficiary, (Object)state.beneficiary)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @CordaSerializable
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\bg\u0018\u00002\u00020\u0001:\u0006\u0002\u0003\u0004\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands;", "Lnet/corda/core/contracts/CommandData;", "Exit", "Issue", "Move", "Net", "SetLifecycle", "Settle", "contracts"})
    public static interface Commands
    extends CommandData {

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands$Net;", "Lnet/corda/finance/contracts/NetCommand;", "type", "Lnet/corda/finance/contracts/NetType;", "(Lnet/corda/finance/contracts/NetType;)V", "getType", "()Lnet/corda/finance/contracts/NetType;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "contracts"})
        public static final class Net
        implements NetCommand {
            @NotNull
            private final NetType type;

            @Override
            @NotNull
            public NetType getType() {
                return this.type;
            }

            public Net(@NotNull NetType type) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                this.type = type;
            }

            @NotNull
            public final NetType component1() {
                return this.getType();
            }

            @NotNull
            public final Net copy(@NotNull NetType type) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
                return new Net(type);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Net copy$default(Net net, NetType netType, int n, Object object) {
                if ((n & 1) != 0) {
                    netType = net.getType();
                }
                return net.copy(netType);
            }

            @NotNull
            public String toString() {
                return "Net(type=" + (Object)((Object)this.getType()) + ")";
            }

            public int hashCode() {
                NetType netType = this.getType();
                return netType != null ? ((Object)((Object)netType)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Net)) break block3;
                        Net net = (Net)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.getType()), (Object)((Object)net.getType()))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001d\u0010\t\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001e\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands$Move;", "Lnet/corda/core/contracts/MoveCommand;", "contract", "Ljava/lang/Class;", "Lnet/corda/core/contracts/Contract;", "(Ljava/lang/Class;)V", "getContract", "()Ljava/lang/Class;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "contracts"})
        public static final class Move
        implements MoveCommand {
            @Nullable
            private final Class<? extends Contract> contract;

            @Nullable
            public Class<? extends Contract> getContract() {
                return this.contract;
            }

            public Move(@Nullable Class<? extends Contract> contract) {
                this.contract = contract;
            }

            public /* synthetic */ Move(Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    clazz = null;
                }
                this(clazz);
            }

            public Move() {
                this(null, 1, null);
            }

            @Nullable
            public final Class<? extends Contract> component1() {
                return this.getContract();
            }

            @NotNull
            public final Move copy(@Nullable Class<? extends Contract> contract) {
                return new Move(contract);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Move copy$default(Move move, Class clazz, int n, Object object) {
                if ((n & 1) != 0) {
                    clazz = move.getContract();
                }
                return move.copy(clazz);
            }

            @NotNull
            public String toString() {
                return "Move(contract=" + this.getContract() + ")";
            }

            public int hashCode() {
                Class<? extends Contract> clazz = this.getContract();
                return clazz != null ? clazz.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Move)) break block3;
                        Move move = (Move)object;
                        if (!Intrinsics.areEqual(this.getContract(), move.getContract())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands$Issue;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "()V", "contracts"})
        public static final class Issue
        extends TypeOnlyCommandData {
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005H\u00c6\u0003J+\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands$Settle;", "P", "", "Lnet/corda/core/contracts/CommandData;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/finance/contracts/asset/Obligation$Terms;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "contracts"})
        public static final class Settle<P>
        implements CommandData {
            @NotNull
            private final Amount<Issued<Terms<P>>> amount;

            @NotNull
            public final Amount<Issued<Terms<P>>> getAmount() {
                return this.amount;
            }

            public Settle(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Terms<P>>> component1() {
                return this.amount;
            }

            @NotNull
            public final Settle<P> copy(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Settle<P>(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Settle copy$default(Settle settle, Amount amount, int n, Object object) {
                if ((n & 1) != 0) {
                    amount = settle.amount;
                }
                return settle.copy(amount);
            }

            @NotNull
            public String toString() {
                return "Settle(amount=" + this.amount + ")";
            }

            public int hashCode() {
                Amount<Issued<Terms<P>>> amount = this.amount;
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Settle)) break block3;
                        Settle settle = (Settle)object;
                        if (!Intrinsics.areEqual(this.amount, settle.amount)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands$SetLifecycle;", "Lnet/corda/core/contracts/CommandData;", "lifecycle", "Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;", "(Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;)V", "inverse", "getInverse", "()Lnet/corda/finance/contracts/asset/Obligation$Lifecycle;", "getLifecycle", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "contracts"})
        public static final class SetLifecycle
        implements CommandData {
            @NotNull
            private final Lifecycle lifecycle;

            @NotNull
            public final Lifecycle getInverse() {
                Lifecycle lifecycle;
                switch (Obligation$Commands$SetLifecycle$WhenMappings.$EnumSwitchMapping$0[this.lifecycle.ordinal()]) {
                    case 1: {
                        lifecycle = Lifecycle.DEFAULTED;
                        break;
                    }
                    case 2: {
                        lifecycle = Lifecycle.NORMAL;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return lifecycle;
            }

            @NotNull
            public final Lifecycle getLifecycle() {
                return this.lifecycle;
            }

            public SetLifecycle(@NotNull Lifecycle lifecycle) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
                this.lifecycle = lifecycle;
            }

            @NotNull
            public final Lifecycle component1() {
                return this.lifecycle;
            }

            @NotNull
            public final SetLifecycle copy(@NotNull Lifecycle lifecycle) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)lifecycle), (String)"lifecycle");
                return new SetLifecycle(lifecycle);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ SetLifecycle copy$default(SetLifecycle setLifecycle, Lifecycle lifecycle, int n, Object object) {
                if ((n & 1) != 0) {
                    lifecycle = setLifecycle.lifecycle;
                }
                return setLifecycle.copy(lifecycle);
            }

            @NotNull
            public String toString() {
                return "SetLifecycle(lifecycle=" + (Object)((Object)this.lifecycle) + ")";
            }

            public int hashCode() {
                Lifecycle lifecycle = this.lifecycle;
                return lifecycle != null ? ((Object)((Object)lifecycle)).hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof SetLifecycle)) break block3;
                        SetLifecycle setLifecycle = (SetLifecycle)object;
                        if (!Intrinsics.areEqual((Object)((Object)this.lifecycle), (Object)((Object)setLifecycle.lifecycle))) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u00020\u0003B\u001f\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005\u00a2\u0006\u0002\u0010\bJ\u001b\u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005H\u00c6\u0003J+\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u001a\b\u0002\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R#\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Commands$Exit;", "P", "", "Lnet/corda/core/contracts/CommandData;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Lnet/corda/finance/contracts/asset/Obligation$Terms;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "contracts"})
        public static final class Exit<P>
        implements CommandData {
            @NotNull
            private final Amount<Issued<Terms<P>>> amount;

            @NotNull
            public final Amount<Issued<Terms<P>>> getAmount() {
                return this.amount;
            }

            public Exit(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Terms<P>>> component1() {
                return this.amount;
            }

            @NotNull
            public final Exit<P> copy(@NotNull Amount<Issued<Terms<P>>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Exit<P>(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Exit copy$default(Exit exit, Amount amount, int n, Object object) {
                if ((n & 1) != 0) {
                    amount = exit.amount;
                }
                return exit.copy(amount);
            }

            @NotNull
            public String toString() {
                return "Exit(amount=" + this.amount + ")";
            }

            public int hashCode() {
                Amount<Issued<Terms<P>>> amount = this.amount;
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Exit)) break block3;
                        Exit exit = (Exit)object;
                        if (!Intrinsics.areEqual(this.amount, exit.amount)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/corda/finance/contracts/asset/Obligation$Companion;", "", "()V", "PROGRAM_ID", "", "Lnet/corda/core/contracts/ContractClassName;", "contracts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

