/*
 * Decompiled with CFR 0.152.
 */
package net.corda.finance.contracts.asset;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.corda.core.contracts.Amount;
import net.corda.core.contracts.BelongsToContract;
import net.corda.core.contracts.CommandAndState;
import net.corda.core.contracts.CommandData;
import net.corda.core.contracts.CommandWithParties;
import net.corda.core.contracts.Contract;
import net.corda.core.contracts.ContractState;
import net.corda.core.contracts.ContractsDSL;
import net.corda.core.contracts.FungibleAsset;
import net.corda.core.contracts.Issued;
import net.corda.core.contracts.MoveCommand;
import net.corda.core.contracts.OwnableState;
import net.corda.core.contracts.PartyAndReference;
import net.corda.core.contracts.Requirements;
import net.corda.core.contracts.TransactionState;
import net.corda.core.contracts.TypeOnlyCommandData;
import net.corda.core.crypto.CryptoUtils;
import net.corda.core.identity.AbstractParty;
import net.corda.core.identity.Party;
import net.corda.core.internal.Emoji;
import net.corda.core.schemas.MappedSchema;
import net.corda.core.schemas.PersistentState;
import net.corda.core.schemas.QueryableState;
import net.corda.core.transactions.LedgerTransaction;
import net.corda.core.transactions.TransactionBuilder;
import net.corda.finance.contracts.asset.Cash;
import net.corda.finance.contracts.asset.OnLedgerAsset;
import net.corda.finance.contracts.utils.StateSumming;
import net.corda.finance.schemas.CashSchemaV1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u0014\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0001:\u0003-./B\u0005\u00a2\u0006\u0002\u0010\u0005J8\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00072\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00100\u0012H\u0016J\u001c\u0010\u0014\u001a\u00020\u00152\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\nH\u0016J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ:\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cJ\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020#2\u0006\u0010\u0019\u001a\u00020$H\u0016JJ\u0010%\u001a\u00020#2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f2\u0006\u0010\u0019\u001a\u00020$2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00102\u0006\u0010*\u001a\u00020\u00022\u0006\u0010+\u001a\u00020,H\u0002\u00a8\u00060"}, d2={"Lnet/corda/finance/contracts/asset/Cash;", "Lnet/corda/finance/contracts/asset/OnLedgerAsset;", "Ljava/util/Currency;", "Lnet/corda/finance/contracts/asset/Cash$Commands;", "Lnet/corda/finance/contracts/asset/Cash$State;", "()V", "deriveState", "Lnet/corda/core/contracts/TransactionState;", "txState", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "owner", "Lnet/corda/core/identity/AbstractParty;", "extractCommands", "", "Lnet/corda/core/contracts/CommandWithParties;", "commands", "", "Lnet/corda/core/contracts/CommandData;", "generateExitCommand", "Lnet/corda/finance/contracts/asset/Cash$Commands$Exit;", "generateIssue", "", "Ljava/security/PublicKey;", "tx", "Lnet/corda/core/transactions/TransactionBuilder;", "notary", "Lnet/corda/core/identity/Party;", "tokenDef", "pennies", "", "generateMoveCommand", "Lnet/corda/finance/contracts/asset/Cash$Commands$Move;", "verify", "", "Lnet/corda/core/transactions/LedgerTransaction;", "verifyIssueCommand", "inputs", "outputs", "issueCommand", "Lnet/corda/finance/contracts/asset/Cash$Commands$Issue;", "currency", "issuer", "Lnet/corda/core/contracts/PartyAndReference;", "Commands", "Companion", "State", "contracts"})
public final class Cash
extends OnLedgerAsset<Currency, Commands, State> {
    @NotNull
    public static final String PROGRAM_ID = "net.corda.finance.contracts.asset.Cash";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public List<CommandWithParties<Commands>> extractCommands(@NotNull Collection<? extends CommandWithParties<? extends CommandData>> commands) {
        Intrinsics.checkParameterIsNotNull(commands, (String)"commands");
        Collection<? extends CommandWithParties<? extends CommandData>> $receiver$iv = commands;
        PublicKey signer$iv = null;
        AbstractParty party$iv = null;
        return ContractsDSL.select($receiver$iv, Commands.class, (PublicKey)signer$iv, (AbstractParty)party$iv);
    }

    @NotNull
    public final Set<PublicKey> generateIssue(@NotNull TransactionBuilder tx, @NotNull Issued<Currency> tokenDef, long pennies, @NotNull AbstractParty owner, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(tokenDef, (String)"tokenDef");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        return this.generateIssue(tx, (Amount<Issued<Currency>>)new Amount(pennies, tokenDef), owner, notary);
    }

    @NotNull
    public final Set<PublicKey> generateIssue(@NotNull TransactionBuilder tx, @NotNull Amount<Issued<Currency>> amount, @NotNull AbstractParty owner, @NotNull Party notary) {
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        Intrinsics.checkParameterIsNotNull((Object)notary, (String)"notary");
        return OnLedgerAsset.Companion.generateIssue(tx, new TransactionState((ContractState)new State(amount, owner), PROGRAM_ID, notary, null, null, 24, null), (CommandData)new Commands.Issue());
    }

    @Override
    @NotNull
    public TransactionState<State> deriveState(@NotNull TransactionState<State> txState, @NotNull Amount<Issued<Currency>> amount, @NotNull AbstractParty owner) {
        Intrinsics.checkParameterIsNotNull(txState, (String)"txState");
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
        return TransactionState.copy$default(txState, (ContractState)((ContractState)((State)txState.getData()).copy(amount, owner)), null, null, null, null, (int)30, null);
    }

    @NotNull
    public Commands.Exit generateExitCommand(@NotNull Amount<Issued<Currency>> amount) {
        Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
        return new Commands.Exit(amount);
    }

    @Override
    @NotNull
    public Commands.Move generateMoveCommand() {
        return new Commands.Move(null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void verify(@NotNull LedgerTransaction tx) {
        void this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
        LedgerTransaction ledgerTransaction2 = tx;
        Function1 selector$iv = verify.groups.1.INSTANCE;
        List groups2 = this_$iv.groupStates(State.class, selector$iv);
        for (LedgerTransaction ledgerTransaction2 : groups2) {
            Object item$iv$iv$iv2;
            void $receiver$iv$iv$iv;
            Amount<Issued<Currency>> inputAmount;
            String $receiver$iv;
            boolean expr$iv;
            State it;
            boolean bl;
            Iterable $receiver$iv22;
            Requirements $receiver;
            Object amountExitingLedger;
            Amount<Issued<Currency>> outputAmount;
            PartyAndReference issuer;
            List inputs;
            block20: {
                CommandWithParties exitCommand;
                Object object;
                Object v1;
                Object element$iv$iv2;
                Currency currency;
                block19: {
                    Iterable $receiver$iv3;
                    Collection $receiver$iv$iv;
                    AbstractParty party$iv;
                    PublicKey signer$iv;
                    Collection $receiver$iv4;
                    void expr$iv2;
                    Object element$iv2;
                    boolean bl2;
                    Issued key;
                    List outputs;
                    block18: {
                        inputs = ledgerTransaction2.component1();
                        outputs = ledgerTransaction2.component2();
                        key = (Issued)ledgerTransaction2.component3();
                        issuer = key.getIssuer();
                        currency = (Currency)key.getProduct();
                        Requirements $receiver2 = Requirements.INSTANCE;
                        String string = "there are no zero sized outputs";
                        Requirements requirements = $receiver2;
                        Iterable $receiver$iv5 = outputs;
                        if ($receiver$iv5 instanceof Collection && ((Collection)$receiver$iv5).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv2 : $receiver$iv5) {
                                State it2 = (State)element$iv2;
                                if (!(it2.getAmount().getQuantity() == 0L)) continue;
                                bl2 = false;
                                break block18;
                            }
                            bl2 = true;
                        }
                    }
                    boolean $receiver$iv5 = bl2;
                    if (expr$iv2 == false) {
                        throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)((Object)$receiver$iv4));
                    }
                    $receiver$iv4 = tx.getCommands();
                    CommandWithParties issueCommand = (CommandWithParties)CollectionsKt.firstOrNull((List)ContractsDSL.select((Collection)$receiver$iv4, Commands.Issue.class, (PublicKey)(signer$iv = (PublicKey)null), (AbstractParty)(party$iv = (AbstractParty)null)));
                    if (issueCommand != null) {
                        this.verifyIssueCommand(inputs, outputs, tx, (CommandWithParties<Commands.Issue>)issueCommand, currency, issuer);
                        continue;
                    }
                    if (StateSumming.sumCashOrNull(inputs) == null) {
                        throw (Throwable)new IllegalArgumentException("there is at least one cash input for this group");
                    }
                    outputAmount = StateSumming.sumCashOrZero(outputs, (Issued<Currency>)new Issued(issuer, (Object)currency));
                    Iterable $receiver$iv6 = inputs;
                    element$iv2 = $receiver$iv6;
                    Collection destination$iv$iv = new ArrayList();
                    for (Object element$iv$iv2 : $receiver$iv$iv) {
                        State it3 = (State)element$iv$iv2;
                        Iterable list$iv$iv = it3.getExitKeys();
                        CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                    }
                    Set exitKeys = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    $receiver$iv$iv = tx.getCommands();
                    Collection parties$iv = null;
                    $receiver$iv3 = ContractsDSL.select((Collection)$receiver$iv3, Commands.Exit.class, (Collection)exitKeys, parties$iv);
                    Object single$iv = null;
                    boolean found$iv = false;
                    for (Object element$iv3 : $receiver$iv3) {
                        CommandWithParties it4 = (CommandWithParties)element$iv3;
                        if (!Intrinsics.areEqual((Object)((Issued)((Commands.Exit)it4.getValue()).getAmount().getToken()), (Object)key)) continue;
                        if (found$iv) {
                            v1 = null;
                            break block19;
                        }
                        single$iv = element$iv3;
                        found$iv = true;
                    }
                    v1 = !found$iv ? null : single$iv;
                }
                if ((object = (exitCommand = (CommandWithParties)v1)) == null || (object = (Commands.Exit)object.getValue()) == null || (object = ((Commands.Exit)object).getAmount()) == null) {
                    object = new Amount(0L, (Object)new Issued(issuer, (Object)currency));
                }
                amountExitingLedger = object;
                $receiver = Requirements.INSTANCE;
                String found$iv = "there are no zero sized inputs";
                element$iv$iv2 = $receiver;
                $receiver$iv22 = inputs;
                if ($receiver$iv22 instanceof Collection && ((Collection)$receiver$iv22).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $receiver$iv22) {
                        it = (State)element$iv;
                        if (!(it.getAmount().getQuantity() == 0L)) continue;
                        bl = false;
                        break block20;
                    }
                    bl = true;
                }
            }
            boolean $receiver$iv22 = bl;
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
            }
            $receiver$iv = "for reference " + issuer.getReference() + " at issuer " + issuer.getParty() + " the amounts balance: " + inputAmount.getQuantity() + " - " + amountExitingLedger.getQuantity() + " != " + outputAmount.getQuantity();
            Object this_$iv2 = $receiver;
            expr$iv = Intrinsics.areEqual(inputAmount, (Object)outputAmount.plus((Amount)amountExitingLedger));
            if (!expr$iv) {
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
            }
            List commands$iv = tx.getCommands();
            Iterable $receiver$iv$iv = inputs;
            this_$iv2 = $receiver$iv$iv;
            Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv$iv, (int)10));
            for (Object item$iv$iv$iv2 : $receiver$iv$iv$iv) {
                void it$iv;
                it = (OwnableState)item$iv$iv$iv2;
                Collection collection = destination$iv$iv$iv;
                PublicKey publicKey = it$iv.getOwner().getOwningKey();
                collection.add(publicKey);
            }
            Set owningPubKeys$iv = CollectionsKt.toSet((Iterable)((List)destination$iv$iv$iv));
            Collection $receiver$iv$iv2 = commands$iv;
            CommandWithParties command$iv = ContractsDSL.requireSingleCommand((Collection)$receiver$iv$iv2, Commands.Move.class);
            Set keysThatSigned$iv = CollectionsKt.toSet((Iterable)command$iv.getSigners());
            $receiver$iv22 = Requirements.INSTANCE;
            String $i$f$using = "the owning keys are a subset of the signing keys";
            item$iv$iv$iv2 = $receiver$iv22;
            boolean expr$iv$iv = keysThatSigned$iv.containsAll(owningPubKeys$iv);
            if (!expr$iv$iv) {
                void $receiver$iv$iv3;
                throw (Throwable)new IllegalArgumentException("Failed requirement: " + (String)$receiver$iv$iv3);
            }
            MoveCommand cfr_ignored_0 = (MoveCommand)command$iv.getValue();
        }
    }

    private final void verifyIssueCommand(List<State> inputs, List<State> outputs, LedgerTransaction tx, CommandWithParties<Commands.Issue> issueCommand, Currency currency, PartyAndReference issuer) {
        String $receiver$iv;
        Amount<Issued<Currency>> inputAmount = StateSumming.sumCashOrZero((Iterable<? extends ContractState>)inputs, (Issued<Currency>)new Issued(issuer, (Object)currency));
        Amount<Issued<Currency>> outputAmount = StateSumming.sumCash((Iterable<? extends ContractState>)outputs);
        Collection $receiver$iv2 = tx.getCommands();
        Object signer$iv = null;
        AbstractParty party$iv = null;
        List cashCommands = ContractsDSL.select((Collection)$receiver$iv2, Commands.Issue.class, (PublicKey)signer$iv, (AbstractParty)party$iv);
        Requirements $receiver = Requirements.INSTANCE;
        signer$iv = "output states are issued by a command signer";
        party$iv = $receiver;
        boolean expr$iv = issueCommand.getSigners().contains(issuer.getParty().getOwningKey());
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "output values sum to more than the inputs";
        Requirements this_$iv = $receiver;
        boolean bl = expr$iv = outputAmount.compareTo(inputAmount) > 0;
        if (!expr$iv) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
        $receiver$iv = "there is only a single issue command";
        this_$iv = $receiver;
        Collection expr$iv32 = cashCommands;
        boolean expr$iv32 = expr$iv32.size() == 1;
        if (!expr$iv32) {
            throw (Throwable)new IllegalArgumentException("Failed requirement: " + $receiver$iv);
        }
    }

    @BelongsToContract(value=Cash.class)
    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B%\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB!\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u0015\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\tH\u00c6\u0003J)\u0010\u001c\u001a\u00020\u00002\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0016J\t\u0010%\u001a\u00020&H\u00d6\u0001J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0004J\u0011\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\tH\u0086\u0004J\u0011\u0010)\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0086\u0004J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020$0+H\u0016J\b\u0010,\u001a\u00020-H\u0016J\u0011\u0010.\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0004J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\tH\u0016J*\u00102\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0012\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u00072\u0006\u00101\u001a\u00020\tH\u0016R \u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u00064"}, d2={"Lnet/corda/finance/contracts/asset/Cash$State;", "Lnet/corda/core/contracts/FungibleAsset;", "Ljava/util/Currency;", "Lnet/corda/core/schemas/QueryableState;", "deposit", "Lnet/corda/core/contracts/PartyAndReference;", "amount", "Lnet/corda/core/contracts/Amount;", "owner", "Lnet/corda/core/identity/AbstractParty;", "(Lnet/corda/core/contracts/PartyAndReference;Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/AbstractParty;)V", "Lnet/corda/core/contracts/Issued;", "(Lnet/corda/core/contracts/Amount;Lnet/corda/core/identity/AbstractParty;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "exitKeys", "", "Ljava/security/PublicKey;", "getExitKeys", "()Ljava/util/Set;", "getOwner", "()Lnet/corda/core/identity/AbstractParty;", "participants", "", "getParticipants", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "", "generateMappedObject", "Lnet/corda/core/schemas/PersistentState;", "schema", "Lnet/corda/core/schemas/MappedSchema;", "hashCode", "", "issuedBy", "party", "ownedBy", "supportedSchemas", "", "toString", "", "withDeposit", "withNewOwner", "Lnet/corda/core/contracts/CommandAndState;", "newOwner", "withNewOwnerAndAmount", "newAmount", "contracts"})
    public static final class State
    implements FungibleAsset<Currency>,
    QueryableState {
        @NotNull
        private final Set<PublicKey> exitKeys;
        @NotNull
        private final List<AbstractParty> participants;
        @NotNull
        private final Amount<Issued<Currency>> amount;
        @NotNull
        private final AbstractParty owner;

        @NotNull
        public Set<PublicKey> getExitKeys() {
            return this.exitKeys;
        }

        @NotNull
        public List<AbstractParty> getParticipants() {
            return this.participants;
        }

        @NotNull
        public FungibleAsset<Currency> withNewOwnerAndAmount(@NotNull Amount<Issued<Currency>> newAmount, @NotNull AbstractParty newOwner) {
            Intrinsics.checkParameterIsNotNull(newAmount, (String)"newAmount");
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return this.copy((Amount<Issued<Currency>>)Amount.copy$default(this.getAmount(), (long)newAmount.getQuantity(), null, null, (int)6, null), newOwner);
        }

        @NotNull
        public String toString() {
            return Emoji.INSTANCE.getBagOfCash() + "Cash(" + this.getAmount() + " at " + ((Issued)this.getAmount().getToken()).getIssuer() + " owned by " + this.getOwner() + ')';
        }

        @NotNull
        public CommandAndState withNewOwner(@NotNull AbstractParty newOwner) {
            Intrinsics.checkParameterIsNotNull((Object)newOwner, (String)"newOwner");
            return new CommandAndState((CommandData)new Commands.Move(null, 1, null), (OwnableState)State.copy$default(this, null, newOwner, 1, null));
        }

        @NotNull
        public final State ownedBy(@NotNull AbstractParty owner) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            return State.copy$default(this, null, owner, 1, null);
        }

        @NotNull
        public final State issuedBy(@NotNull AbstractParty party) {
            Intrinsics.checkParameterIsNotNull((Object)party, (String)"party");
            return State.copy$default(this, new Amount(this.getAmount().getQuantity(), (Object)Issued.copy$default((Issued)((Issued)this.getAmount().getToken()), (PartyAndReference)PartyAndReference.copy$default((PartyAndReference)((Issued)this.getAmount().getToken()).getIssuer(), (AbstractParty)party, null, (int)2, null), null, (int)2, null)), null, 2, null);
        }

        @NotNull
        public final State issuedBy(@NotNull PartyAndReference deposit) {
            Intrinsics.checkParameterIsNotNull((Object)deposit, (String)"deposit");
            return State.copy$default(this, new Amount(this.getAmount().getQuantity(), (Object)Issued.copy$default((Issued)((Issued)this.getAmount().getToken()), (PartyAndReference)deposit, null, (int)2, null)), null, 2, null);
        }

        @NotNull
        public final State withDeposit(@NotNull PartyAndReference deposit) {
            Intrinsics.checkParameterIsNotNull((Object)deposit, (String)"deposit");
            return State.copy$default(this, Amount.copy$default(this.getAmount(), (long)0L, null, (Object)Issued.copy$default((Issued)((Issued)this.getAmount().getToken()), (PartyAndReference)deposit, null, (int)2, null), (int)3, null), null, 2, null);
        }

        @NotNull
        public PersistentState generateMappedObject(@NotNull MappedSchema schema) {
            Intrinsics.checkParameterIsNotNull((Object)schema, (String)"schema");
            MappedSchema mappedSchema = schema;
            if (!(mappedSchema instanceof CashSchemaV1)) {
                throw (Throwable)new IllegalArgumentException("Unrecognised schema " + schema);
            }
            AbstractParty abstractParty = this.getOwner();
            long l = this.getAmount().getQuantity();
            String string = ((Currency)((Issued)this.getAmount().getToken()).getProduct()).getCurrencyCode();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"this.amount.token.product.currencyCode");
            return new CashSchemaV1.PersistentCashState(abstractParty, l, string, CryptoUtils.toStringShort((PublicKey)((Issued)this.getAmount().getToken()).getIssuer().getParty().getOwningKey()), ((Issued)this.getAmount().getToken()).getIssuer().getReference().getBytes());
        }

        @NotNull
        public Iterable<MappedSchema> supportedSchemas() {
            return CollectionsKt.listOf((Object)((Object)CashSchemaV1.INSTANCE));
        }

        @NotNull
        public Amount<Issued<Currency>> getAmount() {
            return this.amount;
        }

        @NotNull
        public AbstractParty getOwner() {
            return this.owner;
        }

        public State(@NotNull Amount<Issued<Currency>> amount, @NotNull AbstractParty owner) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.amount = amount;
            this.owner = owner;
            this.exitKeys = SetsKt.setOf((Object[])new PublicKey[]{this.getOwner().getOwningKey(), ((Issued)this.getAmount().getToken()).getIssuer().getParty().getOwningKey()});
            this.participants = CollectionsKt.listOf((Object)this.getOwner());
        }

        public State(@NotNull PartyAndReference deposit, @NotNull Amount<Currency> amount, @NotNull AbstractParty owner) {
            Intrinsics.checkParameterIsNotNull((Object)deposit, (String)"deposit");
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this((Amount<Issued<Currency>>)new Amount(amount.getQuantity(), (Object)new Issued(deposit, amount.getToken())), owner);
        }

        @NotNull
        public final Amount<Issued<Currency>> component1() {
            return this.getAmount();
        }

        @NotNull
        public final AbstractParty component2() {
            return this.getOwner();
        }

        @NotNull
        public final State copy(@NotNull Amount<Issued<Currency>> amount, @NotNull AbstractParty owner) {
            Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            return new State(amount, owner);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ State copy$default(State state, Amount amount, AbstractParty abstractParty, int n, Object object) {
            if ((n & 1) != 0) {
                amount = state.getAmount();
            }
            if ((n & 2) != 0) {
                abstractParty = state.getOwner();
            }
            return state.copy(amount, abstractParty);
        }

        public int hashCode() {
            Amount<Issued<Currency>> amount = this.getAmount();
            AbstractParty abstractParty = this.getOwner();
            return (amount != null ? amount.hashCode() : 0) * 31 + (abstractParty != null ? abstractParty.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof State)) break block3;
                    State state = (State)object;
                    if (!Intrinsics.areEqual(this.getAmount(), state.getAmount()) || !Intrinsics.areEqual((Object)this.getOwner(), (Object)state.getOwner())) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lnet/corda/finance/contracts/asset/Cash$Commands;", "Lnet/corda/core/contracts/CommandData;", "Exit", "Issue", "Move", "contracts"})
    public static interface Commands
    extends CommandData {

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\b\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001d\u0010\t\u001a\u00020\u00002\u0012\b\u0002\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001e\u0010\u0002\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lnet/corda/finance/contracts/asset/Cash$Commands$Move;", "Lnet/corda/core/contracts/MoveCommand;", "contract", "Ljava/lang/Class;", "Lnet/corda/core/contracts/Contract;", "(Ljava/lang/Class;)V", "getContract", "()Ljava/lang/Class;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "contracts"})
        public static final class Move
        implements MoveCommand {
            @Nullable
            private final Class<? extends Contract> contract;

            @Nullable
            public Class<? extends Contract> getContract() {
                return this.contract;
            }

            public Move(@Nullable Class<? extends Contract> contract) {
                this.contract = contract;
            }

            public /* synthetic */ Move(Class clazz, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 1) != 0) {
                    clazz = null;
                }
                this(clazz);
            }

            public Move() {
                this(null, 1, null);
            }

            @Nullable
            public final Class<? extends Contract> component1() {
                return this.getContract();
            }

            @NotNull
            public final Move copy(@Nullable Class<? extends Contract> contract) {
                return new Move(contract);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Move copy$default(Move move, Class clazz, int n, Object object) {
                if ((n & 1) != 0) {
                    clazz = move.getContract();
                }
                return move.copy(clazz);
            }

            @NotNull
            public String toString() {
                return "Move(contract=" + this.getContract() + ")";
            }

            public int hashCode() {
                Class<? extends Contract> clazz = this.getContract();
                return clazz != null ? clazz.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Move)) break block3;
                        Move move = (Move)object;
                        if (!Intrinsics.areEqual(this.getContract(), move.getContract())) break block3;
                    }
                    return true;
                }
                return false;
            }
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lnet/corda/finance/contracts/asset/Cash$Commands$Issue;", "Lnet/corda/core/contracts/TypeOnlyCommandData;", "()V", "contracts"})
        public static final class Issue
        extends TypeOnlyCommandData {
        }

        @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\u0002\u0010\u0006J\u0015\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0003J\u001f\u0010\n\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u001d\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lnet/corda/finance/contracts/asset/Cash$Commands$Exit;", "Lnet/corda/core/contracts/CommandData;", "amount", "Lnet/corda/core/contracts/Amount;", "Lnet/corda/core/contracts/Issued;", "Ljava/util/Currency;", "(Lnet/corda/core/contracts/Amount;)V", "getAmount", "()Lnet/corda/core/contracts/Amount;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "contracts"})
        public static final class Exit
        implements CommandData {
            @NotNull
            private final Amount<Issued<Currency>> amount;

            @NotNull
            public final Amount<Issued<Currency>> getAmount() {
                return this.amount;
            }

            public Exit(@NotNull Amount<Issued<Currency>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                this.amount = amount;
            }

            @NotNull
            public final Amount<Issued<Currency>> component1() {
                return this.amount;
            }

            @NotNull
            public final Exit copy(@NotNull Amount<Issued<Currency>> amount) {
                Intrinsics.checkParameterIsNotNull(amount, (String)"amount");
                return new Exit(amount);
            }

            @NotNull
            public static /* bridge */ /* synthetic */ Exit copy$default(Exit exit, Amount amount, int n, Object object) {
                if ((n & 1) != 0) {
                    amount = exit.amount;
                }
                return exit.copy(amount);
            }

            @NotNull
            public String toString() {
                return "Exit(amount=" + this.amount + ")";
            }

            public int hashCode() {
                Amount<Issued<Currency>> amount = this.amount;
                return amount != null ? amount.hashCode() : 0;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Exit)) break block3;
                        Exit exit = (Exit)object;
                        if (!Intrinsics.areEqual(this.amount, exit.amount)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0012\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lnet/corda/finance/contracts/asset/Cash$Companion;", "", "()V", "PROGRAM_ID", "", "Lnet/corda/core/contracts/ContractClassName;", "contracts"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

