/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.time.format;

import java.lang.ref.SoftReference;
import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.math.BigDecimal;
import sandbox.java.math.BigInteger;
import sandbox.java.math.RoundingMode;
import sandbox.java.text.ParsePosition;
import sandbox.java.time.DateTimeException;
import sandbox.java.time.Instant;
import sandbox.java.time.LocalDate;
import sandbox.java.time.LocalDateTime;
import sandbox.java.time.ZoneId;
import sandbox.java.time.ZoneOffset;
import sandbox.java.time.chrono.ChronoLocalDate;
import sandbox.java.time.chrono.Chronology;
import sandbox.java.time.chrono.IsoChronology;
import sandbox.java.time.format.DateTimeFormatter;
import sandbox.java.time.format.DateTimeParseContext;
import sandbox.java.time.format.DateTimePrintContext;
import sandbox.java.time.format.DateTimeTextProvider;
import sandbox.java.time.format.DecimalStyle;
import sandbox.java.time.format.FormatStyle;
import sandbox.java.time.format.ResolverStyle;
import sandbox.java.time.format.SignStyle;
import sandbox.java.time.format.TextStyle;
import sandbox.java.time.format.ZoneName;
import sandbox.java.time.temporal.ChronoField;
import sandbox.java.time.temporal.IsoFields;
import sandbox.java.time.temporal.TemporalAccessor;
import sandbox.java.time.temporal.TemporalField;
import sandbox.java.time.temporal.TemporalQueries;
import sandbox.java.time.temporal.TemporalQuery;
import sandbox.java.time.temporal.ValueRange;
import sandbox.java.time.temporal.WeekFields;
import sandbox.java.time.zone.ZoneRules;
import sandbox.java.time.zone.ZoneRulesProvider;
import sandbox.java.util.AbstractMap;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Collections;
import sandbox.java.util.Comparator;
import sandbox.java.util.HashMap;
import sandbox.java.util.HashSet;
import sandbox.java.util.Iterator;
import sandbox.java.util.LinkedHashMap;
import sandbox.java.util.List;
import sandbox.java.util.Locale;
import sandbox.java.util.Map;
import sandbox.java.util.Objects;
import sandbox.java.util.Set;
import sandbox.java.util.concurrent.ConcurrentHashMap;
import sandbox.java.util.concurrent.ConcurrentMap;
import sandbox.java.util.function.Consumer;
import sandbox.sun.util.locale.provider.LocaleProviderAdapter;
import sandbox.sun.util.locale.provider.LocaleResources;
import sandbox.sun.util.locale.provider.TimeZoneNameUtility;

public final class DateTimeFormatterBuilder {
    private static final TemporalQuery<ZoneId> QUERY_REGION_ONLY = temporalAccessor -> {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneId> temporalQuery = TemporalQueries.zoneId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
        ZoneId zoneId = temporalAccessor.query(temporalQuery);
        RuntimeCostAccounter.recordJump();
        if (zoneId == null) return null;
        boolean bl = zoneId instanceof ZoneOffset;
        RuntimeCostAccounter.recordJump();
        if (bl) return null;
        ZoneId zoneId2 = zoneId;
        RuntimeCostAccounter.recordJump();
        return zoneId2;
    };
    private DateTimeFormatterBuilder active;
    private final DateTimeFormatterBuilder parent;
    private final List<DateTimePrinterParser> printerParsers;
    private final boolean optional;
    private int padNextWidth;
    private char padNextChar;
    private int valueParserIndex;
    private static final Map<Character, TemporalField> FIELD_MAP;
    static final Comparator<String> LENGTH_SORT;

    public static String getLocalizedDateTimePattern(FormatStyle formatStyle, FormatStyle formatStyle2, Chronology chronology, Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(locale, "locale");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(chronology, "chrono");
        RuntimeCostAccounter.recordJump();
        if (formatStyle == null) {
            RuntimeCostAccounter.recordJump();
            if (formatStyle2 == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Either dateStyle or timeStyle must be non-null");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getResourceBundleBased:()Lsun/util/locale/provider/LocaleProviderAdapter;");
        LocaleProviderAdapter localeProviderAdapter = LocaleProviderAdapter.getResourceBundleBased();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleProviderAdapter.getLocaleResources:(Ljava/util/Locale;)Lsun/util/locale/provider/LocaleResources;");
        LocaleResources localeResources = localeProviderAdapter.getLocaleResources(locale);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.convertStyle:(Ljava/time/format/FormatStyle;)I");
        int n = DateTimeFormatterBuilder.convertStyle(formatStyle2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.convertStyle:(Ljava/time/format/FormatStyle;)I");
        int n2 = DateTimeFormatterBuilder.convertStyle(formatStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
        String string = chronology.getCalendarType();
        RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/LocaleResources.getJavaTimeDateTimePattern:(IILjava/lang/String;)Ljava/lang/String;");
        String string2 = localeResources.getJavaTimeDateTimePattern(n, n2, string);
        return string2;
    }

    private static int convertStyle(FormatStyle formatStyle) {
        RuntimeCostAccounter.recordJump();
        if (formatStyle == null) {
            return -1;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/FormatStyle.ordinal:()I");
        return formatStyle.ordinal();
    }

    public DateTimeFormatterBuilder() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.active = this;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.printerParsers = new ArrayList<DateTimePrinterParser>();
        this.valueParserIndex = -1;
        this.parent = null;
        this.optional = false;
    }

    private DateTimeFormatterBuilder(DateTimeFormatterBuilder dateTimeFormatterBuilder, boolean bl) {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
        this.active = this;
        RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
        this.printerParsers = new ArrayList<DateTimePrinterParser>();
        this.valueParserIndex = -1;
        this.parent = dateTimeFormatterBuilder;
        this.optional = bl;
    }

    public DateTimeFormatterBuilder parseCaseSensitive() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(SettingsParser.SENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseCaseInsensitive() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(SettingsParser.INSENSITIVE);
        return this;
    }

    public DateTimeFormatterBuilder parseStrict() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(SettingsParser.STRICT);
        return this;
    }

    public DateTimeFormatterBuilder parseLenient() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(SettingsParser.LENIENT);
        return this;
    }

    public DateTimeFormatterBuilder parseDefaulting(TemporalField temporalField, long l) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$DefaultValueParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DefaultValueParser.<init>:(Ljava/time/temporal/TemporalField;J)V");
        DefaultValueParser defaultValueParser = new DefaultValueParser(temporalField, l);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(defaultValueParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)V");
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(temporalField, 1, 19, SignStyle.NORMAL);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;)Ljava/time/format/DateTimeFormatterBuilder;");
        this.appendValue(numberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField, int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                Objects.requireNonNull(temporalField, "field");
                RuntimeCostAccounter.recordJump();
                if (n < 1) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= 19) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("The width must be from 1 to 19 inclusive but was ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)V");
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(temporalField, n, n, SignStyle.NOT_NEGATIVE);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;)Ljava/time/format/DateTimeFormatterBuilder;");
        this.appendValue(numberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValue(TemporalField temporalField, int n, int n2, SignStyle signStyle) {
        block12: {
            block11: {
                block10: {
                    block9: {
                        RuntimeCostAccounter.recordJump();
                        if (n == n2) {
                            RuntimeCostAccounter.recordJump();
                            if (signStyle == SignStyle.NOT_NEGATIVE) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
                                return this.appendValue(temporalField, n2);
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                        Objects.requireNonNull(temporalField, "field");
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                        Objects.requireNonNull(signStyle, "signStyle");
                        RuntimeCostAccounter.recordJump();
                        if (n < 1) break block9;
                        RuntimeCostAccounter.recordJump();
                        if (n <= 19) break block10;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder2 = stringBuilder.append("The minimum width must be from 1 to 19 inclusive but was ");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder3 = stringBuilder2.append(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string = stringBuilder3.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordJump();
                if (n2 < 1) break block11;
                RuntimeCostAccounter.recordJump();
                if (n2 <= 19) break block12;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder.append("The maximum width must be from 1 to 19 inclusive but was ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder5.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 < n) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder.append("The maximum width must exceed or equal the minimum width but ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(" < ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder9.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)V");
        NumberPrinterParser numberPrinterParser = new NumberPrinterParser(temporalField, n, n2, signStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;)Ljava/time/format/DateTimeFormatterBuilder;");
        this.appendValue(numberPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField temporalField, int n, int n2, int n3) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;)V");
        ReducedPrinterParser reducedPrinterParser = new ReducedPrinterParser(temporalField, n, n2, n3, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;)Ljava/time/format/DateTimeFormatterBuilder;");
        this.appendValue(reducedPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendValueReduced(TemporalField temporalField, int n, int n2, ChronoLocalDate chronoLocalDate) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(chronoLocalDate, "baseDate");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;)V");
        ReducedPrinterParser reducedPrinterParser = new ReducedPrinterParser(temporalField, n, n2, 0, chronoLocalDate);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;)Ljava/time/format/DateTimeFormatterBuilder;");
        this.appendValue(reducedPrinterParser);
        return this;
    }

    /*
     * Unable to fully structure code
     */
    private DateTimeFormatterBuilder appendValue(NumberPrinterParser var1_1) {
        block3: {
            block2: {
                v0 = this.active.valueParserIndex;
                RuntimeCostAccounter.recordJump();
                if (v0 < 0) break block2;
                var2_2 = this.active.valueParserIndex;
                v1 = this.active.printerParsers;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.get:(I)Ljava/lang/Object;");
                var3_3 = (NumberPrinterParser)v1.get(var2_2);
                v2 = var1_1.minWidth;
                v3 = var1_1.maxWidth;
                RuntimeCostAccounter.recordJump();
                if (v2 != v3) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.access$000:(Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;)Ljava/time/format/SignStyle;");
                v4 = NumberPrinterParser.access$000(var1_1);
                RuntimeCostAccounter.recordJump();
                if (v4 == SignStyle.NOT_NEGATIVE) {
                    v5 = var1_1.maxWidth;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.withSubsequentWidth:(I)Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;");
                    var3_3 = var3_3.withSubsequentWidth(v5);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.withFixedWidth:()Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;");
                    v6 = var1_1.withFixedWidth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                    this.appendInternal(v6);
                    this.active.valueParserIndex = var2_2;
                    RuntimeCostAccounter.recordJump();
                } else lbl-1000:
                // 2 sources

                {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.withFixedWidth:()Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;");
                    var3_3 = var3_3.withFixedWidth();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                    this.active.valueParserIndex = this.appendInternal(var1_1);
                }
                v7 = this.active.printerParsers;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/List.set:(ILjava/lang/Object;)Ljava/lang/Object;");
                v7.set(var2_2, var3_3);
                RuntimeCostAccounter.recordJump();
                break block3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
            this.active.valueParserIndex = this.appendInternal(var1_1);
        }
        return this;
    }

    public DateTimeFormatterBuilder appendFraction(TemporalField temporalField, int n, int n2, boolean bl) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$FractionPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$FractionPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIZ)V");
        FractionPrinterParser fractionPrinterParser = new FractionPrinterParser(temporalField, n, n2, bl);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(fractionPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
        return this.appendText(temporalField, TextStyle.FULL);
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField, TextStyle textStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(textStyle, "textStyle");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$TextPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getInstance:()Ljava/time/format/DateTimeTextProvider;");
        DateTimeTextProvider dateTimeTextProvider = DateTimeTextProvider.getInstance();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$TextPrinterParser.<init>:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;Ljava/time/format/DateTimeTextProvider;)V");
        TextPrinterParser textPrinterParser = new TextPrinterParser(temporalField, textStyle, dateTimeTextProvider);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(textPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendText(TemporalField temporalField, Map<Long, String> map) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(temporalField, "field");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(map, "textLookup");
        RuntimeCostAccounter.recordAllocation((String)"java/util/LinkedHashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/LinkedHashMap.<init>:(Ljava/util/Map;)V");
        LinkedHashMap<Long, String> linkedHashMap = new LinkedHashMap<Long, String>(map);
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Collections.singletonMap:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/util/Map;");
        Map<TextStyle, Map<Long, String>> map2 = Collections.singletonMap(TextStyle.FULL, linkedHashMap);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeTextProvider$LocaleStore");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.<init>:(Ljava/util/Map;)V");
        final DateTimeTextProvider.LocaleStore localeStore = new DateTimeTextProvider.LocaleStore(map2);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$1");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$1.<init>:(Ljava/time/format/DateTimeFormatterBuilder;Ljava/time/format/DateTimeTextProvider$LocaleStore;)V");
        DateTimeTextProvider dateTimeTextProvider = new DateTimeTextProvider(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.<init>:()V");
            }

            @Override
            public String getText(TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.getText:(JLjava/time/format/TextStyle;)Ljava/lang/String;");
                return localeStore.getText(l, textStyle);
            }

            @Override
            public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField temporalField, TextStyle textStyle, Locale locale) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider$LocaleStore.getTextIterator:(Ljava/time/format/TextStyle;)Ljava/util/Iterator;");
                return localeStore.getTextIterator(textStyle);
            }
        };
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$TextPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$TextPrinterParser.<init>:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;Ljava/time/format/DateTimeTextProvider;)V");
        TextPrinterParser textPrinterParser = new TextPrinterParser(temporalField, TextStyle.FULL, dateTimeTextProvider);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(textPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendInstant() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$InstantPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$InstantPrinterParser.<init>:(I)V");
        InstantPrinterParser instantPrinterParser = new InstantPrinterParser(-2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(instantPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendInstant(int n) {
        block3: {
            block2: {
                RuntimeCostAccounter.recordJump();
                if (n < -1) break block2;
                RuntimeCostAccounter.recordJump();
                if (n <= 9) break block3;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("The fractional digits must be from -1 to 9 inclusive but was ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$InstantPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$InstantPrinterParser.<init>:(I)V");
        InstantPrinterParser instantPrinterParser = new InstantPrinterParser(n);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(instantPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendOffsetId() {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(OffsetIdPrinterParser.INSTANCE_ID_Z);
        return this;
    }

    public DateTimeFormatterBuilder appendOffset(String string, String string2) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
        OffsetIdPrinterParser offsetIdPrinterParser = new OffsetIdPrinterParser(string, string2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(offsetIdPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLocalizedOffset(TextStyle textStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(textStyle, "style");
        RuntimeCostAccounter.recordJump();
        if (textStyle != TextStyle.FULL) {
            RuntimeCostAccounter.recordJump();
            if (textStyle != TextStyle.SHORT) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Style must be either full or short");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.<init>:(Ljava/time/format/TextStyle;)V");
        LocalizedOffsetIdPrinterParser localizedOffsetIdPrinterParser = new LocalizedOffsetIdPrinterParser(textStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(localizedOffsetIdPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneId() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneId> temporalQuery = TemporalQueries.zoneId();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.<init>:(Ljava/time/temporal/TemporalQuery;Ljava/lang/String;)V");
        ZoneIdPrinterParser zoneIdPrinterParser = new ZoneIdPrinterParser(temporalQuery, "ZoneId()");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(zoneIdPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneRegionId() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.<init>:(Ljava/time/temporal/TemporalQuery;Ljava/lang/String;)V");
        ZoneIdPrinterParser zoneIdPrinterParser = new ZoneIdPrinterParser(QUERY_REGION_ONLY, "ZoneRegionId()");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(zoneIdPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneOrOffsetId() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
        TemporalQuery<ZoneId> temporalQuery = TemporalQueries.zone();
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.<init>:(Ljava/time/temporal/TemporalQuery;Ljava/lang/String;)V");
        ZoneIdPrinterParser zoneIdPrinterParser = new ZoneIdPrinterParser(temporalQuery, "ZoneOrOffsetId()");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(zoneIdPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ZoneTextPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneTextPrinterParser.<init>:(Ljava/time/format/TextStyle;Ljava/util/Set;)V");
        ZoneTextPrinterParser zoneTextPrinterParser = new ZoneTextPrinterParser(textStyle, null);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(zoneTextPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendZoneText(TextStyle textStyle, Set<ZoneId> set) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(set, "preferredZones");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ZoneTextPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneTextPrinterParser.<init>:(Ljava/time/format/TextStyle;Ljava/util/Set;)V");
        ZoneTextPrinterParser zoneTextPrinterParser = new ZoneTextPrinterParser(textStyle, set);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(zoneTextPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyId() {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ChronoPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ChronoPrinterParser.<init>:(Ljava/time/format/TextStyle;)V");
        ChronoPrinterParser chronoPrinterParser = new ChronoPrinterParser(null);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(chronoPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendChronologyText(TextStyle textStyle) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(textStyle, "textStyle");
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ChronoPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ChronoPrinterParser.<init>:(Ljava/time/format/TextStyle;)V");
        ChronoPrinterParser chronoPrinterParser = new ChronoPrinterParser(textStyle);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(chronoPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLocalized(FormatStyle formatStyle, FormatStyle formatStyle2) {
        RuntimeCostAccounter.recordJump();
        if (formatStyle == null) {
            RuntimeCostAccounter.recordJump();
            if (formatStyle2 == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Either the date or time style must be non-null");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$LocalizedPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedPrinterParser.<init>:(Ljava/time/format/FormatStyle;Ljava/time/format/FormatStyle;)V");
        LocalizedPrinterParser localizedPrinterParser = new LocalizedPrinterParser(formatStyle, formatStyle2);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(localizedPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(char c) {
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$CharLiteralPrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CharLiteralPrinterParser.<init>:(C)V");
        CharLiteralPrinterParser charLiteralPrinterParser = new CharLiteralPrinterParser(c);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(charLiteralPrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendLiteral(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "literal");
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
        int n = string.length();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n2 = string.length();
            RuntimeCostAccounter.recordJump();
            if (n2 == 1) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$CharLiteralPrinterParser");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c = string.charAt(0);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CharLiteralPrinterParser.<init>:(C)V");
                CharLiteralPrinterParser charLiteralPrinterParser = new CharLiteralPrinterParser(c);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                this.appendInternal(charLiteralPrinterParser);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$StringLiteralPrinterParser");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$StringLiteralPrinterParser.<init>:(Ljava/lang/String;)V");
                StringLiteralPrinterParser stringLiteralPrinterParser = new StringLiteralPrinterParser(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                this.appendInternal(stringLiteralPrinterParser);
            }
        }
        return this;
    }

    public DateTimeFormatterBuilder append(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.toPrinterParser:(Z)Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;");
        CompositePrinterParser compositePrinterParser = dateTimeFormatter.toPrinterParser(false);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(compositePrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendOptional(DateTimeFormatter dateTimeFormatter) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimeFormatter, "formatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.toPrinterParser:(Z)Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;");
        CompositePrinterParser compositePrinterParser = dateTimeFormatter.toPrinterParser(true);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
        this.appendInternal(compositePrinterParser);
        return this;
    }

    public DateTimeFormatterBuilder appendPattern(String string) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(string, "pattern");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parsePattern:(Ljava/lang/String;)V");
        this.parsePattern(string);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void parsePattern(String string) {
        int n = 0;
        while (true) {
            block66: {
                char c;
                block71: {
                    block70: {
                        block69: {
                            block68: {
                                block67: {
                                    int n2;
                                    block57: {
                                        block54: {
                                            int n3;
                                            block65: {
                                                block64: {
                                                    block63: {
                                                        block62: {
                                                            block58: {
                                                                int n4;
                                                                block59: {
                                                                    block61: {
                                                                        block60: {
                                                                            block56: {
                                                                                block55: {
                                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                                                                    int n5 = string.length();
                                                                                    RuntimeCostAccounter.recordJump();
                                                                                    if (n >= n5) {
                                                                                        return;
                                                                                    }
                                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                                                                    c = string.charAt(n);
                                                                                    RuntimeCostAccounter.recordJump();
                                                                                    if (c < 'A') break block55;
                                                                                    RuntimeCostAccounter.recordJump();
                                                                                    if (c <= 'Z') break block56;
                                                                                }
                                                                                RuntimeCostAccounter.recordJump();
                                                                                if (c < 'a') break block57;
                                                                                RuntimeCostAccounter.recordJump();
                                                                                if (c > 'z') break block57;
                                                                            }
                                                                            n2 = n++;
                                                                            while (true) {
                                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                                                                int n6 = string.length();
                                                                                RuntimeCostAccounter.recordJump();
                                                                                if (n >= n6) break;
                                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                                                                char c2 = string.charAt(n);
                                                                                RuntimeCostAccounter.recordJump();
                                                                                if (c2 != c) break;
                                                                                ++n;
                                                                                RuntimeCostAccounter.recordJump();
                                                                            }
                                                                            n3 = n - n2;
                                                                            RuntimeCostAccounter.recordJump();
                                                                            if (c != 'p') break block58;
                                                                            n4 = 0;
                                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                                                            int n7 = string.length();
                                                                            RuntimeCostAccounter.recordJump();
                                                                            if (n >= n7) break block59;
                                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                                                            c = string.charAt(n);
                                                                            RuntimeCostAccounter.recordJump();
                                                                            if (c < 'A') break block60;
                                                                            RuntimeCostAccounter.recordJump();
                                                                            if (c <= 'Z') break block61;
                                                                        }
                                                                        RuntimeCostAccounter.recordJump();
                                                                        if (c < 'a') break block59;
                                                                        RuntimeCostAccounter.recordJump();
                                                                        if (c > 'z') break block59;
                                                                    }
                                                                    n4 = n3;
                                                                    n2 = n++;
                                                                    while (true) {
                                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                                                        int n8 = string.length();
                                                                        RuntimeCostAccounter.recordJump();
                                                                        if (n >= n8) break;
                                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                                                        char c3 = string.charAt(n);
                                                                        RuntimeCostAccounter.recordJump();
                                                                        if (c3 != c) break;
                                                                        ++n;
                                                                        RuntimeCostAccounter.recordJump();
                                                                    }
                                                                    n3 = n - n2;
                                                                }
                                                                RuntimeCostAccounter.recordJump();
                                                                if (n4 == 0) {
                                                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                                    StringBuilder stringBuilder = new StringBuilder();
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                                    StringBuilder stringBuilder2 = stringBuilder.append("Pad letter 'p' must be followed by valid pad pattern: ");
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                                    StringBuilder stringBuilder3 = stringBuilder2.append(string);
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                                    String string2 = stringBuilder3.toString();
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string2);
                                                                    RuntimeCostAccounter.recordThrow();
                                                                    throw illegalArgumentException;
                                                                }
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.padNext:(I)Ljava/time/format/DateTimeFormatterBuilder;");
                                                                this.padNext(n4);
                                                            }
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
                                                            Character c4 = Character.valueOf(c);
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                                                            TemporalField temporalField = FIELD_MAP.get(c4);
                                                            RuntimeCostAccounter.recordJump();
                                                            if (temporalField == null) break block62;
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.parseField:(CILjava/time/temporal/TemporalField;)V");
                                                            this.parseField(c, n3, temporalField);
                                                            RuntimeCostAccounter.recordJump();
                                                            break block54;
                                                        }
                                                        RuntimeCostAccounter.recordJump();
                                                        if (c != 'z') break block63;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n3 > 4) {
                                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                            StringBuilder stringBuilder4 = stringBuilder.append("Too many pattern letters: ");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                            StringBuilder stringBuilder5 = stringBuilder4.append(c);
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                            String string3 = stringBuilder5.toString();
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
                                                            RuntimeCostAccounter.recordThrow();
                                                            throw illegalArgumentException;
                                                        }
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n3 == 4) {
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendZoneText:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                            this.appendZoneText(TextStyle.FULL);
                                                            RuntimeCostAccounter.recordJump();
                                                            break block54;
                                                        } else {
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendZoneText:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                            this.appendZoneText(TextStyle.SHORT);
                                                            RuntimeCostAccounter.recordJump();
                                                        }
                                                        break block54;
                                                    }
                                                    RuntimeCostAccounter.recordJump();
                                                    if (c != 'V') break block64;
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n3 != 2) {
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                        StringBuilder stringBuilder = new StringBuilder();
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                        StringBuilder stringBuilder6 = stringBuilder.append("Pattern letter count must be 2: ");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                        StringBuilder stringBuilder7 = stringBuilder6.append(c);
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                        String string4 = stringBuilder7.toString();
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string4);
                                                        RuntimeCostAccounter.recordThrow();
                                                        throw illegalArgumentException;
                                                    }
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendZoneId:()Ljava/time/format/DateTimeFormatterBuilder;");
                                                    this.appendZoneId();
                                                    RuntimeCostAccounter.recordJump();
                                                    break block54;
                                                }
                                                RuntimeCostAccounter.recordJump();
                                                if (c != 'Z') break block65;
                                                RuntimeCostAccounter.recordJump();
                                                if (n3 < 4) {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffset:(Ljava/lang/String;Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                    this.appendOffset("+HHMM", "+0000");
                                                    RuntimeCostAccounter.recordJump();
                                                    break block54;
                                                } else {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n3 == 4) {
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalizedOffset:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                        this.appendLocalizedOffset(TextStyle.FULL);
                                                        RuntimeCostAccounter.recordJump();
                                                        break block54;
                                                    } else {
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n3 != 5) {
                                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                            StringBuilder stringBuilder8 = stringBuilder.append("Too many pattern letters: ");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                            StringBuilder stringBuilder9 = stringBuilder8.append(c);
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                            String string5 = stringBuilder9.toString();
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string5);
                                                            RuntimeCostAccounter.recordThrow();
                                                            throw illegalArgumentException;
                                                        }
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffset:(Ljava/lang/String;Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                        this.appendOffset("+HH:MM:ss", "Z");
                                                        RuntimeCostAccounter.recordJump();
                                                    }
                                                }
                                                break block54;
                                            }
                                            RuntimeCostAccounter.recordJump();
                                            if (c == 'O') {
                                                RuntimeCostAccounter.recordJump();
                                                if (n3 == 1) {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalizedOffset:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                    this.appendLocalizedOffset(TextStyle.SHORT);
                                                    RuntimeCostAccounter.recordJump();
                                                } else {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n3 != 4) {
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                        StringBuilder stringBuilder = new StringBuilder();
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                        StringBuilder stringBuilder10 = stringBuilder.append("Pattern letter count must be 1 or 4: ");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                        StringBuilder stringBuilder11 = stringBuilder10.append(c);
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                        String string6 = stringBuilder11.toString();
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string6);
                                                        RuntimeCostAccounter.recordThrow();
                                                        throw illegalArgumentException;
                                                    }
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLocalizedOffset:(Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                    this.appendLocalizedOffset(TextStyle.FULL);
                                                    RuntimeCostAccounter.recordJump();
                                                }
                                            } else {
                                                RuntimeCostAccounter.recordJump();
                                                if (c == 'X') {
                                                    int n9;
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n3 > 5) {
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                        StringBuilder stringBuilder = new StringBuilder();
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                        StringBuilder stringBuilder12 = stringBuilder.append("Too many pattern letters: ");
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                        StringBuilder stringBuilder13 = stringBuilder12.append(c);
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                        String string7 = stringBuilder13.toString();
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string7);
                                                        RuntimeCostAccounter.recordThrow();
                                                        throw illegalArgumentException;
                                                    }
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n3 == 1) {
                                                        n9 = 0;
                                                        RuntimeCostAccounter.recordJump();
                                                    } else {
                                                        n9 = 1;
                                                    }
                                                    String string8 = OffsetIdPrinterParser.PATTERNS[n3 + n9];
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffset:(Ljava/lang/String;Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                    this.appendOffset(string8, "Z");
                                                    RuntimeCostAccounter.recordJump();
                                                } else {
                                                    RuntimeCostAccounter.recordJump();
                                                    if (c == 'x') {
                                                        int n10;
                                                        String string9;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n3 > 5) {
                                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                            StringBuilder stringBuilder = new StringBuilder();
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                            StringBuilder stringBuilder14 = stringBuilder.append("Too many pattern letters: ");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                            StringBuilder stringBuilder15 = stringBuilder14.append(c);
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                            String string10 = stringBuilder15.toString();
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string10);
                                                            RuntimeCostAccounter.recordThrow();
                                                            throw illegalArgumentException;
                                                        }
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n3 == 1) {
                                                            string9 = "+00";
                                                            RuntimeCostAccounter.recordJump();
                                                        } else {
                                                            RuntimeCostAccounter.recordJump();
                                                            if (n3 % 2 == 0) {
                                                                string9 = "+0000";
                                                                RuntimeCostAccounter.recordJump();
                                                            } else {
                                                                string9 = "+00:00";
                                                            }
                                                        }
                                                        String string11 = string9;
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n3 == 1) {
                                                            n10 = 0;
                                                            RuntimeCostAccounter.recordJump();
                                                        } else {
                                                            n10 = 1;
                                                        }
                                                        String string12 = OffsetIdPrinterParser.PATTERNS[n3 + n10];
                                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendOffset:(Ljava/lang/String;Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
                                                        this.appendOffset(string12, string11);
                                                        RuntimeCostAccounter.recordJump();
                                                    } else {
                                                        RuntimeCostAccounter.recordJump();
                                                        if (c == 'W') {
                                                            RuntimeCostAccounter.recordJump();
                                                            if (n3 > 1) {
                                                                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                                StringBuilder stringBuilder = new StringBuilder();
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                                StringBuilder stringBuilder16 = stringBuilder.append("Too many pattern letters: ");
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                                StringBuilder stringBuilder17 = stringBuilder16.append(c);
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                                String string13 = stringBuilder17.toString();
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string13);
                                                                RuntimeCostAccounter.recordThrow();
                                                                throw illegalArgumentException;
                                                            }
                                                            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser");
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser.<init>:(CI)V");
                                                            WeekBasedFieldPrinterParser weekBasedFieldPrinterParser = new WeekBasedFieldPrinterParser(c, n3);
                                                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                                                            this.appendInternal(weekBasedFieldPrinterParser);
                                                            RuntimeCostAccounter.recordJump();
                                                        } else {
                                                            RuntimeCostAccounter.recordJump();
                                                            if (c == 'w') {
                                                                RuntimeCostAccounter.recordJump();
                                                                if (n3 > 2) {
                                                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                                    StringBuilder stringBuilder = new StringBuilder();
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                                    StringBuilder stringBuilder18 = stringBuilder.append("Too many pattern letters: ");
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                                    StringBuilder stringBuilder19 = stringBuilder18.append(c);
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                                    String string14 = stringBuilder19.toString();
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string14);
                                                                    RuntimeCostAccounter.recordThrow();
                                                                    throw illegalArgumentException;
                                                                }
                                                                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser");
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser.<init>:(CI)V");
                                                                WeekBasedFieldPrinterParser weekBasedFieldPrinterParser = new WeekBasedFieldPrinterParser(c, n3);
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                                                                this.appendInternal(weekBasedFieldPrinterParser);
                                                                RuntimeCostAccounter.recordJump();
                                                            } else {
                                                                RuntimeCostAccounter.recordJump();
                                                                if (c != 'Y') {
                                                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                                                    StringBuilder stringBuilder = new StringBuilder();
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                                                    StringBuilder stringBuilder20 = stringBuilder.append("Unknown pattern letter: ");
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                                                    StringBuilder stringBuilder21 = stringBuilder20.append(c);
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                                                    String string15 = stringBuilder21.toString();
                                                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                                                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string15);
                                                                    RuntimeCostAccounter.recordThrow();
                                                                    throw illegalArgumentException;
                                                                }
                                                                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser");
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser.<init>:(CI)V");
                                                                WeekBasedFieldPrinterParser weekBasedFieldPrinterParser = new WeekBasedFieldPrinterParser(c, n3);
                                                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                                                                this.appendInternal(weekBasedFieldPrinterParser);
                                                                RuntimeCostAccounter.recordJump();
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        --n;
                                        RuntimeCostAccounter.recordJump();
                                        break block66;
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    if (c != '\'') break block67;
                                    n2 = n++;
                                    while (true) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                        int n11 = string.length();
                                        RuntimeCostAccounter.recordJump();
                                        if (n >= n11) break;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                        char c5 = string.charAt(n);
                                        RuntimeCostAccounter.recordJump();
                                        if (c5 == '\'') {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                            int n12 = string.length();
                                            RuntimeCostAccounter.recordJump();
                                            if (n + 1 >= n12) break;
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                            char c6 = string.charAt(n + 1);
                                            RuntimeCostAccounter.recordJump();
                                            if (c6 != '\'') break;
                                            ++n;
                                        }
                                        ++n;
                                        RuntimeCostAccounter.recordJump();
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                    int n13 = string.length();
                                    RuntimeCostAccounter.recordJump();
                                    if (n >= n13) {
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                        StringBuilder stringBuilder = new StringBuilder();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder22 = stringBuilder.append("Pattern ends with an incomplete string literal: ");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                        StringBuilder stringBuilder23 = stringBuilder22.append(string);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                        String string16 = stringBuilder23.toString();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string16);
                                        RuntimeCostAccounter.recordThrow();
                                        throw illegalArgumentException;
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                                    String string17 = string.substring(n2 + 1, n);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                    int n14 = string17.length();
                                    RuntimeCostAccounter.recordJump();
                                    if (n14 == 0) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
                                        this.appendLiteral('\'');
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;");
                                        String string18 = string17.replace("''", "'");
                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
                                        this.appendLiteral(string18);
                                    }
                                    RuntimeCostAccounter.recordJump();
                                    break block66;
                                }
                                RuntimeCostAccounter.recordJump();
                                if (c != '[') break block68;
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalStart:()Ljava/time/format/DateTimeFormatterBuilder;");
                                this.optionalStart();
                                RuntimeCostAccounter.recordJump();
                                break block66;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (c != ']') break block69;
                            DateTimeFormatterBuilder dateTimeFormatterBuilder = this.active.parent;
                            RuntimeCostAccounter.recordJump();
                            if (dateTimeFormatterBuilder == null) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Pattern invalid as it contains ] without previous [");
                                RuntimeCostAccounter.recordThrow();
                                throw illegalArgumentException;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalEnd:()Ljava/time/format/DateTimeFormatterBuilder;");
                            this.optionalEnd();
                            RuntimeCostAccounter.recordJump();
                            break block66;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (c == '{') break block70;
                        RuntimeCostAccounter.recordJump();
                        if (c == '}') break block70;
                        RuntimeCostAccounter.recordJump();
                        if (c != '#') break block71;
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder24 = stringBuilder.append("Pattern includes reserved character: '");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder25 = stringBuilder24.append(c);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder26 = stringBuilder25.append("'");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    String string19 = stringBuilder26.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string19);
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
                this.appendLiteral(c);
            }
            ++n;
            RuntimeCostAccounter.recordJump();
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseField(char var1_1, int var2_2, TemporalField var3_3) {
        var4_4 = false;
        block0 : switch (var1_1) {
            case 'u': 
            case 'y': {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValueReduced:(Ljava/time/temporal/TemporalField;IILjava/time/chrono/ChronoLocalDate;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValueReduced(var3_3, 2, 2, ReducedPrinterParser.BASE_DATE);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (var2_2 < 4) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3, var2_2, 19, SignStyle.NORMAL);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                this.appendValue(var3_3, var2_2, 19, SignStyle.EXCEEDS_PAD);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 'c': {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 2) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    v0 = new IllegalArgumentException("Invalid pattern \"cc\"");
                    RuntimeCostAccounter.recordThrow();
                    throw v0;
                }
            }
            case 'L': 
            case 'q': {
                var4_4 = true;
            }
            case 'E': 
            case 'M': 
            case 'Q': 
            case 'e': {
                switch (var2_2) {
                    case 1: 
                    case 2: {
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 == 'c') ** GOTO lbl40
                        RuntimeCostAccounter.recordJump();
                        if (var1_1 != 'e') ** GOTO lbl48
lbl40:
                        // 2 sources

                        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser");
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser.<init>:(CI)V");
                        v1 = new WeekBasedFieldPrinterParser(var1_1, var2_2);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
                        this.appendInternal(v1);
                        RuntimeCostAccounter.recordJump();
                        break block0;
lbl48:
                        // 1 sources

                        RuntimeCostAccounter.recordJump();
                        if (var1_1 == 'E') {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                            this.appendText(var3_3, TextStyle.SHORT);
                            RuntimeCostAccounter.recordJump();
                            break block0;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (var2_2 == 1) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;)Ljava/time/format/DateTimeFormatterBuilder;");
                            this.appendValue(var3_3);
                            RuntimeCostAccounter.recordJump();
                            break block0;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendValue(var3_3, 2);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                    case 3: {
                        RuntimeCostAccounter.recordJump();
                        if (var4_4) {
                            v2 = TextStyle.SHORT_STANDALONE;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v2 = TextStyle.SHORT;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendText(var3_3, v2);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                    case 4: {
                        RuntimeCostAccounter.recordJump();
                        if (var4_4) {
                            v3 = TextStyle.FULL_STANDALONE;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v3 = TextStyle.FULL;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendText(var3_3, v3);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                    case 5: {
                        RuntimeCostAccounter.recordJump();
                        if (var4_4) {
                            v4 = TextStyle.NARROW_STANDALONE;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            v4 = TextStyle.NARROW;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendText(var3_3, v4);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v5 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v6 = v5.append("Too many pattern letters: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                v7 = v6.append(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                v8 = v7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v9 = new IllegalArgumentException(v8);
                RuntimeCostAccounter.recordThrow();
                throw v9;
            }
            case 'a': {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendText(var3_3, TextStyle.SHORT);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v10 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v11 = v10.append("Too many pattern letters: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                v12 = v11.append(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                v13 = v12.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v14 = new IllegalArgumentException(v13);
                RuntimeCostAccounter.recordThrow();
                throw v14;
            }
            case 'G': {
                switch (var2_2) {
                    case 1: 
                    case 2: 
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendText(var3_3, TextStyle.SHORT);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                    case 4: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendText(var3_3, TextStyle.FULL);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                    case 5: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendText:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;)Ljava/time/format/DateTimeFormatterBuilder;");
                        this.appendText(var3_3, TextStyle.NARROW);
                        RuntimeCostAccounter.recordJump();
                        break block0;
                    }
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v15 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v16 = v15.append("Too many pattern letters: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                v17 = v16.append(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                v18 = v17.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v19 = new IllegalArgumentException(v18);
                RuntimeCostAccounter.recordThrow();
                throw v19;
            }
            case 'S': {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendFraction:(Ljava/time/temporal/TemporalField;IIZ)Ljava/time/format/DateTimeFormatterBuilder;");
                this.appendFraction(ChronoField.NANO_OF_SECOND, var2_2, var2_2, false);
                RuntimeCostAccounter.recordJump();
                break;
            }
            case 'F': {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v20 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v21 = v20.append("Too many pattern letters: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                v22 = v21.append(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                v23 = v22.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v24 = new IllegalArgumentException(v23);
                RuntimeCostAccounter.recordThrow();
                throw v24;
            }
            case 'H': 
            case 'K': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 's': {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3, var2_2);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v25 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v26 = v25.append("Too many pattern letters: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                v27 = v26.append(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                v28 = v27.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v29 = new IllegalArgumentException(v28);
                RuntimeCostAccounter.recordThrow();
                throw v29;
            }
            case 'D': {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordJump();
                if (var2_2 <= 3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3, var2_2);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                v30 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                v31 = v30.append("Too many pattern letters: ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                v32 = v31.append(var1_1);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                v33 = v32.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                v34 = new IllegalArgumentException(v33);
                RuntimeCostAccounter.recordThrow();
                throw v34;
            }
            default: {
                RuntimeCostAccounter.recordJump();
                if (var2_2 == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;)Ljava/time/format/DateTimeFormatterBuilder;");
                    this.appendValue(var3_3);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
                this.appendValue(var3_3, var2_2);
            }
        }
    }

    public DateTimeFormatterBuilder padNext(int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.padNext:(IC)Ljava/time/format/DateTimeFormatterBuilder;");
        return this.padNext(n, ' ');
    }

    public DateTimeFormatterBuilder padNext(int n, char c) {
        RuntimeCostAccounter.recordJump();
        if (n < 1) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("The pad width must be at least one but was ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        this.active.padNextWidth = n;
        this.active.padNextChar = c;
        this.active.valueParserIndex = -1;
        return this;
    }

    public DateTimeFormatterBuilder optionalStart() {
        this.active.valueParserIndex = -1;
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:(Ljava/time/format/DateTimeFormatterBuilder;Z)V");
        this.active = new DateTimeFormatterBuilder(this.active, true);
        return this;
    }

    public DateTimeFormatterBuilder optionalEnd() {
        DateTimeFormatterBuilder dateTimeFormatterBuilder = this.active.parent;
        RuntimeCostAccounter.recordJump();
        if (dateTimeFormatterBuilder == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Cannot call optionalEnd() as there was no previous call to optionalStart()");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }
        List<DateTimePrinterParser> list = this.active.printerParsers;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        int n = list.size();
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser");
            List<DateTimePrinterParser> list2 = this.active.printerParsers;
            boolean bl = this.active.optional;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.<init>:(Ljava/util/List;Z)V");
            CompositePrinterParser compositePrinterParser = new CompositePrinterParser(list2, bl);
            this.active = this.active.parent;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendInternal:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;)I");
            this.appendInternal(compositePrinterParser);
            RuntimeCostAccounter.recordJump();
        } else {
            this.active = this.active.parent;
        }
        return this;
    }

    private int appendInternal(DateTimePrinterParser dateTimePrinterParser) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(dateTimePrinterParser, "pp");
        int n = this.active.padNextWidth;
        RuntimeCostAccounter.recordJump();
        if (n > 0) {
            RuntimeCostAccounter.recordJump();
            if (dateTimePrinterParser != null) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PadPrinterParserDecorator");
                int n2 = this.active.padNextWidth;
                char c = this.active.padNextChar;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PadPrinterParserDecorator.<init>:(Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;IC)V");
                dateTimePrinterParser = new PadPrinterParserDecorator(dateTimePrinterParser, n2, c);
            }
            this.active.padNextWidth = 0;
            this.active.padNextChar = '\u0000';
        }
        List<DateTimePrinterParser> list = this.active.printerParsers;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.add:(Ljava/lang/Object;)Z");
        list.add(dateTimePrinterParser);
        this.active.valueParserIndex = -1;
        List<DateTimePrinterParser> list2 = this.active.printerParsers;
        RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
        return list2.size() - 1;
    }

    public DateTimeFormatter toFormatter() {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatter;");
        return this.toFormatter(locale);
    }

    public DateTimeFormatter toFormatter(Locale locale) {
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        return this.toFormatter(locale, ResolverStyle.SMART, null);
    }

    DateTimeFormatter toFormatter(ResolverStyle resolverStyle, Chronology chronology) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.getDefault:(Ljava/util/Locale$Category;)Ljava/util/Locale;");
        Locale locale = Locale.getDefault(Locale.Category.FORMAT);
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;Ljava/time/format/ResolverStyle;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
        return this.toFormatter(locale, resolverStyle, chronology);
    }

    private DateTimeFormatter toFormatter(Locale locale, ResolverStyle resolverStyle, Chronology chronology) {
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
        Objects.requireNonNull(locale, "locale");
        while (true) {
            DateTimeFormatterBuilder dateTimeFormatterBuilder = this.active.parent;
            RuntimeCostAccounter.recordJump();
            if (dateTimeFormatterBuilder == null) break;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.optionalEnd:()Ljava/time/format/DateTimeFormatterBuilder;");
            this.optionalEnd();
            RuntimeCostAccounter.recordJump();
        }
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.<init>:(Ljava/util/List;Z)V");
        CompositePrinterParser compositePrinterParser = new CompositePrinterParser(this.printerParsers, false);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatter");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.<init>:(Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;Ljava/util/Locale;Ljava/time/format/DecimalStyle;Ljava/time/format/ResolverStyle;Ljava/util/Set;Ljava/time/chrono/Chronology;Ljava/time/ZoneId;)V");
        return new DateTimeFormatter(compositePrinterParser, locale, DecimalStyle.STANDARD, resolverStyle, null, chronology, null);
    }

    static {
        RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
        FIELD_MAP = new HashMap<Character, TemporalField>();
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c = Character.valueOf('G');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c, ChronoField.ERA);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c2 = Character.valueOf('y');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c2, ChronoField.YEAR_OF_ERA);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c3 = Character.valueOf('u');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c3, ChronoField.YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c4 = Character.valueOf('Q');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c4, IsoFields.QUARTER_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c5 = Character.valueOf('q');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c5, IsoFields.QUARTER_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c6 = Character.valueOf('M');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c6, ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c7 = Character.valueOf('L');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c7, ChronoField.MONTH_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c8 = Character.valueOf('D');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c8, ChronoField.DAY_OF_YEAR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c9 = Character.valueOf('d');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c9, ChronoField.DAY_OF_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c10 = Character.valueOf('F');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c10, ChronoField.ALIGNED_DAY_OF_WEEK_IN_MONTH);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c11 = Character.valueOf('E');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c11, ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c12 = Character.valueOf('c');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c12, ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c13 = Character.valueOf('e');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c13, ChronoField.DAY_OF_WEEK);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c14 = Character.valueOf('a');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c14, ChronoField.AMPM_OF_DAY);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c15 = Character.valueOf('H');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c15, ChronoField.HOUR_OF_DAY);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c16 = Character.valueOf('k');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c16, ChronoField.CLOCK_HOUR_OF_DAY);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c17 = Character.valueOf('K');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c17, ChronoField.HOUR_OF_AMPM);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c18 = Character.valueOf('h');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c18, ChronoField.CLOCK_HOUR_OF_AMPM);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c19 = Character.valueOf('m');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c19, ChronoField.MINUTE_OF_HOUR);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c20 = Character.valueOf('s');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c20, ChronoField.SECOND_OF_MINUTE);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c21 = Character.valueOf('S');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c21, ChronoField.NANO_OF_SECOND);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c22 = Character.valueOf('A');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c22, ChronoField.MILLI_OF_DAY);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c23 = Character.valueOf('n');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c23, ChronoField.NANO_OF_SECOND);
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.valueOf:(C)Ljava/lang/Character;");
        Character c24 = Character.valueOf('N');
        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        FIELD_MAP.put(c24, ChronoField.NANO_OF_DAY);
        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$2");
        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$2.<init>:()V");
        LENGTH_SORT = new Comparator<String>(){
            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            }

            @Override
            public int compare(String string, String string2) {
                int n;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = string.length();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = string2.length();
                RuntimeCostAccounter.recordJump();
                if (n2 == n3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.compareTo:(Ljava/lang/String;)I");
                    n = string.compareTo(string2);
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n4 = string.length();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    n = n4 - string2.length();
                }
                return n;
            }
        };
    }

    static final class WeekBasedFieldPrinterParser
    implements DateTimePrinterParser {
        private char chr;
        private int count;

        WeekBasedFieldPrinterParser(char c, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.chr = c;
            this.count = n;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getLocale:()Ljava/util/Locale;");
            Locale locale = dateTimePrintContext.getLocale();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser.printerParser:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;");
            DateTimePrinterParser dateTimePrinterParser = this.printerParser(locale);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
            return dateTimePrinterParser.format(dateTimePrintContext, stringBuilder);
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getLocale:()Ljava/util/Locale;");
            Locale locale = dateTimeParseContext.getLocale();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$WeekBasedFieldPrinterParser.printerParser:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;");
            DateTimePrinterParser dateTimePrinterParser = this.printerParser(locale);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
            return dateTimePrinterParser.parse(dateTimeParseContext, charSequence, n);
        }

        private DateTimePrinterParser printerParser(Locale locale) {
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.of:(Ljava/util/Locale;)Ljava/time/temporal/WeekFields;");
            WeekFields weekFields = WeekFields.of(locale);
            TemporalField temporalField = null;
            switch (this.chr) {
                case 'Y': {
                    SignStyle signStyle;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.weekBasedYear:()Ljava/time/temporal/TemporalField;");
                    temporalField = weekFields.weekBasedYear();
                    RuntimeCostAccounter.recordJump();
                    if (this.count == 2) {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser");
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;ILjava/time/format/DateTimeFormatterBuilder$1;)V");
                        return new ReducedPrinterParser(temporalField, 2, 2, 0, ReducedPrinterParser.BASE_DATE, 0, null);
                    }
                    RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
                    RuntimeCostAccounter.recordJump();
                    if (this.count < 4) {
                        signStyle = SignStyle.NORMAL;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        signStyle = SignStyle.EXCEEDS_PAD;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;I)V");
                    return new NumberPrinterParser(temporalField, this.count, 19, signStyle, -1);
                }
                case 'c': 
                case 'e': {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.dayOfWeek:()Ljava/time/temporal/TemporalField;");
                    temporalField = weekFields.dayOfWeek();
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 'w': {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.weekOfWeekBasedYear:()Ljava/time/temporal/TemporalField;");
                    temporalField = weekFields.weekOfWeekBasedYear();
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 'W': {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/WeekFields.weekOfMonth:()Ljava/time/temporal/TemporalField;");
                    temporalField = weekFields.weekOfMonth();
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                default: {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
                    IllegalStateException illegalStateException = new IllegalStateException("unreachable");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalStateException;
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
            RuntimeCostAccounter.recordJump();
            if (this.count == 2) {
                n = 2;
                RuntimeCostAccounter.recordJump();
            } else {
                n = 1;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)V");
            return new NumberPrinterParser(temporalField, n, 2, SignStyle.NOT_NEGATIVE);
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
            StringBuilder stringBuilder = new StringBuilder(30);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append("Localized(");
            RuntimeCostAccounter.recordJump();
            if (this.chr == 'Y') {
                RuntimeCostAccounter.recordJump();
                if (this.count == 1) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    stringBuilder.append("WeekBasedYear");
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.count == 2) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append("ReducedValue(WeekBasedYear,2,2,2000-01-01)");
                        RuntimeCostAccounter.recordJump();
                    } else {
                        SignStyle signStyle;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("WeekBasedYear,");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(this.count);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder3.append(",");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(19);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder6 = stringBuilder5.append(",");
                        RuntimeCostAccounter.recordJump();
                        if (this.count < 4) {
                            signStyle = SignStyle.NORMAL;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            signStyle = SignStyle.EXCEEDS_PAD;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        stringBuilder6.append((Object)signStyle);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            } else {
                switch (this.chr) {
                    case 'c': 
                    case 'e': {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append("DayOfWeek");
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 'w': {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append("WeekOfWeekBasedYear");
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 'W': {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append("WeekOfMonth");
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(",");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                stringBuilder.append(this.count);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder.toString();
        }
    }

    static final class LocalizedPrinterParser
    implements DateTimePrinterParser {
        private static final ConcurrentMap<String, DateTimeFormatter> FORMATTER_CACHE;
        private final FormatStyle dateStyle;
        private final FormatStyle timeStyle;

        LocalizedPrinterParser(FormatStyle formatStyle, FormatStyle formatStyle2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.dateStyle = formatStyle;
            this.timeStyle = formatStyle2;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getTemporal:()Ljava/time/temporal/TemporalAccessor;");
            TemporalAccessor temporalAccessor = dateTimePrintContext.getTemporal();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
            Chronology chronology = Chronology.from(temporalAccessor);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getLocale:()Ljava/util/Locale;");
            Locale locale = dateTimePrintContext.getLocale();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedPrinterParser.formatter:(Ljava/util/Locale;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
            DateTimeFormatter dateTimeFormatter = this.formatter(locale, chronology);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.toPrinterParser:(Z)Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;");
            CompositePrinterParser compositePrinterParser = dateTimeFormatter.toPrinterParser(false);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
            return compositePrinterParser.format(dateTimePrintContext, stringBuilder);
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getEffectiveChronology:()Ljava/time/chrono/Chronology;");
            Chronology chronology = dateTimeParseContext.getEffectiveChronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getLocale:()Ljava/util/Locale;");
            Locale locale = dateTimeParseContext.getLocale();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedPrinterParser.formatter:(Ljava/util/Locale;Ljava/time/chrono/Chronology;)Ljava/time/format/DateTimeFormatter;");
            DateTimeFormatter dateTimeFormatter = this.formatter(locale, chronology);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.toPrinterParser:(Z)Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;");
            CompositePrinterParser compositePrinterParser = dateTimeFormatter.toPrinterParser(false);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
            return compositePrinterParser.parse(dateTimeParseContext, charSequence, n);
        }

        private DateTimeFormatter formatter(Locale locale, Chronology chronology) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
            String string = chronology.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append('|');
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Locale.toString:()Ljava/lang/String;");
            String string2 = locale.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append('|');
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append((Object)this.dateStyle);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append((Object)this.timeStyle);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder7.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.get:(Ljava/lang/Object;)Ljava/lang/Object;");
            DateTimeFormatter dateTimeFormatter = (DateTimeFormatter)FORMATTER_CACHE.get(string3);
            RuntimeCostAccounter.recordJump();
            if (dateTimeFormatter == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.getLocalizedDateTimePattern:(Ljava/time/format/FormatStyle;Ljava/time/format/FormatStyle;Ljava/time/chrono/Chronology;Ljava/util/Locale;)Ljava/lang/String;");
                String string4 = DateTimeFormatterBuilder.getLocalizedDateTimePattern(this.dateStyle, this.timeStyle, chronology, locale);
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
                DateTimeFormatterBuilder dateTimeFormatterBuilder = new DateTimeFormatterBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendPattern:(Ljava/lang/String;)Ljava/time/format/DateTimeFormatterBuilder;");
                DateTimeFormatterBuilder dateTimeFormatterBuilder2 = dateTimeFormatterBuilder.appendPattern(string4);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:(Ljava/util/Locale;)Ljava/time/format/DateTimeFormatter;");
                dateTimeFormatter = dateTimeFormatterBuilder2.toFormatter(locale);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentMap.putIfAbsent:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                DateTimeFormatter dateTimeFormatter2 = FORMATTER_CACHE.putIfAbsent(string3, dateTimeFormatter);
                RuntimeCostAccounter.recordJump();
                if (dateTimeFormatter2 != null) {
                    dateTimeFormatter = dateTimeFormatter2;
                }
            }
            return dateTimeFormatter;
        }

        public String toString() {
            Object object;
            Object object2;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Localized(");
            RuntimeCostAccounter.recordJump();
            if (this.dateStyle != null) {
                object2 = this.dateStyle;
                RuntimeCostAccounter.recordJump();
            } else {
                object2 = "";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(object2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordJump();
            if (this.timeStyle != null) {
                object = this.timeStyle;
                RuntimeCostAccounter.recordJump();
            } else {
                object = "";
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(object);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder6.toString();
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:(IFI)V");
            FORMATTER_CACHE = new ConcurrentHashMap<String, DateTimeFormatter>(16, 0.75f, 2);
        }
    }

    static final class ChronoPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle textStyle;

        ChronoPrinterParser(TextStyle textStyle) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.textStyle = textStyle;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
            TemporalQuery<Chronology> temporalQuery = TemporalQueries.chronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            Chronology chronology = dateTimePrintContext.getValue(temporalQuery);
            RuntimeCostAccounter.recordJump();
            if (chronology == null) {
                return false;
            }
            RuntimeCostAccounter.recordJump();
            if (this.textStyle == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                String string = chronology.getId();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(string);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getLocale:()Ljava/util/Locale;");
                Locale locale = dateTimePrintContext.getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ChronoPrinterParser.getChronologyName:(Ljava/time/chrono/Chronology;Ljava/util/Locale;)Ljava/lang/String;");
                String string = this.getChronologyName(chronology, locale);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(string);
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            block10: {
                block9: {
                    RuntimeCostAccounter.recordJump();
                    if (n < 0) break block9;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    int n2 = charSequence.length();
                    RuntimeCostAccounter.recordJump();
                    if (n <= n2) break block10;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getAvailableChronologies:()Ljava/util/Set;");
            Set<Chronology> set = Chronology.getAvailableChronologies();
            Chronology chronology = null;
            int n3 = -1;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<Chronology> iterator = set.iterator();
            while (true) {
                String string;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                Chronology chronology2 = iterator.next();
                RuntimeCostAccounter.recordJump();
                if (this.textStyle == null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                    string = chronology2.getId();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getLocale:()Ljava/util/Locale;");
                    Locale locale = dateTimeParseContext.getLocale();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ChronoPrinterParser.getChronologyName:(Ljava/time/chrono/Chronology;Ljava/util/Locale;)Ljava/lang/String;");
                    string = this.getChronologyName(chronology2, locale);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n4 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n4 > n3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.subSequenceEquals:(Ljava/lang/CharSequence;ILjava/lang/CharSequence;II)Z");
                    boolean bl2 = dateTimeParseContext.subSequenceEquals(charSequence, n, string, 0, n4);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        chronology = chronology2;
                        n3 = n4;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (chronology == null) {
                return ~n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/chrono/Chronology;)V");
            dateTimeParseContext.setParsed(chronology);
            return n + n3;
        }

        private String getChronologyName(Chronology chronology, Locale locale) {
            String string;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("calendarname.");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getCalendarType:()Ljava/lang/String;");
            String string2 = chronology.getCalendarType();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getLocalizedResource:(Ljava/lang/String;Ljava/util/Locale;)Ljava/lang/Object;");
            String string4 = (String)DateTimeTextProvider.getLocalizedResource(string3, locale);
            RuntimeCostAccounter.recordJump();
            if (string4 != null) {
                string = string4;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.getId:()Ljava/lang/String;");
                string = chronology.getId();
            }
            return string;
        }
    }

    static class PrefixTree {
        protected String key;
        protected String value;
        protected char c0;
        protected PrefixTree child;
        protected PrefixTree sibling;

        private PrefixTree(String string, String string2, PrefixTree prefixTree) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.key = string;
            this.value = string2;
            this.child = prefixTree;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string.length();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                this.c0 = (char)65535;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                this.c0 = this.key.charAt(0);
            }
        }

        public static PrefixTree newTree(DateTimeParseContext dateTimeParseContext) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
            boolean bl = dateTimeParseContext.isCaseSensitive();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
                return new PrefixTree("", null, null);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;Ljava/time/format/DateTimeFormatterBuilder$1;)V");
            return new CI("", null, null, null);
        }

        public static PrefixTree newTree(Set<String> set, DateTimeParseContext dateTimeParseContext) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.newTree:(Ljava/time/format/DateTimeParseContext;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
            PrefixTree prefixTree = PrefixTree.newTree(dateTimeParseContext);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
            Iterator<String> iterator = set.iterator();
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                boolean bl = iterator.hasNext();
                RuntimeCostAccounter.recordJump();
                if (!bl) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                String string = iterator.next();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.add0:(Ljava/lang/String;Ljava/lang/String;)Z");
                prefixTree.add0(string, string);
                RuntimeCostAccounter.recordJump();
            }
            return prefixTree;
        }

        public PrefixTree copyTree() {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
            PrefixTree prefixTree = new PrefixTree(this.key, this.value, null);
            RuntimeCostAccounter.recordJump();
            if (this.child != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.copyTree:()Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                prefixTree.child = this.child.copyTree();
            }
            RuntimeCostAccounter.recordJump();
            if (this.sibling != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.copyTree:()Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                prefixTree.sibling = this.sibling.copyTree();
            }
            return prefixTree;
        }

        public boolean add(String string, String string2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.add0:(Ljava/lang/String;Ljava/lang/String;)Z");
            return this.add0(string, string2);
        }

        private boolean add0(String string, String string2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.toKey:(Ljava/lang/String;)Ljava/lang/String;");
            string = this.toKey(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.prefixLength:(Ljava/lang/String;)I");
            int n = this.prefixLength(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n2 = this.key.length();
            RuntimeCostAccounter.recordJump();
            if (n == n2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n < n3) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                    String string3 = string.substring(n);
                    PrefixTree prefixTree = this.child;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (prefixTree == null) break;
                        char c = prefixTree.c0;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                        char c2 = string3.charAt(0);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.isEqual:(CC)Z");
                        boolean bl = this.isEqual(c, c2);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.add0:(Ljava/lang/String;Ljava/lang/String;)Z");
                            return prefixTree.add0(string3, string2);
                        }
                        prefixTree = prefixTree.sibling;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.newNode:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                    prefixTree = this.newNode(string3, string2, null);
                    prefixTree.sibling = this.child;
                    this.child = prefixTree;
                    return true;
                }
                this.value = string2;
                return true;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
            String string4 = this.key.substring(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.newNode:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
            PrefixTree prefixTree = this.newNode(string4, this.value, this.child);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
            this.key = string.substring(0, n);
            this.child = prefixTree;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n4 = string.length();
            RuntimeCostAccounter.recordJump();
            if (n < n4) {
                PrefixTree prefixTree2;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                String string5 = string.substring(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.newNode:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                this.child.sibling = prefixTree2 = this.newNode(string5, string2, null);
                this.value = null;
                RuntimeCostAccounter.recordJump();
            } else {
                this.value = string2;
            }
            return true;
        }

        public String match(CharSequence charSequence, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.prefixOf:(Ljava/lang/CharSequence;II)Z");
            boolean bl = this.prefixOf(charSequence, n, n2);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return null;
            }
            RuntimeCostAccounter.recordJump();
            if (this.child != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                RuntimeCostAccounter.recordJump();
                if ((n += this.key.length()) != n2) {
                    PrefixTree prefixTree = this.child;
                    do {
                        char c = prefixTree.c0;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c2 = charSequence.charAt(n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.isEqual:(CC)Z");
                        boolean bl2 = this.isEqual(c, c2);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.match:(Ljava/lang/CharSequence;II)Ljava/lang/String;");
                            String string = prefixTree.match(charSequence, n, n2);
                            RuntimeCostAccounter.recordJump();
                            if (string != null) {
                                return string;
                            }
                            return this.value;
                        }
                        prefixTree = prefixTree.sibling;
                        RuntimeCostAccounter.recordJump();
                    } while (prefixTree != null);
                }
            }
            return this.value;
        }

        public String match(CharSequence charSequence, ParsePosition parsePosition) {
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
            int n = parsePosition.getIndex();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            int n2 = charSequence.length();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.prefixOf:(Ljava/lang/CharSequence;II)Z");
            boolean bl = this.prefixOf(charSequence, n, n2);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return null;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            n += this.key.length();
            RuntimeCostAccounter.recordJump();
            if (this.child != null) {
                RuntimeCostAccounter.recordJump();
                if (n != n2) {
                    PrefixTree prefixTree = this.child;
                    do {
                        char c = prefixTree.c0;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c2 = charSequence.charAt(n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.isEqual:(CC)Z");
                        boolean bl2 = this.isEqual(c, c2);
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setIndex:(I)V");
                            parsePosition.setIndex(n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.match:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/lang/String;");
                            String string = prefixTree.match(charSequence, parsePosition);
                            RuntimeCostAccounter.recordJump();
                            if (string == null) break;
                            return string;
                        }
                        prefixTree = prefixTree.sibling;
                        RuntimeCostAccounter.recordJump();
                    } while (prefixTree != null);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setIndex:(I)V");
            parsePosition.setIndex(n);
            return this.value;
        }

        protected String toKey(String string) {
            return string;
        }

        protected PrefixTree newNode(String string, String string2, PrefixTree prefixTree) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
            return new PrefixTree(string, string2, prefixTree);
        }

        protected boolean isEqual(char c, char c2) {
            boolean bl;
            RuntimeCostAccounter.recordJump();
            if (c == c2) {
                bl = true;
                RuntimeCostAccounter.recordJump();
            } else {
                bl = false;
            }
            return bl;
        }

        protected boolean prefixOf(CharSequence charSequence, int n, int n2) {
            block3: {
                boolean bl;
                boolean bl2 = charSequence instanceof String;
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    String string = (String)charSequence;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.startsWith:(Ljava/lang/String;I)Z");
                    return string.startsWith(this.key, n);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = this.key.length();
                RuntimeCostAccounter.recordJump();
                if (n3 > n2 - n) {
                    return false;
                }
                int n4 = 0;
                do {
                    int n5 = n3--;
                    RuntimeCostAccounter.recordJump();
                    if (n5 <= 0) break block3;
                    int n6 = n4++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                    char c = this.key.charAt(n6);
                    int n7 = n++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    char c2 = charSequence.charAt(n7);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.isEqual:(CC)Z");
                    bl = this.isEqual(c, c2);
                    RuntimeCostAccounter.recordJump();
                } while (bl);
                return false;
            }
            return true;
        }

        private int prefixLength(String string) {
            int n = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n2 = string.length();
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = this.key.length();
                RuntimeCostAccounter.recordJump();
                if (n >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c = string.charAt(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                char c2 = this.key.charAt(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.isEqual:(CC)Z");
                boolean bl = this.isEqual(c, c2);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    return n;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            return n;
        }

        /* synthetic */ PrefixTree(String string, String string2, PrefixTree prefixTree, 1 var4_4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
            this(string, string2, prefixTree);
        }

        private static class LENIENT
        extends CI {
            private LENIENT(String string, String string2, PrefixTree prefixTree) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;Ljava/time/format/DateTimeFormatterBuilder$1;)V");
                super(string, string2, prefixTree, null);
            }

            @Override
            protected CI newNode(String string, String string2, PrefixTree prefixTree) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
                return new LENIENT(string, string2, prefixTree);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private boolean isLenientChar(char c) {
                RuntimeCostAccounter.recordJump();
                if (c != ' ') {
                    RuntimeCostAccounter.recordJump();
                    if (c != '_') {
                        RuntimeCostAccounter.recordJump();
                        if (c != '/') return false;
                    }
                }
                boolean bl = true;
                RuntimeCostAccounter.recordJump();
                return bl;
            }

            @Override
            protected String toKey(String string) {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n2 = string.length();
                    RuntimeCostAccounter.recordJump();
                    if (n >= n2) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                    char c = string.charAt(n);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.isLenientChar:(C)Z");
                    boolean bl = this.isLenientChar(c);
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                        int n3 = string.length();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:(I)V");
                        StringBuilder stringBuilder = new StringBuilder(n3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/CharSequence;II)Ljava/lang/StringBuilder;");
                        stringBuilder.append(string, 0, n);
                        ++n;
                        while (true) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                            int n4 = string.length();
                            RuntimeCostAccounter.recordJump();
                            if (n >= n4) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                            char c2 = string.charAt(n);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.isLenientChar:(C)Z");
                            boolean bl2 = this.isLenientChar(c2);
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                                char c3 = string.charAt(n);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                stringBuilder.append(c3);
                            }
                            ++n;
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        return stringBuilder.toString();
                    }
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                return string;
            }

            @Override
            public String match(CharSequence charSequence, ParsePosition parsePosition) {
                int n;
                int n2;
                int n3;
                int n4;
                block9: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
                    n4 = parsePosition.getIndex();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    n3 = charSequence.length();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    n2 = this.key.length();
                    n = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n >= n2) break block9;
                        RuntimeCostAccounter.recordJump();
                        if (n4 >= n3) break block9;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c = charSequence.charAt(n4);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.isLenientChar:(C)Z");
                        boolean bl = this.isLenientChar(c);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            ++n4;
                            RuntimeCostAccounter.recordJump();
                            continue;
                        }
                        int n5 = n++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                        char c2 = this.key.charAt(n5);
                        int n6 = n4++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c3 = charSequence.charAt(n6);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.isEqual:(CC)Z");
                        boolean bl2 = this.isEqual(c2, c3);
                        RuntimeCostAccounter.recordJump();
                        if (!bl2) break;
                    }
                    return null;
                }
                RuntimeCostAccounter.recordJump();
                if (n != n2) {
                    return null;
                }
                RuntimeCostAccounter.recordJump();
                if (this.child != null) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 != n3) {
                        int n7 = n4;
                        while (true) {
                            RuntimeCostAccounter.recordJump();
                            if (n7 >= n3) break;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                            char c = charSequence.charAt(n7);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.isLenientChar:(C)Z");
                            boolean bl = this.isLenientChar(c);
                            RuntimeCostAccounter.recordJump();
                            if (!bl) break;
                            ++n7;
                            RuntimeCostAccounter.recordJump();
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n7 < n3) {
                            PrefixTree prefixTree = this.child;
                            do {
                                char c = prefixTree.c0;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                                char c4 = charSequence.charAt(n7);
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$LENIENT.isEqual:(CC)Z");
                                boolean bl = this.isEqual(c, c4);
                                RuntimeCostAccounter.recordJump();
                                if (bl) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setIndex:(I)V");
                                    parsePosition.setIndex(n7);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.match:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/lang/String;");
                                    String string = prefixTree.match(charSequence, parsePosition);
                                    RuntimeCostAccounter.recordJump();
                                    if (string == null) break;
                                    return string;
                                }
                                prefixTree = prefixTree.sibling;
                                RuntimeCostAccounter.recordJump();
                            } while (prefixTree != null);
                        }
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.setIndex:(I)V");
                parsePosition.setIndex(n4);
                return this.value;
            }
        }

        private static class CI
        extends PrefixTree {
            private CI(String string, String string2, PrefixTree prefixTree) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;Ljava/time/format/DateTimeFormatterBuilder$1;)V");
                super(string, string2, prefixTree, null);
            }

            @Override
            protected CI newNode(String string, String string2, PrefixTree prefixTree) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
                return new CI(string, string2, prefixTree);
            }

            @Override
            protected boolean isEqual(char c, char c2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEqualsIgnoreCase:(CC)Z");
                return DateTimeParseContext.charEqualsIgnoreCase(c, c2);
            }

            @Override
            protected boolean prefixOf(CharSequence charSequence, int n, int n2) {
                block2: {
                    boolean bl;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    int n3 = this.key.length();
                    RuntimeCostAccounter.recordJump();
                    if (n3 > n2 - n) {
                        return false;
                    }
                    int n4 = 0;
                    do {
                        int n5 = n3--;
                        RuntimeCostAccounter.recordJump();
                        if (n5 <= 0) break block2;
                        int n6 = n4++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.charAt:(I)C");
                        char c = this.key.charAt(n6);
                        int n7 = n++;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c2 = charSequence.charAt(n7);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI.isEqual:(CC)Z");
                        bl = this.isEqual(c, c2);
                        RuntimeCostAccounter.recordJump();
                    } while (bl);
                    return false;
                }
                return true;
            }

            /* synthetic */ CI(String string, String string2, PrefixTree prefixTree, 1 var4_4) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree$CI.<init>:(Ljava/lang/String;Ljava/lang/String;Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;)V");
                this(string, string2, prefixTree);
            }
        }
    }

    static class ZoneIdPrinterParser
    implements DateTimePrinterParser {
        private final TemporalQuery<ZoneId> query;
        private final String description;
        private static volatile Map.Entry<Integer, PrefixTree> cachedPrefixTree;
        private static volatile Map.Entry<Integer, PrefixTree> cachedPrefixTreeCI;

        ZoneIdPrinterParser(TemporalQuery<ZoneId> temporalQuery, String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.query = temporalQuery;
            this.description = string;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            ZoneId zoneId = dateTimePrintContext.getValue(this.query);
            RuntimeCostAccounter.recordJump();
            if (zoneId == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
            String string = zoneId.getId();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(string);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected PrefixTree getTree(DateTimeParseContext dateTimeParseContext) {
            Map.Entry<Integer, PrefixTree> entry;
            block12: {
                block10: {
                    int n;
                    Set<String> set;
                    block11: {
                        Map.Entry<Integer, PrefixTree> entry2;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.getAvailableZoneIds:()Ljava/util/Set;");
                        set = ZoneRulesProvider.getAvailableZoneIds();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                        n = set.size();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
                        boolean bl = dateTimeParseContext.isCaseSensitive();
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            entry2 = cachedPrefixTree;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entry2 = cachedPrefixTreeCI;
                        }
                        entry = entry2;
                        RuntimeCostAccounter.recordJump();
                        if (entry == null) break block11;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                        int n2 = entry.getKey();
                        RuntimeCostAccounter.recordJump();
                        if (n2 == n) break block12;
                    }
                    ZoneIdPrinterParser zoneIdPrinterParser = this;
                    try {
                        Map.Entry<Integer, PrefixTree> entry3;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
                        boolean bl = dateTimeParseContext.isCaseSensitive();
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            entry3 = cachedPrefixTree;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            entry3 = cachedPrefixTreeCI;
                        }
                        entry = entry3;
                        RuntimeCostAccounter.recordJump();
                        if (entry != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                            int n3 = entry.getKey();
                            RuntimeCostAccounter.recordJump();
                            if (n3 == n) break block10;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                        Integer n4 = n;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.newTree:(Ljava/util/Set;Ljava/time/format/DateTimeParseContext;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                        PrefixTree prefixTree = PrefixTree.newTree(set, dateTimeParseContext);
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                        entry = new AbstractMap.SimpleImmutableEntry<Integer, PrefixTree>(n4, prefixTree);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
                        boolean bl2 = dateTimeParseContext.isCaseSensitive();
                        RuntimeCostAccounter.recordJump();
                        if (bl2) {
                            cachedPrefixTree = entry;
                            RuntimeCostAccounter.recordJump();
                            break block10;
                        }
                        cachedPrefixTreeCI = entry;
                    }
                    catch (Throwable throwable) {
                        RuntimeCostAccounter.recordThrow();
                        throw throwable;
                    }
                }
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
            return entry.getValue();
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            char c;
            int n2;
            block17: {
                block16: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    n2 = charSequence.length();
                    RuntimeCostAccounter.recordJump();
                    if (n > n2) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                        IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                        RuntimeCostAccounter.recordThrow();
                        throw indexOutOfBoundsException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n == n2) {
                        return ~n;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    c = charSequence.charAt(n);
                    RuntimeCostAccounter.recordJump();
                    if (c == '+') break block16;
                    RuntimeCostAccounter.recordJump();
                    if (c != '-') break block17;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.parseOffsetBased:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;IILjava/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser;)I");
                return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n, OffsetIdPrinterParser.INSTANCE_ID_Z);
            }
            RuntimeCostAccounter.recordJump();
            if (n2 >= n + 2) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c2 = charSequence.charAt(n + 1);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                boolean bl = dateTimeParseContext.charEquals(c, 'U');
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                    boolean bl2 = dateTimeParseContext.charEquals(c2, 'T');
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= n + 3) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                            char c3 = charSequence.charAt(n + 2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                            boolean bl3 = dateTimeParseContext.charEquals(c3, 'C');
                            RuntimeCostAccounter.recordJump();
                            if (bl3) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.parseOffsetBased:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;IILjava/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser;)I");
                                return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n + 3, OffsetIdPrinterParser.INSTANCE_ID_ZERO);
                            }
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.parseOffsetBased:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;IILjava/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser;)I");
                        return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n + 2, OffsetIdPrinterParser.INSTANCE_ID_ZERO);
                    }
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                boolean bl4 = dateTimeParseContext.charEquals(c, 'G');
                RuntimeCostAccounter.recordJump();
                if (bl4) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n + 3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                        boolean bl5 = dateTimeParseContext.charEquals(c2, 'M');
                        RuntimeCostAccounter.recordJump();
                        if (bl5) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                            char c4 = charSequence.charAt(n + 2);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                            boolean bl6 = dateTimeParseContext.charEquals(c4, 'T');
                            RuntimeCostAccounter.recordJump();
                            if (bl6) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.parseOffsetBased:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;IILjava/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser;)I");
                                return this.parseOffsetBased(dateTimeParseContext, charSequence, n, n + 3, OffsetIdPrinterParser.INSTANCE_ID_ZERO);
                            }
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.getTree:(Ljava/time/format/DateTimeParseContext;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
            PrefixTree prefixTree = this.getTree(dateTimeParseContext);
            RuntimeCostAccounter.recordAllocation((String)"java/text/ParsePosition");
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.<init>:(I)V");
            ParsePosition parsePosition = new ParsePosition(n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.match:(Ljava/lang/CharSequence;Ljava/text/ParsePosition;)Ljava/lang/String;");
            String string = prefixTree.match(charSequence, parsePosition);
            RuntimeCostAccounter.recordJump();
            if (string == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                boolean bl = dateTimeParseContext.charEquals(c, 'Z');
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/ZoneId;)V");
                    dateTimeParseContext.setParsed(ZoneOffset.UTC);
                    return n + 1;
                }
                return ~n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.of:(Ljava/lang/String;)Ljava/time/ZoneId;");
            ZoneId zoneId = ZoneId.of(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/ZoneId;)V");
            dateTimeParseContext.setParsed(zoneId);
            RuntimeCostAccounter.recordMethodCall((String)"java/text/ParsePosition.getIndex:()I");
            return parsePosition.getIndex();
        }

        private int parseOffsetBased(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n, int n2, OffsetIdPrinterParser offsetIdPrinterParser) {
            String string;
            block9: {
                block8: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.toString:()Ljava/lang/String;");
                    String string2 = charSequence.toString();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(II)Ljava/lang/String;");
                    String string3 = string2.substring(n, n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.toUpperCase:()Ljava/lang/String;");
                    string = string3.toUpperCase();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    int n3 = charSequence.length();
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n3) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.of:(Ljava/lang/String;)Ljava/time/ZoneId;");
                        ZoneId zoneId = ZoneId.of(string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/ZoneId;)V");
                        dateTimeParseContext.setParsed(zoneId);
                        return n2;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    char c = charSequence.charAt(n2);
                    RuntimeCostAccounter.recordJump();
                    if (c == '0') break block8;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    char c2 = charSequence.charAt(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                    boolean bl = dateTimeParseContext.charEquals(c2, 'Z');
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break block9;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.of:(Ljava/lang/String;)Ljava/time/ZoneId;");
                ZoneId zoneId = ZoneId.of(string);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/ZoneId;)V");
                dateTimeParseContext.setParsed(zoneId);
                return n2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.copy:()Ljava/time/format/DateTimeParseContext;");
            DateTimeParseContext dateTimeParseContext2 = dateTimeParseContext.copy();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
            int n4 = offsetIdPrinterParser.parse(dateTimeParseContext2, charSequence, n2);
            try {
                RuntimeCostAccounter.recordJump();
                if (n4 < 0) {
                    RuntimeCostAccounter.recordJump();
                    if (offsetIdPrinterParser == OffsetIdPrinterParser.INSTANCE_ID_Z) {
                        return ~n;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.of:(Ljava/lang/String;)Ljava/time/ZoneId;");
                    ZoneId zoneId = ZoneId.of(string);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/ZoneId;)V");
                    dateTimeParseContext.setParsed(zoneId);
                    return n2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
                Long l = dateTimeParseContext2.getParsed(ChronoField.OFFSET_SECONDS);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                int n5 = (int)l.longValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneOffset.ofTotalSeconds:(I)Ljava/time/ZoneOffset;");
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(n5);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.ofOffset:(Ljava/lang/String;Ljava/time/ZoneOffset;)Ljava/time/ZoneId;");
                ZoneId zoneId = ZoneId.ofOffset(string, zoneOffset);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsed:(Ljava/time/ZoneId;)V");
                dateTimeParseContext.setParsed(zoneId);
                return n4;
            }
            catch (DateTimeException dateTimeException) {
                return ~n;
            }
        }

        public String toString() {
            return this.description;
        }
    }

    static final class ZoneTextPrinterParser
    extends ZoneIdPrinterParser {
        private final TextStyle textStyle;
        private Set<String> preferredZones;
        private static final int STD = 0;
        private static final int DST = 1;
        private static final int GENERIC = 2;
        private static final Map<String, SoftReference<Map<Locale, String[]>>> cache;
        private final Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> cachedTree;
        private final Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> cachedTreeCI;

        ZoneTextPrinterParser(TextStyle textStyle, Set<ZoneId> set) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zone:()Ljava/time/temporal/TemporalQuery;");
            TemporalQuery<ZoneId> temporalQuery = TemporalQueries.zone();
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("ZoneText(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append((Object)textStyle);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string = stringBuilder4.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.<init>:(Ljava/time/temporal/TemporalQuery;Ljava/lang/String;)V");
            super(temporalQuery, string);
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
            this.cachedTree = new HashMap<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>>();
            RuntimeCostAccounter.recordAllocation((String)"java/util/HashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/HashMap.<init>:()V");
            this.cachedTreeCI = new HashMap<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>>();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            this.textStyle = Objects.requireNonNull(textStyle, "textStyle");
            RuntimeCostAccounter.recordJump();
            if (set != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                int n = set.size();
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/HashSet");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/HashSet.<init>:()V");
                    this.preferredZones = new HashSet<String>();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.iterator:()Ljava/util/Iterator;");
                    Iterator<ZoneId> iterator = set.iterator();
                    while (true) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                        boolean bl = iterator.hasNext();
                        RuntimeCostAccounter.recordJump();
                        if (!bl) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                        ZoneId zoneId = iterator.next();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
                        String string2 = zoneId.getId();
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.add:(Ljava/lang/Object;)Z");
                        this.preferredZones.add(string2);
                        RuntimeCostAccounter.recordJump();
                    }
                }
            }
        }

        private String getDisplayName(String string, int n, Locale locale) {
            String[] stringArray;
            block13: {
                Map<Locale, String[]> map;
                block12: {
                    RuntimeCostAccounter.recordJump();
                    if (this.textStyle == TextStyle.NARROW) {
                        return null;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    SoftReference<Map<Locale, String[]>> softReference = cache.get(string);
                    map = null;
                    RuntimeCostAccounter.recordJump();
                    if (softReference == null) break block12;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.get:()Ljava/lang/Object;");
                    map = softReference.get();
                    RuntimeCostAccounter.recordJump();
                    if (map == null) break block12;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    stringArray = map.get(locale);
                    RuntimeCostAccounter.recordJump();
                    if (stringArray != null) break block13;
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/TimeZoneNameUtility.retrieveDisplayNames:(Ljava/lang/String;Ljava/util/Locale;)[Ljava/lang/String;");
                stringArray = TimeZoneNameUtility.retrieveDisplayNames((String)string, (Locale)locale);
                RuntimeCostAccounter.recordJump();
                if (stringArray == null) {
                    return null;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.copyOfRange:([Ljava/lang/Object;II)[Ljava/lang/Object;");
                stringArray = Arrays.copyOfRange(stringArray, 0, 7);
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/TimeZoneNameUtility.retrieveGenericDisplayName:(Ljava/lang/String;ILjava/util/Locale;)Ljava/lang/String;");
                stringArray[5] = TimeZoneNameUtility.retrieveGenericDisplayName((String)string, (int)1, (Locale)locale);
                String string2 = stringArray[5];
                RuntimeCostAccounter.recordJump();
                if (string2 == null) {
                    stringArray[5] = stringArray[0];
                }
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/TimeZoneNameUtility.retrieveGenericDisplayName:(Ljava/lang/String;ILjava/util/Locale;)Ljava/lang/String;");
                stringArray[6] = TimeZoneNameUtility.retrieveGenericDisplayName((String)string, (int)0, (Locale)locale);
                String string3 = stringArray[6];
                RuntimeCostAccounter.recordJump();
                if (string3 == null) {
                    stringArray[6] = stringArray[0];
                }
                RuntimeCostAccounter.recordJump();
                if (map == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
                    map = new ConcurrentHashMap<Locale, String[]>();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                map.put(locale, stringArray);
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/SoftReference");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.<init>:(Ljava/lang/Object;)V");
                SoftReference<Map<Locale, String[]>> softReference = new SoftReference<Map<Locale, String[]>>(map);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                cache.put(string, softReference);
            }
            switch (n) {
                case 0: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.zoneNameStyleIndex:()I");
                    return stringArray[this.textStyle.zoneNameStyleIndex() + 1];
                }
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.zoneNameStyleIndex:()I");
                    return stringArray[this.textStyle.zoneNameStyleIndex() + 3];
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/TextStyle.zoneNameStyleIndex:()I");
            return stringArray[this.textStyle.zoneNameStyleIndex() + 5];
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.zoneId:()Ljava/time/temporal/TemporalQuery;");
            TemporalQuery<ZoneId> temporalQuery = TemporalQueries.zoneId();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            ZoneId zoneId = dateTimePrintContext.getValue(temporalQuery);
            RuntimeCostAccounter.recordJump();
            if (zoneId == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getId:()Ljava/lang/String;");
            String string = zoneId.getId();
            boolean bl = zoneId instanceof ZoneOffset;
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                int n;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getTemporal:()Ljava/time/temporal/TemporalAccessor;");
                TemporalAccessor temporalAccessor = dateTimePrintContext.getTemporal();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                boolean bl2 = temporalAccessor.isSupported(ChronoField.INSTANT_SECONDS);
                RuntimeCostAccounter.recordJump();
                if (bl2) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/ZoneId.getRules:()Ljava/time/zone/ZoneRules;");
                    ZoneRules zoneRules = zoneId.getRules();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/Instant.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/Instant;");
                    Instant instant = Instant.from(temporalAccessor);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRules.isDaylightSavings:(Ljava/time/Instant;)Z");
                    boolean bl3 = zoneRules.isDaylightSavings(instant);
                    RuntimeCostAccounter.recordJump();
                    if (bl3) {
                        n = 1;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n = 0;
                        RuntimeCostAccounter.recordJump();
                    }
                } else {
                    n = 2;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getLocale:()Ljava/util/Locale;");
                Locale locale = dateTimePrintContext.getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneTextPrinterParser.getDisplayName:(Ljava/lang/String;ILjava/util/Locale;)Ljava/lang/String;");
                String string2 = this.getDisplayName(string, n, locale);
                RuntimeCostAccounter.recordJump();
                if (string2 != null) {
                    string = string2;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(string);
            return true;
        }

        @Override
        protected PrefixTree getTree(DateTimeParseContext dateTimeParseContext) {
            PrefixTree prefixTree;
            block21: {
                int n;
                String string;
                String[] stringArray;
                String[][] stringArray2;
                Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> map;
                int n2;
                Set<String> set;
                Locale locale;
                block20: {
                    Map<Locale, Map.Entry<Integer, SoftReference<PrefixTree>>> map2;
                    RuntimeCostAccounter.recordJump();
                    if (this.textStyle == TextStyle.NARROW) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ZoneIdPrinterParser.getTree:(Ljava/time/format/DateTimeParseContext;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                        return super.getTree(dateTimeParseContext);
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getLocale:()Ljava/util/Locale;");
                    locale = dateTimeParseContext.getLocale();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
                    boolean bl = dateTimeParseContext.isCaseSensitive();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/zone/ZoneRulesProvider.getAvailableZoneIds:()Ljava/util/Set;");
                    set = ZoneRulesProvider.getAvailableZoneIds();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.size:()I");
                    n2 = set.size();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        map2 = this.cachedTree;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        map2 = this.cachedTreeCI;
                    }
                    map = map2;
                    Map.Entry<Integer, SoftReference<PrefixTree>> entry = null;
                    prefixTree = null;
                    stringArray2 = null;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.get:(Ljava/lang/Object;)Ljava/lang/Object;");
                    entry = map.get(locale);
                    RuntimeCostAccounter.recordJump();
                    if (entry == null) break block20;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.intValue:()I");
                    int n3 = entry.getKey();
                    RuntimeCostAccounter.recordJump();
                    if (n3 != n2) break block20;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.get:()Ljava/lang/Object;");
                    prefixTree = entry.getValue().get();
                    RuntimeCostAccounter.recordJump();
                    if (prefixTree != null) break block21;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.newTree:(Ljava/time/format/DateTimeParseContext;)Ljava/time/format/DateTimeFormatterBuilder$PrefixTree;");
                prefixTree = PrefixTree.newTree(dateTimeParseContext);
                RuntimeCostAccounter.recordMethodCall((String)"sun/util/locale/provider/TimeZoneNameUtility.getZoneStrings:(Ljava/util/Locale;)[[Ljava/lang/String;");
                String[][] stringArray3 = stringArray2 = TimeZoneNameUtility.getZoneStrings((Locale)locale);
                int n4 = stringArray3.length;
                int n5 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n5 >= n4) break;
                    stringArray = stringArray3[n5];
                    string = stringArray[0];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
                    boolean bl = set.contains(string);
                    RuntimeCostAccounter.recordJump();
                    if (!bl) {
                        RuntimeCostAccounter.recordJump();
                    } else {
                        int n6;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.add:(Ljava/lang/String;Ljava/lang/String;)Z");
                        prefixTree.add(string, string);
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/ZoneName.toZid:(Ljava/lang/String;Ljava/util/Locale;)Ljava/lang/String;");
                        string = ZoneName.toZid(string, locale);
                        RuntimeCostAccounter.recordJump();
                        if (this.textStyle == TextStyle.FULL) {
                            n6 = 1;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            n6 = 2;
                        }
                        n = n6;
                        while (true) {
                            int n7 = stringArray.length;
                            RuntimeCostAccounter.recordJump();
                            if (n >= n7) break;
                            String string2 = stringArray[n];
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.add:(Ljava/lang/String;Ljava/lang/String;)Z");
                            prefixTree.add(string2, string);
                            n += 2;
                            RuntimeCostAccounter.recordJump();
                        }
                    }
                    ++n5;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (this.preferredZones != null) {
                    stringArray3 = stringArray2;
                    n4 = stringArray3.length;
                    n5 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n5 >= n4) break;
                        stringArray = stringArray3[n5];
                        string = stringArray[0];
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
                        boolean bl = this.preferredZones.contains(string);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Set.contains:(Ljava/lang/Object;)Z");
                            boolean bl2 = set.contains(string);
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) {
                                RuntimeCostAccounter.recordJump();
                            } else {
                                int n8;
                                RuntimeCostAccounter.recordJump();
                                if (this.textStyle == TextStyle.FULL) {
                                    n8 = 1;
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    n8 = 2;
                                }
                                n = n8;
                                while (true) {
                                    int n9 = stringArray.length;
                                    RuntimeCostAccounter.recordJump();
                                    if (n >= n9) break;
                                    String string3 = stringArray[n];
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$PrefixTree.add:(Ljava/lang/String;Ljava/lang/String;)Z");
                                    prefixTree.add(string3, string);
                                    n += 2;
                                    RuntimeCostAccounter.recordJump();
                                }
                            }
                        }
                        ++n5;
                        RuntimeCostAccounter.recordJump();
                    }
                }
                RuntimeCostAccounter.recordAllocation((String)"java/util/AbstractMap$SimpleImmutableEntry");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                Integer n10 = n2;
                RuntimeCostAccounter.recordAllocation((String)"java/lang/ref/SoftReference");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/ref/SoftReference.<init>:(Ljava/lang/Object;)V");
                SoftReference<PrefixTree> softReference = new SoftReference<PrefixTree>(prefixTree);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/AbstractMap$SimpleImmutableEntry.<init>:(Ljava/lang/Object;Ljava/lang/Object;)V");
                AbstractMap.SimpleImmutableEntry<Integer, SoftReference<PrefixTree>> simpleImmutableEntry = new AbstractMap.SimpleImmutableEntry<Integer, SoftReference<PrefixTree>>(n10, softReference);
                RuntimeCostAccounter.recordMethodCall((String)"java/util/Map.put:(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
                map.put(locale, simpleImmutableEntry);
            }
            return prefixTree;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/util/concurrent/ConcurrentHashMap");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/concurrent/ConcurrentHashMap.<init>:()V");
            cache = new ConcurrentHashMap<String, SoftReference<Map<Locale, String[]>>>();
        }
    }

    static final class LocalizedOffsetIdPrinterParser
    implements DateTimePrinterParser {
        private final TextStyle style;

        LocalizedOffsetIdPrinterParser(TextStyle textStyle) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.style = textStyle;
        }

        private static StringBuilder appendHMS(StringBuilder stringBuilder, int n) {
            char c = (char)(n / 10 + 48);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append(c);
            char c2 = (char)(n % 10 + 48);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            return stringBuilder2.append(c2);
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            block11: {
                int n;
                int n2;
                block13: {
                    int n3;
                    block12: {
                        String string;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
                        Long l = dateTimePrintContext.getValue(ChronoField.OFFSET_SECONDS);
                        RuntimeCostAccounter.recordJump();
                        if (l == null) {
                            return false;
                        }
                        String string2 = "GMT";
                        RuntimeCostAccounter.recordJump();
                        if (string2 != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            stringBuilder.append(string2);
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l2 = l;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                        int n4 = Math.toIntExact(l2);
                        RuntimeCostAccounter.recordJump();
                        if (n4 == 0) break block11;
                        int n5 = n4 / 3600 % 100;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                        n3 = Math.abs(n5);
                        int n6 = n4 / 60 % 60;
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                        n2 = Math.abs(n6);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                        n = Math.abs(n4 % 60);
                        RuntimeCostAccounter.recordJump();
                        if (n4 < 0) {
                            string = "-";
                            RuntimeCostAccounter.recordJump();
                        } else {
                            string = "+";
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        stringBuilder.append(string);
                        RuntimeCostAccounter.recordJump();
                        if (this.style != TextStyle.FULL) break block12;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.appendHMS:(Ljava/lang/StringBuilder;I)Ljava/lang/StringBuilder;");
                        LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(':');
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.appendHMS:(Ljava/lang/StringBuilder;I)Ljava/lang/StringBuilder;");
                        LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n2);
                        RuntimeCostAccounter.recordJump();
                        if (n != 0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                            stringBuilder.append(':');
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.appendHMS:(Ljava/lang/StringBuilder;I)Ljava/lang/StringBuilder;");
                            LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n);
                            RuntimeCostAccounter.recordJump();
                        }
                        break block11;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= 10) {
                        char c = (char)(n3 / 10 + 48);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                    }
                    char c = (char)(n3 % 10 + 48);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(c);
                    RuntimeCostAccounter.recordJump();
                    if (n2 != 0) break block13;
                    RuntimeCostAccounter.recordJump();
                    if (n == 0) break block11;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(':');
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.appendHMS:(Ljava/lang/StringBuilder;I)Ljava/lang/StringBuilder;");
                LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n2);
                RuntimeCostAccounter.recordJump();
                if (n != 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(':');
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.appendHMS:(Ljava/lang/StringBuilder;I)Ljava/lang/StringBuilder;");
                    LocalizedOffsetIdPrinterParser.appendHMS(stringBuilder, n);
                }
            }
            return true;
        }

        int getDigit(CharSequence charSequence, int n) {
            char c;
            block3: {
                block2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    c = charSequence.charAt(n);
                    RuntimeCostAccounter.recordJump();
                    if (c < '0') break block2;
                    RuntimeCostAccounter.recordJump();
                    if (c <= '9') break block3;
                }
                return -1;
            }
            return c - 48;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            block35: {
                int n7;
                block30: {
                    int n8;
                    int n9;
                    block34: {
                        block33: {
                            int n10;
                            int n11;
                            block32: {
                                block31: {
                                    n6 = n;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                                    n7 = n6 + charSequence.length();
                                    String string = "GMT";
                                    RuntimeCostAccounter.recordJump();
                                    if (string != null) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                        int n12 = string.length();
                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.subSequenceEquals:(Ljava/lang/CharSequence;ILjava/lang/CharSequence;II)Z");
                                        boolean bl = dateTimeParseContext.subSequenceEquals(charSequence, n6, string, 0, n12);
                                        RuntimeCostAccounter.recordJump();
                                        if (!bl) {
                                            return ~n;
                                        }
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                                        n6 += string.length();
                                    }
                                    n5 = 0;
                                    RuntimeCostAccounter.recordJump();
                                    if (n6 == n7) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                                        return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n6);
                                    }
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                                    char c = charSequence.charAt(n6);
                                    RuntimeCostAccounter.recordJump();
                                    if (c == '+') {
                                        n5 = 1;
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordJump();
                                        if (c == '-') {
                                            n5 = -1;
                                            RuntimeCostAccounter.recordJump();
                                        } else {
                                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                                            return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, 0L, n, n6);
                                        }
                                    }
                                    ++n6;
                                    n4 = 0;
                                    n3 = 0;
                                    n2 = 0;
                                    RuntimeCostAccounter.recordJump();
                                    if (this.style != TextStyle.FULL) break block30;
                                    int n13 = n6++;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                                    n11 = this.getDigit(charSequence, n13);
                                    int n14 = n6++;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                                    n10 = this.getDigit(charSequence, n14);
                                    RuntimeCostAccounter.recordJump();
                                    if (n11 < 0) break block31;
                                    RuntimeCostAccounter.recordJump();
                                    if (n10 < 0) break block31;
                                    int n15 = n6++;
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                                    char c2 = charSequence.charAt(n15);
                                    RuntimeCostAccounter.recordJump();
                                    if (c2 == ':') break block32;
                                }
                                return ~n;
                            }
                            n4 = n11 * 10 + n10;
                            int n16 = n6++;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                            n9 = this.getDigit(charSequence, n16);
                            int n17 = n6++;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                            n8 = this.getDigit(charSequence, n17);
                            RuntimeCostAccounter.recordJump();
                            if (n9 < 0) break block33;
                            RuntimeCostAccounter.recordJump();
                            if (n8 >= 0) break block34;
                        }
                        return ~n;
                    }
                    n3 = n9 * 10 + n8;
                    RuntimeCostAccounter.recordJump();
                    if (n6 + 2 < n7) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c = charSequence.charAt(n6);
                        RuntimeCostAccounter.recordJump();
                        if (c == ':') {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                            int n18 = this.getDigit(charSequence, n6 + 1);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                            int n19 = this.getDigit(charSequence, n6 + 2);
                            RuntimeCostAccounter.recordJump();
                            if (n18 >= 0) {
                                RuntimeCostAccounter.recordJump();
                                if (n19 >= 0) {
                                    n2 = n18 * 10 + n19;
                                    n6 += 3;
                                }
                            }
                        }
                    }
                    RuntimeCostAccounter.recordJump();
                    break block35;
                }
                int n20 = n6++;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                n4 = this.getDigit(charSequence, n20);
                RuntimeCostAccounter.recordJump();
                if (n4 < 0) {
                    return ~n;
                }
                RuntimeCostAccounter.recordJump();
                if (n6 < n7) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                    int n21 = this.getDigit(charSequence, n6);
                    RuntimeCostAccounter.recordJump();
                    if (n21 >= 0) {
                        n4 = n4 * 10 + n21;
                        ++n6;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n6 + 2 < n7) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                        char c = charSequence.charAt(n6);
                        RuntimeCostAccounter.recordJump();
                        if (c == ':') {
                            RuntimeCostAccounter.recordJump();
                            if (n6 + 2 < n7) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                                char c3 = charSequence.charAt(n6);
                                RuntimeCostAccounter.recordJump();
                                if (c3 == ':') {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                                    int n22 = this.getDigit(charSequence, n6 + 1);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                                    int n23 = this.getDigit(charSequence, n6 + 2);
                                    RuntimeCostAccounter.recordJump();
                                    if (n22 >= 0) {
                                        RuntimeCostAccounter.recordJump();
                                        if (n23 >= 0) {
                                            n3 = n22 * 10 + n23;
                                            RuntimeCostAccounter.recordJump();
                                            if ((n6 += 3) + 2 < n7) {
                                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                                                char c4 = charSequence.charAt(n6);
                                                RuntimeCostAccounter.recordJump();
                                                if (c4 == ':') {
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                                                    int n24 = this.getDigit(charSequence, n6 + 1);
                                                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$LocalizedOffsetIdPrinterParser.getDigit:(Ljava/lang/CharSequence;I)I");
                                                    int n25 = this.getDigit(charSequence, n6 + 2);
                                                    RuntimeCostAccounter.recordJump();
                                                    if (n24 >= 0) {
                                                        RuntimeCostAccounter.recordJump();
                                                        if (n25 >= 0) {
                                                            n2 = n24 * 10 + n25;
                                                            n6 += 3;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            long l = (long)n5 * ((long)n4 * 3600L + (long)n3 * 60L + (long)n2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
            return dateTimeParseContext.setParsedField(ChronoField.OFFSET_SECONDS, l, n, n6);
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("LocalizedOffset(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append((Object)this.style);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }

    static final class OffsetIdPrinterParser
    implements DateTimePrinterParser {
        static final String[] PATTERNS;
        static final OffsetIdPrinterParser INSTANCE_ID_Z;
        static final OffsetIdPrinterParser INSTANCE_ID_ZERO;
        private final String noOffsetText;
        private final int type;

        OffsetIdPrinterParser(String string, String string2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(string, "pattern");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
            Objects.requireNonNull(string2, "noOffsetText");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.checkPattern:(Ljava/lang/String;)I");
            this.type = this.checkPattern(string);
            this.noOffsetText = string2;
        }

        private int checkPattern(String string) {
            int n = 0;
            while (true) {
                int n2 = PATTERNS.length;
                RuntimeCostAccounter.recordJump();
                if (n >= n2) break;
                String string2 = PATTERNS[n];
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.equals:(Ljava/lang/Object;)Z");
                boolean bl = string2.equals(string);
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return n;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Invalid zone offset pattern: ");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            String string3 = stringBuilder3.toString();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string3);
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            block12: {
                int n;
                int n2;
                block14: {
                    String string;
                    int n3;
                    block15: {
                        String string2;
                        int n4;
                        block13: {
                            String string3;
                            int n5;
                            block11: {
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
                                Long l = dateTimePrintContext.getValue(ChronoField.OFFSET_SECONDS);
                                RuntimeCostAccounter.recordJump();
                                if (l == null) {
                                    return false;
                                }
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                                long l2 = l;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.toIntExact:(J)I");
                                n5 = Math.toIntExact(l2);
                                RuntimeCostAccounter.recordJump();
                                if (n5 != 0) break block11;
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                stringBuilder.append(this.noOffsetText);
                                RuntimeCostAccounter.recordJump();
                                break block12;
                            }
                            int n6 = n5 / 3600 % 100;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                            int n7 = Math.abs(n6);
                            int n8 = n5 / 60 % 60;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                            n4 = Math.abs(n8);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(I)I");
                            n3 = Math.abs(n5 % 60);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                            n2 = stringBuilder.length();
                            n = n7;
                            RuntimeCostAccounter.recordJump();
                            if (n5 < 0) {
                                string3 = "-";
                                RuntimeCostAccounter.recordJump();
                            } else {
                                string3 = "+";
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder2 = stringBuilder.append(string3);
                            char c = (char)(n7 / 10 + 48);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                            StringBuilder stringBuilder3 = stringBuilder2.append(c);
                            char c2 = (char)(n7 % 10 + 48);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                            stringBuilder3.append(c2);
                            RuntimeCostAccounter.recordJump();
                            if (this.type >= 3) break block13;
                            RuntimeCostAccounter.recordJump();
                            if (this.type < 1) break block14;
                            RuntimeCostAccounter.recordJump();
                            if (n4 <= 0) break block14;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.type % 2 == 0) {
                            string2 = ":";
                            RuntimeCostAccounter.recordJump();
                        } else {
                            string2 = "";
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append(string2);
                        char c = (char)(n4 / 10 + 48);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(c);
                        char c3 = (char)(n4 % 10 + 48);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder5.append(c3);
                        n += n4;
                        RuntimeCostAccounter.recordJump();
                        if (this.type >= 7) break block15;
                        RuntimeCostAccounter.recordJump();
                        if (this.type < 5) break block14;
                        RuntimeCostAccounter.recordJump();
                        if (n3 <= 0) break block14;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.type % 2 == 0) {
                        string = ":";
                        RuntimeCostAccounter.recordJump();
                    } else {
                        string = "";
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder.append(string);
                    char c = (char)(n3 / 10 + 48);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(c);
                    char c4 = (char)(n3 % 10 + 48);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder7.append(c4);
                    n += n3;
                }
                RuntimeCostAccounter.recordJump();
                if (n == 0) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.setLength:(I)V");
                    stringBuilder.setLength(n2);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    stringBuilder.append(this.noOffsetText);
                }
            }
            return true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int parse(DateTimeParseContext var1_1, CharSequence var2_2, int var3_3) {
            block14: {
                block13: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    var4_4 = var2_2.length();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    var5_5 = this.noOffsetText.length();
                    RuntimeCostAccounter.recordJump();
                    if (var5_5 == 0) {
                        RuntimeCostAccounter.recordJump();
                        if (var3_3 == var4_4) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                            return var1_1.setParsedField(ChronoField.OFFSET_SECONDS, 0L, var3_3, var3_3);
                        }
                    } else {
                        RuntimeCostAccounter.recordJump();
                        if (var3_3 == var4_4) {
                            return ~var3_3;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.subSequenceEquals:(Ljava/lang/CharSequence;ILjava/lang/CharSequence;II)Z");
                        v0 = var1_1.subSequenceEquals(var2_2, var3_3, this.noOffsetText, 0, var5_5);
                        RuntimeCostAccounter.recordJump();
                        if (v0) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                            return var1_1.setParsedField(ChronoField.OFFSET_SECONDS, 0L, var3_3, var3_3 + var5_5);
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    var6_6 = var2_2.charAt(var3_3);
                    RuntimeCostAccounter.recordJump();
                    if (var6_6 == '+') break block13;
                    RuntimeCostAccounter.recordJump();
                    if (var6_6 != '-') break block14;
                }
                RuntimeCostAccounter.recordJump();
                if (var6_6 == '-') {
                    v1 = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v1 = 1;
                }
                var7_7 = v1;
                RuntimeCostAccounter.recordArrayAllocation((int)4, (int)4);
                var8_8 = new int[4];
                var8_8[0] = var3_3 + 1;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.parseNumber:([IILjava/lang/CharSequence;Z)Z");
                v2 = this.parseNumber(var8_8, 1, var2_2, true);
                RuntimeCostAccounter.recordJump();
                if (v2) ** GOTO lbl-1000
                RuntimeCostAccounter.recordJump();
                if (this.type >= 3) {
                    v3 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v3 = false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.parseNumber:([IILjava/lang/CharSequence;Z)Z");
                v4 = this.parseNumber(var8_8, 2, var2_2, v3);
                RuntimeCostAccounter.recordJump();
                if (v4) ** GOTO lbl-1000
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.parseNumber:([IILjava/lang/CharSequence;Z)Z");
                v5 = this.parseNumber(var8_8, 3, var2_2, false);
                RuntimeCostAccounter.recordJump();
                if (v5) lbl-1000:
                // 3 sources

                {
                    v6 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v6 = false;
                }
                RuntimeCostAccounter.recordJump();
                if (!v6) {
                    var9_9 = (long)var7_7 * ((long)var8_8[1] * 3600L + (long)var8_8[2] * 60L + (long)var8_8[3]);
                    v7 = var8_8[0];
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                    return var1_1.setParsedField(ChronoField.OFFSET_SECONDS, var9_9, var3_3, v7);
                }
            }
            RuntimeCostAccounter.recordJump();
            if (var5_5 == 0) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                return var1_1.setParsedField(ChronoField.OFFSET_SECONDS, 0L, var3_3, var3_3 + var5_5);
            }
            return ~var3_3;
        }

        private boolean parseNumber(int[] nArray, int n, CharSequence charSequence, boolean bl) {
            int n2;
            int n3;
            block17: {
                block16: {
                    char c;
                    char c2;
                    block15: {
                        block14: {
                            block11: {
                                block13: {
                                    block12: {
                                        int n4 = (this.type + 3) / 2;
                                        RuntimeCostAccounter.recordJump();
                                        if (n4 < n) {
                                            return false;
                                        }
                                        n3 = nArray[0];
                                        RuntimeCostAccounter.recordJump();
                                        if (this.type % 2 != 0) break block11;
                                        RuntimeCostAccounter.recordJump();
                                        if (n <= 1) break block11;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                                        int n5 = charSequence.length();
                                        RuntimeCostAccounter.recordJump();
                                        if (n3 + 1 > n5) break block12;
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                                        char c3 = charSequence.charAt(n3);
                                        RuntimeCostAccounter.recordJump();
                                        if (c3 == ':') break block13;
                                    }
                                    return bl;
                                }
                                ++n3;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                            int n6 = charSequence.length();
                            RuntimeCostAccounter.recordJump();
                            if (n3 + 2 > n6) {
                                return bl;
                            }
                            int n7 = n3++;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                            c2 = charSequence.charAt(n7);
                            int n8 = n3++;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                            c = charSequence.charAt(n8);
                            RuntimeCostAccounter.recordJump();
                            if (c2 < '0') break block14;
                            RuntimeCostAccounter.recordJump();
                            if (c2 > '9') break block14;
                            RuntimeCostAccounter.recordJump();
                            if (c < '0') break block14;
                            RuntimeCostAccounter.recordJump();
                            if (c <= '9') break block15;
                        }
                        return bl;
                    }
                    n2 = (c2 - 48) * 10 + (c - 48);
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) break block16;
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= 59) break block17;
                }
                return bl;
            }
            nArray[n] = n2;
            nArray[0] = n3;
            return false;
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;");
            String string = this.noOffsetText.replace("'", "''");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Offset(");
            String string2 = PATTERNS[this.type];
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",'");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append("')");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder6.toString();
        }

        static {
            RuntimeCostAccounter.recordArrayAllocation((int)9, (int)8);
            PATTERNS = new String[]{"+HH", "+HHmm", "+HH:mm", "+HHMM", "+HH:MM", "+HHMMss", "+HH:MM:ss", "+HHMMSS", "+HH:MM:SS"};
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
            INSTANCE_ID_Z = new OffsetIdPrinterParser("+HH:MM:ss", "Z");
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$OffsetIdPrinterParser.<init>:(Ljava/lang/String;Ljava/lang/String;)V");
            INSTANCE_ID_ZERO = new OffsetIdPrinterParser("+HH:MM:ss", "0");
        }
    }

    static final class InstantPrinterParser
    implements DateTimePrinterParser {
        private static final long SECONDS_PER_10000_YEARS = 315569520000L;
        private static final long SECONDS_0000_TO_1970 = 62167219200L;
        private final int fractionalDigits;

        InstantPrinterParser(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.fractionalDigits = n;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            block20: {
                int n;
                block19: {
                    block18: {
                        LocalDateTime localDateTime;
                        long l;
                        long l2;
                        long l3;
                        long l4;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
                        Long l5 = dateTimePrintContext.getValue(ChronoField.INSTANT_SECONDS);
                        Long l6 = null;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getTemporal:()Ljava/time/temporal/TemporalAccessor;");
                        TemporalAccessor temporalAccessor = dateTimePrintContext.getTemporal();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.isSupported:(Ljava/time/temporal/TemporalField;)Z");
                        boolean bl = temporalAccessor.isSupported(ChronoField.NANO_OF_SECOND);
                        RuntimeCostAccounter.recordJump();
                        if (bl) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getTemporal:()Ljava/time/temporal/TemporalAccessor;");
                            TemporalAccessor temporalAccessor2 = dateTimePrintContext.getTemporal();
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.getLong:(Ljava/time/temporal/TemporalField;)J");
                            long l7 = temporalAccessor2.getLong(ChronoField.NANO_OF_SECOND);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.valueOf:(J)Ljava/lang/Long;");
                            l6 = l7;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (l5 == null) {
                            return false;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        long l8 = l5;
                        RuntimeCostAccounter.recordJump();
                        if (l6 != null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                            l4 = l6;
                            RuntimeCostAccounter.recordJump();
                        } else {
                            l4 = 0L;
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ChronoField.checkValidIntValue:(J)I");
                        n = ChronoField.NANO_OF_SECOND.checkValidIntValue(l4);
                        RuntimeCostAccounter.recordJump();
                        if (l8 >= -62167219200L) {
                            l3 = l8 - 315569520000L + 62167219200L;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorDiv:(JJ)J");
                            l2 = Math.floorDiv(l3, 315569520000L) + 1L;
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.floorMod:(JJ)J");
                            l = Math.floorMod(l3, 315569520000L);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
                            localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, 0, ZoneOffset.UTC);
                            RuntimeCostAccounter.recordJump();
                            if (l2 > 0L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder2 = stringBuilder.append('+');
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                                stringBuilder2.append(l2);
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                            stringBuilder.append(localDateTime);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getSecond:()I");
                            int n2 = localDateTime.getSecond();
                            RuntimeCostAccounter.recordJump();
                            if (n2 == 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                stringBuilder.append(":00");
                            }
                            RuntimeCostAccounter.recordJump();
                        } else {
                            l3 = l8 + 62167219200L;
                            l2 = l3 / 315569520000L;
                            l = l3 % 315569520000L;
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.ofEpochSecond:(JILjava/time/ZoneOffset;)Ljava/time/LocalDateTime;");
                            localDateTime = LocalDateTime.ofEpochSecond(l - 62167219200L, 0, ZoneOffset.UTC);
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
                            int n3 = stringBuilder.length();
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                            stringBuilder.append(localDateTime);
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getSecond:()I");
                            int n4 = localDateTime.getSecond();
                            RuntimeCostAccounter.recordJump();
                            if (n4 == 0) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                stringBuilder.append(":00");
                            }
                            RuntimeCostAccounter.recordJump();
                            if (l2 < 0L) {
                                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.getYear:()I");
                                int n5 = localDateTime.getYear();
                                RuntimeCostAccounter.recordJump();
                                if (n5 == -10000) {
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
                                    String string = Long.toString(l2 - 1L);
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.replace:(IILjava/lang/String;)Ljava/lang/StringBuilder;");
                                    stringBuilder.replace(n3, n3 + 2, string);
                                    RuntimeCostAccounter.recordJump();
                                } else {
                                    RuntimeCostAccounter.recordJump();
                                    if (l == 0L) {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.insert:(IJ)Ljava/lang/StringBuilder;");
                                        stringBuilder.insert(n3, l2);
                                        RuntimeCostAccounter.recordJump();
                                    } else {
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
                                        long l9 = Math.abs(l2);
                                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.insert:(IJ)Ljava/lang/StringBuilder;");
                                        stringBuilder.insert(n3 + 1, l9);
                                    }
                                }
                            }
                        }
                        RuntimeCostAccounter.recordJump();
                        if (this.fractionalDigits >= 0) break block18;
                        RuntimeCostAccounter.recordJump();
                        if (n > 0) break block19;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (this.fractionalDigits <= 0) break block20;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append('.');
                int n6 = 100000000;
                int n7 = 0;
                while (true) {
                    block22: {
                        block23: {
                            block21: {
                                RuntimeCostAccounter.recordJump();
                                if (this.fractionalDigits != -1) break block21;
                                RuntimeCostAccounter.recordJump();
                                if (n > 0) break block22;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (this.fractionalDigits != -2) break block23;
                            RuntimeCostAccounter.recordJump();
                            if (n > 0) break block22;
                            RuntimeCostAccounter.recordJump();
                            if (n7 % 3 != 0) break block22;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n7 >= this.fractionalDigits) break;
                    }
                    int n8 = n / n6;
                    char c = (char)(n8 + 48);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(c);
                    n -= n8 * n6;
                    n6 /= 10;
                    ++n7;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append('Z');
            return true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int parse(DateTimeParseContext var1_1, CharSequence var2_2, int var3_3) {
            RuntimeCostAccounter.recordJump();
            if (this.fractionalDigits < 0) {
                v0 = 0;
                RuntimeCostAccounter.recordJump();
            } else {
                v0 = this.fractionalDigits;
            }
            var4_4 = v0;
            RuntimeCostAccounter.recordJump();
            if (this.fractionalDigits < 0) {
                v1 = 9;
                RuntimeCostAccounter.recordJump();
            } else {
                v1 = this.fractionalDigits;
            }
            var5_5 = v1;
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.<init>:()V");
            v2 = new DateTimeFormatterBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.append:(Ljava/time/format/DateTimeFormatter;)Ljava/time/format/DateTimeFormatterBuilder;");
            v3 = v2.append(DateTimeFormatter.ISO_LOCAL_DATE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
            v4 = v3.appendLiteral('T');
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
            v5 = v4.appendValue(ChronoField.HOUR_OF_DAY, 2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
            v6 = v5.appendLiteral(':');
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
            v7 = v6.appendValue(ChronoField.MINUTE_OF_HOUR, 2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
            v8 = v7.appendLiteral(':');
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendValue:(Ljava/time/temporal/TemporalField;I)Ljava/time/format/DateTimeFormatterBuilder;");
            v9 = v8.appendValue(ChronoField.SECOND_OF_MINUTE, 2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendFraction:(Ljava/time/temporal/TemporalField;IIZ)Ljava/time/format/DateTimeFormatterBuilder;");
            v10 = v9.appendFraction(ChronoField.NANO_OF_SECOND, var4_4, var5_5, true);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.appendLiteral:(C)Ljava/time/format/DateTimeFormatterBuilder;");
            v11 = v10.appendLiteral('Z');
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder.toFormatter:()Ljava/time/format/DateTimeFormatter;");
            v12 = v11.toFormatter();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatter.toPrinterParser:(Z)Ljava/time/format/DateTimeFormatterBuilder$CompositePrinterParser;");
            var6_6 = v12.toPrinterParser(false);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.copy:()Ljava/time/format/DateTimeParseContext;");
            var7_7 = var1_1.copy();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
            var8_8 = var6_6.parse(var7_7, var2_2, var3_3);
            RuntimeCostAccounter.recordJump();
            if (var8_8 < 0) {
                return var8_8;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            v13 = var7_7.getParsed(ChronoField.YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            var9_9 = v13;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            v14 = var7_7.getParsed(ChronoField.MONTH_OF_YEAR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
            var11_10 = v14.intValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            v15 = var7_7.getParsed(ChronoField.DAY_OF_MONTH);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
            var12_11 = v15.intValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            v16 = var7_7.getParsed(ChronoField.HOUR_OF_DAY);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
            var13_12 = v16.intValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            v17 = var7_7.getParsed(ChronoField.MINUTE_OF_HOUR);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
            var14_13 = v17.intValue();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            var15_14 = var7_7.getParsed(ChronoField.SECOND_OF_MINUTE);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            var16_15 = var7_7.getParsed(ChronoField.NANO_OF_SECOND);
            RuntimeCostAccounter.recordJump();
            if (var15_14 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
                v18 = var15_14.intValue();
                RuntimeCostAccounter.recordJump();
            } else {
                v18 = 0;
            }
            var17_16 = v18;
            RuntimeCostAccounter.recordJump();
            if (var16_15 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.intValue:()I");
                v19 = var16_15.intValue();
                RuntimeCostAccounter.recordJump();
            } else {
                v19 = 0;
            }
            var18_17 = v19;
            var19_18 = 0;
            RuntimeCostAccounter.recordJump();
            if (var13_12 != 24) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var14_13 != 0) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var17_16 != 0) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var18_17 == 0) {
                var13_12 = 0;
                var19_18 = 1;
                RuntimeCostAccounter.recordJump();
            } else lbl-1000:
            // 4 sources

            {
                RuntimeCostAccounter.recordJump();
                if (var13_12 == 23) {
                    RuntimeCostAccounter.recordJump();
                    if (var14_13 == 59) {
                        RuntimeCostAccounter.recordJump();
                        if (var17_16 == 60) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedLeapSecond:()V");
                            var1_1.setParsedLeapSecond();
                            var17_16 = 59;
                        }
                    }
                }
            }
            var20_19 = (int)var9_9 % 10000;
            try {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.of:(IIIIIII)Ljava/time/LocalDateTime;");
                v20 = LocalDateTime.of(var20_19, var11_10, var12_11, var13_12, var14_13, var17_16, 0);
                v21 = var19_18;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.plusDays:(J)Ljava/time/LocalDateTime;");
                var21_20 = v20.plusDays(v21);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDateTime.toEpochSecond:(Ljava/time/ZoneOffset;)J");
                var22_23 = var21_20.toEpochSecond(ZoneOffset.UTC);
                v22 = var9_9 / 10000L;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.multiplyExact:(JJ)J");
            }
            catch (RuntimeException var21_21) {
                return ~var3_3;
            }
            RuntimeCostAccounter.recordJump();
            var21_22 = var8_8;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
            var21_22 = var1_1.setParsedField(ChronoField.INSTANT_SECONDS, var22_23 += Math.multiplyExact(v22, 315569520000L), var3_3, var21_22);
            v23 = var18_17;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
            return var1_1.setParsedField(ChronoField.NANO_OF_SECOND, v23, var3_3, var21_22);
        }

        public String toString() {
            return "Instant()";
        }
    }

    static final class TextPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final TextStyle textStyle;
        private final DateTimeTextProvider provider;
        private volatile NumberPrinterParser numberPrinterParser;

        TextPrinterParser(TemporalField temporalField, TextStyle textStyle, DateTimeTextProvider dateTimeTextProvider) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.field = temporalField;
            this.textStyle = textStyle;
            this.provider = dateTimeTextProvider;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean format(DateTimePrintContext var1_1, StringBuilder var2_2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            var3_3 = var1_1.getValue(this.field);
            RuntimeCostAccounter.recordJump();
            if (var3_3 == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getTemporal:()Ljava/time/temporal/TemporalAccessor;");
            v0 = var1_1.getTemporal();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalQueries.chronology:()Ljava/time/temporal/TemporalQuery;");
            v1 = TemporalQueries.chronology();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalAccessor.query:(Ljava/time/temporal/TemporalQuery;)Ljava/lang/Object;");
            var4_4 = v0.query(v1);
            RuntimeCostAccounter.recordJump();
            if (var4_4 == null) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var4_4 == IsoChronology.INSTANCE) lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                v2 = var3_3;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getLocale:()Ljava/util/Locale;");
                v3 = var1_1.getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getText:(Ljava/time/temporal/TemporalField;JLjava/time/format/TextStyle;Ljava/util/Locale;)Ljava/lang/String;");
                var5_5 = this.provider.getText(this.field, v2, this.textStyle, v3);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                v4 = var3_3;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getLocale:()Ljava/util/Locale;");
                v5 = var1_1.getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getText:(Ljava/time/chrono/Chronology;Ljava/time/temporal/TemporalField;JLjava/time/format/TextStyle;Ljava/util/Locale;)Ljava/lang/String;");
                var5_5 = this.provider.getText(var4_4, this.field, v4, this.textStyle, v5);
            }
            RuntimeCostAccounter.recordJump();
            if (var5_5 == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$TextPrinterParser.numberPrinterParser:()Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;");
                v6 = this.numberPrinterParser();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
                return v6.format(var1_1, var2_2);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            var2_2.append(var5_5);
            return true;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int parse(DateTimeParseContext var1_1, CharSequence var2_2, int var3_3) {
            block12: {
                block11: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    var4_4 = var2_2.length();
                    RuntimeCostAccounter.recordJump();
                    if (var3_3 < 0) break block11;
                    RuntimeCostAccounter.recordJump();
                    if (var3_3 <= var4_4) break block12;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                v0 = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw v0;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            v1 = var1_1.isStrict();
            RuntimeCostAccounter.recordJump();
            if (v1) {
                v2 = this.textStyle;
                RuntimeCostAccounter.recordJump();
            } else {
                v2 = null;
            }
            var5_5 = v2;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getEffectiveChronology:()Ljava/time/chrono/Chronology;");
            var6_6 = var1_1.getEffectiveChronology();
            RuntimeCostAccounter.recordJump();
            if (var6_6 == null) ** GOTO lbl-1000
            RuntimeCostAccounter.recordJump();
            if (var6_6 == IsoChronology.INSTANCE) lbl-1000:
            // 2 sources

            {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getLocale:()Ljava/util/Locale;");
                v3 = var1_1.getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getTextIterator:(Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;Ljava/util/Locale;)Ljava/util/Iterator;");
                var7_7 = this.provider.getTextIterator(this.field, var5_5, v3);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getLocale:()Ljava/util/Locale;");
                v4 = var1_1.getLocale();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeTextProvider.getTextIterator:(Ljava/time/chrono/Chronology;Ljava/time/temporal/TemporalField;Ljava/time/format/TextStyle;Ljava/util/Locale;)Ljava/util/Iterator;");
                var7_7 = this.provider.getTextIterator(var6_6, this.field, var5_5, v4);
            }
            RuntimeCostAccounter.recordJump();
            if (var7_7 != null) {
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    v5 = var7_7.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!v5) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    var8_8 = var7_7.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getKey:()Ljava/lang/Object;");
                    var9_9 = var8_8.getKey();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                    v6 = var9_9.length();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.subSequenceEquals:(Ljava/lang/CharSequence;ILjava/lang/CharSequence;II)Z");
                    v7 = var1_1.subSequenceEquals(var9_9, 0, var2_2, var3_3, v6);
                    RuntimeCostAccounter.recordJump();
                    if (v7) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/util/Map$Entry.getValue:()Ljava/lang/Object;");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
                        v8 = var8_8.getValue();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                        v9 = var3_3 + var9_9.length();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                        return var1_1.setParsedField(this.field, v8, var3_3, v9);
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                v10 = var1_1.isStrict();
                RuntimeCostAccounter.recordJump();
                if (v10) {
                    return ~var3_3;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$TextPrinterParser.numberPrinterParser:()Ljava/time/format/DateTimeFormatterBuilder$NumberPrinterParser;");
            v11 = this.numberPrinterParser();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
            return v11.parse(var1_1, var2_2, var3_3);
        }

        private NumberPrinterParser numberPrinterParser() {
            RuntimeCostAccounter.recordJump();
            if (this.numberPrinterParser == null) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;)V");
                this.numberPrinterParser = new NumberPrinterParser(this.field, 1, 19, SignStyle.NORMAL);
            }
            return this.numberPrinterParser;
        }

        public String toString() {
            RuntimeCostAccounter.recordJump();
            if (this.textStyle == TextStyle.FULL) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder2 = stringBuilder.append("Text(");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append(this.field);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(")");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                return stringBuilder4.toString();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder.append("Text(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(this.field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append((Object)this.textStyle);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder9.toString();
        }
    }

    static final class FractionPrinterParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final int minWidth;
        private final int maxWidth;
        private final boolean decimalPoint;

        FractionPrinterParser(TemporalField temporalField, int n, int n2, boolean bl) {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
                            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;Ljava/lang/String;)Ljava/lang/Object;");
                            Objects.requireNonNull(temporalField, "field");
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                            ValueRange valueRange = temporalField.range();
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isFixed:()Z");
                            boolean bl2 = valueRange.isFixed();
                            RuntimeCostAccounter.recordJump();
                            if (!bl2) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                                StringBuilder stringBuilder = new StringBuilder();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder2 = stringBuilder.append("Field must have a fixed set of values: ");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                                StringBuilder stringBuilder3 = stringBuilder2.append(temporalField);
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                                String string = stringBuilder3.toString();
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                                RuntimeCostAccounter.recordThrow();
                                throw illegalArgumentException;
                            }
                            RuntimeCostAccounter.recordJump();
                            if (n < 0) break block8;
                            RuntimeCostAccounter.recordJump();
                            if (n <= 9) break block9;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder.append("Minimum width must be from 0 to 9 inclusive but was ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder5 = stringBuilder4.append(n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder5.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw illegalArgumentException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 1) break block10;
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= 9) break block11;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder.append("Maximum width must be from 1 to 9 inclusive but was ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder7.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder.append("Maximum width must exceed or equal the minimum width but ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder10 = stringBuilder9.append(" < ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder11 = stringBuilder10.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder11.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            this.field = temporalField;
            this.minWidth = n;
            this.maxWidth = n2;
            this.decimalPoint = bl;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            Long l = dateTimePrintContext.getValue(this.field);
            RuntimeCostAccounter.recordJump();
            if (l == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
            DecimalStyle decimalStyle = dateTimePrintContext.getDecimalStyle();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$FractionPrinterParser.convertToFraction:(J)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal = this.convertToFraction(l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.scale:()I");
            int n = bigDecimal.scale();
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                RuntimeCostAccounter.recordJump();
                if (this.minWidth > 0) {
                    RuntimeCostAccounter.recordJump();
                    if (this.decimalPoint) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getDecimalSeparator:()C");
                        char c = decimalStyle.getDecimalSeparator();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                    }
                    int n2 = 0;
                    while (true) {
                        RuntimeCostAccounter.recordJump();
                        if (n2 >= this.minWidth) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getZeroDigit:()C");
                        char c = decimalStyle.getZeroDigit();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                        ++n2;
                        RuntimeCostAccounter.recordJump();
                    }
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.scale:()I");
                int n3 = bigDecimal.scale();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                int n4 = Math.max(n3, this.minWidth);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                int n5 = Math.min(n4, this.maxWidth);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.setScale:(ILjava/math/RoundingMode;)Ljava/math/BigDecimal;");
                bigDecimal = bigDecimal.setScale(n5, RoundingMode.FLOOR);
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.toPlainString:()Ljava/lang/String;");
                String string = bigDecimal.toPlainString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.substring:(I)Ljava/lang/String;");
                String string2 = string.substring(2);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.convertNumberToI18N:(Ljava/lang/String;)Ljava/lang/String;");
                string2 = decimalStyle.convertNumberToI18N(string2);
                RuntimeCostAccounter.recordJump();
                if (this.decimalPoint) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getDecimalSeparator:()C");
                    char c = decimalStyle.getDecimalSeparator();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                    stringBuilder.append(c);
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(string2);
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            int n2;
            int n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            boolean bl = dateTimeParseContext.isStrict();
            RuntimeCostAccounter.recordJump();
            if (bl) {
                n3 = this.minWidth;
                RuntimeCostAccounter.recordJump();
            } else {
                n3 = 0;
            }
            int n4 = n3;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            boolean bl2 = dateTimeParseContext.isStrict();
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                n2 = this.maxWidth;
                RuntimeCostAccounter.recordJump();
            } else {
                n2 = 9;
            }
            int n5 = n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            int n6 = charSequence.length();
            RuntimeCostAccounter.recordJump();
            if (n == n6) {
                int n7;
                RuntimeCostAccounter.recordJump();
                if (n4 > 0) {
                    n7 = ~n;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n7 = n;
                }
                return n7;
            }
            RuntimeCostAccounter.recordJump();
            if (this.decimalPoint) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c = charSequence.charAt(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
                DecimalStyle decimalStyle = dateTimeParseContext.getDecimalStyle();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getDecimalSeparator:()C");
                char c2 = decimalStyle.getDecimalSeparator();
                RuntimeCostAccounter.recordJump();
                if (c != c2) {
                    int n8;
                    RuntimeCostAccounter.recordJump();
                    if (n4 > 0) {
                        n8 = ~n;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        n8 = n;
                    }
                    return n8;
                }
                ++n;
            }
            int n9 = n + n4;
            RuntimeCostAccounter.recordJump();
            if (n9 > n6) {
                return ~n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
            int n10 = Math.min(n + n5, n6);
            int n11 = 0;
            int n12 = n;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n12 >= n10) break;
                int n13 = n12++;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c = charSequence.charAt(n13);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
                DecimalStyle decimalStyle = dateTimeParseContext.getDecimalStyle();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.convertToDigit:(C)I");
                int n14 = decimalStyle.convertToDigit(c);
                RuntimeCostAccounter.recordJump();
                if (n14 < 0) {
                    RuntimeCostAccounter.recordJump();
                    if (n12 < n9) {
                        return ~n;
                    }
                    --n12;
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                n11 = n11 * 10 + n14;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordAllocation((String)"java/math/BigDecimal");
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.<init>:(I)V");
            BigDecimal bigDecimal = new BigDecimal(n11);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.movePointLeft:(I)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal2 = bigDecimal.movePointLeft(n12 - n);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$FractionPrinterParser.convertFromFraction:(Ljava/math/BigDecimal;)J");
            long l = this.convertFromFraction(bigDecimal2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
            return dateTimeParseContext.setParsedField(this.field, l, n, n12);
        }

        private BigDecimal convertToFraction(long l) {
            BigDecimal bigDecimal;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = this.field.range();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.checkValidValue:(JLjava/time/temporal/TemporalField;)J");
            valueRange.checkValidValue(l, this.field);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
            long l2 = valueRange.getMinimum();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal2 = BigDecimal.valueOf(l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            long l3 = valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal3 = BigDecimal.valueOf(l3);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.subtract:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal4 = bigDecimal3.subtract(bigDecimal2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.add:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal5 = bigDecimal4.add(BigDecimal.ONE);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal6 = BigDecimal.valueOf(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.subtract:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal7 = bigDecimal6.subtract(bigDecimal2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.divide:(Ljava/math/BigDecimal;ILjava/math/RoundingMode;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal8 = bigDecimal7.divide(bigDecimal5, 9, RoundingMode.FLOOR);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.compareTo:(Ljava/math/BigDecimal;)I");
            int n = bigDecimal8.compareTo(BigDecimal.ZERO);
            RuntimeCostAccounter.recordJump();
            if (n == 0) {
                bigDecimal = BigDecimal.ZERO;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.stripTrailingZeros:()Ljava/math/BigDecimal;");
                bigDecimal = bigDecimal8.stripTrailingZeros();
            }
            return bigDecimal;
        }

        private long convertFromFraction(BigDecimal bigDecimal) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
            ValueRange valueRange = this.field.range();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMinimum:()J");
            long l = valueRange.getMinimum();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal2 = BigDecimal.valueOf(l);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.getMaximum:()J");
            long l2 = valueRange.getMaximum();
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.valueOf:(J)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal3 = BigDecimal.valueOf(l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.subtract:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal4 = bigDecimal3.subtract(bigDecimal2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.add:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal5 = bigDecimal4.add(BigDecimal.ONE);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.multiply:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal6 = bigDecimal.multiply(bigDecimal5);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.setScale:(ILjava/math/RoundingMode;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal7 = bigDecimal6.setScale(0, RoundingMode.FLOOR);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.add:(Ljava/math/BigDecimal;)Ljava/math/BigDecimal;");
            BigDecimal bigDecimal8 = bigDecimal7.add(bigDecimal2);
            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigDecimal.longValueExact:()J");
            return bigDecimal8.longValueExact();
        }

        public String toString() {
            String string;
            RuntimeCostAccounter.recordJump();
            if (this.decimalPoint) {
                string = ",DecimalPoint";
                RuntimeCostAccounter.recordJump();
            } else {
                string = "";
            }
            String string2 = string;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Fraction(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.minWidth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(this.maxWidth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(string2);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder9.toString();
        }
    }

    static final class ReducedPrinterParser
    extends NumberPrinterParser {
        static final LocalDate BASE_DATE;
        private final int baseValue;
        private final ChronoLocalDate baseDate;

        ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate) {
            block13: {
                block12: {
                    block11: {
                        block10: {
                            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;I)V");
                            this(temporalField, n, n2, n3, chronoLocalDate, 0);
                            RuntimeCostAccounter.recordJump();
                            if (n < 1) break block10;
                            RuntimeCostAccounter.recordJump();
                            if (n <= 10) break block11;
                        }
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("The minWidth must be from 1 to 10 inclusive but was ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(n);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string = stringBuilder3.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                        RuntimeCostAccounter.recordThrow();
                        throw illegalArgumentException;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 1) break block12;
                    RuntimeCostAccounter.recordJump();
                    if (n2 <= 10) break block13;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder.append("The maxWidth must be from 1 to 10 inclusive but was ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder5.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (n2 < n) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder.append("Maximum width must exceed or equal the minimum width but ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(" < ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append(n);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder9.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (chronoLocalDate == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/TemporalField.range:()Ljava/time/temporal/ValueRange;");
                ValueRange valueRange = temporalField.range();
                long l = n3;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/temporal/ValueRange.isValidValue:(J)Z");
                boolean bl = valueRange.isValidValue(l);
                RuntimeCostAccounter.recordJump();
                if (!bl) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The base value must be within the range of the field");
                    RuntimeCostAccounter.recordThrow();
                    throw illegalArgumentException;
                }
                long l2 = (long)n3 + EXCEED_POINTS[n2] - Integer.MAX_VALUE;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 > 0) {
                    RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                    DateTimeException dateTimeException = new DateTimeException("Unable to add printer-parser as the range exceeds the capacity of an int");
                    RuntimeCostAccounter.recordThrow();
                    throw dateTimeException;
                }
            }
        }

        private ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate, int n4) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;I)V");
            super(temporalField, n, n2, SignStyle.NOT_NEGATIVE, n4);
            this.baseValue = n3;
            this.baseDate = chronoLocalDate;
        }

        @Override
        long getValue(DateTimePrintContext dateTimePrintContext, long l) {
            long l2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
            long l3 = Math.abs(l);
            int n = this.baseValue;
            RuntimeCostAccounter.recordJump();
            if (this.baseDate != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getTemporal:()Ljava/time/temporal/TemporalAccessor;");
                TemporalAccessor temporalAccessor = dateTimePrintContext.getTemporal();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.from:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/Chronology;");
                Chronology chronology = Chronology.from(temporalAccessor);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate = chronology.date(this.baseDate);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
                n = chronoLocalDate.get(this.field);
            }
            long l4 = (l2 = l - (long)n) == 0L ? 0 : (l2 < 0L ? -1 : 1);
            RuntimeCostAccounter.recordJump();
            if (l4 >= 0) {
                long l5 = l - ((long)n + EXCEED_POINTS[this.minWidth]);
                long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l6 < 0) {
                    return l3 % EXCEED_POINTS[this.minWidth];
                }
            }
            return l3 % EXCEED_POINTS[this.maxWidth];
        }

        @Override
        int setValue(DateTimeParseContext dateTimeParseContext, long l, int n, int n2) {
            long l2;
            int n3 = this.baseValue;
            RuntimeCostAccounter.recordJump();
            if (this.baseDate != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getEffectiveChronology:()Ljava/time/chrono/Chronology;");
                Chronology chronology2 = dateTimeParseContext.getEffectiveChronology();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/Chronology.date:(Ljava/time/temporal/TemporalAccessor;)Ljava/time/chrono/ChronoLocalDate;");
                ChronoLocalDate chronoLocalDate = chronology2.date(this.baseDate);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/chrono/ChronoLocalDate.get:(Ljava/time/temporal/TemporalField;)I");
                n3 = chronoLocalDate.get(this.field);
                l2 = l;
                Consumer<Chronology> consumer = chronology -> {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.setValue:(Ljava/time/format/DateTimeParseContext;JII)I");
                    this.setValue(dateTimeParseContext, l2, n, n2);
                };
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.addChronoChangedListener:(Ljava/util/function/Consumer;)V");
                dateTimeParseContext.addChronoChangedListener(consumer);
            }
            int n4 = n2 - n;
            RuntimeCostAccounter.recordJump();
            if (n4 == this.minWidth) {
                RuntimeCostAccounter.recordJump();
                if (l >= 0L) {
                    long l3;
                    l2 = EXCEED_POINTS[this.minWidth];
                    long l4 = (long)n3 % l2;
                    long l5 = (long)n3 - l4;
                    RuntimeCostAccounter.recordJump();
                    if (n3 > 0) {
                        l = l5 + l;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        l = l5 - l;
                    }
                    long l6 = (l3 = l - (long)n3) == 0L ? 0 : (l3 < 0L ? -1 : 1);
                    RuntimeCostAccounter.recordJump();
                    if (l6 < 0) {
                        l += l2;
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
            return dateTimeParseContext.setParsedField(this.field, l, n, n2);
        }

        @Override
        ReducedPrinterParser withFixedWidth() {
            RuntimeCostAccounter.recordJump();
            if (this.subsequentWidth == -1) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;I)V");
            return new ReducedPrinterParser(this.field, this.minWidth, this.maxWidth, this.baseValue, this.baseDate, -1);
        }

        @Override
        ReducedPrinterParser withSubsequentWidth(int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;I)V");
            return new ReducedPrinterParser(this.field, this.minWidth, this.maxWidth, this.baseValue, this.baseDate, this.subsequentWidth + n);
        }

        @Override
        boolean isFixedWidth(DateTimeParseContext dateTimeParseContext) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            boolean bl = dateTimeParseContext.isStrict();
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.isFixedWidth:(Ljava/time/format/DateTimeParseContext;)Z");
            return super.isFixedWidth(dateTimeParseContext);
        }

        @Override
        public String toString() {
            Comparable<ChronoLocalDate> comparable;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("ReducedValue(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.minWidth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder6 = stringBuilder5.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder7 = stringBuilder6.append(this.maxWidth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder8 = stringBuilder7.append(",");
            RuntimeCostAccounter.recordJump();
            if (this.baseDate != null) {
                comparable = this.baseDate;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Integer.valueOf:(I)Ljava/lang/Integer;");
                comparable = this.baseValue;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder9 = stringBuilder8.append(comparable);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder9.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder10.toString();
        }

        /* synthetic */ ReducedPrinterParser(TemporalField temporalField, int n, int n2, int n3, ChronoLocalDate chronoLocalDate, int n4, 1 var7_7) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$ReducedPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IIILjava/time/chrono/ChronoLocalDate;I)V");
            this(temporalField, n, n2, n3, chronoLocalDate, n4);
        }

        static {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/LocalDate.of:(III)Ljava/time/LocalDate;");
            BASE_DATE = LocalDate.of(2000, 1, 1);
        }
    }

    static class NumberPrinterParser
    implements DateTimePrinterParser {
        static final long[] EXCEED_POINTS;
        final TemporalField field;
        final int minWidth;
        final int maxWidth;
        private final SignStyle signStyle;
        final int subsequentWidth;

        NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.field = temporalField;
            this.minWidth = n;
            this.maxWidth = n2;
            this.signStyle = signStyle;
            this.subsequentWidth = 0;
        }

        protected NumberPrinterParser(TemporalField temporalField, int n, int n2, SignStyle signStyle, int n3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.field = temporalField;
            this.minWidth = n;
            this.maxWidth = n2;
            this.signStyle = signStyle;
            this.subsequentWidth = n3;
        }

        NumberPrinterParser withFixedWidth() {
            RuntimeCostAccounter.recordJump();
            if (this.subsequentWidth == -1) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;I)V");
            return new NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, -1);
        }

        NumberPrinterParser withSubsequentWidth(int n) {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.<init>:(Ljava/time/temporal/TemporalField;IILjava/time/format/SignStyle;I)V");
            return new NumberPrinterParser(this.field, this.minWidth, this.maxWidth, this.signStyle, this.subsequentWidth + n);
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            String string;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getValue:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            Long l = dateTimePrintContext.getValue(this.field);
            RuntimeCostAccounter.recordJump();
            if (l == null) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.longValue:()J");
            long l2 = l;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.getValue:(Ljava/time/format/DateTimePrintContext;J)J");
            long l3 = this.getValue(dateTimePrintContext, l2);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
            DecimalStyle decimalStyle = dateTimePrintContext.getDecimalStyle();
            RuntimeCostAccounter.recordJump();
            if (l3 == Long.MIN_VALUE) {
                string = "9223372036854775808";
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.abs:(J)J");
                long l4 = Math.abs(l3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Long.toString:(J)Ljava/lang/String;");
                string = Long.toString(l4);
            }
            String string2 = string;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n = string2.length();
            RuntimeCostAccounter.recordJump();
            if (n > this.maxWidth) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder2 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append("Field ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(this.field);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(" cannot be printed as the value ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(l3);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(" exceeds the maximum print width of ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(this.maxWidth);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string3 = stringBuilder8.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string3);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.convertNumberToI18N:(Ljava/lang/String;)Ljava/lang/String;");
            string2 = decimalStyle.convertNumberToI18N(string2);
            RuntimeCostAccounter.recordJump();
            if (l3 >= 0L) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/SignStyle.ordinal:()I");
                switch (3.$SwitchMap$java$time$format$SignStyle[this.signStyle.ordinal()]) {
                    case 1: {
                        RuntimeCostAccounter.recordJump();
                        if (this.minWidth >= 19) break;
                        long l5 = l3 - EXCEED_POINTS[this.minWidth];
                        long l6 = l5 == 0L ? 0 : (l5 < 0L ? -1 : 1);
                        RuntimeCostAccounter.recordJump();
                        if (l6 < 0) break;
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getPositiveSign:()C");
                        char c = decimalStyle.getPositiveSign();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 2: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getPositiveSign:()C");
                        char c = decimalStyle.getPositiveSign();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                    }
                }
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/SignStyle.ordinal:()I");
                switch (3.$SwitchMap$java$time$format$SignStyle[this.signStyle.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getNegativeSign:()C");
                        char c = decimalStyle.getNegativeSign();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                        stringBuilder.append(c);
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    case 4: {
                        RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder9 = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder10 = stringBuilder9.append("Field ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder11 = stringBuilder10.append(this.field);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder12 = stringBuilder11.append(" cannot be printed as the value ");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(J)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder13 = stringBuilder12.append(l3);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder14 = stringBuilder13.append(" cannot be negative according to the SignStyle");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        String string4 = stringBuilder14.toString();
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                        DateTimeException dateTimeException = new DateTimeException(string4);
                        RuntimeCostAccounter.recordThrow();
                        throw dateTimeException;
                    }
                }
            }
            int n2 = 0;
            while (true) {
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
                int n3 = this.minWidth - string2.length();
                RuntimeCostAccounter.recordJump();
                if (n2 >= n3) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getZeroDigit:()C");
                char c = decimalStyle.getZeroDigit();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                stringBuilder.append(c);
                ++n2;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(string2);
            return true;
        }

        long getValue(DateTimePrintContext dateTimePrintContext, long l) {
            return l;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        boolean isFixedWidth(DateTimeParseContext dateTimeParseContext) {
            RuntimeCostAccounter.recordJump();
            if (this.subsequentWidth != -1) {
                RuntimeCostAccounter.recordJump();
                if (this.subsequentWidth <= 0) return false;
                RuntimeCostAccounter.recordJump();
                if (this.minWidth != this.maxWidth) return false;
                RuntimeCostAccounter.recordJump();
                if (this.signStyle != SignStyle.NOT_NEGATIVE) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public int parse(DateTimeParseContext var1_1, CharSequence var2_2, int var3_3) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            var4_4 = var2_2.length();
            RuntimeCostAccounter.recordJump();
            if (var3_3 == var4_4) {
                return ~var3_3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
            var5_5 = var2_2.charAt(var3_3);
            var6_6 = false;
            var7_7 = false;
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
            v0 = var1_1.getDecimalStyle();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getPositiveSign:()C");
            v1 = v0.getPositiveSign();
            RuntimeCostAccounter.recordJump();
            if (var5_5 == v1) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                v2 = var1_1.isStrict();
                RuntimeCostAccounter.recordJump();
                if (this.minWidth == this.maxWidth) {
                    v3 = true;
                    RuntimeCostAccounter.recordJump();
                } else {
                    v3 = false;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/SignStyle.parse:(ZZZ)Z");
                v4 = this.signStyle.parse(true, v2, v3);
                RuntimeCostAccounter.recordJump();
                if (!v4) {
                    return ~var3_3;
                }
                var7_7 = true;
                ++var3_3;
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
                v5 = var1_1.getDecimalStyle();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.getNegativeSign:()C");
                v6 = v5.getNegativeSign();
                RuntimeCostAccounter.recordJump();
                if (var5_5 == v6) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                    v7 = var1_1.isStrict();
                    RuntimeCostAccounter.recordJump();
                    if (this.minWidth == this.maxWidth) {
                        v8 = true;
                        RuntimeCostAccounter.recordJump();
                    } else {
                        v8 = false;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/SignStyle.parse:(ZZZ)Z");
                    v9 = this.signStyle.parse(false, v7, v8);
                    RuntimeCostAccounter.recordJump();
                    if (!v9) {
                        return ~var3_3;
                    }
                    var6_6 = true;
                    ++var3_3;
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (this.signStyle == SignStyle.ALWAYS) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                        v10 = var1_1.isStrict();
                        RuntimeCostAccounter.recordJump();
                        if (v10) {
                            return ~var3_3;
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            v11 = var1_1.isStrict();
            RuntimeCostAccounter.recordJump();
            if (v11) ** GOTO lbl-1000
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.isFixedWidth:(Ljava/time/format/DateTimeParseContext;)Z");
            v12 = this.isFixedWidth(var1_1);
            RuntimeCostAccounter.recordJump();
            if (v12) lbl-1000:
            // 2 sources

            {
                v13 = this.minWidth;
                RuntimeCostAccounter.recordJump();
            } else {
                v13 = 1;
            }
            var8_8 = v13;
            var9_9 = var3_3 + var8_8;
            RuntimeCostAccounter.recordJump();
            if (var9_9 > var4_4) {
                return ~var3_3;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            v14 = var1_1.isStrict();
            RuntimeCostAccounter.recordJump();
            if (v14) ** GOTO lbl-1000
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.isFixedWidth:(Ljava/time/format/DateTimeParseContext;)Z");
            v15 = this.isFixedWidth(var1_1);
            RuntimeCostAccounter.recordJump();
            if (v15) lbl-1000:
            // 2 sources

            {
                v16 = this.maxWidth;
                RuntimeCostAccounter.recordJump();
            } else {
                v16 = 9;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
            var10_10 = v16 + Math.max(this.subsequentWidth, 0);
            var11_11 = 0L;
            var13_12 = null;
            var14_13 = var3_3;
            var15_14 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (var15_14 >= 2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.min:(II)I");
                var16_15 = Math.min(var14_13 + var10_10, var4_4);
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (var14_13 >= var16_15) break;
                    v17 = var14_13++;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    var17_16 = var2_2.charAt(v17);
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getDecimalStyle:()Ljava/time/format/DecimalStyle;");
                    v18 = var1_1.getDecimalStyle();
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DecimalStyle.convertToDigit:(C)I");
                    var18_17 = v18.convertToDigit(var17_16);
                    RuntimeCostAccounter.recordJump();
                    if (var18_17 < 0) {
                        RuntimeCostAccounter.recordJump();
                        if (--var14_13 >= var9_9) break;
                        return ~var3_3;
                    }
                    RuntimeCostAccounter.recordJump();
                    if (var14_13 - var3_3 > 18) {
                        RuntimeCostAccounter.recordJump();
                        if (var13_12 == null) {
                            RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
                            var13_12 = BigInteger.valueOf(var11_11);
                        }
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.multiply:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                        v19 = var13_12.multiply(BigInteger.TEN);
                        v20 = var18_17;
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.valueOf:(J)Ljava/math/BigInteger;");
                        v21 = BigInteger.valueOf(v20);
                        RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.add:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                        var13_12 = v19.add(v21);
                        RuntimeCostAccounter.recordJump();
                    } else {
                        var11_11 = var11_11 * 10L + (long)var18_17;
                    }
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (this.subsequentWidth <= 0) break;
                RuntimeCostAccounter.recordJump();
                if (var15_14 != 0) break;
                var17_16 = var14_13 - var3_3;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Math.max:(II)I");
                var10_10 = Math.max(var8_8, var17_16 - this.subsequentWidth);
                var14_13 = var3_3;
                var11_11 = 0L;
                var13_12 = null;
                ++var15_14;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordJump();
            if (var6_6) {
                RuntimeCostAccounter.recordJump();
                if (var13_12 != null) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.equals:(Ljava/lang/Object;)Z");
                    v22 = var13_12.equals(BigInteger.ZERO);
                    RuntimeCostAccounter.recordJump();
                    if (v22) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                        v23 = var1_1.isStrict();
                        RuntimeCostAccounter.recordJump();
                        if (v23) {
                            return ~(var3_3 - 1);
                        }
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.negate:()Ljava/math/BigInteger;");
                    var13_12 = var13_12.negate();
                    RuntimeCostAccounter.recordJump();
                } else {
                    RuntimeCostAccounter.recordJump();
                    if (var11_11 == 0L) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                        v24 = var1_1.isStrict();
                        RuntimeCostAccounter.recordJump();
                        if (v24) {
                            return ~(var3_3 - 1);
                        }
                    }
                    var11_11 = -var11_11;
                    RuntimeCostAccounter.recordJump();
                }
            } else {
                RuntimeCostAccounter.recordJump();
                if (this.signStyle == SignStyle.EXCEEDS_PAD) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
                    v25 = var1_1.isStrict();
                    RuntimeCostAccounter.recordJump();
                    if (v25) {
                        var15_14 = var14_13 - var3_3;
                        RuntimeCostAccounter.recordJump();
                        if (var7_7) {
                            RuntimeCostAccounter.recordJump();
                            if (var15_14 <= this.minWidth) {
                                return ~(var3_3 - 1);
                            }
                        } else {
                            RuntimeCostAccounter.recordJump();
                            if (var15_14 > this.minWidth) {
                                return ~var3_3;
                            }
                        }
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (var13_12 != null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.bitLength:()I");
                v26 = var13_12.bitLength();
                RuntimeCostAccounter.recordJump();
                if (v26 > 63) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.divide:(Ljava/math/BigInteger;)Ljava/math/BigInteger;");
                    var13_12 = var13_12.divide(BigInteger.TEN);
                    --var14_13;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/math/BigInteger.longValue:()J");
                v27 = var13_12.longValue();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.setValue:(Ljava/time/format/DateTimeParseContext;JII)I");
                return this.setValue(var1_1, v27, var3_3, var14_13);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$NumberPrinterParser.setValue:(Ljava/time/format/DateTimeParseContext;JII)I");
            return this.setValue(var1_1, var11_11, var3_3, var14_13);
        }

        int setValue(DateTimeParseContext dateTimeParseContext, long l, int n, int n2) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
            return dateTimeParseContext.setParsedField(this.field, l, n, n2);
        }

        public String toString() {
            RuntimeCostAccounter.recordJump();
            if (this.minWidth == 1) {
                RuntimeCostAccounter.recordJump();
                if (this.maxWidth == 19) {
                    RuntimeCostAccounter.recordJump();
                    if (this.signStyle == SignStyle.NORMAL) {
                        RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                        StringBuilder stringBuilder = new StringBuilder();
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder2 = stringBuilder.append("Value(");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder3 = stringBuilder2.append(this.field);
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                        StringBuilder stringBuilder4 = stringBuilder3.append(")");
                        RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                        return stringBuilder4.toString();
                    }
                }
            }
            RuntimeCostAccounter.recordJump();
            if (this.minWidth == this.maxWidth) {
                RuntimeCostAccounter.recordJump();
                if (this.signStyle == SignStyle.NOT_NEGATIVE) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                    StringBuilder stringBuilder = new StringBuilder();
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder5 = stringBuilder.append("Value(");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder6 = stringBuilder5.append(this.field);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder7 = stringBuilder6.append(",");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder8 = stringBuilder7.append(this.minWidth);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                    StringBuilder stringBuilder9 = stringBuilder8.append(")");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                    return stringBuilder9.toString();
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder.append("Value(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder11 = stringBuilder10.append(this.field);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder12 = stringBuilder11.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder13 = stringBuilder12.append(this.minWidth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder14 = stringBuilder13.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder15 = stringBuilder14.append(this.maxWidth);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder16 = stringBuilder15.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder17 = stringBuilder16.append((Object)this.signStyle);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder18 = stringBuilder17.append(")");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder18.toString();
        }

        static /* synthetic */ SignStyle access$000(NumberPrinterParser numberPrinterParser) {
            return numberPrinterParser.signStyle;
        }

        static {
            RuntimeCostAccounter.recordArrayAllocation((int)11, (int)8);
            EXCEED_POINTS = new long[]{0L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L};
        }
    }

    static final class StringLiteralPrinterParser
    implements DateTimePrinterParser {
        private final String literal;

        StringLiteralPrinterParser(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.literal = string;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            stringBuilder.append(this.literal);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            block5: {
                block4: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    int n2 = charSequence.length();
                    RuntimeCostAccounter.recordJump();
                    if (n > n2) break block4;
                    RuntimeCostAccounter.recordJump();
                    if (n >= 0) break block5;
                }
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            int n3 = this.literal.length();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.subSequenceEquals:(Ljava/lang/CharSequence;ILjava/lang/CharSequence;II)Z");
            boolean bl = dateTimeParseContext.subSequenceEquals(charSequence, n, this.literal, 0, n3);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return ~n;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.length:()I");
            return n + this.literal.length();
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/String.replace:(Ljava/lang/CharSequence;Ljava/lang/CharSequence;)Ljava/lang/String;");
            String string = this.literal.replace("'", "''");
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("'");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("'");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }

    static final class CharLiteralPrinterParser
    implements DateTimePrinterParser {
        private final char literal;

        CharLiteralPrinterParser(char c) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.literal = c;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            stringBuilder.append(this.literal);
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            block4: {
                block5: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                    int n2 = charSequence.length();
                    RuntimeCostAccounter.recordJump();
                    if (n == n2) {
                        return ~n;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                    char c = charSequence.charAt(n);
                    RuntimeCostAccounter.recordJump();
                    if (c == this.literal) break block4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isCaseSensitive:()Z");
                    boolean bl = dateTimeParseContext.isCaseSensitive();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break block5;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toUpperCase:(C)C");
                    char c2 = Character.toUpperCase(c);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toUpperCase:(C)C");
                    char c3 = Character.toUpperCase(this.literal);
                    RuntimeCostAccounter.recordJump();
                    if (c2 == c3) break block4;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                    char c4 = Character.toLowerCase(c);
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/Character.toLowerCase:(C)C");
                    char c5 = Character.toLowerCase(this.literal);
                    RuntimeCostAccounter.recordJump();
                    if (c4 == c5) break block4;
                }
                return ~n;
            }
            return n + 1;
        }

        public String toString() {
            RuntimeCostAccounter.recordJump();
            if (this.literal == '\'') {
                return "''";
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("'");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.literal);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append("'");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder4.toString();
        }
    }

    static class DefaultValueParser
    implements DateTimePrinterParser {
        private final TemporalField field;
        private final long value;

        DefaultValueParser(TemporalField temporalField, long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.field = temporalField;
            this.value = l;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.getParsed:(Ljava/time/temporal/TemporalField;)Ljava/lang/Long;");
            Long l = dateTimeParseContext.getParsed(this.field);
            RuntimeCostAccounter.recordJump();
            if (l == null) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setParsedField:(Ljava/time/temporal/TemporalField;JII)I");
                dateTimeParseContext.setParsedField(this.field, this.value, n, n);
            }
            return n;
        }
    }

    static final class SettingsParser
    extends Enum<SettingsParser>
    implements DateTimePrinterParser {
        public static final /* enum */ SettingsParser SENSITIVE;
        public static final /* enum */ SettingsParser INSENSITIVE;
        public static final /* enum */ SettingsParser STRICT;
        public static final /* enum */ SettingsParser LENIENT;
        private static final /* synthetic */ SettingsParser[] $VALUES;

        /*
         * Exception decompiling
         */
        public static SettingsParser[] values() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Invalid type string [s
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolUtils.decodeTypeTok(ConstantPoolUtils.java:101)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.convertFromString(ConstantPoolEntryClass.java:52)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryClass.getTypeInstance(ConstantPoolEntryClass.java:61)
             *     at org.benf.cfr.reader.entities.constantpool.ConstantPoolEntryMethodRef.getMethodPrototype(ConstantPoolEntryMethodRef.java:72)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.buildInvoke(Op02WithProcessedDataAndRefs.java:331)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.createStatement(Op02WithProcessedDataAndRefs.java:1224)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.access$100(Op02WithProcessedDataAndRefs.java:57)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2080)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs$11.call(Op02WithProcessedDataAndRefs.java:2077)
             *     at org.benf.cfr.reader.util.graph.AbstractGraphVisitorFI.process(AbstractGraphVisitorFI.java:60)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.convertToOp03List(Op02WithProcessedDataAndRefs.java:2089)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:469)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public static SettingsParser valueOf(String string) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.valueOf:(Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Enum;");
            return Enum.valueOf(SettingsParser.class, string);
        }

        private SettingsParser() {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Enum.<init>:(Ljava/lang/String;I)V");
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser.ordinal:()I");
            switch (this.ordinal()) {
                case 0: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setCaseSensitive:(Z)V");
                    dateTimeParseContext.setCaseSensitive(true);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 1: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setCaseSensitive:(Z)V");
                    dateTimeParseContext.setCaseSensitive(false);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 2: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setStrict:(Z)V");
                    dateTimeParseContext.setStrict(true);
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                case 3: {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.setStrict:(Z)V");
                    dateTimeParseContext.setStrict(false);
                }
            }
            return n;
        }

        public String toString() {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser.ordinal:()I");
            switch (this.ordinal()) {
                case 0: {
                    return "ParseCaseSensitive(true)";
                }
                case 1: {
                    return "ParseCaseSensitive(false)";
                }
                case 2: {
                    return "ParseStrict(true)";
                }
                case 3: {
                    return "ParseStrict(false)";
                }
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalStateException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalStateException.<init>:(Ljava/lang/String;)V");
            IllegalStateException illegalStateException = new IllegalStateException("Unreachable");
            RuntimeCostAccounter.recordThrow();
            throw illegalStateException;
        }

        static {
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser.<init>:(Ljava/lang/String;I)V");
            SENSITIVE = new SettingsParser();
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser.<init>:(Ljava/lang/String;I)V");
            INSENSITIVE = new SettingsParser();
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser.<init>:(Ljava/lang/String;I)V");
            STRICT = new SettingsParser();
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$SettingsParser.<init>:(Ljava/lang/String;I)V");
            LENIENT = new SettingsParser();
            RuntimeCostAccounter.recordArrayAllocation((int)4, (int)8);
            $VALUES = new SettingsParser[]{SENSITIVE, INSENSITIVE, STRICT, LENIENT};
        }
    }

    static final class PadPrinterParserDecorator
    implements DateTimePrinterParser {
        private final DateTimePrinterParser printerParser;
        private final int padWidth;
        private final char padChar;

        PadPrinterParserDecorator(DateTimePrinterParser dateTimePrinterParser, int n, char c) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.printerParser = dateTimePrinterParser;
            this.padWidth = n;
            this.padChar = c;
        }

        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
            int n = stringBuilder.length();
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
            boolean bl = this.printerParser.format(dateTimePrintContext, stringBuilder);
            RuntimeCostAccounter.recordJump();
            if (!bl) {
                return false;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
            int n2 = stringBuilder.length() - n;
            RuntimeCostAccounter.recordJump();
            if (n2 > this.padWidth) {
                RuntimeCostAccounter.recordAllocation((String)"java/time/DateTimeException");
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder2 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder3 = stringBuilder2.append("Cannot print as output of ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder4 = stringBuilder3.append(n2);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder5 = stringBuilder4.append(" characters exceeds pad width of ");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder6 = stringBuilder5.append(this.padWidth);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                String string = stringBuilder6.toString();
                RuntimeCostAccounter.recordMethodCall((String)"java/time/DateTimeException.<init>:(Ljava/lang/String;)V");
                DateTimeException dateTimeException = new DateTimeException(string);
                RuntimeCostAccounter.recordThrow();
                throw dateTimeException;
            }
            int n3 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n3 >= this.padWidth - n2) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.insert:(IC)Ljava/lang/StringBuilder;");
                stringBuilder.insert(n, this.padChar);
                ++n3;
                RuntimeCostAccounter.recordJump();
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.isStrict:()Z");
            boolean bl = dateTimeParseContext.isStrict();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            int n2 = charSequence.length();
            RuntimeCostAccounter.recordJump();
            if (n > n2) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                RuntimeCostAccounter.recordThrow();
                throw indexOutOfBoundsException;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            int n3 = charSequence.length();
            RuntimeCostAccounter.recordJump();
            if (n == n3) {
                return ~n;
            }
            int n4 = n + this.padWidth;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
            int n5 = charSequence.length();
            RuntimeCostAccounter.recordJump();
            if (n4 > n5) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return ~n;
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.length:()I");
                n4 = charSequence.length();
            }
            int n6 = n;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n6 >= n4) break;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.charAt:(I)C");
                char c = charSequence.charAt(n6);
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.charEquals:(CC)Z");
                boolean bl2 = dateTimeParseContext.charEquals(c, this.padChar);
                RuntimeCostAccounter.recordJump();
                if (!bl2) break;
                ++n6;
                RuntimeCostAccounter.recordJump();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/CharSequence.subSequence:(II)Ljava/lang/CharSequence;");
            charSequence = charSequence.subSequence(0, n4);
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
            int n7 = this.printerParser.parse(dateTimeParseContext, charSequence, n6);
            RuntimeCostAccounter.recordJump();
            if (n7 != n4) {
                RuntimeCostAccounter.recordJump();
                if (bl) {
                    return ~(n + n6);
                }
            }
            return n7;
        }

        public String toString() {
            String string;
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder2 = stringBuilder.append("Pad(");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder3 = stringBuilder2.append(this.printerParser);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder4 = stringBuilder3.append(",");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(I)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder5 = stringBuilder4.append(this.padWidth);
            RuntimeCostAccounter.recordJump();
            if (this.padChar == ' ') {
                string = ")";
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
                StringBuilder stringBuilder6 = new StringBuilder();
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder7 = stringBuilder6.append(",'");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(C)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder8 = stringBuilder7.append(this.padChar);
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                StringBuilder stringBuilder9 = stringBuilder8.append("')");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
                string = stringBuilder9.toString();
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
            StringBuilder stringBuilder10 = stringBuilder5.append(string);
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder10.toString();
        }
    }

    static final class CompositePrinterParser
    implements DateTimePrinterParser {
        private final DateTimePrinterParser[] printerParsers;
        private final boolean optional;

        CompositePrinterParser(List<DateTimePrinterParser> list, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.size:()I");
            int n = list.size();
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            DateTimePrinterParser[] dateTimePrinterParserArray = new DateTimePrinterParser[n];
            RuntimeCostAccounter.recordMethodCall((String)"java/util/List.toArray:([Ljava/lang/Object;)[Ljava/lang/Object;");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.<init>:([Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;Z)V");
            this(list.toArray(dateTimePrinterParserArray), bl);
        }

        CompositePrinterParser(DateTimePrinterParser[] dateTimePrinterParserArray, boolean bl) {
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
            this.printerParsers = dateTimePrinterParserArray;
            this.optional = bl;
        }

        public CompositePrinterParser withOptional(boolean bl) {
            RuntimeCostAccounter.recordJump();
            if (bl == this.optional) {
                return this;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser");
            RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$CompositePrinterParser.<init>:([Ljava/time/format/DateTimeFormatterBuilder$DateTimePrinterParser;Z)V");
            return new CompositePrinterParser(this.printerParsers, bl);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean format(DateTimePrintContext dateTimePrintContext, StringBuilder stringBuilder) {
            boolean bl;
            int n;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.length:()I");
            int n2 = stringBuilder.length();
            RuntimeCostAccounter.recordJump();
            if (this.optional) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.startOptional:()V");
                dateTimePrintContext.startOptional();
            }
            try {
                DateTimePrinterParser[] dateTimePrinterParserArray = this.printerParsers;
                int n3 = dateTimePrinterParserArray.length;
                n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= n3) break;
                    DateTimePrinterParser dateTimePrinterParser = dateTimePrinterParserArray[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.format:(Ljava/time/format/DateTimePrintContext;Ljava/lang/StringBuilder;)Z");
                    boolean bl2 = dateTimePrinterParser.format(dateTimePrintContext, stringBuilder);
                    RuntimeCostAccounter.recordJump();
                    if (bl2) break block8;
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.setLength:(I)V");
                    stringBuilder.setLength(n2);
                    bl = true;
                    break;
                }
            }
            catch (Throwable throwable) {
                RuntimeCostAccounter.recordJump();
                if (this.optional) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.endOptional:()V");
                    dateTimePrintContext.endOptional();
                }
                RuntimeCostAccounter.recordThrow();
                throw throwable;
            }
            {
                block8: {
                    RuntimeCostAccounter.recordJump();
                    if (this.optional) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.endOptional:()V");
                        dateTimePrintContext.endOptional();
                    }
                    return bl;
                }
                ++n;
                RuntimeCostAccounter.recordJump();
                continue;
            }
            RuntimeCostAccounter.recordJump();
            if (this.optional) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimePrintContext.endOptional:()V");
                dateTimePrintContext.endOptional();
                RuntimeCostAccounter.recordJump();
            }
            return true;
        }

        @Override
        public int parse(DateTimeParseContext dateTimeParseContext, CharSequence charSequence, int n) {
            RuntimeCostAccounter.recordJump();
            if (this.optional) {
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.startOptional:()V");
                dateTimeParseContext.startOptional();
                int n2 = n;
                DateTimePrinterParser[] dateTimePrinterParserArray = this.printerParsers;
                int n3 = dateTimePrinterParserArray.length;
                int n4 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n3) break;
                    DateTimePrinterParser dateTimePrinterParser = dateTimePrinterParserArray[n4];
                    RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
                    n2 = dateTimePrinterParser.parse(dateTimeParseContext, charSequence, n2);
                    RuntimeCostAccounter.recordJump();
                    if (n2 < 0) {
                        RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.endOptional:(Z)V");
                        dateTimeParseContext.endOptional(false);
                        return n;
                    }
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeParseContext.endOptional:(Z)V");
                dateTimeParseContext.endOptional(true);
                return n2;
            }
            DateTimePrinterParser[] dateTimePrinterParserArray = this.printerParsers;
            int n5 = dateTimePrinterParserArray.length;
            int n6 = 0;
            while (true) {
                RuntimeCostAccounter.recordJump();
                if (n6 >= n5) break;
                DateTimePrinterParser dateTimePrinterParser = dateTimePrinterParserArray[n6];
                RuntimeCostAccounter.recordMethodCall((String)"java/time/format/DateTimeFormatterBuilder$DateTimePrinterParser.parse:(Ljava/time/format/DateTimeParseContext;Ljava/lang/CharSequence;I)I");
                n = dateTimePrinterParser.parse(dateTimeParseContext, charSequence, n);
                RuntimeCostAccounter.recordJump();
                if (n < 0) {
                    RuntimeCostAccounter.recordJump();
                    break;
                }
                ++n6;
                RuntimeCostAccounter.recordJump();
            }
            return n;
        }

        public String toString() {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/StringBuilder");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.<init>:()V");
            StringBuilder stringBuilder = new StringBuilder();
            RuntimeCostAccounter.recordJump();
            if (this.printerParsers != null) {
                String string;
                String string2;
                RuntimeCostAccounter.recordJump();
                if (this.optional) {
                    string2 = "[";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string2 = "(";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(string2);
                DateTimePrinterParser[] dateTimePrinterParserArray = this.printerParsers;
                int n = dateTimePrinterParserArray.length;
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    DateTimePrinterParser dateTimePrinterParser = dateTimePrinterParserArray[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
                    stringBuilder.append(dateTimePrinterParser);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
                if (this.optional) {
                    string = "]";
                    RuntimeCostAccounter.recordJump();
                } else {
                    string = ")";
                }
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.append:(Ljava/lang/String;)Ljava/lang/StringBuilder;");
                stringBuilder.append(string);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/StringBuilder.toString:()Ljava/lang/String;");
            return stringBuilder.toString();
        }
    }

    static interface DateTimePrinterParser {
        public boolean format(DateTimePrintContext var1, StringBuilder var2);

        public int parse(DateTimeParseContext var1, CharSequence var2, int var3);
    }
}

