/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterReader;
import sandbox.java.io.IOException;
import sandbox.java.io.Reader;

public class PushbackReader
extends FilterReader {
    private char[] buf;
    private int pos;

    public PushbackReader(Reader reader, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterReader.<init>:(Ljava/io/Reader;)V");
        super(reader);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)2);
        this.buf = new char[n2];
        this.pos = n;
    }

    public PushbackReader(Reader reader) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.<init>:(Ljava/io/Reader;I)V");
        this(reader, 1);
    }

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.buf == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.ensureOpen:()V");
            this.ensureOpen();
            int n = this.buf.length;
            RuntimeCostAccounter.recordJump();
            if (this.pos < n) {
                return this.buf[this.pos++];
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterReader.read:()I");
            return super.read();
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    @Override
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        try {
            int n3;
            block16: {
                block17: {
                    int n4;
                    block18: {
                        block15: {
                            int n5;
                            RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.ensureOpen:()V");
                            this.ensureOpen();
                            try {
                                block20: {
                                    block19: {
                                        RuntimeCostAccounter.recordJump();
                                        if (n2 > 0) break block15;
                                        RuntimeCostAccounter.recordJump();
                                        if (n2 < 0) {
                                            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                                            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                                            RuntimeCostAccounter.recordThrow();
                                            throw indexOutOfBoundsException;
                                        }
                                        RuntimeCostAccounter.recordJump();
                                        if (n < 0) break block19;
                                        int n6 = cArray.length;
                                        RuntimeCostAccounter.recordJump();
                                        if (n <= n6) break block20;
                                    }
                                    RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                                    IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                                    RuntimeCostAccounter.recordThrow();
                                    throw indexOutOfBoundsException;
                                }
                                n5 = 0;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
                                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
                                IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
                                RuntimeCostAccounter.recordThrow();
                                throw indexOutOfBoundsException;
                            }
                            return n5;
                        }
                        n3 = this.buf.length - this.pos;
                        RuntimeCostAccounter.recordJump();
                        if (n3 > 0) {
                            RuntimeCostAccounter.recordJump();
                            if (n2 < n3) {
                                n3 = n2;
                            }
                            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
                            System.arraycopy(this.buf, this.pos, cArray, n, n3);
                            this.pos += n3;
                            n += n3;
                            n2 -= n3;
                        }
                        RuntimeCostAccounter.recordJump();
                        if (n2 <= 0) break block16;
                        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterReader.read:([CII)I");
                        n2 = super.read(cArray, n, n2);
                        RuntimeCostAccounter.recordJump();
                        if (n2 != -1) break block17;
                        RuntimeCostAccounter.recordJump();
                        if (n3 == 0) {
                            n4 = -1;
                            RuntimeCostAccounter.recordJump();
                            break block18;
                        }
                        n4 = n3;
                    }
                    return n4;
                }
                int n7 = n3 + n2;
                return n7;
            }
            int n8 = n3;
            return n8;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(int n) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (this.pos == 0) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException("Pushback buffer overflow");
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            this.buf[--this.pos] = (char)n;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unread(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.ensureOpen:()V");
            this.ensureOpen();
            RuntimeCostAccounter.recordJump();
            if (n2 > this.pos) {
                RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
                RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
                IOException iOException = new IOException("Pushback buffer overflow");
                RuntimeCostAccounter.recordThrow();
                throw iOException;
            }
            this.pos -= n2;
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(cArray, n, this.buf, this.pos, n2);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
        RuntimeCostAccounter.recordJump();
    }

    public void unread(char[] cArray) throws IOException {
        int n = cArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.unread:([CII)V");
        this.unread(cArray, 0, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean ready() throws IOException {
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.ensureOpen:()V");
            this.ensureOpen();
            int n = this.buf.length;
            RuntimeCostAccounter.recordJump();
            if (this.pos >= n) {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterReader.ready:()Z");
                boolean bl = super.ready();
                RuntimeCostAccounter.recordJump();
                if (!bl) return false;
            }
            boolean bl = true;
            RuntimeCostAccounter.recordJump();
            return bl;
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }

    @Override
    public void mark(int n) throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("mark/reset not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    @Override
    public void reset() throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("mark/reset not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void close() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterReader.close:()V");
        super.close();
        this.buf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordJump();
        if (l < 0L) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("skip value is negative");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        Object object = this.lock;
        try {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackReader.ensureOpen:()V");
            this.ensureOpen();
            int n = this.buf.length - this.pos;
            RuntimeCostAccounter.recordJump();
            if (n > 0) {
                long l2 = l - (long)n;
                long l3 = l2 == 0L ? 0 : (l2 < 0L ? -1 : 1);
                RuntimeCostAccounter.recordJump();
                if (l3 <= 0) {
                    this.pos = (int)((long)this.pos + l);
                    return l;
                }
                this.pos = this.buf.length;
                l -= (long)n;
            }
            long l4 = n;
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterReader.skip:(J)J");
            return l4 + super.skip(l);
        }
        catch (Throwable throwable) {
            RuntimeCostAccounter.recordThrow();
            throw throwable;
        }
    }
}

