# Matomo DDEV environment

**WARNING**: Matomo DDEV environment can be helpful when developing for Matomo, to be able to create or test new plugins locally, to run unit, integration, system or UI tests, but it is **highly discouraged** to use DDEV environments to run or host publicly accessible production installations of Matomo.

## Prerequisites

Before you begin, make sure you have DDEV installed. If you don't have it yet, follow the installation instructions in the official [DDEV documentation](https://ddev.readthedocs.io/en/stable/).

If you don't have a Docker provider already available, you will need to start by choosing one. We recommend installing [Rancher Desktop](https://rancherdesktop.io/), as it is free and open source.

By default, Rancher Desktop will use ports 80 and 443 for Traefik router for Kubernetes. To make these ports available to DDEV, we recommend disabling Traefik by unchecking the checkbox: Preferences > Kubernetes > Enable Traefik.

## Setup steps

### 1. Start the environment

Once DDEV is installed, navigate to your project directory and run:

```
ddev start
```

This command will start the DDEV environment for local development. By default, your local environment will be accessible at [https://matomo.ddev.site](https://matomo.ddev.site).

You can also open this URL directly in your browser by running:

```
ddev launch
```

This will automatically open the default browser and take you to the Matomo setup page.

### 2. Set up Matomo using the UI installer

Follow the on-screen instructions in the UI installer to complete the Matomo setup. This will configure the necessary database and settings for your local instance.

### 3. Set up the development environment

After Matomo is set up, you can initialize the development environment by running:

```
ddev matomo:init:dev
```

This command will set up the environment for development, installing the additional dependencies required.

We have also added a parameter to the `ddev matomo:init:dev` command to enable source maps for Vue components. 
To enable them, you can run:
```
ddev matomo:init:dev --with-sourcemaps
```

You can also disable sourcemaps at any time if you want to, just run the default command again:
```
ddev matomo:init:dev
```
NOTE: You should tick 'Disable cache' on your browser developer tools to see the changes.

To see help:
```
ddev help matomo:init:dev
```

### 4. Set up the testing environment

After Matomo is set up, you can initialize the testing environment by running:

```
ddev matomo:init:tests
```

This command will set up the environment for running tests, ensuring everything is in place for the UI and other automated tests.

## Usage

The command `ddev matomo:console` provides access to all Matomo console commands. Some useful commands include:

- `core:archive` – Run local archiving
- `generate:plugin` - Generate a new plugin/theme including all needed files
- `tests:run` – Run unit, integration, and system tests
- `tests:run-ui` – Run UI tests
- `tests:run-js` – Run tracker JavaScript tests
- `cache:clear` - Remove all caches, including CSS and JavaScript
- `vue:build` - Builds vue modules for one or more plugins

For more information about Matomo development, check out the official [Matomo Developer Documentation](https://developer.matomo.org/).

## Update PHP or MySQL version

You can create `.ddev/config.local.yaml` to adjust the environment configuration. This file will be automatically ignored by git.

For example, you can adjust `php_version` to `8.4`. All configuration from `.ddev/config.yaml` can be overridden. Check [DDEV documentation](https://docs.ddev.com/en/stable/users/configuration/config/#managing-configuration) for more details.

From your host, run `ddev restart` for the changes to take effect.

## Generating testing data locally

To see some visits within your local Matomo instance, you don't need a website with the JavaScript tracking code installed. Instead, you can generate sample visits using the VisitorGenerator plugin.

Start by creating a site in the Matomo Dashboard. Then, run the following commands on your host machine:

```
ddev matomo:console development:enable
ddev matomo:console plugin:activate VisitorGenerator
ddev matomo:console visitorgenerator:generate-visits
```

## Known issues

Currently, the screenshots generated by UI tests do not match those generated in the CI environment. However, this does not affect the functionality of the tests themselves. The screenshots should still be good enough to verify that your changes or plugin are working correctly.

