# Copyright (c) 2016 Oracle and/or its affiliates. All rights reserved. This
# code is released under a tri EPL/GPL/LGPL license. You can use it,
# redistribute it and/or modify it under the terms of the:
#
# Eclipse Public License version 1.0
# GNU General Public License version 2
# GNU Lesser General Public License version 2.1

# encoding: utf-8

# Real-world usage of Array#pack, gathered by bjfish2

Infinity = Float::INFINITY
NaN = Float::NAN

def assert_equal(one, two)
  raise "Expected size: `#{one.b.size}` Actual size: `#{two.size}`" if one.b.size != two.size
  raise "Expected: `#{one.b}` Actual: `#{two}`" if one.b != two
end

assert_equal("z",([] << 122).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x06",([] << 6).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("e",([] << 101).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("f",([] << 102).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("g",[103].pack('C'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("h",[104].pack('C'))
assert_equal("(",([] << 40).pack('C*'))
assert_equal("\xD2\x01",([210] << 1).pack('C*'))
assert_equal("0",([] << 48).pack('C*'))
assert_equal("\xD4\x01",([212] << 1).pack('C*'))
assert_equal("=",([] << 61).pack('C*'))
assert_equal("k\x00\x00\x00",[107].pack('V'))
assert_equal("A",([] << 65).pack('C*'))
assert_equal("l\x00\x00\x00\x00\x00\x00\x00",[108 & 0xffff_ffff, 108 >> 32].pack('VV'))
assert_equal("M",([] << 77).pack('C*'))
assert_equal("m\x00\x00\x00", [109].pack('V'))
assert_equal("Q",([] << 81).pack('C*'))
assert_equal("n\x00\x00\x00\x00\x00\x00\x00",[110 & 0xffff_ffff, 110 >> 32].pack('VV'))
assert_equal("]",([] << 93).pack('C*'))
assert_equal("\x00\x00\xDEB", [111.0].pack('e'))
assert_equal("a",([] << 97).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\x00\\@",[112.0].pack('E'))
assert_equal("h",([] << 104).pack('C*'))
assert_equal("r",([] << 114).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x92\x01",([146] << 1).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("v",([] << 118).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\x9A\x01",([154] << 1).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("w",([] << 119).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\xA2\x01",([162] << 1).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("x",([] << 120).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\xA8\x01",([168] << 1).pack('C*'))
assert_equal("\x03",[3].pack('C'))
assert_equal("\xB0\x01",([176] << 1).pack('C*'))
assert_equal("\x06",[6].pack('C'))
assert_equal("\xB8\x01",([184] << 1).pack('C*'))
assert_equal("\t",[9].pack('C'))
assert_equal("\xC2\x01",([194] << 1).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xCA\x01",([202] << 1).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xD2\x01",([210] << 1).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("~",([] << 126).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\xDA\x01",([218] << 1).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x7F",([] << 127).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\xF8\x01",([248] << 1).pack('C*'))
assert_equal("\xC9\x01",([201] << 1).pack('C*'))
assert_equal("\xF8\x01",([248] << 1).pack('C*'))
assert_equal("\xAD\x02",([173] << 2).pack('C*'))
assert_equal("\x80\x02",([128] << 2).pack('C*'))
assert_equal("\xCA\x01",([202] << 1).pack('C*'))
assert_equal("\x80\x02",([128] << 2).pack('C*'))
assert_equal("\xAE\x02",([174] << 2).pack('C*'))
assert_equal("\x88\x02",([136] << 2).pack('C*'))
assert_equal("\xCB\x01",[203, 1].pack('C*'))
assert_equal("\x88\x02",([136] << 2).pack('C*'))
assert_equal("\xAF\x02",[175, 2].pack('C*'))
assert_equal("\x90\x02",([144] << 2).pack('C*'))
assert_equal("\xCC\x01",[204, 1].pack('C*'))
assert_equal("\x90\x02",([144] << 2).pack('C*'))
assert_equal("\xB0\x02",[176, 2].pack('C*'))
assert_equal("\x98\x02",([152] << 2).pack('C*'))
assert_equal("\x9A\x03",([154] << 3).pack('C*'))
assert_equal("\x98\x02",([152] << 2).pack('C*'))
assert_equal("\xE2\x04",([226] << 4).pack('C*'))
assert_equal("\xA0\x02",([160] << 2).pack('C*'))
assert_equal("\x9C\x03",([156] << 3).pack('C*'))
assert_equal("\xA0\x02",([160] << 2).pack('C*'))
assert_equal("\xE4\x04",([228] << 4).pack('C*'))
assert_equal("\xAD\x02",([173] << 2).pack('C*'))
assert_equal("\xCF\x00\x00\x00",[207].pack('V'))
assert_equal("\xAD\x02",([173] << 2).pack('C*'))
assert_equal("3\x01\x00\x00",[307].pack('V'))
assert_equal("\xB1\x02",([177] << 2).pack('C*'))
assert_equal("\xD0\x00\x00\x00\x00\x00\x00\x00",[208 & 0xffff_ffff, 208 >> 32].pack('VV'))
assert_equal("\xB1\x02",([177] << 2).pack('C*'))
assert_equal("4\x01\x00\x00\x00\x00\x00\x00",[308 & 0xffff_ffff, 308 >> 32].pack('VV'))
assert_equal("\xBD\x02",([189] << 2).pack('C*'))
assert_equal("\xD1\x00\x00\x00", [209].pack('V'))
assert_equal("\xBD\x02",([189] << 2).pack('C*'))
assert_equal("5\x01\x00\x00", [309].pack('V'))
assert_equal("\xC1\x02",([193] << 2).pack('C*'))
assert_equal("\xD2\x00\x00\x00\x00\x00\x00\x00",[210 & 0xffff_ffff, 210 >> 32].pack('VV'))
assert_equal("\xC1\x02",([193] << 2).pack('C*'))
assert_equal("6\x01\x00\x00\x00\x00\x00\x00",[310 & 0xffff_ffff, 310 >> 32].pack('VV'))
assert_equal("\xCD\x02",([205] << 2).pack('C*'))
assert_equal("\x00\x00SC", [211].pack('e'))
assert_equal("\xCD\x02",([205] << 2).pack('C*'))
assert_equal("\x00\x80\x9BC", [311].pack('e'))
assert_equal("\xD1\x02",([209] << 2).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\x80j@",[212].pack('E'))
assert_equal("\xD1\x02",([209] << 2).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\x80s@",[312].pack('E'))
assert_equal("\xD8\x02",([216] << 2).pack('C*'))
assert_equal("\xD8\x02",([216] << 2).pack('C*'))
assert_equal("\xE2\x02",([226] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xE2\x02",([226] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xEA\x02",([234] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xEA\x02",([234] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x82\x03",([130] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xDA\x01",([218] << 1).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x82\x03",([130] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xBE\x02",([190] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x8A\x03",([138] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xDB\x01",([219] << 1).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x8A\x03",([138] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xBF\x02",([191] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x92\x03",([146] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xDC\x01",([220] << 1).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x92\x03",([146] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xC0\x02",([192] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x98\x03",([152] << 3).pack('C*'))
assert_equal("\x02",[2].pack('C'))
assert_equal("\x98\x03",([152] << 3).pack('C*'))
assert_equal("\x03",[3].pack('C'))
assert_equal("\xA0\x03",([160] << 3).pack('C*'))
assert_equal("\x05",[5].pack('C'))
assert_equal("\xA0\x03",([160] << 3).pack('C*'))
assert_equal("\x06",[6].pack('C'))
assert_equal("\xA8\x03",([168] << 3).pack('C*'))
assert_equal("\b",[8].pack('C'))
assert_equal("\xA8\x03",([168] << 3).pack('C*'))
assert_equal("\t",[9].pack('C'))
assert_equal("\xB2\x03",([178] << 3).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xB2\x03",([178] << 3).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xBA\x03",([186] << 3).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xBA\x03",([186] << 3).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xCA\x03",([202] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xE3\x01",([227] << 1).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xCA\x03",([202] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\xC7\x02",([199] << 2).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xE8\x03",([232] << 3).pack('C*'))
assert_equal("\x91\x03",([145] << 3).pack('C*'))
assert_equal("\xF0\x03",([240] << 3).pack('C*'))
assert_equal("\x92\x03",([146] << 3).pack('C*'))
assert_equal("\xF8\x03",([248] << 3).pack('C*'))
assert_equal("\x93\x03",[147, 3].pack('C*'))
assert_equal("\x80\x04",([128] << 4).pack('C*'))
assert_equal("\x94\x03",[148, 3].pack('C*'))
assert_equal("\x88\x04",([136] << 4).pack('C*'))
assert_equal("\xAA\x06",([170] << 6).pack('C*'))
assert_equal("\x90\x04",([144] << 4).pack('C*'))
assert_equal("\xAC\x06",([172] << 6).pack('C*'))
assert_equal("\x9D\x04",([157] << 4).pack('C*'))
assert_equal("\x97\x01\x00\x00",[407].pack('V'))
assert_equal("\xA1\x04",([161] << 4).pack('C*'))
assert_equal("\x98\x01\x00\x00\x00\x00\x00\x00",[408 & 0xffff_ffff, 408 >> 32].pack('VV'))
assert_equal("\xAD\x04",([173] << 4).pack('C*'))
assert_equal("\x99\x01\x00\x00", [409].pack('V'))
assert_equal("\xB1\x04",([177] << 4).pack('C*'))
assert_equal("\x9A\x01\x00\x00\x00\x00\x00\x00",[410 & 0xffff_ffff, 410 >> 32].pack('VV'))
assert_equal("\xBD\x04",([189] << 4).pack('C*'))
assert_equal("\x00\x80\xCDC", [411.0].pack('e'))
assert_equal("\xC1\x04",([193] << 4).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\xC0y@",[412.0].pack('E'))
assert_equal("\xC8\x04",([200] << 4).pack('C*'))
assert_equal("\xD2\x04",([210] << 4).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xDA\x04",([218] << 4).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x88\x05",([136] << 5).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\x90\x05",([144] << 5).pack('C*'))
assert_equal("\x04",[4].pack('C'))
assert_equal("\x98\x05",([152] << 5).pack('C*'))
assert_equal("\a",[7].pack('C'))
assert_equal("\xA2\x05",([162] << 5).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\xAA\x05",([170] << 5).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\xFF\xFF\xFF\xFF\x0F",[255, 255, 255, 255, 15].pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\x01",[255, 255, 255, 255, 255, 255, 255, 255, 255, 1].pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x81\x80\x80\x80\xF8\xFF\xFF\xFF\xFF\x01",([129, 128, 128, 128, 248, 255, 255, 255, 255] << 1).pack('C*'))
assert_equal("(",([] << 40).pack('C*'))
assert_equal("\x81\x80\x80\x80\x80\x80\x80\x80\x80\x01",([129, 128, 128, 128, 128, 128, 128, 128, 128] << 1).pack('C*'))
assert_equal("2",([] << 50).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("=",([] << 61).pack('C*'))
assert_equal("\x00\x00\x00\x00", [0.0].pack('e'))
assert_equal("E",([] << 69).pack('C*'))
assert_equal("\x00\x00\x80?", [1.0].pack('e'))
assert_equal("M",([] << 77).pack('C*'))
assert_equal("\x00\x00\xC0?", [1.5].pack('e'))
assert_equal("U",([] << 85).pack('C*'))
assert_equal("\x00\x00\x80\xBF", [-1.0].pack('e'))
assert_equal("]",([] << 93).pack('C*'))
assert_equal("\x00\x00\xC0\xBF", [-1.5].pack('e'))
assert_equal("e",([] << 101).pack('C*'))
assert_equal(" \xBC>M", [200000000.0].pack('e'))
assert_equal("m",([] << 109).pack('C*'))
assert_equal("\xB6\x87}\x92", [-8.0e-28].pack('e'))
assert_equal("q",([] << 113).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\x00\xF0\x7F",[Infinity].pack('E'))
assert_equal("y",([] << 121).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\x00\xF0\xFF",[-Infinity].pack('E'))
assert_equal("\x81\x01",([129] << 1).pack('C*'))
assert_equal("\x00\x00\x00\x00\x00\x00\xF8\x7F",[NaN].pack('E'))
assert_equal("\x8D\x01",([141] << 1).pack('C*'))
assert_equal("\x00\x00\x80\x7F", [Infinity].pack('e'))
assert_equal("\x95\x01",([149] << 1).pack('C*'))
assert_equal("\x00\x00\x80\xFF", [-Infinity].pack('e'))
assert_equal("\x9D\x01",([157] << 1).pack('C*'))
assert_equal("\x00\x00\xC0\x7F", [NaN].pack('e'))
assert_equal("\xA2\x01",([162] << 1).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\xA8\x01",([168] << 1).pack('C*'))
assert_equal("\x80\x80\x80\x80\xF8\xFF\xFF\xFF\xFF\x01",([128, 128, 128, 128, 248, 255, 255, 255, 255] << 1).pack('C*'))
assert_equal("\xB0\x01",([176] << 1).pack('C*'))
assert_equal("\x80\x80\x80\x80\x80\x80\x80\x80\x80\x01",([128, 128, 128, 128, 128, 128, 128, 128, 128] << 1).pack('C*'))
assert_equal("\xBA\x01",([186] << 1).pack('C*'))
assert_equal("\x06",([] << 6).pack('C*'))
assert_equal("\xC2\x01",([194] << 1).pack('C*'))
assert_equal("\x06",([] << 6).pack('C*'))
assert_equal("\xCA\x01",([202] << 1).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\xD2\x01",([210] << 1).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))

assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))

assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))

assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))

assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))

assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))

assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))

assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))

assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))

assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))

assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x18",([] << 24).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\r",([] << 13).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x0F",([] << 15).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x0F",([] << 15).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1D",([] << 29).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1F",([] << 31).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1D",([] << 29).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1F",([] << 31).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1D",([] << 29).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x1F",([] << 31).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x0E",([] << 14).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x0E",([] << 14).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x0E",([] << 14).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x0E",([] << 14).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x0E",([] << 14).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("z",([] << 122).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x0E",([] << 14).pack('C*'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x02",([] << 2).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x02",[2].pack('C'))
assert_equal("\x10",([] << 16).pack('C*'))
assert_equal("\x02",[2].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x14",([] << 20).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\a",([] << 7).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x00",([] << 0).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x14",([] << 20).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x00",([] << 0).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x14",([] << 20).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x03",[3].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x03",[3].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x03",[3].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x03",[3].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x05",[5].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x05",[5].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x05",[5].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x15",([] << 21).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x03",([] << 3).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\"",([] << 34).pack('C*'))
assert_equal("\x13",([] << 19).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x16",([] << 22).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x04",[4].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\x16",([] << 22).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x04",[4].pack('C'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("(",([] << 40).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("5",([] << 53).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("(",([] << 40).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("5",([] << 53).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("(",([] << 40).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("(",([] << 40).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("5",([] << 53).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\e",([] << 27).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\x01",([] << 1).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal(">",([] << 62).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("5",([] << 53).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x01",[1].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("5",([] << 53).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("&",([] << 38).pack('C*'))
assert_equal("\b",([] << 8).pack('C*'))
assert_equal("\x00",[0].pack('C'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("\x05",([] << 5).pack('C*'))
assert_equal("\x12",([] << 18).pack('C*'))
assert_equal("\t",([] << 9).pack('C*'))
assert_equal("\x1A",([] << 26).pack('C*'))
assert_equal("\x04",([] << 4).pack('C*'))
assert_equal(" ",([] << 32).pack('C*'))
assert_equal("\n",([] << 10).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\f",([] << 12).pack('C*'))
assert_equal("*",([] << 42).pack('C*'))
assert_equal("\v",([] << 11).pack('C*'))
assert_equal("5",([] << 53).pack('C*'))

def assert_equal_u(one, two)
  raise "Expected: `#{one}` Actual: `#{two}`" if one != two
end
assert_equal_u("Á",[193].pack('U'))
assert_equal_u("á",[225].pack('U'))
assert_equal_u("Ă",[258].pack('U'))
assert_equal_u("ă",[259].pack('U'))
assert_equal_u("∾",[8766].pack('U'))
assert_equal_u("∿",[8767].pack('U'))
assert_equal_u("∾",[8766, 819].pack('U'))
assert_equal_u("Â",[194].pack('U'))
assert_equal_u("â",[226].pack('U'))
assert_equal_u("´",[180].pack('U'))
assert_equal_u("А",[1040].pack('U'))
assert_equal_u("а",[1072].pack('U'))
assert_equal_u("Æ",[198].pack('U'))
assert_equal_u("æ",[230].pack('U'))
assert_equal_u("⁡",[8289].pack('U'))
assert_equal_u("𝔄",[120068].pack('U'))
assert_equal_u("𝔞",[120094].pack('U'))
assert_equal_u("À",[192].pack('U'))
assert_equal_u("à",[224].pack('U'))
assert_equal_u("ℵ",[8501].pack('U'))
assert_equal_u("ℵ",[8501].pack('U'))
assert_equal_u("Α",[913].pack('U'))
assert_equal_u("α",[945].pack('U'))
assert_equal_u("Ā",[256].pack('U'))
assert_equal_u("ā",[257].pack('U'))
assert_equal_u("⨿",[10815].pack('U'))
assert_equal_u("&",[38].pack('U'))
assert_equal_u("&",[38].pack('U'))
assert_equal_u("⩓",[10835].pack('U'))
assert_equal_u("∧",[8743].pack('U'))
assert_equal_u("⩕",[10837].pack('U'))
assert_equal_u("⩜",[10844].pack('U'))
assert_equal_u("⩘",[10840].pack('U'))
assert_equal_u("⩚",[10842].pack('U'))
assert_equal_u("∠",[8736].pack('U'))
assert_equal_u("⦤",[10660].pack('U'))
assert_equal_u("∠",[8736].pack('U'))
assert_equal_u("∡",[8737].pack('U'))
assert_equal_u("⦨",[10664].pack('U'))
assert_equal_u("⦩",[10665].pack('U'))
assert_equal_u("⦪",[10666].pack('U'))
assert_equal_u("⦫",[10667].pack('U'))
assert_equal_u("⦬",[10668].pack('U'))
assert_equal_u("⦭",[10669].pack('U'))
assert_equal_u("⦮",[10670].pack('U'))
assert_equal_u("⦯",[10671].pack('U'))
assert_equal_u("∟",[8735].pack('U'))
assert_equal_u("⊾",[8894].pack('U'))
assert_equal_u("⦝",[10653].pack('U'))
assert_equal_u("∢",[8738].pack('U'))
assert_equal_u("Å",[197].pack('U'))
assert_equal_u("⍼",[9084].pack('U'))
assert_equal_u("Ą",[260].pack('U'))
assert_equal_u("ą",[261].pack('U'))
assert_equal_u("𝔸",[120120].pack('U'))
assert_equal_u("𝕒",[120146].pack('U'))
assert_equal_u("≈",[8776].pack('U'))
assert_equal_u("⩯",[10863].pack('U'))
assert_equal_u("⩰",[10864].pack('U'))
assert_equal_u("≊",[8778].pack('U'))
assert_equal_u("≋",[8779].pack('U'))
assert_equal_u("'",[39].pack('U'))
assert_equal_u("⁡",[8289].pack('U'))
assert_equal_u("≈",[8776].pack('U'))
assert_equal_u("≊",[8778].pack('U'))
assert_equal_u("Å",[197].pack('U'))
assert_equal_u("å",[229].pack('U'))
assert_equal_u("𝒜",[119964].pack('U'))
assert_equal_u("𝒶",[119990].pack('U'))
assert_equal_u("≔",[8788].pack('U'))
assert_equal_u("*",[42].pack('U'))
assert_equal_u("≈",[8776].pack('U'))
assert_equal_u("≍",[8781].pack('U'))
assert_equal_u("Ã",[195].pack('U'))
assert_equal_u("ã",[227].pack('U'))
assert_equal_u("Ä",[196].pack('U'))
assert_equal_u("ä",[228].pack('U'))
assert_equal_u("∳",[8755].pack('U'))
assert_equal_u("⨑",[10769].pack('U'))
assert_equal_u("≌",[8780].pack('U'))
assert_equal_u("϶",[1014].pack('U'))
assert_equal_u("‵",[8245].pack('U'))
assert_equal_u("∽",[8765].pack('U'))
assert_equal_u("⋍",[8909].pack('U'))
assert_equal_u("∖",[8726].pack('U'))
assert_equal_u("⫧",[10983].pack('U'))
assert_equal_u("⊽",[8893].pack('U'))
assert_equal_u("⌆",[8966].pack('U'))
assert_equal_u("⌅",[8965].pack('U'))
assert_equal_u("⌅",[8965].pack('U'))
assert_equal_u("⎵",[9141].pack('U'))
assert_equal_u("⎶",[9142].pack('U'))
assert_equal_u("≌",[8780].pack('U'))
assert_equal_u("Б",[1041].pack('U'))
assert_equal_u("б",[1073].pack('U'))
assert_equal_u("„",[8222].pack('U'))
assert_equal_u("∵",[8757].pack('U'))
assert_equal_u("∵",[8757].pack('U'))
assert_equal_u("∵",[8757].pack('U'))
assert_equal_u("⦰",[10672].pack('U'))
assert_equal_u("϶",[1014].pack('U'))
assert_equal_u("ℬ",[8492].pack('U'))
assert_equal_u("ℬ",[8492].pack('U'))
assert_equal_u("Β",[914].pack('U'))
assert_equal_u("β",[946].pack('U'))
assert_equal_u("ℶ",[8502].pack('U'))
assert_equal_u("≬",[8812].pack('U'))
assert_equal_u("𝔅",[120069].pack('U'))
assert_equal_u("𝔟",[120095].pack('U'))
assert_equal_u("⋂",[8898].pack('U'))
assert_equal_u("◯",[9711].pack('U'))
assert_equal_u("⋃",[8899].pack('U'))
assert_equal_u("⨀",[10752].pack('U'))
assert_equal_u("⨁",[10753].pack('U'))
assert_equal_u("⨂",[10754].pack('U'))
assert_equal_u("⨆",[10758].pack('U'))
assert_equal_u("★",[9733].pack('U'))
assert_equal_u("▽",[9661].pack('U'))
assert_equal_u("△",[9651].pack('U'))
assert_equal_u("⨄",[10756].pack('U'))
assert_equal_u("⋁",[8897].pack('U'))
assert_equal_u("⋀",[8896].pack('U'))
assert_equal_u("⤍",[10509].pack('U'))
assert_equal_u("⧫",[10731].pack('U'))
assert_equal_u("▪",[9642].pack('U'))
assert_equal_u("▴",[9652].pack('U'))
assert_equal_u("▾",[9662].pack('U'))
assert_equal_u("◂",[9666].pack('U'))
assert_equal_u("▸",[9656].pack('U'))
assert_equal_u("␣",[9251].pack('U'))
assert_equal_u("▒",[9618].pack('U'))
assert_equal_u("░",[9617].pack('U'))
assert_equal_u("▓",[9619].pack('U'))
assert_equal_u("█",[9608].pack('U'))
assert_equal_u("=",[61, 8421].pack('U'))
assert_equal_u("≡",[8801, 8421].pack('U'))
assert_equal_u("⫭",[10989].pack('U'))
assert_equal_u("⌐",[8976].pack('U'))
assert_equal_u("𝔹",[120121].pack('U'))
assert_equal_u("𝕓",[120147].pack('U'))
assert_equal_u("⊥",[8869].pack('U'))
assert_equal_u("⊥",[8869].pack('U'))
assert_equal_u("⋈",[8904].pack('U'))
assert_equal_u("⧉",[10697].pack('U'))
assert_equal_u("╗",[9559].pack('U'))
assert_equal_u("╖",[9558].pack('U'))
assert_equal_u("╕",[9557].pack('U'))
assert_equal_u("┐",[9488].pack('U'))
assert_equal_u("╔",[9556].pack('U'))
assert_equal_u("╓",[9555].pack('U'))
assert_equal_u("╒",[9554].pack('U'))
assert_equal_u("┌",[9484].pack('U'))
assert_equal_u("═",[9552].pack('U'))
assert_equal_u("─",[9472].pack('U'))
assert_equal_u("╦",[9574].pack('U'))
assert_equal_u("╤",[9572].pack('U'))
assert_equal_u("╥",[9573].pack('U'))
assert_equal_u("┬",[9516].pack('U'))
assert_equal_u("╩",[9577].pack('U'))
assert_equal_u("╧",[9575].pack('U'))
assert_equal_u("╨",[9576].pack('U'))
assert_equal_u("┴",[9524].pack('U'))
assert_equal_u("⊟",[8863].pack('U'))
assert_equal_u("⊞",[8862].pack('U'))
assert_equal_u("⊠",[8864].pack('U'))
assert_equal_u("╝",[9565].pack('U'))
assert_equal_u("╜",[9564].pack('U'))
assert_equal_u("╛",[9563].pack('U'))
assert_equal_u("┘",[9496].pack('U'))
assert_equal_u("╚",[9562].pack('U'))
assert_equal_u("╙",[9561].pack('U'))
assert_equal_u("╘",[9560].pack('U'))
assert_equal_u("└",[9492].pack('U'))
assert_equal_u("║",[9553].pack('U'))
assert_equal_u("│",[9474].pack('U'))
assert_equal_u("╬",[9580].pack('U'))
assert_equal_u("╫",[9579].pack('U'))
assert_equal_u("╪",[9578].pack('U'))
assert_equal_u("┼",[9532].pack('U'))
assert_equal_u("╣",[9571].pack('U'))
assert_equal_u("╢",[9570].pack('U'))
assert_equal_u("╡",[9569].pack('U'))
assert_equal_u("┤",[9508].pack('U'))
assert_equal_u("╠",[9568].pack('U'))
assert_equal_u("╟",[9567].pack('U'))
assert_equal_u("╞",[9566].pack('U'))
assert_equal_u("├",[9500].pack('U'))
assert_equal_u("‵",[8245].pack('U'))
assert_equal_u("˘",[728].pack('U'))
assert_equal_u("˘",[728].pack('U'))
assert_equal_u("¦",[166].pack('U'))
assert_equal_u("ℬ",[8492].pack('U'))
assert_equal_u("𝒷",[119991].pack('U'))
assert_equal_u("⁏",[8271].pack('U'))
assert_equal_u("∽",[8765].pack('U'))
assert_equal_u("⋍",[8909].pack('U'))
assert_equal_u("\\",[92].pack('U'))
assert_equal_u("⧅",[10693].pack('U'))
assert_equal_u("⟈",[10184].pack('U'))
assert_equal_u("•",[8226].pack('U'))
assert_equal_u("•",[8226].pack('U'))
assert_equal_u("≎",[8782].pack('U'))
assert_equal_u("⪮",[10926].pack('U'))
assert_equal_u("≏",[8783].pack('U'))
assert_equal_u("≎",[8782].pack('U'))
assert_equal_u("≏",[8783].pack('U'))
assert_equal_u("Ć",[262].pack('U'))
assert_equal_u("ć",[263].pack('U'))
assert_equal_u("⋒",[8914].pack('U'))
assert_equal_u("∩",[8745].pack('U'))
assert_equal_u("⩄",[10820].pack('U'))
assert_equal_u("⩉",[10825].pack('U'))
assert_equal_u("⩋",[10827].pack('U'))
assert_equal_u("⩇",[10823].pack('U'))
assert_equal_u("⩀",[10816].pack('U'))
assert_equal_u("ⅅ",[8517].pack('U'))
assert_equal_u("∩",[8745, 65024].pack('U'))
assert_equal_u("⁁",[8257].pack('U'))
assert_equal_u("ˇ",[711].pack('U'))
assert_equal_u("ℭ",[8493].pack('U'))
assert_equal_u("⩍",[10829].pack('U'))
assert_equal_u("Č",[268].pack('U'))
assert_equal_u("č",[269].pack('U'))
assert_equal_u("Ç",[199].pack('U'))
assert_equal_u("ç",[231].pack('U'))
assert_equal_u("Ĉ",[264].pack('U'))
assert_equal_u("ĉ",[265].pack('U'))
assert_equal_u("∰",[8752].pack('U'))
assert_equal_u("⩌",[10828].pack('U'))
assert_equal_u("⩐",[10832].pack('U'))
assert_equal_u("Ċ",[266].pack('U'))
assert_equal_u("ċ",[267].pack('U'))
assert_equal_u("¸",[184].pack('U'))
assert_equal_u("¸",[184].pack('U'))
assert_equal_u("⦲",[10674].pack('U'))
assert_equal_u("¢",[162].pack('U'))
assert_equal_u("·",[183].pack('U'))
assert_equal_u("·",[183].pack('U'))
assert_equal_u("ℭ",[8493].pack('U'))
assert_equal_u("𝔠",[120096].pack('U'))
assert_equal_u("Ч",[1063].pack('U'))
assert_equal_u("ч",[1095].pack('U'))
assert_equal_u("✓",[10003].pack('U'))
assert_equal_u("✓",[10003].pack('U'))
assert_equal_u("Χ",[935].pack('U'))
assert_equal_u("χ",[967].pack('U'))
assert_equal_u("○",[9675].pack('U'))
assert_equal_u("ˆ",[710].pack('U'))
assert_equal_u("≗",[8791].pack('U'))
assert_equal_u("↺",[8634].pack('U'))
assert_equal_u("↻",[8635].pack('U'))
assert_equal_u("⊛",[8859].pack('U'))
assert_equal_u("⊚",[8858].pack('U'))
assert_equal_u("⊝",[8861].pack('U'))
assert_equal_u("⊙",[8857].pack('U'))
assert_equal_u("®",[174].pack('U'))
assert_equal_u("Ⓢ",[9416].pack('U'))
assert_equal_u("⊖",[8854].pack('U'))
assert_equal_u("⊕",[8853].pack('U'))
assert_equal_u("⊗",[8855].pack('U'))
assert_equal_u("⧃",[10691].pack('U'))
assert_equal_u("≗",[8791].pack('U'))
assert_equal_u("⨐",[10768].pack('U'))
assert_equal_u("⫯",[10991].pack('U'))
assert_equal_u("⧂",[10690].pack('U'))
assert_equal_u("∲",[8754].pack('U'))
assert_equal_u("”",[8221].pack('U'))
assert_equal_u("’",[8217].pack('U'))
assert_equal_u("♣",[9827].pack('U'))
assert_equal_u("♣",[9827].pack('U'))
assert_equal_u("∷",[8759].pack('U'))
assert_equal_u(":",[58].pack('U'))
assert_equal_u("⩴",[10868].pack('U'))
assert_equal_u("≔",[8788].pack('U'))
assert_equal_u("≔",[8788].pack('U'))
assert_equal_u(",",[44].pack('U'))
assert_equal_u("@",[64].pack('U'))
assert_equal_u("∁",[8705].pack('U'))
assert_equal_u("∘",[8728].pack('U'))
assert_equal_u("∁",[8705].pack('U'))
assert_equal_u("ℂ",[8450].pack('U'))
assert_equal_u("≅",[8773].pack('U'))
assert_equal_u("⩭",[10861].pack('U'))
assert_equal_u("≡",[8801].pack('U'))
assert_equal_u("∯",[8751].pack('U'))
assert_equal_u("∮",[8750].pack('U'))
assert_equal_u("∮",[8750].pack('U'))
assert_equal_u("ℂ",[8450].pack('U'))
assert_equal_u("𝕔",[120148].pack('U'))
assert_equal_u("∐",[8720].pack('U'))
assert_equal_u("∐",[8720].pack('U'))
assert_equal_u("©",[169].pack('U'))
assert_equal_u("©",[169].pack('U'))
assert_equal_u("℗",[8471].pack('U'))
assert_equal_u("∳",[8755].pack('U'))
assert_equal_u("↵",[8629].pack('U'))
assert_equal_u("⨯",[10799].pack('U'))
assert_equal_u("✗",[10007].pack('U'))
assert_equal_u("𝒞",[119966].pack('U'))
assert_equal_u("𝒸",[119992].pack('U'))
assert_equal_u("⫏",[10959].pack('U'))
assert_equal_u("⫑",[10961].pack('U'))
assert_equal_u("⫐",[10960].pack('U'))
assert_equal_u("⫒",[10962].pack('U'))
assert_equal_u("⋯",[8943].pack('U'))
assert_equal_u("⤸",[10552].pack('U'))
assert_equal_u("⤵",[10549].pack('U'))
assert_equal_u("⋞",[8926].pack('U'))
assert_equal_u("⋟",[8927].pack('U'))
assert_equal_u("↶",[8630].pack('U'))
assert_equal_u("⤽",[10557].pack('U'))
assert_equal_u("⋓",[8915].pack('U'))
assert_equal_u("∪",[8746].pack('U'))
assert_equal_u("⩈",[10824].pack('U'))
assert_equal_u("≍",[8781].pack('U'))
assert_equal_u("⩆",[10822].pack('U'))
assert_equal_u("⩊",[10826].pack('U'))
assert_equal_u("⊍",[8845].pack('U'))
assert_equal_u("⩅",[10821].pack('U'))
assert_equal_u("∪",[8746, 65024].pack('U'))
assert_equal_u("↷",[8631].pack('U'))
assert_equal_u("⤼",[10556].pack('U'))
assert_equal_u("⋞",[8926].pack('U'))
assert_equal_u("⋟",[8927].pack('U'))
assert_equal_u("⋎",[8910].pack('U'))
assert_equal_u("⋏",[8911].pack('U'))
assert_equal_u("¤",[164].pack('U'))
assert_equal_u("↶",[8630].pack('U'))
assert_equal_u("↷",[8631].pack('U'))
assert_equal_u("⋎",[8910].pack('U'))
assert_equal_u("⋏",[8911].pack('U'))
assert_equal_u("∲",[8754].pack('U'))
assert_equal_u("∱",[8753].pack('U'))
assert_equal_u("⌭",[9005].pack('U'))
assert_equal_u("‡",[8225].pack('U'))
assert_equal_u("†",[8224].pack('U'))
assert_equal_u("ℸ",[8504].pack('U'))
assert_equal_u("↡",[8609].pack('U'))
assert_equal_u("⇓",[8659].pack('U'))
assert_equal_u("↓",[8595].pack('U'))
assert_equal_u("‐",[8208].pack('U'))
assert_equal_u("⫤",[10980].pack('U'))
assert_equal_u("⊣",[8867].pack('U'))
assert_equal_u("⤏",[10511].pack('U'))
assert_equal_u("˝",[733].pack('U'))
assert_equal_u("Ď",[270].pack('U'))
assert_equal_u("ď",[271].pack('U'))
assert_equal_u("Д",[1044].pack('U'))
assert_equal_u("д",[1076].pack('U'))
assert_equal_u("ⅅ",[8517].pack('U'))
assert_equal_u("ⅆ",[8518].pack('U'))
assert_equal_u("‡",[8225].pack('U'))
assert_equal_u("⇊",[8650].pack('U'))
assert_equal_u("⤑",[10513].pack('U'))
assert_equal_u("⩷",[10871].pack('U'))
assert_equal_u("°",[176].pack('U'))
assert_equal_u("∇",[8711].pack('U'))
assert_equal_u("Δ",[916].pack('U'))
assert_equal_u("δ",[948].pack('U'))
assert_equal_u("⦱",[10673].pack('U'))
assert_equal_u("⥿",[10623].pack('U'))
assert_equal_u("𝔇",[120071].pack('U'))
assert_equal_u("𝔡",[120097].pack('U'))
assert_equal_u("⥥",[10597].pack('U'))
assert_equal_u("⇃",[8643].pack('U'))
assert_equal_u("⇂",[8642].pack('U'))
assert_equal_u("´",[180].pack('U'))
assert_equal_u("˙",[729].pack('U'))
assert_equal_u("˝",[733].pack('U'))
assert_equal_u("`",[96].pack('U'))
assert_equal_u("˜",[732].pack('U'))
assert_equal_u("⋄",[8900].pack('U'))
assert_equal_u("⋄",[8900].pack('U'))
assert_equal_u("⋄",[8900].pack('U'))
assert_equal_u("♦",[9830].pack('U'))
assert_equal_u("♦",[9830].pack('U'))
assert_equal_u("¨",[168].pack('U'))
assert_equal_u("ⅆ",[8518].pack('U'))
assert_equal_u("ϝ",[989].pack('U'))
assert_equal_u("⋲",[8946].pack('U'))
assert_equal_u("÷",[247].pack('U'))
assert_equal_u("÷",[247].pack('U'))
assert_equal_u("⋇",[8903].pack('U'))
assert_equal_u("⋇",[8903].pack('U'))
assert_equal_u("Ђ",[1026].pack('U'))
assert_equal_u("ђ",[1106].pack('U'))
assert_equal_u("⌞",[8990].pack('U'))
assert_equal_u("⌍",[8973].pack('U'))
assert_equal_u("$",[36].pack('U'))
assert_equal_u("𝔻",[120123].pack('U'))
assert_equal_u("𝕕",[120149].pack('U'))
assert_equal_u("¨",[168].pack('U'))
assert_equal_u("˙",[729].pack('U'))
assert_equal_u("⃜",[8412].pack('U'))
assert_equal_u("≐",[8784].pack('U'))
assert_equal_u("≑",[8785].pack('U'))
assert_equal_u("≐",[8784].pack('U'))
assert_equal_u("∸",[8760].pack('U'))
assert_equal_u("∔",[8724].pack('U'))
assert_equal_u("⊡",[8865].pack('U'))
assert_equal_u("⌆",[8966].pack('U'))
assert_equal_u("∯",[8751].pack('U'))
assert_equal_u("¨",[168].pack('U'))
assert_equal_u("⇓",[8659].pack('U'))
assert_equal_u("⇐",[8656].pack('U'))
assert_equal_u("⇔",[8660].pack('U'))
assert_equal_u("⫤",[10980].pack('U'))
assert_equal_u("⟸",[10232].pack('U'))
assert_equal_u("⟺",[10234].pack('U'))
assert_equal_u("⟹",[10233].pack('U'))
assert_equal_u("⇒",[8658].pack('U'))
assert_equal_u("⊨",[8872].pack('U'))
assert_equal_u("⇑",[8657].pack('U'))
assert_equal_u("⇕",[8661].pack('U'))
assert_equal_u("∥",[8741].pack('U'))
assert_equal_u("↓",[8595].pack('U'))
assert_equal_u("⇓",[8659].pack('U'))
assert_equal_u("↓",[8595].pack('U'))
assert_equal_u("⤓",[10515].pack('U'))
assert_equal_u("⇵",[8693].pack('U'))
assert_equal_u("̑",[785].pack('U'))
assert_equal_u("⇊",[8650].pack('U'))
assert_equal_u("⇃",[8643].pack('U'))
assert_equal_u("⇂",[8642].pack('U'))
assert_equal_u("⥐",[10576].pack('U'))
assert_equal_u("⥞",[10590].pack('U'))
assert_equal_u("↽",[8637].pack('U'))
assert_equal_u("⥖",[10582].pack('U'))
assert_equal_u("⥟",[10591].pack('U'))
assert_equal_u("⇁",[8641].pack('U'))
assert_equal_u("⥗",[10583].pack('U'))
assert_equal_u("⊤",[8868].pack('U'))
assert_equal_u("↧",[8615].pack('U'))
assert_equal_u("⤐",[10512].pack('U'))
assert_equal_u("⌟",[8991].pack('U'))
assert_equal_u("⌌",[8972].pack('U'))
assert_equal_u("𝒟",[119967].pack('U'))
assert_equal_u("𝒹",[119993].pack('U'))
assert_equal_u("Ѕ",[1029].pack('U'))
assert_equal_u("ѕ",[1109].pack('U'))
assert_equal_u("⧶",[10742].pack('U'))
assert_equal_u("Đ",[272].pack('U'))
assert_equal_u("đ",[273].pack('U'))
assert_equal_u("⋱",[8945].pack('U'))
assert_equal_u("▿",[9663].pack('U'))
assert_equal_u("▾",[9662].pack('U'))
assert_equal_u("⇵",[8693].pack('U'))
assert_equal_u("⥯",[10607].pack('U'))
assert_equal_u("⦦",[10662].pack('U'))
assert_equal_u("Џ",[1039].pack('U'))
assert_equal_u("џ",[1119].pack('U'))
assert_equal_u("⟿",[10239].pack('U'))
assert_equal_u("É",[201].pack('U'))
assert_equal_u("é",[233].pack('U'))
assert_equal_u("⩮",[10862].pack('U'))
assert_equal_u("Ě",[282].pack('U'))
assert_equal_u("ě",[283].pack('U'))
assert_equal_u("≖",[8790].pack('U'))
assert_equal_u("Ê",[202].pack('U'))
assert_equal_u("ê",[234].pack('U'))
assert_equal_u("≕",[8789].pack('U'))
assert_equal_u("Э",[1069].pack('U'))
assert_equal_u("э",[1101].pack('U'))
assert_equal_u("⩷",[10871].pack('U'))
assert_equal_u("Ė",[278].pack('U'))
assert_equal_u("≑",[8785].pack('U'))
assert_equal_u("ė",[279].pack('U'))
assert_equal_u("ⅇ",[8519].pack('U'))
assert_equal_u("≒",[8786].pack('U'))
assert_equal_u("𝔈",[120072].pack('U'))
assert_equal_u("𝔢",[120098].pack('U'))
assert_equal_u("⪚",[10906].pack('U'))
assert_equal_u("È",[200].pack('U'))
assert_equal_u("è",[232].pack('U'))
assert_equal_u("⪖",[10902].pack('U'))
assert_equal_u("⪘",[10904].pack('U'))
assert_equal_u("⪙",[10905].pack('U'))
assert_equal_u("∈",[8712].pack('U'))
assert_equal_u("⏧",[9191].pack('U'))
assert_equal_u("ℓ",[8467].pack('U'))
assert_equal_u("⪕",[10901].pack('U'))
assert_equal_u("⪗",[10903].pack('U'))
assert_equal_u("Ē",[274].pack('U'))
assert_equal_u("ē",[275].pack('U'))
assert_equal_u("∅",[8709].pack('U'))
assert_equal_u("∅",[8709].pack('U'))
assert_equal_u("◻",[9723].pack('U'))
assert_equal_u("∅",[8709].pack('U'))
assert_equal_u("▫",[9643].pack('U'))
assert_equal_u(" ",[8195].pack('U'))
assert_equal_u(" ",[8196].pack('U'))
assert_equal_u(" ",[8197].pack('U'))
assert_equal_u("Ŋ",[330].pack('U'))
assert_equal_u("ŋ",[331].pack('U'))
assert_equal_u(" ",[8194].pack('U'))
assert_equal_u("Ę",[280].pack('U'))
assert_equal_u("ę",[281].pack('U'))
assert_equal_u("𝔼",[120124].pack('U'))
assert_equal_u("𝕖",[120150].pack('U'))
assert_equal_u("⋕",[8917].pack('U'))
assert_equal_u("⧣",[10723].pack('U'))
assert_equal_u("⩱",[10865].pack('U'))
assert_equal_u("ε",[949].pack('U'))
assert_equal_u("Ε",[917].pack('U'))
assert_equal_u("ε",[949].pack('U'))
assert_equal_u("ϵ",[1013].pack('U'))
assert_equal_u("≖",[8790].pack('U'))
assert_equal_u("≕",[8789].pack('U'))
assert_equal_u("≂",[8770].pack('U'))
assert_equal_u("⪖",[10902].pack('U'))
assert_equal_u("⪕",[10901].pack('U'))
assert_equal_u("⩵",[10869].pack('U'))
assert_equal_u("=",[61].pack('U'))
assert_equal_u("≂",[8770].pack('U'))
assert_equal_u("≟",[8799].pack('U'))
assert_equal_u("⇌",[8652].pack('U'))
assert_equal_u("≡",[8801].pack('U'))
assert_equal_u("⩸",[10872].pack('U'))
assert_equal_u("⧥",[10725].pack('U'))
assert_equal_u("⥱",[10609].pack('U'))
assert_equal_u("≓",[8787].pack('U'))
assert_equal_u("ℰ",[8496].pack('U'))
assert_equal_u("ℯ",[8495].pack('U'))
assert_equal_u("≐",[8784].pack('U'))
assert_equal_u("⩳",[10867].pack('U'))
assert_equal_u("≂",[8770].pack('U'))
assert_equal_u("Η",[919].pack('U'))
assert_equal_u("η",[951].pack('U'))
assert_equal_u("Ð",[208].pack('U'))
assert_equal_u("ð",[240].pack('U'))
assert_equal_u("Ë",[203].pack('U'))
assert_equal_u("ë",[235].pack('U'))
assert_equal_u("€",[8364].pack('U'))
assert_equal_u("!",[33].pack('U'))
assert_equal_u("∃",[8707].pack('U'))
assert_equal_u("∃",[8707].pack('U'))
assert_equal_u("ℰ",[8496].pack('U'))
assert_equal_u("ⅇ",[8519].pack('U'))
assert_equal_u("ⅇ",[8519].pack('U'))
assert_equal_u("≒",[8786].pack('U'))
assert_equal_u("Ф",[1060].pack('U'))
assert_equal_u("ф",[1092].pack('U'))
assert_equal_u("♀",[9792].pack('U'))
assert_equal_u("ﬃ",[64259].pack('U'))
assert_equal_u("ﬀ",[64256].pack('U'))
assert_equal_u("ﬄ",[64260].pack('U'))
assert_equal_u("𝔉",[120073].pack('U'))
assert_equal_u("𝔣",[120099].pack('U'))
assert_equal_u("ﬁ",[64257].pack('U'))
assert_equal_u("◼",[9724].pack('U'))
assert_equal_u("▪",[9642].pack('U'))
assert_equal_u("f",[102, 106].pack('U'))
assert_equal_u("♭",[9837].pack('U'))
assert_equal_u("ﬂ",[64258].pack('U'))
assert_equal_u("▱",[9649].pack('U'))
assert_equal_u("ƒ",[402].pack('U'))
assert_equal_u("𝔽",[120125].pack('U'))
assert_equal_u("𝕗",[120151].pack('U'))
assert_equal_u("∀",[8704].pack('U'))
assert_equal_u("∀",[8704].pack('U'))
assert_equal_u("⋔",[8916].pack('U'))
assert_equal_u("⫙",[10969].pack('U'))
assert_equal_u("ℱ",[8497].pack('U'))
assert_equal_u("⨍",[10765].pack('U'))
assert_equal_u("½",[189].pack('U'))
assert_equal_u("⅓",[8531].pack('U'))
assert_equal_u("¼",[188].pack('U'))
assert_equal_u("⅕",[8533].pack('U'))
assert_equal_u("⅙",[8537].pack('U'))
assert_equal_u("⅛",[8539].pack('U'))
assert_equal_u("⅔",[8532].pack('U'))
assert_equal_u("⅖",[8534].pack('U'))
assert_equal_u("¾",[190].pack('U'))
assert_equal_u("⅗",[8535].pack('U'))
assert_equal_u("⅜",[8540].pack('U'))
assert_equal_u("⅘",[8536].pack('U'))
assert_equal_u("⅚",[8538].pack('U'))
assert_equal_u("⅝",[8541].pack('U'))
assert_equal_u("⅞",[8542].pack('U'))
assert_equal_u("⁄",[8260].pack('U'))
assert_equal_u("⌢",[8994].pack('U'))
assert_equal_u("ℱ",[8497].pack('U'))
assert_equal_u("𝒻",[119995].pack('U'))
assert_equal_u("ǵ",[501].pack('U'))
assert_equal_u("Γ",[915].pack('U'))
assert_equal_u("γ",[947].pack('U'))
assert_equal_u("Ϝ",[988].pack('U'))
assert_equal_u("ϝ",[989].pack('U'))
assert_equal_u("⪆",[10886].pack('U'))
assert_equal_u("Ğ",[286].pack('U'))
assert_equal_u("ğ",[287].pack('U'))
assert_equal_u("Ģ",[290].pack('U'))
assert_equal_u("Ĝ",[284].pack('U'))
assert_equal_u("ĝ",[285].pack('U'))
assert_equal_u("Г",[1043].pack('U'))
assert_equal_u("г",[1075].pack('U'))
assert_equal_u("Ġ",[288].pack('U'))
assert_equal_u("ġ",[289].pack('U'))
assert_equal_u("≧",[8807].pack('U'))
assert_equal_u("≥",[8805].pack('U'))
assert_equal_u("⪌",[10892].pack('U'))
assert_equal_u("⋛",[8923].pack('U'))
assert_equal_u("≥",[8805].pack('U'))
assert_equal_u("≧",[8807].pack('U'))
assert_equal_u("⩾",[10878].pack('U'))
assert_equal_u("⩾",[10878].pack('U'))
assert_equal_u("⪩",[10921].pack('U'))
assert_equal_u("⪀",[10880].pack('U'))
assert_equal_u("⪂",[10882].pack('U'))
assert_equal_u("⪄",[10884].pack('U'))
assert_equal_u("⋛",[8923, 65024].pack('U'))
assert_equal_u("⪔",[10900].pack('U'))
assert_equal_u("𝔊",[120074].pack('U'))
assert_equal_u("𝔤",[120100].pack('U'))
assert_equal_u("⋙",[8921].pack('U'))
assert_equal_u("≫",[8811].pack('U'))
assert_equal_u("⋙",[8921].pack('U'))
assert_equal_u("ℷ",[8503].pack('U'))
assert_equal_u("Ѓ",[1027].pack('U'))
assert_equal_u("ѓ",[1107].pack('U'))
assert_equal_u("≷",[8823].pack('U'))
assert_equal_u("⪥",[10917].pack('U'))
assert_equal_u("⪒",[10898].pack('U'))
assert_equal_u("⪤",[10916].pack('U'))
assert_equal_u("⪊",[10890].pack('U'))
assert_equal_u("⪊",[10890].pack('U'))
assert_equal_u("≩",[8809].pack('U'))
assert_equal_u("⪈",[10888].pack('U'))
assert_equal_u("⪈",[10888].pack('U'))
assert_equal_u("≩",[8809].pack('U'))
assert_equal_u("⋧",[8935].pack('U'))
assert_equal_u("𝔾",[120126].pack('U'))
assert_equal_u("𝕘",[120152].pack('U'))
assert_equal_u("`",[96].pack('U'))
assert_equal_u("≥",[8805].pack('U'))
assert_equal_u("⋛",[8923].pack('U'))
assert_equal_u("≧",[8807].pack('U'))
assert_equal_u("⪢",[10914].pack('U'))
assert_equal_u("≷",[8823].pack('U'))
assert_equal_u("⩾",[10878].pack('U'))
assert_equal_u("≳",[8819].pack('U'))
assert_equal_u("𝒢",[119970].pack('U'))
assert_equal_u("ℊ",[8458].pack('U'))
assert_equal_u("≳",[8819].pack('U'))
assert_equal_u("⪎",[10894].pack('U'))
assert_equal_u("⪐",[10896].pack('U'))
assert_equal_u(">",[62].pack('U'))
assert_equal_u("≫",[8811].pack('U'))
assert_equal_u(">",[62].pack('U'))
assert_equal_u("⪧",[10919].pack('U'))
assert_equal_u("⩺",[10874].pack('U'))
assert_equal_u("⋗",[8919].pack('U'))
assert_equal_u("⦕",[10645].pack('U'))
assert_equal_u("⩼",[10876].pack('U'))
assert_equal_u("⪆",[10886].pack('U'))
assert_equal_u("⥸",[10616].pack('U'))
assert_equal_u("⋗",[8919].pack('U'))
assert_equal_u("⋛",[8923].pack('U'))
assert_equal_u("⪌",[10892].pack('U'))
assert_equal_u("≷",[8823].pack('U'))
assert_equal_u("≳",[8819].pack('U'))
assert_equal_u("≩",[8809, 65024].pack('U'))
assert_equal_u("≩",[8809, 65024].pack('U'))
assert_equal_u("ˇ",[711].pack('U'))
assert_equal_u(" ",[8202].pack('U'))
assert_equal_u("½",[189].pack('U'))
assert_equal_u("ℋ",[8459].pack('U'))
assert_equal_u("Ъ",[1066].pack('U'))
assert_equal_u("ъ",[1098].pack('U'))
assert_equal_u("⇔",[8660].pack('U'))
assert_equal_u("↔",[8596].pack('U'))
assert_equal_u("⥈",[10568].pack('U'))
assert_equal_u("↭",[8621].pack('U'))
assert_equal_u("^",[94].pack('U'))
assert_equal_u("ℏ",[8463].pack('U'))
assert_equal_u("Ĥ",[292].pack('U'))
assert_equal_u("ĥ",[293].pack('U'))
assert_equal_u("♥",[9829].pack('U'))
assert_equal_u("♥",[9829].pack('U'))
assert_equal_u("…",[8230].pack('U'))
assert_equal_u("⊹",[8889].pack('U'))
assert_equal_u("ℌ",[8460].pack('U'))
assert_equal_u("𝔥",[120101].pack('U'))
assert_equal_u("ℋ",[8459].pack('U'))
assert_equal_u("⤥",[10533].pack('U'))
assert_equal_u("⤦",[10534].pack('U'))
assert_equal_u("⇿",[8703].pack('U'))
assert_equal_u("∻",[8763].pack('U'))
assert_equal_u("↩",[8617].pack('U'))
assert_equal_u("↪",[8618].pack('U'))
assert_equal_u("ℍ",[8461].pack('U'))
assert_equal_u("𝕙",[120153].pack('U'))
assert_equal_u("―",[8213].pack('U'))
assert_equal_u("─",[9472].pack('U'))
assert_equal_u("ℋ",[8459].pack('U'))
assert_equal_u("𝒽",[119997].pack('U'))
assert_equal_u("ℏ",[8463].pack('U'))
assert_equal_u("Ħ",[294].pack('U'))
assert_equal_u("ħ",[295].pack('U'))
assert_equal_u("≎",[8782].pack('U'))
assert_equal_u("≏",[8783].pack('U'))
assert_equal_u("⁃",[8259].pack('U'))
assert_equal_u("‐",[8208].pack('U'))
assert_equal_u("Í",[205].pack('U'))
assert_equal_u("í",[237].pack('U'))
assert_equal_u("⁣",[8291].pack('U'))
assert_equal_u("Î",[206].pack('U'))
assert_equal_u("î",[238].pack('U'))
assert_equal_u("И",[1048].pack('U'))
assert_equal_u("и",[1080].pack('U'))
assert_equal_u("İ",[304].pack('U'))
assert_equal_u("Е",[1045].pack('U'))
assert_equal_u("е",[1077].pack('U'))
assert_equal_u("¡",[161].pack('U'))
assert_equal_u("⇔",[8660].pack('U'))
assert_equal_u("ℑ",[8465].pack('U'))
assert_equal_u("𝔦",[120102].pack('U'))
assert_equal_u("Ì",[204].pack('U'))
assert_equal_u("ì",[236].pack('U'))
assert_equal_u("ⅈ",[8520].pack('U'))
assert_equal_u("⨌",[10764].pack('U'))
assert_equal_u("∭",[8749].pack('U'))
assert_equal_u("⧜",[10716].pack('U'))
assert_equal_u("℩",[8489].pack('U'))
assert_equal_u("Ĳ",[306].pack('U'))
assert_equal_u("ĳ",[307].pack('U'))
assert_equal_u("ℑ",[8465].pack('U'))
assert_equal_u("Ī",[298].pack('U'))
assert_equal_u("ī",[299].pack('U'))
assert_equal_u("ℑ",[8465].pack('U'))
assert_equal_u("ⅈ",[8520].pack('U'))
assert_equal_u("ℐ",[8464].pack('U'))
assert_equal_u("ℑ",[8465].pack('U'))
assert_equal_u("ı",[305].pack('U'))
assert_equal_u("⊷",[8887].pack('U'))
assert_equal_u("Ƶ",[437].pack('U'))
assert_equal_u("⇒",[8658].pack('U'))
assert_equal_u("∈",[8712].pack('U'))
assert_equal_u("℅",[8453].pack('U'))
assert_equal_u("∞",[8734].pack('U'))
assert_equal_u("⧝",[10717].pack('U'))
assert_equal_u("ı",[305].pack('U'))
assert_equal_u("∬",[8748].pack('U'))
assert_equal_u("∫",[8747].pack('U'))
assert_equal_u("⊺",[8890].pack('U'))
assert_equal_u("ℤ",[8484].pack('U'))
assert_equal_u("∫",[8747].pack('U'))
assert_equal_u("⊺",[8890].pack('U'))
assert_equal_u("⋂",[8898].pack('U'))
assert_equal_u("⨗",[10775].pack('U'))
assert_equal_u("⨼",[10812].pack('U'))
assert_equal_u("⁣",[8291].pack('U'))
assert_equal_u("⁢",[8290].pack('U'))
assert_equal_u("Ё",[1025].pack('U'))
assert_equal_u("ё",[1105].pack('U'))
assert_equal_u("Į",[302].pack('U'))
assert_equal_u("į",[303].pack('U'))
assert_equal_u("𝕀",[120128].pack('U'))
assert_equal_u("𝕚",[120154].pack('U'))
assert_equal_u("Ι",[921].pack('U'))
assert_equal_u("ι",[953].pack('U'))
assert_equal_u("⨼",[10812].pack('U'))
assert_equal_u("¿",[191].pack('U'))
assert_equal_u("ℐ",[8464].pack('U'))
assert_equal_u("𝒾",[119998].pack('U'))
assert_equal_u("∈",[8712].pack('U'))
assert_equal_u("⋵",[8949].pack('U'))
assert_equal_u("⋹",[8953].pack('U'))
assert_equal_u("⋴",[8948].pack('U'))
assert_equal_u("⋳",[8947].pack('U'))
assert_equal_u("∈",[8712].pack('U'))
assert_equal_u("⁢",[8290].pack('U'))
assert_equal_u("Ĩ",[296].pack('U'))
assert_equal_u("ĩ",[297].pack('U'))
assert_equal_u("І",[1030].pack('U'))
assert_equal_u("і",[1110].pack('U'))
assert_equal_u("Ï",[207].pack('U'))
assert_equal_u("ï",[239].pack('U'))
assert_equal_u("Ĵ",[308].pack('U'))
assert_equal_u("ĵ",[309].pack('U'))
assert_equal_u("Й",[1049].pack('U'))
assert_equal_u("й",[1081].pack('U'))
assert_equal_u("𝔍",[120077].pack('U'))
assert_equal_u("𝔧",[120103].pack('U'))
assert_equal_u("ȷ",[567].pack('U'))
assert_equal_u("𝕁",[120129].pack('U'))
assert_equal_u("𝕛",[120155].pack('U'))
assert_equal_u("𝒥",[119973].pack('U'))
assert_equal_u("𝒿",[119999].pack('U'))
assert_equal_u("Ј",[1032].pack('U'))
assert_equal_u("ј",[1112].pack('U'))
assert_equal_u("Є",[1028].pack('U'))
assert_equal_u("є",[1108].pack('U'))
assert_equal_u("Κ",[922].pack('U'))
assert_equal_u("κ",[954].pack('U'))
assert_equal_u("ϰ",[1008].pack('U'))
assert_equal_u("Ķ",[310].pack('U'))
assert_equal_u("ķ",[311].pack('U'))
assert_equal_u("К",[1050].pack('U'))
assert_equal_u("к",[1082].pack('U'))
assert_equal_u("𝔎",[120078].pack('U'))
assert_equal_u("𝔨",[120104].pack('U'))
assert_equal_u("ĸ",[312].pack('U'))
assert_equal_u("Х",[1061].pack('U'))
assert_equal_u("х",[1093].pack('U'))
assert_equal_u("Ќ",[1036].pack('U'))
assert_equal_u("ќ",[1116].pack('U'))
assert_equal_u("𝕂",[120130].pack('U'))
assert_equal_u("𝕜",[120156].pack('U'))
assert_equal_u("𝒦",[119974].pack('U'))
assert_equal_u("𝓀",[120000].pack('U'))
assert_equal_u("⇚",[8666].pack('U'))
assert_equal_u("Ĺ",[313].pack('U'))
assert_equal_u("ĺ",[314].pack('U'))
assert_equal_u("⦴",[10676].pack('U'))
assert_equal_u("ℒ",[8466].pack('U'))
assert_equal_u("Λ",[923].pack('U'))
assert_equal_u("λ",[955].pack('U'))
assert_equal_u("⟪",[10218].pack('U'))
assert_equal_u("⟨",[10216].pack('U'))
assert_equal_u("⦑",[10641].pack('U'))
assert_equal_u("⟨",[10216].pack('U'))
assert_equal_u("⪅",[10885].pack('U'))
assert_equal_u("ℒ",[8466].pack('U'))
assert_equal_u("«",[171].pack('U'))
assert_equal_u("↞",[8606].pack('U'))
assert_equal_u("⇐",[8656].pack('U'))
assert_equal_u("←",[8592].pack('U'))
assert_equal_u("⇤",[8676].pack('U'))
assert_equal_u("⤟",[10527].pack('U'))
assert_equal_u("⤝",[10525].pack('U'))
assert_equal_u("↩",[8617].pack('U'))
assert_equal_u("↫",[8619].pack('U'))
assert_equal_u("⤹",[10553].pack('U'))
assert_equal_u("⥳",[10611].pack('U'))
assert_equal_u("↢",[8610].pack('U'))
assert_equal_u("⪫",[10923].pack('U'))
assert_equal_u("⤛",[10523].pack('U'))
assert_equal_u("⤙",[10521].pack('U'))
assert_equal_u("⪭",[10925].pack('U'))
assert_equal_u("⪭",[10925, 65024].pack('U'))
assert_equal_u("⤎",[10510].pack('U'))
assert_equal_u("⤌",[10508].pack('U'))
assert_equal_u("❲",[10098].pack('U'))
assert_equal_u("{",[123].pack('U'))
assert_equal_u("[",[91].pack('U'))
assert_equal_u("⦋",[10635].pack('U'))
assert_equal_u("⦏",[10639].pack('U'))
assert_equal_u("⦍",[10637].pack('U'))
assert_equal_u("Ľ",[317].pack('U'))
assert_equal_u("ľ",[318].pack('U'))
assert_equal_u("Ļ",[315].pack('U'))
assert_equal_u("ļ",[316].pack('U'))
assert_equal_u("⌈",[8968].pack('U'))
assert_equal_u("{",[123].pack('U'))
assert_equal_u("Л",[1051].pack('U'))
assert_equal_u("л",[1083].pack('U'))
assert_equal_u("⤶",[10550].pack('U'))
assert_equal_u("“",[8220].pack('U'))
assert_equal_u("„",[8222].pack('U'))
assert_equal_u("⥧",[10599].pack('U'))
assert_equal_u("⥋",[10571].pack('U'))
assert_equal_u("↲",[8626].pack('U'))
assert_equal_u("≦",[8806].pack('U'))
assert_equal_u("≤",[8804].pack('U'))
assert_equal_u("⟨",[10216].pack('U'))
assert_equal_u("←",[8592].pack('U'))
assert_equal_u("⇐",[8656].pack('U'))
assert_equal_u("←",[8592].pack('U'))
assert_equal_u("⇤",[8676].pack('U'))
assert_equal_u("⇆",[8646].pack('U'))
assert_equal_u("↢",[8610].pack('U'))
assert_equal_u("⌈",[8968].pack('U'))
assert_equal_u("⟦",[10214].pack('U'))
assert_equal_u("⥡",[10593].pack('U'))
assert_equal_u("⇃",[8643].pack('U'))
assert_equal_u("⥙",[10585].pack('U'))
assert_equal_u("⌊",[8970].pack('U'))
assert_equal_u("↽",[8637].pack('U'))
assert_equal_u("↼",[8636].pack('U'))
assert_equal_u("⇇",[8647].pack('U'))
assert_equal_u("↔",[8596].pack('U'))
assert_equal_u("⇔",[8660].pack('U'))
assert_equal_u("↔",[8596].pack('U'))
assert_equal_u("⇆",[8646].pack('U'))
assert_equal_u("⇋",[8651].pack('U'))
assert_equal_u("↭",[8621].pack('U'))
assert_equal_u("⥎",[10574].pack('U'))
assert_equal_u("⊣",[8867].pack('U'))
assert_equal_u("↤",[8612].pack('U'))
assert_equal_u("⥚",[10586].pack('U'))
assert_equal_u("⋋",[8907].pack('U'))
assert_equal_u("⊲",[8882].pack('U'))
assert_equal_u("⧏",[10703].pack('U'))
assert_equal_u("⊴",[8884].pack('U'))
assert_equal_u("⥑",[10577].pack('U'))
assert_equal_u("⥠",[10592].pack('U'))
assert_equal_u("↿",[8639].pack('U'))
assert_equal_u("⥘",[10584].pack('U'))
assert_equal_u("↼",[8636].pack('U'))
assert_equal_u("⥒",[10578].pack('U'))
assert_equal_u("⪋",[10891].pack('U'))
assert_equal_u("⋚",[8922].pack('U'))
assert_equal_u("≤",[8804].pack('U'))
assert_equal_u("≦",[8806].pack('U'))
assert_equal_u("⩽",[10877].pack('U'))
assert_equal_u("⩽",[10877].pack('U'))
assert_equal_u("⪨",[10920].pack('U'))
assert_equal_u("⩿",[10879].pack('U'))
assert_equal_u("⪁",[10881].pack('U'))
assert_equal_u("⪃",[10883].pack('U'))
assert_equal_u("⋚",[8922, 65024].pack('U'))
assert_equal_u("⪓",[10899].pack('U'))
assert_equal_u("⪅",[10885].pack('U'))
assert_equal_u("⋖",[8918].pack('U'))
assert_equal_u("⋚",[8922].pack('U'))
assert_equal_u("⪋",[10891].pack('U'))
assert_equal_u("⋚",[8922].pack('U'))
assert_equal_u("≦",[8806].pack('U'))
assert_equal_u("≶",[8822].pack('U'))
assert_equal_u("≶",[8822].pack('U'))
assert_equal_u("⪡",[10913].pack('U'))
assert_equal_u("≲",[8818].pack('U'))
assert_equal_u("⩽",[10877].pack('U'))
assert_equal_u("≲",[8818].pack('U'))
assert_equal_u("⥼",[10620].pack('U'))
assert_equal_u("⌊",[8970].pack('U'))
assert_equal_u("𝔏",[120079].pack('U'))
assert_equal_u("𝔩",[120105].pack('U'))
assert_equal_u("≶",[8822].pack('U'))
assert_equal_u("⪑",[10897].pack('U'))
assert_equal_u("⥢",[10594].pack('U'))
assert_equal_u("↽",[8637].pack('U'))
assert_equal_u("↼",[8636].pack('U'))
assert_equal_u("⥪",[10602].pack('U'))
assert_equal_u("▄",[9604].pack('U'))
assert_equal_u("Љ",[1033].pack('U'))
assert_equal_u("љ",[1113].pack('U'))
assert_equal_u("⋘",[8920].pack('U'))
assert_equal_u("≪",[8810].pack('U'))
assert_equal_u("⇇",[8647].pack('U'))
assert_equal_u("⌞",[8990].pack('U'))
assert_equal_u("⇚",[8666].pack('U'))
assert_equal_u("⥫",[10603].pack('U'))
assert_equal_u("◺",[9722].pack('U'))
assert_equal_u("Ŀ",[319].pack('U'))
assert_equal_u("ŀ",[320].pack('U'))
assert_equal_u("⎰",[9136].pack('U'))
assert_equal_u("⎰",[9136].pack('U'))
assert_equal_u("⪉",[10889].pack('U'))
assert_equal_u("⪉",[10889].pack('U'))
assert_equal_u("≨",[8808].pack('U'))
assert_equal_u("⪇",[10887].pack('U'))
assert_equal_u("⪇",[10887].pack('U'))
assert_equal_u("≨",[8808].pack('U'))
assert_equal_u("⋦",[8934].pack('U'))
assert_equal_u("⟬",[10220].pack('U'))
assert_equal_u("⇽",[8701].pack('U'))
assert_equal_u("⟦",[10214].pack('U'))
assert_equal_u("⟵",[10229].pack('U'))
assert_equal_u("⟸",[10232].pack('U'))
assert_equal_u("⟵",[10229].pack('U'))
assert_equal_u("⟷",[10231].pack('U'))
assert_equal_u("⟺",[10234].pack('U'))
assert_equal_u("⟷",[10231].pack('U'))
assert_equal_u("⟼",[10236].pack('U'))
assert_equal_u("⟶",[10230].pack('U'))
assert_equal_u("⟹",[10233].pack('U'))
assert_equal_u("⟶",[10230].pack('U'))
assert_equal_u("↫",[8619].pack('U'))
assert_equal_u("↬",[8620].pack('U'))
assert_equal_u("⦅",[10629].pack('U'))
assert_equal_u("𝕃",[120131].pack('U'))
assert_equal_u("𝕝",[120157].pack('U'))
assert_equal_u("⨭",[10797].pack('U'))
assert_equal_u("⨴",[10804].pack('U'))
assert_equal_u("∗",[8727].pack('U'))
assert_equal_u("_",[95].pack('U'))
assert_equal_u("↙",[8601].pack('U'))
assert_equal_u("↘",[8600].pack('U'))
assert_equal_u("◊",[9674].pack('U'))
assert_equal_u("◊",[9674].pack('U'))
assert_equal_u("⧫",[10731].pack('U'))
assert_equal_u("(",[40].pack('U'))
assert_equal_u("⦓",[10643].pack('U'))
assert_equal_u("⇆",[8646].pack('U'))
assert_equal_u("⌟",[8991].pack('U'))
assert_equal_u("⇋",[8651].pack('U'))
assert_equal_u("⥭",[10605].pack('U'))
assert_equal_u("‎",[8206].pack('U'))
assert_equal_u("⊿",[8895].pack('U'))
assert_equal_u("‹",[8249].pack('U'))
assert_equal_u("ℒ",[8466].pack('U'))
assert_equal_u("𝓁",[120001].pack('U'))
assert_equal_u("↰",[8624].pack('U'))
assert_equal_u("↰",[8624].pack('U'))
assert_equal_u("≲",[8818].pack('U'))
assert_equal_u("⪍",[10893].pack('U'))
assert_equal_u("⪏",[10895].pack('U'))
assert_equal_u("[",[91].pack('U'))
assert_equal_u("‘",[8216].pack('U'))
assert_equal_u("‚",[8218].pack('U'))
assert_equal_u("Ł",[321].pack('U'))
assert_equal_u("ł",[322].pack('U'))
assert_equal_u("<",[60].pack('U'))
assert_equal_u("≪",[8810].pack('U'))
assert_equal_u("<",[60].pack('U'))
assert_equal_u("⪦",[10918].pack('U'))
assert_equal_u("⩹",[10873].pack('U'))
assert_equal_u("⋖",[8918].pack('U'))
assert_equal_u("⋋",[8907].pack('U'))
assert_equal_u("⋉",[8905].pack('U'))
assert_equal_u("⥶",[10614].pack('U'))
assert_equal_u("⩻",[10875].pack('U'))
assert_equal_u("◃",[9667].pack('U'))
assert_equal_u("⊴",[8884].pack('U'))
assert_equal_u("◂",[9666].pack('U'))
assert_equal_u("⦖",[10646].pack('U'))
assert_equal_u("⥊",[10570].pack('U'))
assert_equal_u("⥦",[10598].pack('U'))
assert_equal_u("≨",[8808, 65024].pack('U'))
assert_equal_u("≨",[8808, 65024].pack('U'))
assert_equal_u("¯",[175].pack('U'))
assert_equal_u("♂",[9794].pack('U'))
assert_equal_u("✠",[10016].pack('U'))
assert_equal_u("✠",[10016].pack('U'))
assert_equal_u("⤅",[10501].pack('U'))
assert_equal_u("↦",[8614].pack('U'))
assert_equal_u("↦",[8614].pack('U'))
assert_equal_u("↧",[8615].pack('U'))
assert_equal_u("↤",[8612].pack('U'))
assert_equal_u("↥",[8613].pack('U'))
assert_equal_u("▮",[9646].pack('U'))
assert_equal_u("⨩",[10793].pack('U'))
assert_equal_u("М",[1052].pack('U'))
assert_equal_u("м",[1084].pack('U'))
assert_equal_u("—",[8212].pack('U'))
assert_equal_u("∺",[8762].pack('U'))
assert_equal_u("∡",[8737].pack('U'))
assert_equal_u(" ",[8287].pack('U'))
assert_equal_u("ℳ",[8499].pack('U'))
assert_equal_u("𝔐",[120080].pack('U'))
assert_equal_u("𝔪",[120106].pack('U'))
assert_equal_u("℧",[8487].pack('U'))
assert_equal_u("µ",[181].pack('U'))
assert_equal_u("∣",[8739].pack('U'))
assert_equal_u("*",[42].pack('U'))
assert_equal_u("⫰",[10992].pack('U'))
assert_equal_u("·",[183].pack('U'))
assert_equal_u("−",[8722].pack('U'))
assert_equal_u("⊟",[8863].pack('U'))
assert_equal_u("∸",[8760].pack('U'))
assert_equal_u("⨪",[10794].pack('U'))
assert_equal_u("∓",[8723].pack('U'))
assert_equal_u("⫛",[10971].pack('U'))
assert_equal_u("…",[8230].pack('U'))
assert_equal_u("∓",[8723].pack('U'))
assert_equal_u("⊧",[8871].pack('U'))
assert_equal_u("𝕄",[120132].pack('U'))
assert_equal_u("𝕞",[120158].pack('U'))
assert_equal_u("∓",[8723].pack('U'))
assert_equal_u("ℳ",[8499].pack('U'))
assert_equal_u("𝓂",[120002].pack('U'))
assert_equal_u("∾",[8766].pack('U'))
assert_equal_u("Μ",[924].pack('U'))
assert_equal_u("μ",[956].pack('U'))
assert_equal_u("⊸",[8888].pack('U'))
assert_equal_u("⊸",[8888].pack('U'))
assert_equal_u("∇",[8711].pack('U'))
assert_equal_u("Ń",[323].pack('U'))
assert_equal_u("ń",[324].pack('U'))
assert_equal_u("∠",[8736, 8402].pack('U'))
assert_equal_u("≉",[8777].pack('U'))
assert_equal_u("⩰",[10864, 824].pack('U'))
assert_equal_u("≋",[8779, 824].pack('U'))
assert_equal_u("ŉ",[329].pack('U'))
assert_equal_u("≉",[8777].pack('U'))
assert_equal_u("♮",[9838].pack('U'))
assert_equal_u("♮",[9838].pack('U'))
assert_equal_u("ℕ",[8469].pack('U'))
assert_equal_u(" ",[160].pack('U'))
assert_equal_u("≎",[8782, 824].pack('U'))
assert_equal_u("≏",[8783, 824].pack('U'))
assert_equal_u("⩃",[10819].pack('U'))
assert_equal_u("Ň",[327].pack('U'))
assert_equal_u("ň",[328].pack('U'))
assert_equal_u("Ņ",[325].pack('U'))
assert_equal_u("ņ",[326].pack('U'))
assert_equal_u("≇",[8775].pack('U'))
assert_equal_u("⩭",[10861, 824].pack('U'))
assert_equal_u("⩂",[10818].pack('U'))
assert_equal_u("Н",[1053].pack('U'))
assert_equal_u("н",[1085].pack('U'))
assert_equal_u("–",[8211].pack('U'))
assert_equal_u("≠",[8800].pack('U'))
assert_equal_u("⤤",[10532].pack('U'))
assert_equal_u("⇗",[8663].pack('U'))
assert_equal_u("↗",[8599].pack('U'))
assert_equal_u("↗",[8599].pack('U'))
assert_equal_u("≐",[8784, 824].pack('U'))
assert_equal_u("​",[8203].pack('U'))
assert_equal_u("​",[8203].pack('U'))
assert_equal_u("​",[8203].pack('U'))
assert_equal_u("​",[8203].pack('U'))
assert_equal_u("≢",[8802].pack('U'))
assert_equal_u("⤨",[10536].pack('U'))
assert_equal_u("≂",[8770, 824].pack('U'))
assert_equal_u("≫",[8811].pack('U'))
assert_equal_u("≪",[8810].pack('U'))
assert_equal_u("\n",[10].pack('U'))
assert_equal_u("∄",[8708].pack('U'))
assert_equal_u("∄",[8708].pack('U'))
assert_equal_u("𝔑",[120081].pack('U'))
assert_equal_u("𝔫",[120107].pack('U'))
assert_equal_u("≧",[8807, 824].pack('U'))
assert_equal_u("≱",[8817].pack('U'))
assert_equal_u("≱",[8817].pack('U'))
assert_equal_u("≧",[8807, 824].pack('U'))
assert_equal_u("⩾",[10878, 824].pack('U'))
assert_equal_u("⩾",[10878, 824].pack('U'))
assert_equal_u("⋙",[8921, 824].pack('U'))
assert_equal_u("≵",[8821].pack('U'))
assert_equal_u("≫",[8811, 8402].pack('U'))
assert_equal_u("≯",[8815].pack('U'))
assert_equal_u("≯",[8815].pack('U'))
assert_equal_u("≫",[8811, 824].pack('U'))
assert_equal_u("⇎",[8654].pack('U'))
assert_equal_u("↮",[8622].pack('U'))
assert_equal_u("⫲",[10994].pack('U'))
assert_equal_u("∋",[8715].pack('U'))
assert_equal_u("⋼",[8956].pack('U'))
assert_equal_u("⋺",[8954].pack('U'))
assert_equal_u("∋",[8715].pack('U'))
assert_equal_u("Њ",[1034].pack('U'))
assert_equal_u("њ",[1114].pack('U'))
assert_equal_u("⇍",[8653].pack('U'))
assert_equal_u("↚",[8602].pack('U'))
assert_equal_u("‥",[8229].pack('U'))
assert_equal_u("≦",[8806, 824].pack('U'))
assert_equal_u("≰",[8816].pack('U'))
assert_equal_u("⇍",[8653].pack('U'))
assert_equal_u("↚",[8602].pack('U'))
assert_equal_u("⇎",[8654].pack('U'))
assert_equal_u("↮",[8622].pack('U'))
assert_equal_u("≰",[8816].pack('U'))
assert_equal_u("≦",[8806, 824].pack('U'))
assert_equal_u("⩽",[10877, 824].pack('U'))
assert_equal_u("⩽",[10877, 824].pack('U'))
assert_equal_u("≮",[8814].pack('U'))
assert_equal_u("⋘",[8920, 824].pack('U'))
assert_equal_u("≴",[8820].pack('U'))
assert_equal_u("≪",[8810, 8402].pack('U'))
assert_equal_u("≮",[8814].pack('U'))
assert_equal_u("⋪",[8938].pack('U'))
assert_equal_u("⋬",[8940].pack('U'))
assert_equal_u("≪",[8810, 824].pack('U'))
assert_equal_u("∤",[8740].pack('U'))
assert_equal_u("⁠",[8288].pack('U'))
assert_equal_u(" ",[160].pack('U'))
assert_equal_u("ℕ",[8469].pack('U'))
assert_equal_u("𝕟",[120159].pack('U'))
assert_equal_u("⫬",[10988].pack('U'))
assert_equal_u("¬",[172].pack('U'))
assert_equal_u("≢",[8802].pack('U'))
assert_equal_u("≭",[8813].pack('U'))
assert_equal_u("∦",[8742].pack('U'))
assert_equal_u("∉",[8713].pack('U'))
assert_equal_u("≠",[8800].pack('U'))
assert_equal_u("≂",[8770, 824].pack('U'))
assert_equal_u("∄",[8708].pack('U'))
assert_equal_u("≯",[8815].pack('U'))
assert_equal_u("≱",[8817].pack('U'))
assert_equal_u("≧",[8807, 824].pack('U'))
assert_equal_u("≫",[8811, 824].pack('U'))
assert_equal_u("≹",[8825].pack('U'))
assert_equal_u("⩾",[10878, 824].pack('U'))
assert_equal_u("≵",[8821].pack('U'))
assert_equal_u("≎",[8782, 824].pack('U'))
assert_equal_u("≏",[8783, 824].pack('U'))
assert_equal_u("∉",[8713].pack('U'))
assert_equal_u("⋵",[8949, 824].pack('U'))
assert_equal_u("⋹",[8953, 824].pack('U'))
assert_equal_u("∉",[8713].pack('U'))
assert_equal_u("⋷",[8951].pack('U'))
assert_equal_u("⋶",[8950].pack('U'))
assert_equal_u("⋪",[8938].pack('U'))
assert_equal_u("⧏",[10703, 824].pack('U'))
assert_equal_u("⋬",[8940].pack('U'))
assert_equal_u("≮",[8814].pack('U'))
assert_equal_u("≰",[8816].pack('U'))
assert_equal_u("≸",[8824].pack('U'))
assert_equal_u("≪",[8810, 824].pack('U'))
assert_equal_u("⩽",[10877, 824].pack('U'))
assert_equal_u("≴",[8820].pack('U'))
assert_equal_u("⪢",[10914, 824].pack('U'))
assert_equal_u("⪡",[10913, 824].pack('U'))
assert_equal_u("∌",[8716].pack('U'))
assert_equal_u("∌",[8716].pack('U'))
assert_equal_u("⋾",[8958].pack('U'))
assert_equal_u("⋽",[8957].pack('U'))
assert_equal_u("⊀",[8832].pack('U'))
assert_equal_u("⪯",[10927, 824].pack('U'))
assert_equal_u("⋠",[8928].pack('U'))
assert_equal_u("∌",[8716].pack('U'))
assert_equal_u("⋫",[8939].pack('U'))
assert_equal_u("⧐",[10704, 824].pack('U'))
assert_equal_u("⋭",[8941].pack('U'))
assert_equal_u("⊏",[8847, 824].pack('U'))
assert_equal_u("⋢",[8930].pack('U'))
assert_equal_u("⊐",[8848, 824].pack('U'))
assert_equal_u("⋣",[8931].pack('U'))
assert_equal_u("⊂",[8834, 8402].pack('U'))
assert_equal_u("⊈",[8840].pack('U'))
assert_equal_u("⊁",[8833].pack('U'))
assert_equal_u("⪰",[10928, 824].pack('U'))
assert_equal_u("⋡",[8929].pack('U'))
assert_equal_u("≿",[8831, 824].pack('U'))
assert_equal_u("⊃",[8835, 8402].pack('U'))
assert_equal_u("⊉",[8841].pack('U'))
assert_equal_u("≁",[8769].pack('U'))
assert_equal_u("≄",[8772].pack('U'))
assert_equal_u("≇",[8775].pack('U'))
assert_equal_u("≉",[8777].pack('U'))
assert_equal_u("∤",[8740].pack('U'))
assert_equal_u("∦",[8742].pack('U'))
assert_equal_u("∦",[8742].pack('U'))
assert_equal_u("⫽",[11005, 8421].pack('U'))
assert_equal_u("∂",[8706, 824].pack('U'))
assert_equal_u("⨔",[10772].pack('U'))
assert_equal_u("⊀",[8832].pack('U'))
assert_equal_u("⋠",[8928].pack('U'))
assert_equal_u("⪯",[10927, 824].pack('U'))
assert_equal_u("⊀",[8832].pack('U'))
assert_equal_u("⪯",[10927, 824].pack('U'))
assert_equal_u("⇏",[8655].pack('U'))
assert_equal_u("↛",[8603].pack('U'))
assert_equal_u("⤳",[10547, 824].pack('U'))
assert_equal_u("↝",[8605, 824].pack('U'))
assert_equal_u("⇏",[8655].pack('U'))
assert_equal_u("↛",[8603].pack('U'))
assert_equal_u("⋫",[8939].pack('U'))
assert_equal_u("⋭",[8941].pack('U'))
assert_equal_u("⊁",[8833].pack('U'))
assert_equal_u("⋡",[8929].pack('U'))
assert_equal_u("⪰",[10928, 824].pack('U'))
assert_equal_u("𝒩",[119977].pack('U'))
assert_equal_u("𝓃",[120003].pack('U'))
assert_equal_u("∤",[8740].pack('U'))
assert_equal_u("∦",[8742].pack('U'))
assert_equal_u("≁",[8769].pack('U'))
assert_equal_u("≄",[8772].pack('U'))
assert_equal_u("≄",[8772].pack('U'))
assert_equal_u("∤",[8740].pack('U'))
assert_equal_u("∦",[8742].pack('U'))
assert_equal_u("⋢",[8930].pack('U'))
assert_equal_u("⋣",[8931].pack('U'))
assert_equal_u("⊄",[8836].pack('U'))
assert_equal_u("⫅",[10949, 824].pack('U'))
assert_equal_u("⊈",[8840].pack('U'))
assert_equal_u("⊂",[8834, 8402].pack('U'))
assert_equal_u("⊈",[8840].pack('U'))
assert_equal_u("⫅",[10949, 824].pack('U'))
assert_equal_u("⊁",[8833].pack('U'))
assert_equal_u("⪰",[10928, 824].pack('U'))
assert_equal_u("⊅",[8837].pack('U'))
assert_equal_u("⫆",[10950, 824].pack('U'))
assert_equal_u("⊉",[8841].pack('U'))
assert_equal_u("⊃",[8835, 8402].pack('U'))
assert_equal_u("⊉",[8841].pack('U'))
assert_equal_u("⫆",[10950, 824].pack('U'))
assert_equal_u("≹",[8825].pack('U'))
assert_equal_u("Ñ",[209].pack('U'))
assert_equal_u("ñ",[241].pack('U'))
assert_equal_u("≸",[8824].pack('U'))
assert_equal_u("⋪",[8938].pack('U'))
assert_equal_u("⋬",[8940].pack('U'))
assert_equal_u("⋫",[8939].pack('U'))
assert_equal_u("⋭",[8941].pack('U'))
assert_equal_u("Ν",[925].pack('U'))
assert_equal_u("ν",[957].pack('U'))
assert_equal_u("#",[35].pack('U'))
assert_equal_u("№",[8470].pack('U'))
assert_equal_u(" ",[8199].pack('U'))
assert_equal_u("≍",[8781, 8402].pack('U'))
assert_equal_u("⊯",[8879].pack('U'))
assert_equal_u("⊮",[8878].pack('U'))
assert_equal_u("⊭",[8877].pack('U'))
assert_equal_u("⊬",[8876].pack('U'))
assert_equal_u("≥",[8805, 8402].pack('U'))
assert_equal_u(">",[62, 8402].pack('U'))
assert_equal_u("⤄",[10500].pack('U'))
assert_equal_u("⧞",[10718].pack('U'))
assert_equal_u("⤂",[10498].pack('U'))
assert_equal_u("≤",[8804, 8402].pack('U'))
assert_equal_u("<",[60, 8402].pack('U'))
assert_equal_u("⊴",[8884, 8402].pack('U'))
assert_equal_u("⤃",[10499].pack('U'))
assert_equal_u("⊵",[8885, 8402].pack('U'))
assert_equal_u("∼",[8764, 8402].pack('U'))
assert_equal_u("⤣",[10531].pack('U'))
assert_equal_u("⇖",[8662].pack('U'))
assert_equal_u("↖",[8598].pack('U'))
assert_equal_u("↖",[8598].pack('U'))
assert_equal_u("⤧",[10535].pack('U'))
assert_equal_u("Ó",[211].pack('U'))
assert_equal_u("ó",[243].pack('U'))
assert_equal_u("⊛",[8859].pack('U'))
assert_equal_u("⊚",[8858].pack('U'))
assert_equal_u("Ô",[212].pack('U'))
assert_equal_u("ô",[244].pack('U'))
assert_equal_u("О",[1054].pack('U'))
assert_equal_u("о",[1086].pack('U'))
assert_equal_u("⊝",[8861].pack('U'))
assert_equal_u("Ő",[336].pack('U'))
assert_equal_u("ő",[337].pack('U'))
assert_equal_u("⨸",[10808].pack('U'))
assert_equal_u("⊙",[8857].pack('U'))
assert_equal_u("⦼",[10684].pack('U'))
assert_equal_u("Œ",[338].pack('U'))
assert_equal_u("œ",[339].pack('U'))
assert_equal_u("⦿",[10687].pack('U'))
assert_equal_u("𝔒",[120082].pack('U'))
assert_equal_u("𝔬",[120108].pack('U'))
assert_equal_u("˛",[731].pack('U'))
assert_equal_u("Ò",[210].pack('U'))
assert_equal_u("ò",[242].pack('U'))
assert_equal_u("⧁",[10689].pack('U'))
assert_equal_u("⦵",[10677].pack('U'))
assert_equal_u("Ω",[937].pack('U'))
assert_equal_u("∮",[8750].pack('U'))
assert_equal_u("↺",[8634].pack('U'))
assert_equal_u("⦾",[10686].pack('U'))
assert_equal_u("⦻",[10683].pack('U'))
assert_equal_u("‾",[8254].pack('U'))
assert_equal_u("⧀",[10688].pack('U'))
assert_equal_u("Ō",[332].pack('U'))
assert_equal_u("ō",[333].pack('U'))
assert_equal_u("Ω",[937].pack('U'))
assert_equal_u("ω",[969].pack('U'))
assert_equal_u("Ο",[927].pack('U'))
assert_equal_u("ο",[959].pack('U'))
assert_equal_u("⦶",[10678].pack('U'))
assert_equal_u("⊖",[8854].pack('U'))
assert_equal_u("𝕆",[120134].pack('U'))
assert_equal_u("𝕠",[120160].pack('U'))
assert_equal_u("⦷",[10679].pack('U'))
assert_equal_u("“",[8220].pack('U'))
assert_equal_u("‘",[8216].pack('U'))
assert_equal_u("⦹",[10681].pack('U'))
assert_equal_u("⊕",[8853].pack('U'))
assert_equal_u("⩔",[10836].pack('U'))
assert_equal_u("∨",[8744].pack('U'))
assert_equal_u("↻",[8635].pack('U'))
assert_equal_u("⩝",[10845].pack('U'))
assert_equal_u("ℴ",[8500].pack('U'))
assert_equal_u("ℴ",[8500].pack('U'))
assert_equal_u("ª",[170].pack('U'))
assert_equal_u("º",[186].pack('U'))
assert_equal_u("⊶",[8886].pack('U'))
assert_equal_u("⩖",[10838].pack('U'))
assert_equal_u("⩗",[10839].pack('U'))
assert_equal_u("⩛",[10843].pack('U'))
assert_equal_u("Ⓢ",[9416].pack('U'))
assert_equal_u("𝒪",[119978].pack('U'))
assert_equal_u("ℴ",[8500].pack('U'))
assert_equal_u("Ø",[216].pack('U'))
assert_equal_u("ø",[248].pack('U'))
assert_equal_u("⊘",[8856].pack('U'))
assert_equal_u("Õ",[213].pack('U'))
assert_equal_u("õ",[245].pack('U'))
assert_equal_u("⨷",[10807].pack('U'))
assert_equal_u("⊗",[8855].pack('U'))
assert_equal_u("⨶",[10806].pack('U'))
assert_equal_u("Ö",[214].pack('U'))
assert_equal_u("ö",[246].pack('U'))
assert_equal_u("⌽",[9021].pack('U'))
assert_equal_u("‾",[8254].pack('U'))
assert_equal_u("⏞",[9182].pack('U'))
assert_equal_u("⎴",[9140].pack('U'))
assert_equal_u("⏜",[9180].pack('U'))
assert_equal_u("∥",[8741].pack('U'))
assert_equal_u("¶",[182].pack('U'))
assert_equal_u("∥",[8741].pack('U'))
assert_equal_u("⫳",[10995].pack('U'))
assert_equal_u("⫽",[11005].pack('U'))
assert_equal_u("∂",[8706].pack('U'))
assert_equal_u("∂",[8706].pack('U'))
assert_equal_u("П",[1055].pack('U'))
assert_equal_u("п",[1087].pack('U'))
assert_equal_u("%",[37].pack('U'))
assert_equal_u(".",[46].pack('U'))
assert_equal_u("‰",[8240].pack('U'))
assert_equal_u("⊥",[8869].pack('U'))
assert_equal_u("‱",[8241].pack('U'))
assert_equal_u("𝔓",[120083].pack('U'))
assert_equal_u("𝔭",[120109].pack('U'))
assert_equal_u("Φ",[934].pack('U'))
assert_equal_u("φ",[966].pack('U'))
assert_equal_u("ϕ",[981].pack('U'))
assert_equal_u("ℳ",[8499].pack('U'))
assert_equal_u("☎",[9742].pack('U'))
assert_equal_u("Π",[928].pack('U'))
assert_equal_u("π",[960].pack('U'))
assert_equal_u("⋔",[8916].pack('U'))
assert_equal_u("ϖ",[982].pack('U'))
assert_equal_u("ℏ",[8463].pack('U'))
assert_equal_u("ℎ",[8462].pack('U'))
assert_equal_u("ℏ",[8463].pack('U'))
assert_equal_u("+",[43].pack('U'))
assert_equal_u("⨣",[10787].pack('U'))
assert_equal_u("⊞",[8862].pack('U'))
assert_equal_u("⨢",[10786].pack('U'))
assert_equal_u("∔",[8724].pack('U'))
assert_equal_u("⨥",[10789].pack('U'))
assert_equal_u("⩲",[10866].pack('U'))
assert_equal_u("±",[177].pack('U'))
assert_equal_u("±",[177].pack('U'))
assert_equal_u("⨦",[10790].pack('U'))
assert_equal_u("⨧",[10791].pack('U'))
assert_equal_u("±",[177].pack('U'))
assert_equal_u("ℌ",[8460].pack('U'))
assert_equal_u("⨕",[10773].pack('U'))
assert_equal_u("ℙ",[8473].pack('U'))
assert_equal_u("𝕡",[120161].pack('U'))
assert_equal_u("£",[163].pack('U'))
assert_equal_u("⪻",[10939].pack('U'))
assert_equal_u("≺",[8826].pack('U'))
assert_equal_u("⪷",[10935].pack('U'))
assert_equal_u("≼",[8828].pack('U'))
assert_equal_u("⪳",[10931].pack('U'))
assert_equal_u("⪯",[10927].pack('U'))
assert_equal_u("≺",[8826].pack('U'))
assert_equal_u("⪷",[10935].pack('U'))
assert_equal_u("≼",[8828].pack('U'))
assert_equal_u("≺",[8826].pack('U'))
assert_equal_u("⪯",[10927].pack('U'))
assert_equal_u("≼",[8828].pack('U'))
assert_equal_u("≾",[8830].pack('U'))
assert_equal_u("⪯",[10927].pack('U'))
assert_equal_u("⪹",[10937].pack('U'))
assert_equal_u("⪵",[10933].pack('U'))
assert_equal_u("⋨",[8936].pack('U'))
assert_equal_u("≾",[8830].pack('U'))
assert_equal_u("″",[8243].pack('U'))
assert_equal_u("′",[8242].pack('U'))
assert_equal_u("ℙ",[8473].pack('U'))
assert_equal_u("⪹",[10937].pack('U'))
assert_equal_u("⪵",[10933].pack('U'))
assert_equal_u("⋨",[8936].pack('U'))
assert_equal_u("∏",[8719].pack('U'))
assert_equal_u("∏",[8719].pack('U'))
assert_equal_u("⌮",[9006].pack('U'))
assert_equal_u("⌒",[8978].pack('U'))
assert_equal_u("⌓",[8979].pack('U'))
assert_equal_u("∝",[8733].pack('U'))
assert_equal_u("∷",[8759].pack('U'))
assert_equal_u("∝",[8733].pack('U'))
assert_equal_u("∝",[8733].pack('U'))
assert_equal_u("≾",[8830].pack('U'))
assert_equal_u("⊰",[8880].pack('U'))
assert_equal_u("𝒫",[119979].pack('U'))
assert_equal_u("𝓅",[120005].pack('U'))
assert_equal_u("Ψ",[936].pack('U'))
assert_equal_u("ψ",[968].pack('U'))
assert_equal_u(" ",[8200].pack('U'))
assert_equal_u("𝔔",[120084].pack('U'))
assert_equal_u("𝔮",[120110].pack('U'))
assert_equal_u("⨌",[10764].pack('U'))
assert_equal_u("ℚ",[8474].pack('U'))
assert_equal_u("𝕢",[120162].pack('U'))
assert_equal_u("⁗",[8279].pack('U'))
assert_equal_u("𝒬",[119980].pack('U'))
assert_equal_u("𝓆",[120006].pack('U'))
assert_equal_u("ℍ",[8461].pack('U'))
assert_equal_u("⨖",[10774].pack('U'))
assert_equal_u("?",[63].pack('U'))
assert_equal_u("≟",[8799].pack('U'))
assert_equal_u("\"",[34].pack('U'))
assert_equal_u("\"",[34].pack('U'))
assert_equal_u("⇛",[8667].pack('U'))
assert_equal_u("∽",[8765, 817].pack('U'))
assert_equal_u("Ŕ",[340].pack('U'))
assert_equal_u("ŕ",[341].pack('U'))
assert_equal_u("√",[8730].pack('U'))
assert_equal_u("⦳",[10675].pack('U'))
assert_equal_u("⟫",[10219].pack('U'))
assert_equal_u("⟩",[10217].pack('U'))
assert_equal_u("⦒",[10642].pack('U'))
assert_equal_u("⦥",[10661].pack('U'))
assert_equal_u("⟩",[10217].pack('U'))
assert_equal_u("»",[187].pack('U'))
assert_equal_u("↠",[8608].pack('U'))
assert_equal_u("⇒",[8658].pack('U'))
assert_equal_u("→",[8594].pack('U'))
assert_equal_u("⥵",[10613].pack('U'))
assert_equal_u("⇥",[8677].pack('U'))
assert_equal_u("⤠",[10528].pack('U'))
assert_equal_u("⤳",[10547].pack('U'))
assert_equal_u("⤞",[10526].pack('U'))
assert_equal_u("↪",[8618].pack('U'))
assert_equal_u("↬",[8620].pack('U'))
assert_equal_u("⥅",[10565].pack('U'))
assert_equal_u("⥴",[10612].pack('U'))
assert_equal_u("⤖",[10518].pack('U'))
assert_equal_u("↣",[8611].pack('U'))
assert_equal_u("↝",[8605].pack('U'))
assert_equal_u("⤜",[10524].pack('U'))
assert_equal_u("⤚",[10522].pack('U'))
assert_equal_u("∶",[8758].pack('U'))
assert_equal_u("ℚ",[8474].pack('U'))
assert_equal_u("⤐",[10512].pack('U'))
assert_equal_u("⤏",[10511].pack('U'))
assert_equal_u("⤍",[10509].pack('U'))
assert_equal_u("❳",[10099].pack('U'))
assert_equal_u("}",[125].pack('U'))
assert_equal_u("]",[93].pack('U'))
assert_equal_u("⦌",[10636].pack('U'))
assert_equal_u("⦎",[10638].pack('U'))
assert_equal_u("⦐",[10640].pack('U'))
assert_equal_u("Ř",[344].pack('U'))
assert_equal_u("ř",[345].pack('U'))
assert_equal_u("Ŗ",[342].pack('U'))
assert_equal_u("ŗ",[343].pack('U'))
assert_equal_u("⌉",[8969].pack('U'))
assert_equal_u("}",[125].pack('U'))
assert_equal_u("Р",[1056].pack('U'))
assert_equal_u("р",[1088].pack('U'))
assert_equal_u("⤷",[10551].pack('U'))
assert_equal_u("⥩",[10601].pack('U'))
assert_equal_u("”",[8221].pack('U'))
assert_equal_u("”",[8221].pack('U'))
assert_equal_u("↳",[8627].pack('U'))
assert_equal_u("ℜ",[8476].pack('U'))
assert_equal_u("ℜ",[8476].pack('U'))
assert_equal_u("ℛ",[8475].pack('U'))
assert_equal_u("ℜ",[8476].pack('U'))
assert_equal_u("ℝ",[8477].pack('U'))
assert_equal_u("▭",[9645].pack('U'))
assert_equal_u("®",[174].pack('U'))
assert_equal_u("®",[174].pack('U'))
assert_equal_u("∋",[8715].pack('U'))
assert_equal_u("⇋",[8651].pack('U'))
assert_equal_u("⥯",[10607].pack('U'))
assert_equal_u("⥽",[10621].pack('U'))
assert_equal_u("⌋",[8971].pack('U'))
assert_equal_u("ℜ",[8476].pack('U'))
assert_equal_u("𝔯",[120111].pack('U'))
assert_equal_u("⥤",[10596].pack('U'))
assert_equal_u("⇁",[8641].pack('U'))
assert_equal_u("⇀",[8640].pack('U'))
assert_equal_u("⥬",[10604].pack('U'))
assert_equal_u("Ρ",[929].pack('U'))
assert_equal_u("ρ",[961].pack('U'))
assert_equal_u("ϱ",[1009].pack('U'))
assert_equal_u("⟩",[10217].pack('U'))
assert_equal_u("→",[8594].pack('U'))
assert_equal_u("⇒",[8658].pack('U'))
assert_equal_u("→",[8594].pack('U'))
assert_equal_u("⇥",[8677].pack('U'))
assert_equal_u("⇄",[8644].pack('U'))
assert_equal_u("↣",[8611].pack('U'))
assert_equal_u("⌉",[8969].pack('U'))
assert_equal_u("⟧",[10215].pack('U'))
assert_equal_u("⥝",[10589].pack('U'))
assert_equal_u("⇂",[8642].pack('U'))
assert_equal_u("⥕",[10581].pack('U'))
assert_equal_u("⌋",[8971].pack('U'))
assert_equal_u("⇁",[8641].pack('U'))
assert_equal_u("⇀",[8640].pack('U'))
assert_equal_u("⇄",[8644].pack('U'))
assert_equal_u("⇌",[8652].pack('U'))
assert_equal_u("⇉",[8649].pack('U'))
assert_equal_u("↝",[8605].pack('U'))
assert_equal_u("⊢",[8866].pack('U'))
assert_equal_u("↦",[8614].pack('U'))
assert_equal_u("⥛",[10587].pack('U'))
assert_equal_u("⋌",[8908].pack('U'))
assert_equal_u("⊳",[8883].pack('U'))
assert_equal_u("⧐",[10704].pack('U'))
assert_equal_u("⊵",[8885].pack('U'))
assert_equal_u("⥏",[10575].pack('U'))
assert_equal_u("⥜",[10588].pack('U'))
assert_equal_u("↾",[8638].pack('U'))
assert_equal_u("⥔",[10580].pack('U'))
assert_equal_u("⇀",[8640].pack('U'))
assert_equal_u("⥓",[10579].pack('U'))
assert_equal_u("˚",[730].pack('U'))
assert_equal_u("≓",[8787].pack('U'))
assert_equal_u("⇄",[8644].pack('U'))
assert_equal_u("⇌",[8652].pack('U'))
assert_equal_u("‏",[8207].pack('U'))
assert_equal_u("⎱",[9137].pack('U'))
assert_equal_u("⎱",[9137].pack('U'))
assert_equal_u("⫮",[10990].pack('U'))
assert_equal_u("⟭",[10221].pack('U'))
assert_equal_u("⇾",[8702].pack('U'))
assert_equal_u("⟧",[10215].pack('U'))
assert_equal_u("⦆",[10630].pack('U'))
assert_equal_u("ℝ",[8477].pack('U'))
assert_equal_u("𝕣",[120163].pack('U'))
assert_equal_u("⨮",[10798].pack('U'))
assert_equal_u("⨵",[10805].pack('U'))
assert_equal_u("⥰",[10608].pack('U'))
assert_equal_u(")",[41].pack('U'))
assert_equal_u("⦔",[10644].pack('U'))
assert_equal_u("⨒",[10770].pack('U'))
assert_equal_u("⇉",[8649].pack('U'))
assert_equal_u("⇛",[8667].pack('U'))
assert_equal_u("›",[8250].pack('U'))
assert_equal_u("ℛ",[8475].pack('U'))
assert_equal_u("𝓇",[120007].pack('U'))
assert_equal_u("↱",[8625].pack('U'))
assert_equal_u("↱",[8625].pack('U'))
assert_equal_u("]",[93].pack('U'))
assert_equal_u("’",[8217].pack('U'))
assert_equal_u("’",[8217].pack('U'))
assert_equal_u("⋌",[8908].pack('U'))
assert_equal_u("⋊",[8906].pack('U'))
assert_equal_u("▹",[9657].pack('U'))
assert_equal_u("⊵",[8885].pack('U'))
assert_equal_u("▸",[9656].pack('U'))
assert_equal_u("⧎",[10702].pack('U'))
assert_equal_u("⧴",[10740].pack('U'))
assert_equal_u("⥨",[10600].pack('U'))
assert_equal_u("℞",[8478].pack('U'))
assert_equal_u("Ś",[346].pack('U'))
assert_equal_u("ś",[347].pack('U'))
assert_equal_u("‚",[8218].pack('U'))
assert_equal_u("⪼",[10940].pack('U'))
assert_equal_u("≻",[8827].pack('U'))
assert_equal_u("⪸",[10936].pack('U'))
assert_equal_u("Š",[352].pack('U'))
assert_equal_u("š",[353].pack('U'))
assert_equal_u("≽",[8829].pack('U'))
assert_equal_u("⪴",[10932].pack('U'))
assert_equal_u("⪰",[10928].pack('U'))
assert_equal_u("Ş",[350].pack('U'))
assert_equal_u("ş",[351].pack('U'))
assert_equal_u("Ŝ",[348].pack('U'))
assert_equal_u("ŝ",[349].pack('U'))
assert_equal_u("⪺",[10938].pack('U'))
assert_equal_u("⪶",[10934].pack('U'))
assert_equal_u("⋩",[8937].pack('U'))
assert_equal_u("⨓",[10771].pack('U'))
assert_equal_u("≿",[8831].pack('U'))
assert_equal_u("С",[1057].pack('U'))
assert_equal_u("с",[1089].pack('U'))
assert_equal_u("⋅",[8901].pack('U'))
assert_equal_u("⊡",[8865].pack('U'))
assert_equal_u("⩦",[10854].pack('U'))
assert_equal_u("⤥",[10533].pack('U'))
assert_equal_u("⇘",[8664].pack('U'))
assert_equal_u("↘",[8600].pack('U'))
assert_equal_u("↘",[8600].pack('U'))
assert_equal_u("§",[167].pack('U'))
assert_equal_u(";",[59].pack('U'))
assert_equal_u("⤩",[10537].pack('U'))
assert_equal_u("∖",[8726].pack('U'))
assert_equal_u("∖",[8726].pack('U'))
assert_equal_u("✶",[10038].pack('U'))
assert_equal_u("𝔖",[120086].pack('U'))
assert_equal_u("𝔰",[120112].pack('U'))
assert_equal_u("⌢",[8994].pack('U'))
assert_equal_u("♯",[9839].pack('U'))
assert_equal_u("Щ",[1065].pack('U'))
assert_equal_u("щ",[1097].pack('U'))
assert_equal_u("Ш",[1064].pack('U'))
assert_equal_u("ш",[1096].pack('U'))
assert_equal_u("↓",[8595].pack('U'))
assert_equal_u("←",[8592].pack('U'))
assert_equal_u("∣",[8739].pack('U'))
assert_equal_u("∥",[8741].pack('U'))
assert_equal_u("→",[8594].pack('U'))
assert_equal_u("↑",[8593].pack('U'))
assert_equal_u("­",[173].pack('U'))
assert_equal_u("Σ",[931].pack('U'))
assert_equal_u("σ",[963].pack('U'))
assert_equal_u("ς",[962].pack('U'))
assert_equal_u("ς",[962].pack('U'))
assert_equal_u("∼",[8764].pack('U'))
assert_equal_u("⩪",[10858].pack('U'))
assert_equal_u("≃",[8771].pack('U'))
assert_equal_u("≃",[8771].pack('U'))
assert_equal_u("⪞",[10910].pack('U'))
assert_equal_u("⪠",[10912].pack('U'))
assert_equal_u("⪝",[10909].pack('U'))
assert_equal_u("⪟",[10911].pack('U'))
assert_equal_u("≆",[8774].pack('U'))
assert_equal_u("⨤",[10788].pack('U'))
assert_equal_u("⥲",[10610].pack('U'))
assert_equal_u("←",[8592].pack('U'))
assert_equal_u("∘",[8728].pack('U'))
assert_equal_u("∖",[8726].pack('U'))
assert_equal_u("⨳",[10803].pack('U'))
assert_equal_u("⧤",[10724].pack('U'))
assert_equal_u("∣",[8739].pack('U'))
assert_equal_u("⌣",[8995].pack('U'))
assert_equal_u("⪪",[10922].pack('U'))
assert_equal_u("⪬",[10924].pack('U'))
assert_equal_u("⪬",[10924, 65024].pack('U'))
assert_equal_u("Ь",[1068].pack('U'))
assert_equal_u("ь",[1100].pack('U'))
assert_equal_u("/",[47].pack('U'))
assert_equal_u("⧄",[10692].pack('U'))
assert_equal_u("⌿",[9023].pack('U'))
assert_equal_u("𝕊",[120138].pack('U'))
assert_equal_u("𝕤",[120164].pack('U'))
assert_equal_u("♠",[9824].pack('U'))
assert_equal_u("♠",[9824].pack('U'))
assert_equal_u("∥",[8741].pack('U'))
assert_equal_u("⊓",[8851].pack('U'))
assert_equal_u("⊓",[8851, 65024].pack('U'))
assert_equal_u("⊔",[8852].pack('U'))
assert_equal_u("⊔",[8852, 65024].pack('U'))
assert_equal_u("√",[8730].pack('U'))
assert_equal_u("⊏",[8847].pack('U'))
assert_equal_u("⊑",[8849].pack('U'))
assert_equal_u("⊏",[8847].pack('U'))
assert_equal_u("⊑",[8849].pack('U'))
assert_equal_u("⊐",[8848].pack('U'))
assert_equal_u("⊒",[8850].pack('U'))
assert_equal_u("⊐",[8848].pack('U'))
assert_equal_u("⊒",[8850].pack('U'))
assert_equal_u("□",[9633].pack('U'))
assert_equal_u("□",[9633].pack('U'))
assert_equal_u("□",[9633].pack('U'))
assert_equal_u("⊓",[8851].pack('U'))
assert_equal_u("⊏",[8847].pack('U'))
assert_equal_u("⊑",[8849].pack('U'))
assert_equal_u("⊐",[8848].pack('U'))
assert_equal_u("⊒",[8850].pack('U'))
assert_equal_u("⊔",[8852].pack('U'))
assert_equal_u("▪",[9642].pack('U'))
assert_equal_u("▪",[9642].pack('U'))
assert_equal_u("→",[8594].pack('U'))
assert_equal_u("𝒮",[119982].pack('U'))
assert_equal_u("𝓈",[120008].pack('U'))
assert_equal_u("∖",[8726].pack('U'))
assert_equal_u("⌣",[8995].pack('U'))
assert_equal_u("⋆",[8902].pack('U'))
assert_equal_u("⋆",[8902].pack('U'))
assert_equal_u("☆",[9734].pack('U'))
assert_equal_u("★",[9733].pack('U'))
assert_equal_u("ϵ",[1013].pack('U'))
assert_equal_u("ϕ",[981].pack('U'))
assert_equal_u("¯",[175].pack('U'))
assert_equal_u("⋐",[8912].pack('U'))
assert_equal_u("⊂",[8834].pack('U'))
assert_equal_u("⪽",[10941].pack('U'))
assert_equal_u("⫅",[10949].pack('U'))
assert_equal_u("⊆",[8838].pack('U'))
assert_equal_u("⫃",[10947].pack('U'))
assert_equal_u("⫁",[10945].pack('U'))
assert_equal_u("⫋",[10955].pack('U'))
assert_equal_u("⊊",[8842].pack('U'))
assert_equal_u("⪿",[10943].pack('U'))
assert_equal_u("⥹",[10617].pack('U'))
assert_equal_u("⋐",[8912].pack('U'))
assert_equal_u("⊂",[8834].pack('U'))
assert_equal_u("⊆",[8838].pack('U'))
assert_equal_u("⫅",[10949].pack('U'))
assert_equal_u("⊆",[8838].pack('U'))
assert_equal_u("⊊",[8842].pack('U'))
assert_equal_u("⫋",[10955].pack('U'))
assert_equal_u("⫇",[10951].pack('U'))
assert_equal_u("⫕",[10965].pack('U'))
assert_equal_u("⫓",[10963].pack('U'))
assert_equal_u("≻",[8827].pack('U'))
assert_equal_u("⪸",[10936].pack('U'))
assert_equal_u("≽",[8829].pack('U'))
assert_equal_u("≻",[8827].pack('U'))
assert_equal_u("⪰",[10928].pack('U'))
assert_equal_u("≽",[8829].pack('U'))
assert_equal_u("≿",[8831].pack('U'))
assert_equal_u("⪰",[10928].pack('U'))
assert_equal_u("⪺",[10938].pack('U'))
assert_equal_u("⪶",[10934].pack('U'))
assert_equal_u("⋩",[8937].pack('U'))
assert_equal_u("≿",[8831].pack('U'))
assert_equal_u("∋",[8715].pack('U'))
assert_equal_u("∑",[8721].pack('U'))
assert_equal_u("∑",[8721].pack('U'))
assert_equal_u("♪",[9834].pack('U'))
assert_equal_u("⋑",[8913].pack('U'))
assert_equal_u("⊃",[8835].pack('U'))
assert_equal_u("¹",[185].pack('U'))
assert_equal_u("²",[178].pack('U'))
assert_equal_u("³",[179].pack('U'))
assert_equal_u("⪾",[10942].pack('U'))
assert_equal_u("⫘",[10968].pack('U'))
assert_equal_u("⫆",[10950].pack('U'))
assert_equal_u("⊇",[8839].pack('U'))
assert_equal_u("⫄",[10948].pack('U'))
assert_equal_u("⊃",[8835].pack('U'))
assert_equal_u("⊇",[8839].pack('U'))
assert_equal_u("⟉",[10185].pack('U'))
assert_equal_u("⫗",[10967].pack('U'))
assert_equal_u("⥻",[10619].pack('U'))
assert_equal_u("⫂",[10946].pack('U'))
assert_equal_u("⫌",[10956].pack('U'))
assert_equal_u("⊋",[8843].pack('U'))
assert_equal_u("⫀",[10944].pack('U'))
assert_equal_u("⋑",[8913].pack('U'))
assert_equal_u("⊃",[8835].pack('U'))
assert_equal_u("⊇",[8839].pack('U'))
assert_equal_u("⫆",[10950].pack('U'))
assert_equal_u("⊋",[8843].pack('U'))
assert_equal_u("⫌",[10956].pack('U'))
assert_equal_u("⫈",[10952].pack('U'))
assert_equal_u("⫔",[10964].pack('U'))
assert_equal_u("⫖",[10966].pack('U'))
assert_equal_u("⤦",[10534].pack('U'))
assert_equal_u("⇙",[8665].pack('U'))
assert_equal_u("↙",[8601].pack('U'))
assert_equal_u("↙",[8601].pack('U'))
assert_equal_u("⤪",[10538].pack('U'))
assert_equal_u("ß",[223].pack('U'))
assert_equal_u("\t",[9].pack('U'))
assert_equal_u("⌖",[8982].pack('U'))
assert_equal_u("Τ",[932].pack('U'))
assert_equal_u("τ",[964].pack('U'))
assert_equal_u("⎴",[9140].pack('U'))
assert_equal_u("Ť",[356].pack('U'))
assert_equal_u("ť",[357].pack('U'))
assert_equal_u("Ţ",[354].pack('U'))
assert_equal_u("ţ",[355].pack('U'))
assert_equal_u("Т",[1058].pack('U'))
assert_equal_u("т",[1090].pack('U'))
assert_equal_u("⃛",[8411].pack('U'))
assert_equal_u("⌕",[8981].pack('U'))
assert_equal_u("𝔗",[120087].pack('U'))
assert_equal_u("𝔱",[120113].pack('U'))
assert_equal_u("∴",[8756].pack('U'))
assert_equal_u("∴",[8756].pack('U'))
assert_equal_u("∴",[8756].pack('U'))
assert_equal_u("Θ",[920].pack('U'))
assert_equal_u("θ",[952].pack('U'))
assert_equal_u("ϑ",[977].pack('U'))
assert_equal_u("ϑ",[977].pack('U'))
assert_equal_u("≈",[8776].pack('U'))
assert_equal_u("∼",[8764].pack('U'))
assert_equal_u(" ",[8287, 8202].pack('U'))
assert_equal_u(" ",[8201].pack('U'))
assert_equal_u(" ",[8201].pack('U'))
assert_equal_u("≈",[8776].pack('U'))
assert_equal_u("∼",[8764].pack('U'))
assert_equal_u("Þ",[222].pack('U'))
assert_equal_u("þ",[254].pack('U'))
assert_equal_u("∼",[8764].pack('U'))
assert_equal_u("˜",[732].pack('U'))
assert_equal_u("≃",[8771].pack('U'))
assert_equal_u("≅",[8773].pack('U'))
assert_equal_u("≈",[8776].pack('U'))
assert_equal_u("×",[215].pack('U'))
assert_equal_u("⊠",[8864].pack('U'))
assert_equal_u("⨱",[10801].pack('U'))
assert_equal_u("⨰",[10800].pack('U'))
assert_equal_u("∭",[8749].pack('U'))
assert_equal_u("⤨",[10536].pack('U'))
assert_equal_u("⊤",[8868].pack('U'))
assert_equal_u("⌶",[9014].pack('U'))
assert_equal_u("⫱",[10993].pack('U'))
assert_equal_u("𝕋",[120139].pack('U'))
assert_equal_u("𝕥",[120165].pack('U'))
assert_equal_u("⫚",[10970].pack('U'))
assert_equal_u("⤩",[10537].pack('U'))
assert_equal_u("‴",[8244].pack('U'))
assert_equal_u("™",[8482].pack('U'))
assert_equal_u("™",[8482].pack('U'))
assert_equal_u("▵",[9653].pack('U'))
assert_equal_u("▿",[9663].pack('U'))
assert_equal_u("◃",[9667].pack('U'))
assert_equal_u("⊴",[8884].pack('U'))
assert_equal_u("≜",[8796].pack('U'))
assert_equal_u("▹",[9657].pack('U'))
assert_equal_u("⊵",[8885].pack('U'))
assert_equal_u("◬",[9708].pack('U'))
assert_equal_u("≜",[8796].pack('U'))
assert_equal_u("⨺",[10810].pack('U'))
assert_equal_u("⃛",[8411].pack('U'))
assert_equal_u("⨹",[10809].pack('U'))
assert_equal_u("⧍",[10701].pack('U'))
assert_equal_u("⨻",[10811].pack('U'))
assert_equal_u("⏢",[9186].pack('U'))
assert_equal_u("𝒯",[119983].pack('U'))
assert_equal_u("𝓉",[120009].pack('U'))
assert_equal_u("Ц",[1062].pack('U'))
assert_equal_u("ц",[1094].pack('U'))
assert_equal_u("Ћ",[1035].pack('U'))
assert_equal_u("ћ",[1115].pack('U'))
assert_equal_u("Ŧ",[358].pack('U'))
assert_equal_u("ŧ",[359].pack('U'))
assert_equal_u("≬",[8812].pack('U'))
assert_equal_u("↞",[8606].pack('U'))
assert_equal_u("↠",[8608].pack('U'))
assert_equal_u("Ú",[218].pack('U'))
assert_equal_u("ú",[250].pack('U'))
assert_equal_u("↟",[8607].pack('U'))
assert_equal_u("⇑",[8657].pack('U'))
assert_equal_u("↑",[8593].pack('U'))
assert_equal_u("⥉",[10569].pack('U'))
assert_equal_u("Ў",[1038].pack('U'))
assert_equal_u("ў",[1118].pack('U'))
assert_equal_u("Ŭ",[364].pack('U'))
assert_equal_u("ŭ",[365].pack('U'))
assert_equal_u("Û",[219].pack('U'))
assert_equal_u("û",[251].pack('U'))
assert_equal_u("У",[1059].pack('U'))
assert_equal_u("у",[1091].pack('U'))
assert_equal_u("⇅",[8645].pack('U'))
assert_equal_u("Ű",[368].pack('U'))
assert_equal_u("ű",[369].pack('U'))
assert_equal_u("⥮",[10606].pack('U'))
assert_equal_u("⥾",[10622].pack('U'))
assert_equal_u("𝔘",[120088].pack('U'))
assert_equal_u("𝔲",[120114].pack('U'))
assert_equal_u("Ù",[217].pack('U'))
assert_equal_u("ù",[249].pack('U'))
assert_equal_u("⥣",[10595].pack('U'))
assert_equal_u("↿",[8639].pack('U'))
assert_equal_u("↾",[8638].pack('U'))
assert_equal_u("▀",[9600].pack('U'))
assert_equal_u("⌜",[8988].pack('U'))
assert_equal_u("⌜",[8988].pack('U'))
assert_equal_u("⌏",[8975].pack('U'))
assert_equal_u("◸",[9720].pack('U'))
assert_equal_u("Ū",[362].pack('U'))
assert_equal_u("ū",[363].pack('U'))
assert_equal_u("¨",[168].pack('U'))
assert_equal_u("_",[95].pack('U'))
assert_equal_u("⏟",[9183].pack('U'))
assert_equal_u("⎵",[9141].pack('U'))
assert_equal_u("⏝",[9181].pack('U'))
assert_equal_u("⋃",[8899].pack('U'))
assert_equal_u("⊎",[8846].pack('U'))
assert_equal_u("Ų",[370].pack('U'))
assert_equal_u("ų",[371].pack('U'))
assert_equal_u("𝕌",[120140].pack('U'))
assert_equal_u("𝕦",[120166].pack('U'))
assert_equal_u("↑",[8593].pack('U'))
assert_equal_u("⇑",[8657].pack('U'))
assert_equal_u("↑",[8593].pack('U'))
assert_equal_u("⤒",[10514].pack('U'))
assert_equal_u("⇅",[8645].pack('U'))
assert_equal_u("↕",[8597].pack('U'))
assert_equal_u("⇕",[8661].pack('U'))
assert_equal_u("↕",[8597].pack('U'))
assert_equal_u("⥮",[10606].pack('U'))
assert_equal_u("↿",[8639].pack('U'))
assert_equal_u("↾",[8638].pack('U'))
assert_equal_u("⊎",[8846].pack('U'))
assert_equal_u("↖",[8598].pack('U'))
assert_equal_u("↗",[8599].pack('U'))
assert_equal_u("ϒ",[978].pack('U'))
assert_equal_u("υ",[965].pack('U'))
assert_equal_u("ϒ",[978].pack('U'))
assert_equal_u("Υ",[933].pack('U'))
assert_equal_u("υ",[965].pack('U'))
assert_equal_u("⊥",[8869].pack('U'))
assert_equal_u("↥",[8613].pack('U'))
assert_equal_u("⇈",[8648].pack('U'))
assert_equal_u("⌝",[8989].pack('U'))
assert_equal_u("⌝",[8989].pack('U'))
assert_equal_u("⌎",[8974].pack('U'))
assert_equal_u("Ů",[366].pack('U'))
assert_equal_u("ů",[367].pack('U'))
assert_equal_u("◹",[9721].pack('U'))
assert_equal_u("𝒰",[119984].pack('U'))
assert_equal_u("𝓊",[120010].pack('U'))
assert_equal_u("⋰",[8944].pack('U'))
assert_equal_u("Ũ",[360].pack('U'))
assert_equal_u("ũ",[361].pack('U'))
assert_equal_u("▵",[9653].pack('U'))
assert_equal_u("▴",[9652].pack('U'))
assert_equal_u("⇈",[8648].pack('U'))
assert_equal_u("Ü",[220].pack('U'))
assert_equal_u("ü",[252].pack('U'))
assert_equal_u("⦧",[10663].pack('U'))
assert_equal_u("⦜",[10652].pack('U'))
assert_equal_u("ϵ",[1013].pack('U'))
assert_equal_u("ϰ",[1008].pack('U'))
assert_equal_u("∅",[8709].pack('U'))
assert_equal_u("ϕ",[981].pack('U'))
assert_equal_u("ϖ",[982].pack('U'))
assert_equal_u("∝",[8733].pack('U'))
assert_equal_u("⇕",[8661].pack('U'))
assert_equal_u("↕",[8597].pack('U'))
assert_equal_u("ϱ",[1009].pack('U'))
assert_equal_u("ς",[962].pack('U'))
assert_equal_u("⊊",[8842, 65024].pack('U'))
assert_equal_u("⫋",[10955, 65024].pack('U'))
assert_equal_u("⊋",[8843, 65024].pack('U'))
assert_equal_u("⫌",[10956, 65024].pack('U'))
assert_equal_u("ϑ",[977].pack('U'))
assert_equal_u("⊲",[8882].pack('U'))
assert_equal_u("⊳",[8883].pack('U'))
assert_equal_u("⫫",[10987].pack('U'))
assert_equal_u("⫨",[10984].pack('U'))
assert_equal_u("⫩",[10985].pack('U'))
assert_equal_u("В",[1042].pack('U'))
assert_equal_u("в",[1074].pack('U'))
assert_equal_u("⊫",[8875].pack('U'))
assert_equal_u("⊩",[8873].pack('U'))
assert_equal_u("⊨",[8872].pack('U'))
assert_equal_u("⊢",[8866].pack('U'))
assert_equal_u("⫦",[10982].pack('U'))
assert_equal_u("⋁",[8897].pack('U'))
assert_equal_u("∨",[8744].pack('U'))
assert_equal_u("⊻",[8891].pack('U'))
assert_equal_u("≚",[8794].pack('U'))
assert_equal_u("⋮",[8942].pack('U'))
assert_equal_u("‖",[8214].pack('U'))
assert_equal_u("|",[124].pack('U'))
assert_equal_u("‖",[8214].pack('U'))
assert_equal_u("|",[124].pack('U'))
assert_equal_u("∣",[8739].pack('U'))
assert_equal_u("|",[124].pack('U'))
assert_equal_u("❘",[10072].pack('U'))
assert_equal_u("≀",[8768].pack('U'))
assert_equal_u(" ",[8202].pack('U'))
assert_equal_u("𝔙",[120089].pack('U'))
assert_equal_u("𝔳",[120115].pack('U'))
assert_equal_u("⊲",[8882].pack('U'))
assert_equal_u("⊂",[8834, 8402].pack('U'))
assert_equal_u("⊃",[8835, 8402].pack('U'))
assert_equal_u("𝕍",[120141].pack('U'))
assert_equal_u("𝕧",[120167].pack('U'))
assert_equal_u("∝",[8733].pack('U'))
assert_equal_u("⊳",[8883].pack('U'))
assert_equal_u("𝒱",[119985].pack('U'))
assert_equal_u("𝓋",[120011].pack('U'))
assert_equal_u("⫋",[10955, 65024].pack('U'))
assert_equal_u("⊊",[8842, 65024].pack('U'))
assert_equal_u("⫌",[10956, 65024].pack('U'))
assert_equal_u("⊋",[8843, 65024].pack('U'))
assert_equal_u("⊪",[8874].pack('U'))
assert_equal_u("⦚",[10650].pack('U'))
assert_equal_u("Ŵ",[372].pack('U'))
assert_equal_u("ŵ",[373].pack('U'))
assert_equal_u("⩟",[10847].pack('U'))
assert_equal_u("⋀",[8896].pack('U'))
assert_equal_u("∧",[8743].pack('U'))
assert_equal_u("≙",[8793].pack('U'))
assert_equal_u("℘",[8472].pack('U'))
assert_equal_u("𝔚",[120090].pack('U'))
assert_equal_u("𝔴",[120116].pack('U'))
assert_equal_u("𝕎",[120142].pack('U'))
assert_equal_u("𝕨",[120168].pack('U'))
assert_equal_u("℘",[8472].pack('U'))
assert_equal_u("≀",[8768].pack('U'))
assert_equal_u("≀",[8768].pack('U'))
assert_equal_u("𝒲",[119986].pack('U'))
assert_equal_u("𝓌",[120012].pack('U'))
assert_equal_u("⋂",[8898].pack('U'))
assert_equal_u("◯",[9711].pack('U'))
assert_equal_u("⋃",[8899].pack('U'))
assert_equal_u("▽",[9661].pack('U'))
assert_equal_u("𝔛",[120091].pack('U'))
assert_equal_u("𝔵",[120117].pack('U'))
assert_equal_u("⟺",[10234].pack('U'))
assert_equal_u("⟷",[10231].pack('U'))
assert_equal_u("Ξ",[926].pack('U'))
assert_equal_u("ξ",[958].pack('U'))
assert_equal_u("⟸",[10232].pack('U'))
assert_equal_u("⟵",[10229].pack('U'))
assert_equal_u("⟼",[10236].pack('U'))
assert_equal_u("⋻",[8955].pack('U'))
assert_equal_u("⨀",[10752].pack('U'))
assert_equal_u("𝕏",[120143].pack('U'))
assert_equal_u("𝕩",[120169].pack('U'))
assert_equal_u("⨁",[10753].pack('U'))
assert_equal_u("⨂",[10754].pack('U'))
assert_equal_u("⟹",[10233].pack('U'))
assert_equal_u("⟶",[10230].pack('U'))
assert_equal_u("𝒳",[119987].pack('U'))
assert_equal_u("𝓍",[120013].pack('U'))
assert_equal_u("⨆",[10758].pack('U'))
assert_equal_u("⨄",[10756].pack('U'))
assert_equal_u("△",[9651].pack('U'))
assert_equal_u("⋁",[8897].pack('U'))
assert_equal_u("⋀",[8896].pack('U'))
assert_equal_u("Ý",[221].pack('U'))
assert_equal_u("ý",[253].pack('U'))
assert_equal_u("Я",[1071].pack('U'))
assert_equal_u("я",[1103].pack('U'))
assert_equal_u("Ŷ",[374].pack('U'))
assert_equal_u("ŷ",[375].pack('U'))
assert_equal_u("Ы",[1067].pack('U'))
assert_equal_u("ы",[1099].pack('U'))
assert_equal_u("¥",[165].pack('U'))
assert_equal_u("𝔜",[120092].pack('U'))
assert_equal_u("𝔶",[120118].pack('U'))
assert_equal_u("Ї",[1031].pack('U'))
assert_equal_u("ї",[1111].pack('U'))
assert_equal_u("𝕐",[120144].pack('U'))
assert_equal_u("𝕪",[120170].pack('U'))
assert_equal_u("𝒴",[119988].pack('U'))
assert_equal_u("𝓎",[120014].pack('U'))
assert_equal_u("Ю",[1070].pack('U'))
assert_equal_u("ю",[1102].pack('U'))
assert_equal_u("Ÿ",[376].pack('U'))
assert_equal_u("ÿ",[255].pack('U'))
assert_equal_u("Ź",[377].pack('U'))
assert_equal_u("ź",[378].pack('U'))
assert_equal_u("Ž",[381].pack('U'))
assert_equal_u("ž",[382].pack('U'))
assert_equal_u("З",[1047].pack('U'))
assert_equal_u("з",[1079].pack('U'))
assert_equal_u("Ż",[379].pack('U'))
assert_equal_u("ż",[380].pack('U'))
assert_equal_u("ℨ",[8488].pack('U'))
assert_equal_u("​",[8203].pack('U'))
assert_equal_u("Ζ",[918].pack('U'))
assert_equal_u("ζ",[950].pack('U'))
assert_equal_u("ℨ",[8488].pack('U'))
assert_equal_u("𝔷",[120119].pack('U'))
assert_equal_u("Ж",[1046].pack('U'))
assert_equal_u("ж",[1078].pack('U'))
assert_equal_u("⇝",[8669].pack('U'))
assert_equal_u("ℤ",[8484].pack('U'))
assert_equal_u("𝕫",[120171].pack('U'))
assert_equal_u("𝒵",[119989].pack('U'))
assert_equal_u("𝓏",[120015].pack('U'))
assert_equal_u("‍",[8205].pack('U'))
assert_equal_u("‌",[8204].pack('U'))
assert_equal_u("&",[38].pack('U*'))
assert_equal_u("&",[38].pack('U*'))
assert_equal_u(">",[62].pack('U*'))
assert_equal_u("<",[60].pack('U*'))
assert_equal_u("<",[60].pack('U*'))
assert_equal_u("&",[38].pack('U*'))
assert_equal_u("&",[38].pack('U*'))
assert_equal_u("'",[39].pack('U*'))
assert_equal_u('"',[34].pack('U*'))

def assert_equal(one, two)
  raise "Expected: `#{one}` Actual: `#{two}`" if one != two
end

assert_equal "\000\000", [0].pack('n')
assert_equal "\000\001", [1].pack('n')
assert_equal "\000\003", [3].pack('n')
