/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.util.stream;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.util.ArrayList;
import sandbox.java.util.Arrays;
import sandbox.java.util.Comparator;
import sandbox.java.util.Iterator;
import sandbox.java.util.Objects;
import sandbox.java.util.Spliterator;
import sandbox.java.util.function.Consumer;
import sandbox.java.util.function.IntFunction;
import sandbox.java.util.stream.AbstractPipeline;
import sandbox.java.util.stream.DoublePipeline;
import sandbox.java.util.stream.DoubleStream;
import sandbox.java.util.stream.IntPipeline;
import sandbox.java.util.stream.IntStream;
import sandbox.java.util.stream.LongPipeline;
import sandbox.java.util.stream.LongStream;
import sandbox.java.util.stream.Node;
import sandbox.java.util.stream.Nodes;
import sandbox.java.util.stream.PipelineHelper;
import sandbox.java.util.stream.ReferencePipeline;
import sandbox.java.util.stream.Sink;
import sandbox.java.util.stream.SpinedBuffer;
import sandbox.java.util.stream.Stream;
import sandbox.java.util.stream.StreamOpFlag;
import sandbox.java.util.stream.StreamShape;

final class SortedOps {
    private SortedOps() {
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.<init>:()V");
    }

    static <T> Stream<T> makeRef(AbstractPipeline<?, T, ?> abstractPipeline) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$OfRef.<init>:(Ljava/util/stream/AbstractPipeline;)V");
        return new OfRef<T>(abstractPipeline);
    }

    static <T> Stream<T> makeRef(AbstractPipeline<?, T, ?> abstractPipeline, Comparator<? super T> comparator) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$OfRef");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$OfRef.<init>:(Ljava/util/stream/AbstractPipeline;Ljava/util/Comparator;)V");
        return new OfRef<T>(abstractPipeline, comparator);
    }

    static <T> IntStream makeInt(AbstractPipeline<?, Integer, ?> abstractPipeline) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$OfInt");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$OfInt.<init>:(Ljava/util/stream/AbstractPipeline;)V");
        return new OfInt(abstractPipeline);
    }

    static <T> LongStream makeLong(AbstractPipeline<?, Long, ?> abstractPipeline) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$OfLong");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$OfLong.<init>:(Ljava/util/stream/AbstractPipeline;)V");
        return new OfLong(abstractPipeline);
    }

    static <T> DoubleStream makeDouble(AbstractPipeline<?, Double, ?> abstractPipeline) {
        RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$OfDouble");
        RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$OfDouble.<init>:(Ljava/util/stream/AbstractPipeline;)V");
        return new OfDouble(abstractPipeline);
    }

    private static final class DoubleSortingSink
    extends AbstractDoubleSortingSink {
        private SpinedBuffer.OfDouble b;

        DoubleSortingSink(Sink<? super Double> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractDoubleSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public void begin(long l) {
            SpinedBuffer.OfDouble ofDouble;
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (l > 0L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfDouble");
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.<init>:(I)V");
                ofDouble = new SpinedBuffer.OfDouble(n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfDouble");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.<init>:()V");
                ofDouble = new SpinedBuffer.OfDouble();
            }
            this.b = ofDouble;
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.asPrimitiveArray:()Ljava/lang/Object;");
            double[] dArray = (double[])this.b.asPrimitiveArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([D)V");
            Arrays.sort(dArray);
            long l = dArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                double[] dArray2 = dArray;
                int n = dArray2.length;
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    double d = dArray2[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(D)V");
                    this.downstream.accept(d);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                double[] dArray3 = dArray;
                int n = dArray3.length;
                int n3 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= n) break;
                    double d = dArray3[n3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(D)V");
                    this.downstream.accept(d);
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
        }

        @Override
        public void accept(double d) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfDouble.accept:(D)V");
            this.b.accept(d);
        }
    }

    private static final class SizedDoubleSortingSink
    extends AbstractDoubleSortingSink {
        private double[] array;
        private int offset;

        SizedDoubleSortingSink(Sink<? super Double> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractDoubleSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.array = new double[n];
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([DII)V");
            Arrays.sort(this.array, 0, this.offset);
            long l = this.offset;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    double d = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(D)V");
                    this.downstream.accept(d);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                    double d = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(D)V");
                    this.downstream.accept(d);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(double d) {
            this.array[this.offset++] = d;
        }
    }

    private static abstract class AbstractDoubleSortingSink
    extends Sink.ChainedDouble<Double> {
        protected boolean cancellationWasRequested;

        AbstractDoubleSortingSink(Sink<? super Double> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink$ChainedDouble.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public final boolean cancellationRequested() {
            this.cancellationWasRequested = true;
            return false;
        }
    }

    private static final class LongSortingSink
    extends AbstractLongSortingSink {
        private SpinedBuffer.OfLong b;

        LongSortingSink(Sink<? super Long> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractLongSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public void begin(long l) {
            SpinedBuffer.OfLong ofLong;
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (l > 0L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfLong");
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.<init>:(I)V");
                ofLong = new SpinedBuffer.OfLong(n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfLong");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.<init>:()V");
                ofLong = new SpinedBuffer.OfLong();
            }
            this.b = ofLong;
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.asPrimitiveArray:()Ljava/lang/Object;");
            long[] lArray = (long[])this.b.asPrimitiveArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([J)V");
            Arrays.sort(lArray);
            long l = lArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                long[] lArray2 = lArray;
                int n = lArray2.length;
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    long l2 = lArray2[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(J)V");
                    this.downstream.accept(l2);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                long[] lArray3 = lArray;
                int n = lArray3.length;
                int n3 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n3 >= n) break;
                    long l3 = lArray3[n3];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(J)V");
                    this.downstream.accept(l3);
                    ++n3;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
        }

        @Override
        public void accept(long l) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfLong.accept:(J)V");
            this.b.accept(l);
        }
    }

    private static final class SizedLongSortingSink
    extends AbstractLongSortingSink {
        private long[] array;
        private int offset;

        SizedLongSortingSink(Sink<? super Long> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractLongSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.array = new long[n];
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([JII)V");
            Arrays.sort(this.array, 0, this.offset);
            long l = this.offset;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    long l2 = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(J)V");
                    this.downstream.accept(l2);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                    long l3 = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(J)V");
                    this.downstream.accept(l3);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(long l) {
            this.array[this.offset++] = l;
        }
    }

    private static abstract class AbstractLongSortingSink
    extends Sink.ChainedLong<Long> {
        protected boolean cancellationWasRequested;

        AbstractLongSortingSink(Sink<? super Long> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink$ChainedLong.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public final boolean cancellationRequested() {
            this.cancellationWasRequested = true;
            return false;
        }
    }

    private static final class IntSortingSink
    extends AbstractIntSortingSink {
        private SpinedBuffer.OfInt b;

        IntSortingSink(Sink<? super Integer> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractIntSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public void begin(long l) {
            SpinedBuffer.OfInt ofInt;
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (l > 0L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfInt");
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.<init>:(I)V");
                ofInt = new SpinedBuffer.OfInt(n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SpinedBuffer$OfInt");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.<init>:()V");
                ofInt = new SpinedBuffer.OfInt();
            }
            this.b = ofInt;
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.asPrimitiveArray:()Ljava/lang/Object;");
            int[] nArray = (int[])this.b.asPrimitiveArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([I)V");
            Arrays.sort(nArray);
            long l = nArray.length;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                int[] nArray2 = nArray;
                int n = nArray2.length;
                int n2 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n2 >= n) break;
                    int n3 = nArray2[n2];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(I)V");
                    this.downstream.accept(n3);
                    ++n2;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                int[] nArray3 = nArray;
                int n = nArray3.length;
                int n4 = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n4 >= n) break;
                    int n5 = nArray3[n4];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(I)V");
                    this.downstream.accept(n5);
                    ++n4;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
        }

        @Override
        public void accept(int n) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SpinedBuffer$OfInt.accept:(I)V");
            this.b.accept(n);
        }
    }

    private static final class SizedIntSortingSink
    extends AbstractIntSortingSink {
        private int[] array;
        private int offset;

        SizedIntSortingSink(Sink<? super Integer> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractIntSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)4);
            this.array = new int[n];
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([III)V");
            Arrays.sort(this.array, 0, this.offset);
            long l = this.offset;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    int n2 = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(I)V");
                    this.downstream.accept(n2);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                    int n3 = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(I)V");
                    this.downstream.accept(n3);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(int n) {
            this.array[this.offset++] = n;
        }
    }

    private static abstract class AbstractIntSortingSink
    extends Sink.ChainedInt<Integer> {
        protected boolean cancellationWasRequested;

        AbstractIntSortingSink(Sink<? super Integer> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink$ChainedInt.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
        }

        @Override
        public final boolean cancellationRequested() {
            this.cancellationWasRequested = true;
            return false;
        }
    }

    private static final class RefSortingSink<T>
    extends AbstractRefSortingSink<T> {
        private ArrayList<T> list;

        RefSortingSink(Sink<? super T> sink, Comparator<? super T> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractRefSortingSink.<init>:(Ljava/util/stream/Sink;Ljava/util/Comparator;)V");
            super(sink, comparator);
        }

        @Override
        public void begin(long l) {
            ArrayList arrayList;
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            RuntimeCostAccounter.recordJump();
            if (l >= 0L) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                int n = (int)l;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:(I)V");
                arrayList = new ArrayList(n);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordAllocation((String)"java/util/ArrayList");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.<init>:()V");
                arrayList = new ArrayList();
            }
            this.list = arrayList;
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.sort:(Ljava/util/Comparator;)V");
            this.list.sort(this.comparator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.size:()I");
            long l = this.list.size();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                Sink sink = this.downstream;
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/Object.getClass:()Ljava/lang/Class;");
                sink.getClass();
                Consumer<Object> consumer = sink::accept;
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.forEach:(Ljava/util/function/Consumer;)V");
                this.list.forEach(consumer);
                RuntimeCostAccounter.recordJump();
            } else {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.iterator:()Ljava/util/Iterator;");
                Iterator<T> iterator = this.list.iterator();
                while (true) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.hasNext:()Z");
                    boolean bl = iterator.hasNext();
                    RuntimeCostAccounter.recordJump();
                    if (!bl) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/Iterator.next:()Ljava/lang/Object;");
                    T t = iterator.next();
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl2 = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl2) {
                        RuntimeCostAccounter.recordJump();
                        break;
                    }
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(Ljava/lang/Object;)V");
                    this.downstream.accept(t);
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
            this.list = null;
        }

        @Override
        public void accept(T t) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/ArrayList.add:(Ljava/lang/Object;)Z");
            this.list.add(t);
        }
    }

    private static final class SizedRefSortingSink<T>
    extends AbstractRefSortingSink<T> {
        private T[] array;
        private int offset;

        SizedRefSortingSink(Sink<? super T> sink, Comparator<? super T> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$AbstractRefSortingSink.<init>:(Ljava/util/stream/Sink;Ljava/util/Comparator;)V");
            super(sink, comparator);
        }

        @Override
        public void begin(long l) {
            RuntimeCostAccounter.recordJump();
            if (l >= 0x7FFFFFF7L) {
                RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
                RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Stream size exceeds max array size");
                RuntimeCostAccounter.recordThrow();
                throw illegalArgumentException;
            }
            int n = (int)l;
            RuntimeCostAccounter.recordArrayAllocation((int)n, (int)8);
            this.array = new Object[n];
        }

        @Override
        public void end() {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.sort:([Ljava/lang/Object;IILjava/util/Comparator;)V");
            Arrays.sort(this.array, 0, this.offset, this.comparator);
            long l = this.offset;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.begin:(J)V");
            this.downstream.begin(l);
            RuntimeCostAccounter.recordJump();
            if (!this.cancellationWasRequested) {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    T t = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(Ljava/lang/Object;)V");
                    this.downstream.accept(t);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
                RuntimeCostAccounter.recordJump();
            } else {
                int n = 0;
                while (true) {
                    RuntimeCostAccounter.recordJump();
                    if (n >= this.offset) break;
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.cancellationRequested:()Z");
                    boolean bl = this.downstream.cancellationRequested();
                    RuntimeCostAccounter.recordJump();
                    if (bl) break;
                    T t = this.array[n];
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.accept:(Ljava/lang/Object;)V");
                    this.downstream.accept(t);
                    ++n;
                    RuntimeCostAccounter.recordJump();
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink.end:()V");
            this.downstream.end();
            this.array = null;
        }

        @Override
        public void accept(T t) {
            this.array[this.offset++] = t;
        }
    }

    private static abstract class AbstractRefSortingSink<T>
    extends Sink.ChainedReference<T, T> {
        protected final Comparator<? super T> comparator;
        protected boolean cancellationWasRequested;

        AbstractRefSortingSink(Sink<? super T> sink, Comparator<? super T> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Sink$ChainedReference.<init>:(Ljava/util/stream/Sink;)V");
            super(sink);
            this.comparator = comparator;
        }

        @Override
        public final boolean cancellationRequested() {
            this.cancellationWasRequested = true;
            return false;
        }
    }

    private static final class OfDouble
    extends DoublePipeline.StatefulOp<Double> {
        OfDouble(AbstractPipeline<?, Double, ?> abstractPipeline) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/DoublePipeline$StatefulOp.<init>:(Ljava/util/stream/AbstractPipeline;Ljava/util/stream/StreamShape;I)V");
            super(abstractPipeline, StreamShape.DOUBLE_VALUE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
        }

        @Override
        public Sink<Double> opWrapSink(int n, Sink<Double> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(sink);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return sink;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl2 = StreamOpFlag.SIZED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$SizedDoubleSortingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$SizedDoubleSortingSink.<init>:(Ljava/util/stream/Sink;)V");
                return new SizedDoubleSortingSink((Sink<? super Double>)sink);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$DoubleSortingSink");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$DoubleSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            return new DoubleSortingSink((Sink<? super Double>)sink);
        }

        @Override
        public <P_IN> Node<Double> opEvaluateParallel(PipelineHelper<Double> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Double[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.getStreamAndOpFlags:()I");
            int n = pipelineHelper.getStreamAndOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            Node.OfDouble ofDouble = (Node.OfDouble)pipelineHelper.evaluate(spliterator, true, intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfDouble.asPrimitiveArray:()Ljava/lang/Object;");
            double[] dArray = (double[])ofDouble.asPrimitiveArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.parallelSort:([D)V");
            Arrays.parallelSort(dArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([D)Ljava/util/stream/Node$OfDouble;");
            return Nodes.node(dArray);
        }
    }

    private static final class OfLong
    extends LongPipeline.StatefulOp<Long> {
        OfLong(AbstractPipeline<?, Long, ?> abstractPipeline) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/LongPipeline$StatefulOp.<init>:(Ljava/util/stream/AbstractPipeline;Ljava/util/stream/StreamShape;I)V");
            super(abstractPipeline, StreamShape.LONG_VALUE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
        }

        @Override
        public Sink<Long> opWrapSink(int n, Sink<Long> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(sink);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return sink;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl2 = StreamOpFlag.SIZED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$SizedLongSortingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$SizedLongSortingSink.<init>:(Ljava/util/stream/Sink;)V");
                return new SizedLongSortingSink((Sink<? super Long>)sink);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$LongSortingSink");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$LongSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            return new LongSortingSink((Sink<? super Long>)sink);
        }

        @Override
        public <P_IN> Node<Long> opEvaluateParallel(PipelineHelper<Long> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Long[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.getStreamAndOpFlags:()I");
            int n = pipelineHelper.getStreamAndOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            Node.OfLong ofLong = (Node.OfLong)pipelineHelper.evaluate(spliterator, true, intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfLong.asPrimitiveArray:()Ljava/lang/Object;");
            long[] lArray = (long[])ofLong.asPrimitiveArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.parallelSort:([J)V");
            Arrays.parallelSort(lArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([J)Ljava/util/stream/Node$OfLong;");
            return Nodes.node(lArray);
        }
    }

    private static final class OfInt
    extends IntPipeline.StatefulOp<Integer> {
        OfInt(AbstractPipeline<?, Integer, ?> abstractPipeline) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/IntPipeline$StatefulOp.<init>:(Ljava/util/stream/AbstractPipeline;Ljava/util/stream/StreamShape;I)V");
            super(abstractPipeline, StreamShape.INT_VALUE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
        }

        @Override
        public Sink<Integer> opWrapSink(int n, Sink sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(sink);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                return sink;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl2 = StreamOpFlag.SIZED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$SizedIntSortingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$SizedIntSortingSink.<init>:(Ljava/util/stream/Sink;)V");
                return new SizedIntSortingSink(sink);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$IntSortingSink");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$IntSortingSink.<init>:(Ljava/util/stream/Sink;)V");
            return new IntSortingSink(sink);
        }

        @Override
        public <P_IN> Node<Integer> opEvaluateParallel(PipelineHelper<Integer> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<Integer[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.getStreamAndOpFlags:()I");
            int n = pipelineHelper.getStreamAndOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
                return pipelineHelper.evaluate(spliterator, false, intFunction);
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            Node.OfInt ofInt = (Node.OfInt)pipelineHelper.evaluate(spliterator, true, intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node$OfInt.asPrimitiveArray:()Ljava/lang/Object;");
            int[] nArray = (int[])ofInt.asPrimitiveArray();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.parallelSort:([I)V");
            Arrays.parallelSort(nArray);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([I)Ljava/util/stream/Node$OfInt;");
            return Nodes.node(nArray);
        }
    }

    private static final class OfRef<T>
    extends ReferencePipeline.StatefulOp<T, T> {
        private final boolean isNaturalSort;
        private final Comparator<? super T> comparator;

        OfRef(AbstractPipeline<?, T, ?> abstractPipeline) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReferencePipeline$StatefulOp.<init>:(Ljava/util/stream/AbstractPipeline;Ljava/util/stream/StreamShape;I)V");
            super(abstractPipeline, StreamShape.REFERENCE, StreamOpFlag.IS_ORDERED | StreamOpFlag.IS_SORTED);
            this.isNaturalSort = true;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Comparator.naturalOrder:()Ljava/util/Comparator;");
            this.comparator = Comparator.naturalOrder();
        }

        OfRef(AbstractPipeline<?, T, ?> abstractPipeline, Comparator<? super T> comparator) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/ReferencePipeline$StatefulOp.<init>:(Ljava/util/stream/AbstractPipeline;Ljava/util/stream/StreamShape;I)V");
            super(abstractPipeline, StreamShape.REFERENCE, StreamOpFlag.IS_ORDERED | StreamOpFlag.NOT_SORTED);
            this.isNaturalSort = false;
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            this.comparator = Objects.requireNonNull(comparator);
        }

        @Override
        public Sink<T> opWrapSink(int n, Sink<T> sink) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Objects.requireNonNull:(Ljava/lang/Object;)Ljava/lang/Object;");
            Objects.requireNonNull(sink);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.isNaturalSort) {
                    return sink;
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl2 = StreamOpFlag.SIZED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl2) {
                RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$SizedRefSortingSink");
                RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$SizedRefSortingSink.<init>:(Ljava/util/stream/Sink;Ljava/util/Comparator;)V");
                return new SizedRefSortingSink<T>(sink, this.comparator);
            }
            RuntimeCostAccounter.recordAllocation((String)"java/util/stream/SortedOps$RefSortingSink");
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/SortedOps$RefSortingSink.<init>:(Ljava/util/stream/Sink;Ljava/util/Comparator;)V");
            return new RefSortingSink<T>(sink, this.comparator);
        }

        @Override
        public <P_IN> Node<T> opEvaluateParallel(PipelineHelper<T> pipelineHelper, Spliterator<P_IN> spliterator, IntFunction<T[]> intFunction) {
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.getStreamAndOpFlags:()I");
            int n = pipelineHelper.getStreamAndOpFlags();
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/StreamOpFlag.isKnown:(I)Z");
            boolean bl = StreamOpFlag.SORTED.isKnown(n);
            RuntimeCostAccounter.recordJump();
            if (bl) {
                RuntimeCostAccounter.recordJump();
                if (this.isNaturalSort) {
                    RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
                    return pipelineHelper.evaluate(spliterator, false, intFunction);
                }
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/PipelineHelper.evaluate:(Ljava/util/Spliterator;ZLjava/util/function/IntFunction;)Ljava/util/stream/Node;");
            Node<T> node = pipelineHelper.evaluate(spliterator, true, intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Node.asArray:(Ljava/util/function/IntFunction;)[Ljava/lang/Object;");
            T[] TArray = node.asArray(intFunction);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/Arrays.parallelSort:([Ljava/lang/Object;Ljava/util/Comparator;)V");
            Arrays.parallelSort(TArray, this.comparator);
            RuntimeCostAccounter.recordMethodCall((String)"java/util/stream/Nodes.node:([Ljava/lang/Object;)Ljava/util/stream/Node;");
            return Nodes.node(TArray);
        }
    }
}

