/*
 * Decompiled with CFR 0.152.
 */
package sandbox.java.io;

import sandbox.com.r3cev.costing.RuntimeCostAccounter;
import sandbox.java.io.FilterInputStream;
import sandbox.java.io.IOException;
import sandbox.java.io.InputStream;

public class PushbackInputStream
extends FilterInputStream {
    protected byte[] buf;
    protected int pos;

    private void ensureOpen() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.in == null) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Stream closed");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
    }

    public PushbackInputStream(InputStream inputStream, int n) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.<init>:(Ljava/io/InputStream;)V");
        super(inputStream);
        RuntimeCostAccounter.recordJump();
        if (n <= 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IllegalArgumentException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IllegalArgumentException.<init>:(Ljava/lang/String;)V");
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("size <= 0");
            RuntimeCostAccounter.recordThrow();
            throw illegalArgumentException;
        }
        int n2 = n;
        RuntimeCostAccounter.recordArrayAllocation((int)n2, (int)1);
        this.buf = new byte[n2];
        this.pos = n;
    }

    public PushbackInputStream(InputStream inputStream) {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.<init>:(Ljava/io/InputStream;I)V");
        this(inputStream, 1);
    }

    @Override
    public int read() throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.ensureOpen:()V");
        this.ensureOpen();
        int n = this.buf.length;
        RuntimeCostAccounter.recordJump();
        if (this.pos < n) {
            return this.buf[this.pos++] & 0xFF;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.read:()I");
        return super.read();
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        block12: {
            block11: {
                RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.ensureOpen:()V");
                this.ensureOpen();
                RuntimeCostAccounter.recordJump();
                if (byArray == null) {
                    RuntimeCostAccounter.recordAllocation((String)"java/lang/NullPointerException");
                    RuntimeCostAccounter.recordMethodCall((String)"java/lang/NullPointerException.<init>:()V");
                    NullPointerException nullPointerException = new NullPointerException();
                    RuntimeCostAccounter.recordThrow();
                    throw nullPointerException;
                }
                RuntimeCostAccounter.recordJump();
                if (n < 0) break block11;
                RuntimeCostAccounter.recordJump();
                if (n2 < 0) break block11;
                int n3 = byArray.length - n;
                RuntimeCostAccounter.recordJump();
                if (n2 <= n3) break block12;
            }
            RuntimeCostAccounter.recordAllocation((String)"java/lang/IndexOutOfBoundsException");
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/IndexOutOfBoundsException.<init>:()V");
            IndexOutOfBoundsException indexOutOfBoundsException = new IndexOutOfBoundsException();
            RuntimeCostAccounter.recordThrow();
            throw indexOutOfBoundsException;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 == 0) {
            return 0;
        }
        int n4 = this.buf.length - this.pos;
        RuntimeCostAccounter.recordJump();
        if (n4 > 0) {
            RuntimeCostAccounter.recordJump();
            if (n2 < n4) {
                n4 = n2;
            }
            RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
            System.arraycopy(this.buf, this.pos, byArray, n, n4);
            this.pos += n4;
            n += n4;
            n2 -= n4;
        }
        RuntimeCostAccounter.recordJump();
        if (n2 > 0) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.read:([BII)I");
            n2 = super.read(byArray, n, n2);
            RuntimeCostAccounter.recordJump();
            if (n2 == -1) {
                int n5;
                RuntimeCostAccounter.recordJump();
                if (n4 == 0) {
                    n5 = -1;
                    RuntimeCostAccounter.recordJump();
                } else {
                    n5 = n4;
                }
                return n5;
            }
            return n4 + n2;
        }
        return n4;
    }

    public void unread(int n) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (this.pos == 0) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Push back buffer is full");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        this.buf[--this.pos] = (byte)n;
    }

    public void unread(byte[] byArray, int n, int n2) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (n2 > this.pos) {
            RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
            RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
            IOException iOException = new IOException("Push back buffer is full");
            RuntimeCostAccounter.recordThrow();
            throw iOException;
        }
        this.pos -= n2;
        RuntimeCostAccounter.recordMethodCall((String)"java/lang/System.arraycopy:(Ljava/lang/Object;ILjava/lang/Object;II)V");
        System.arraycopy(byArray, n, this.buf, this.pos, n2);
    }

    public void unread(byte[] byArray) throws IOException {
        int n = byArray.length;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.unread:([BII)V");
        this.unread(byArray, 0, n);
    }

    @Override
    public int available() throws IOException {
        int n;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.ensureOpen:()V");
        this.ensureOpen();
        int n2 = this.buf.length - this.pos;
        RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.available:()I");
        int n3 = super.available();
        RuntimeCostAccounter.recordJump();
        if (n2 > Integer.MAX_VALUE - n3) {
            n = Integer.MAX_VALUE;
            RuntimeCostAccounter.recordJump();
        } else {
            n = n2 + n3;
        }
        return n;
    }

    @Override
    public long skip(long l) throws IOException {
        RuntimeCostAccounter.recordMethodCall((String)"java/io/PushbackInputStream.ensureOpen:()V");
        this.ensureOpen();
        RuntimeCostAccounter.recordJump();
        if (l <= 0L) {
            return 0L;
        }
        long l2 = this.buf.length - this.pos;
        RuntimeCostAccounter.recordJump();
        if (l2 > 0L) {
            RuntimeCostAccounter.recordJump();
            if (l < l2) {
                l2 = l;
            }
            this.pos = (int)((long)this.pos + l2);
            l -= l2;
        }
        RuntimeCostAccounter.recordJump();
        if (l > 0L) {
            RuntimeCostAccounter.recordMethodCall((String)"java/io/FilterInputStream.skip:(J)J");
            l2 += super.skip(l);
        }
        return l2;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int n) {
    }

    @Override
    public synchronized void reset() throws IOException {
        RuntimeCostAccounter.recordAllocation((String)"java/io/IOException");
        RuntimeCostAccounter.recordMethodCall((String)"java/io/IOException.<init>:(Ljava/lang/String;)V");
        IOException iOException = new IOException("mark/reset not supported");
        RuntimeCostAccounter.recordThrow();
        throw iOException;
    }

    @Override
    public synchronized void close() throws IOException {
        RuntimeCostAccounter.recordJump();
        if (this.in == null) {
            return;
        }
        RuntimeCostAccounter.recordMethodCall((String)"java/io/InputStream.close:()V");
        this.in.close();
        this.in = null;
        this.buf = null;
    }
}

