---
title: 'Registration'
linkTitle: 'Registration'
weight: 1
description: 'App CVAT user registration and account access.'
---

To start to annotate in CVAT, you need to
create an account or log in to the existing account.

This section describes [App CVAT](https://app.cvat.ai/), that is suitable
for small personal projects, that do not require user management.
It is also ok to use if you just want to try what is CVAT.

While it is easy to use, it has some limitations.
For example, in App CVAT you cannot create a superuser (admin account)
or administer user roles. All these features are available
for [Admin user](/docs/administration/basics/admin-account/) in
[local version of CVAT](/docs/administration/basics/installation/).

See:

- [User registration](#user-registration)
- [Account access](#account-access)

To creata account or log in, go to the [App CVAT](https://app.cvat.ai/) login page:

![](/images/image001.jpg)

> **Note:** By default authentication and registration with Google and GitHub work only for [App CVAT](https://app.cvat.ai/). <br>If you want to use Google and GitHub authentication on a local installation, see [Social auth configuration](/docs/administration/basics/social-accounts-configuration/).

### User registration

To register as a non-admin user, do the following:

1. Click **Create an account**.

   ![Create account](/images/image002.jpg)

2. Fill in all blank fields, accept terms of use, and
   click the **Create an account** button.

![Account form](/images/image003.jpg)

<br>A username generates from the email automatically. You can edit it if needed.

![Usernname generation](/images/filling_email.gif)

To register with Google or GitHub, click the button with the name of the service, and follow instructions on the screen.

### Account access

To access your account, do the following:

1. Go to the login page.
2. Enter username or email. The password field will appear.
3. Enter the password and click **Next**.

To log in with Google or GitHub, click the button with the name of the service.
