---
title: 'Shortcuts'
linkTitle: 'Shortcuts'
weight: 23
description: 'List of available mouse and keyboard shortcuts.'
---

Many UI elements have shortcut hints. Put your pointer to a required element to see it.

![](/images/image075.jpg)

| Shortcut                   | Common                                                                                                   |
| -------------------------- | -------------------------------------------------------------------------------------------------------- |
|                            | _Main functions_                                                                                         |
| `F1`                       | Open/hide the list of available shortcuts                                                                |
| `F2`                       | Go to the settings page or go back                                                                       |
| `Ctrl+S`                   | Go to the settings page or go back                                                                       |
| `Ctrl+Z`                   | Cancel the latest action related with objects                                                            |
| `Ctrl+Shift+Z` or `Ctrl+Y` | Cancel undo action                                                                                       |
| Hold `Mouse Wheel`         | To move an image frame (for example, while drawing)                                                      |
|                            | _Player_                                                                                                 |
| `F`                        | Go to the next frame                                                                                     |
| `D`                        | Go to the previous frame                                                                                 |
| `V`                        | Go forward with a step                                                                                   |
| `C`                        | Go backward with a step                                                                                  |
| `Right`                    | Search the next frame that satisfies to the filters <br> or next frame which contain any objects         |
| `Left`                     | Search the previous frame that satisfies to the filters <br> or previous frame which contain any objects |
| `Space`                    | Start/stop automatic changing frames                                                                     |
| `` ` `` or `~`             | Focus on the element to change the current frame                                                         |
|                            | _Modes_                                                                                                  |
| `N`                        | Repeat the latest procedure of drawing with the same parameters                                          |
| `M`                        | Activate or deactivate mode to merging shapes                                                            |
| `Alt+M`                    | Activate or deactivate mode to splitting shapes                                                          |
| `G`                        | Activate or deactivate mode to grouping shapes                                                           |
| `Shift+G`                  | Reset group for selected shapes (in group mode)                                                          |
| `Esc`                      | Cancel any active canvas mode                                                                            |
|                            | _Image operations_                                                                                       |
| `Ctrl+R`                   | Change image angle (add 90 degrees)                                                                      |
| `Ctrl+Shift+R`             | Change image angle (subtract 90 degrees)                                                                 |
|                            | _Operations with objects_                                                                                |
| `Ctrl`                     | Switch automatic bordering for polygons and polylines during drawing/editing                             |
| Hold `Ctrl`                | When the shape is active and fix it                                                                      |
| `Alt+Click` on point       | Deleting a point (used when hovering over a point of polygon, polyline, points)                          |
| `Shift+Click` on point     | Editing a shape (used when hovering over a point of polygon, polyline or points)                         |
| `Right-Click` on shape     | Display of an object element from objects sidebar                                                        |
| `T+L`                      | Change locked state for all objects in the sidebar                                                       |
| `L`                        | Change locked state for an active object                                                                 |
| `T+H`                      | Change hidden state for objects in the sidebar                                                           |
| `H`                        | Change hidden state for an active object                                                                 |
| `Q` or `/`                 | Change occluded property for an active object                                                            |
| `Del` or `Shift+Del`       | Delete an active object. Use shift to force delete of locked objects                                     |
| `-` or `_`                 | Put an active object "farther" from the user (decrease z axis value)                                     |
| `+` or `=`                 | Put an active object "closer" to the user (increase z axis value)                                        |
| `Ctrl+C`                   | Copy shape to CVAT internal clipboard                                                                    |
| `Ctrl+V`                   | Paste a shape from internal CVAT clipboard                                                               |
| Hold `Ctrl` while pasting  | When pasting shape from the buffer for multiple pasting.                                                 |
| `Ctrl+B`                   | Make a copy of the object on the following frames                                                        |
| `Ctrl+(0..9)`              | Changes a label for an activated object or for the next drawn object if no objects are activated         |
|                            | _Operations are available only for track_                                                                |
| `K`                        | Change keyframe property for an active track                                                             |
| `O`                        | Change outside property for an active track                                                              |
| `R`                        | Go to the next keyframe of an active track                                                               |
| `E`                        | Go to the previous keyframe of an active track                                                           |
|                            | _Attribute annotation mode_                                                                              |
| `Up Arrow`                 | Go to the next attribute (up)                                                                            |
| `Down Arrow`               | Go to the next attribute (down)                                                                          |
| `Tab`                      | Go to the next annotated object in current frame                                                         |
| `Shift+Tab`                | Go to the previous annotated object in current frame                                                     |
| `<number>`                 | Assign a corresponding value to the current attribute                                                    |
|                            | _Standard 3d mode_                                                                                       |
| `Shift+Up Arrow`           | Increases camera roll angle                                                                              |
| `Shift+Down Arrow`         | Decreases camera roll angle                                                                              |
| `Shift+Left Arrow`         | Decreases camera pitch angle                                                                             |
| `Shift+Right Arrow`        | Increases camera pitch angle                                                                             |
| `Alt+O`                    | Move the camera up                                                                                       |
| `Alt+U`                    | Move the camera down                                                                                     |
| `Alt+J`                    | Move the camera left                                                                                     |
| `Alt+L`                    | Move the camera right                                                                                    |
| `Alt+I`                    | Performs zoom in                                                                                         |
| `Alt+K`                    | Performs zoom out                                                                                        |
