---
title: 'Documentation'
linkTitle: 'Documentation'
description: 'Welcome to the documentation of Computer Vision Annotation Tool.'
no_list: true
menu:
  main:
    weight: 20
---

CVAT is a free, online, interactive video and image annotation tool for computer vision.
It is being developed and used by Intel to annotate millions of objects with different properties.
Many UI and UX decisions are based on feedbacks from professional data annotation team.
Try it online [app.cvat.ai](https://app.cvat.ai).

Our documentation provides information for AI researchers, system administrators, developers, simple and advanced users.
The documentation is divided into three sections, and each section is divided into subsections `basic` and `advanced`.

<section id="docs">

{{< blocks/section color="docs" >}}

{{% blocks/feature icon="fa-sign-in-alt" title="[Getting started](/docs/getting_started/)" %}}

Basic information and sections needed for a quick start.

{{% /blocks/feature %}}

{{% blocks/feature icon="fa-question" title="[FAQ](/docs/faq/)" %}}

Answers to frequently asked questions.

{{% /blocks/feature %}}

{{% blocks/feature icon="fab fa-github" title="[GitHub Repository](https://github.com/cvat-ai/cvat)" %}}

Computer Vision Annotation Tool GitHub repository.

{{% /blocks/feature %}}


<!--lint disable maximum-line-length-->

{{% blocks/feature icon="fa-book" title="[Manual](/docs/manual/)" %}}

This section contains documents for CVAT simple and advanced users.

{{% /blocks/feature %}}

{{% blocks/feature icon="fa-server" title="[Administration](/docs/administration/)" %}}

This section contains documents for system administrators.

{{% /blocks/feature %}}

{{% blocks/feature icon="fa-terminal" title="[Contributing](/docs/contributing/)" %}}

This section contains documents for developers.

{{% /blocks/feature %}}


{{< /blocks/section >}}

</section>
