---
title: 'Subscription management'
linkTitle: 'Subscription management'
weight: 2
description: 'How to manage your subscription'
---

This article provides tips on how to effectively manage your
CVAT subscriptions, including tracking expenses and canceling
unnecessary subscriptions, to optimize your finances and save time.

Whether you're a business owner or an individual,
you'll learn how to take control of your subscriptions and manage them.

See:

- [Billing](#billing)
  - [Pro plan](#pro-plan)
  - [Team plan](#team-plan)
- [Change payment method](#change-payment-method)
  - [Pro plan](#pro-plan-1)
  - [Team plan](#team-plan-1)
- [Adding and removing team members](#adding-and-removing-team-members)
  - [Pro plan](#pro-plan-2)
  - [Team plan](#team-plan-2)
- [Change plan](#change-plan)
- [Can I subscribe to several plans?](#can-i-subscribe-to-several-plans)
- [Cancel plan](#cancel-plan)
  - [What will happen to my data?](#what-will-happen-to-my-data)
  - [Pro plan](#pro-plan-3)
  - [Team plan](#team-plan-3)
- [Plan renewal](#plan-renewal)
  - [Pro plan](#pro-plan-4)
  - [Team plan](#team-plan-4)

## Billing

This section describes the billing model and gives short a
description of limitations for each plan.

For more information,
see: [Pricing Plans](https://www.cvat.ai/post/new-pricing-plans)

### Pro plan

**Account/Month**: The **Pro** plan has a fixed price and is
designed for personal use only.  It doesn't allow collaboration with team members,
but removes all the other limits of the **Free** plan.


### Team plan

**Member/month**: The **Team** plan allows you to create
an organization and add team members who can collaborate on projects.
The **monthly payment for the plan depends on the number of team members you've added**.
All limits of the **Free** plan will be removed.

## Change payment method

This section describes how to change or add payment methods.

### Pro plan

Access Manage **Pro Plan** > **Manage** and click **+Add Payment Method**

![Payment pro](/images/update_payment_pro.png)

### Team plan

Access **Manage Team Plan** > **Manage** and click **+Add Payment Method**.

![Payment team](/images/update_payment_team.png)

## Adding and removing team members

This section describes how to add team members
to collaborate within one team.

### Pro plan

Not available.

### Team plan

Go to the **Manage Team plan** > **Manage** > **Update quantity**.

![Add members](/images/change_members_number_team.gif)

If you've added a user **before the current billing period ends**,
the payment will be prorated for the remaining time until the
next billing cycle begins. From the following month onward,
the full payment will be charged.

In case you **removed the user before the current billing period ends**,
funds will not be returned to your account,
but next month you will pay less by the amount of unused funds.

## Change plan

The procedure is the same for both **Pro** and **Team** plans.

If for some reason you want to change your plan, you need to:

1. Unsubscribe from the previous plan.
2. If you need a refund, contact us at [accounting@cvat.ai](mailto:accounting@cvat.ai).
3. Subscribe to a new plan.

## Can I subscribe to several plans?

Paid plans are not mutually exclusive.
You can have several active subscriptions,
for example, the **Pro** plan and several **Team**
plans for different organizations.

## Cancel plan

This section describes how to cancel your CVAT subscription
and what will happen to your data.

### What will happen to my data?

Once you have terminated your subscription, your data will remain
accessible within the system for a month. During this period,
you will be unable to add new tasks and free plan limits will be applied.

In case you possess a substantial amount of data,
it will be switched to read-only mode. It means
you will not be able to save annotations, add any resources,
and so on.

Following the one month, you will receive a
notification requesting you to either remove the
excess data or it will be deleted automatically.

### Pro plan

Access **Manage Pro Plan** > **Manage** > **Cancel plan**

Please, fill out the feedback form, to help us improve our platform.

![Cancel pro](/images/cancel_pro.gif)

### Team plan

Access **Manage Team plan** > **Manage** -> **Cancel plan**

Please, fill out the feedback form, to help us improve our platform.

![Cancel team](/images/cancel_team.gif)

## Plan renewal

This section describes how to renew your
CVAT subscription

### Pro plan

Access **Manage Pro Plan** > **Manage** > **Renew plan**

### Team plan

Access **Manage Team Plan** > **Manage** > **Renew plan**
