import { Transform, Type } from 'class-transformer'
import { IsInt, IsOptional, IsString } from 'class-validator'

import { PagerDto } from '~/shared/dto/pager.dto'

export class CategoryAndSlugDto {
  @IsString()
  readonly category: string

  @IsString()
  @Transform(({ value: v }) => decodeURI(v))
  readonly slug: string
}

export class PostPagerDto extends PagerDto {
  @IsOptional()
  @IsInt()
  @Type(() => Number)
  truncate?: number
}
