/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import se.vidstige.jadb.JadbException;
import se.vidstige.jadb.RemoteFile;
import se.vidstige.jadb.SyncTransport;
import se.vidstige.jadb.server.AdbDeviceResponder;
import se.vidstige.jadb.server.AdbResponder;

class AdbProtocolHandler
implements Runnable {
    private final Socket socket;
    private final AdbResponder responder;
    private AdbDeviceResponder selected;

    public AdbProtocolHandler(Socket socket, AdbResponder responder) {
        this.socket = socket;
        this.responder = responder;
    }

    private AdbDeviceResponder findDevice(String serial) throws ProtocolException {
        for (AdbDeviceResponder d : this.responder.getDevices()) {
            if (!d.getSerial().equals(serial)) continue;
            return d;
        }
        throw new ProtocolException("'" + serial + "' not connected");
    }

    @Override
    public void run() {
        block2: {
            try {
                this.runServer();
            }
            catch (IOException e) {
                if (e.getMessage() == null) break block2;
                System.out.println("IO Error: " + e.getMessage());
            }
        }
    }

    private void runServer() throws IOException {
        try (DataInputStream input = new DataInputStream(this.socket.getInputStream());
             DataOutputStream output = new DataOutputStream(this.socket.getOutputStream());){
            while (this.processCommand(input, output)) {
            }
        }
    }

    private boolean processCommand(DataInput input, DataOutputStream output) throws IOException {
        block11: {
            String command = this.readCommand(input);
            this.responder.onCommand(command);
            try {
                if ("host:version".equals(command)) {
                    this.hostVersion(output);
                    break block11;
                }
                if ("host:transport-any".equals(command)) {
                    this.hostTransportAny(output);
                    break block11;
                }
                if ("host:devices".equals(command)) {
                    this.hostDevices(output);
                    break block11;
                }
                if (command.startsWith("host:transport:")) {
                    this.hostTransport(output, command);
                    break block11;
                }
                if ("sync:".equals(command)) {
                    this.sync(output, input);
                    break block11;
                }
                if (command.startsWith("shell:")) {
                    this.shell(input, output, command);
                    return false;
                }
                if ("host:get-state".equals(command)) {
                    this.hostGetState(output);
                    break block11;
                }
                if (command.startsWith("host-serial:")) {
                    this.hostSerial(output, command);
                    break block11;
                }
                if (command.startsWith("tcpip:")) {
                    this.handleTcpip(output, command);
                    break block11;
                }
                throw new ProtocolException("Unknown command: " + command);
            }
            catch (ProtocolException e) {
                output.writeBytes("FAIL");
                this.send(output, e.getMessage());
            }
        }
        output.flush();
        return true;
    }

    private void handleTcpip(DataOutputStream output, String command) throws IOException {
        output.writeBytes("OKAY");
        this.selected.enableIpCommand(command.substring("tcpip:".length()), output);
    }

    private void hostSerial(DataOutput output, String command) throws IOException {
        String[] strs = command.split(":", 0);
        if (strs.length != 3) {
            throw new ProtocolException("Invalid command: " + command);
        }
        String serial = strs[1];
        boolean found = false;
        output.writeBytes("OKAY");
        for (AdbDeviceResponder d : this.responder.getDevices()) {
            if (!d.getSerial().equals(serial)) continue;
            this.send(output, d.getType());
            found = true;
            break;
        }
        if (!found) {
            this.send(output, "unknown");
        }
    }

    private void hostGetState(DataOutput output) throws IOException {
        AdbDeviceResponder device = this.responder.getDevices().get(0);
        output.writeBytes("OKAY");
        this.send(output, device.getType());
    }

    private void shell(DataInput input, DataOutputStream output, String command) throws IOException {
        String shellCommand = command.substring("shell:".length());
        output.writeBytes("OKAY");
        this.shell(shellCommand, output, input);
    }

    private void hostTransport(DataOutput output, String command) throws IOException {
        String serial = command.substring("host:transport:".length());
        this.selected = this.findDevice(serial);
        output.writeBytes("OKAY");
    }

    private void hostDevices(DataOutput output) throws IOException {
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        DataOutputStream writer = new DataOutputStream(tmp);
        for (AdbDeviceResponder d : this.responder.getDevices()) {
            writer.writeBytes(d.getSerial() + "\t" + d.getType() + "\n");
        }
        output.writeBytes("OKAY");
        this.send(output, new String(tmp.toByteArray(), StandardCharsets.UTF_8));
    }

    private void hostTransportAny(DataOutput output) throws IOException {
        this.selected = this.responder.getDevices().get(0);
        output.writeBytes("OKAY");
    }

    private void hostVersion(DataOutput output) throws IOException {
        output.writeBytes("OKAY");
        this.send(output, String.format("%04x", this.responder.getVersion()));
    }

    private void shell(String command, DataOutputStream stdout, DataInput stdin) throws IOException {
        this.selected.shell(command, stdout, stdin);
    }

    private int readInt(DataInput input) throws IOException {
        return Integer.reverseBytes(input.readInt());
    }

    private int readHexInt(DataInput input) throws IOException {
        return Integer.parseInt(this.readString(input, 4), 16);
    }

    private String readString(DataInput input, int length) throws IOException {
        byte[] responseBuffer = new byte[length];
        input.readFully(responseBuffer);
        return new String(responseBuffer, StandardCharsets.UTF_8);
    }

    private String readCommand(DataInput input) throws IOException {
        int length = this.readHexInt(input);
        return this.readString(input, length);
    }

    private void sync(DataOutput output, DataInput input) throws IOException {
        output.writeBytes("OKAY");
        try {
            String id = this.readString(input, 4);
            int length = this.readInt(input);
            switch (id) {
                case "SEND": {
                    this.syncSend(output, input, length);
                    break;
                }
                case "RECV": {
                    this.syncRecv(output, input, length);
                    break;
                }
                case "LIST": {
                    this.syncList(output, input, length);
                    break;
                }
                default: {
                    throw new JadbException("Unknown sync id " + id);
                }
            }
        }
        catch (JadbException e) {
            SyncTransport sync = this.getSyncTransport(output, input);
            sync.send("FAIL", e.getMessage());
        }
    }

    private void syncRecv(DataOutput output, DataInput input, int length) throws IOException, JadbException {
        String remotePath = this.readString(input, length);
        SyncTransport transport = this.getSyncTransport(output, input);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        this.selected.filePulled(new RemoteFile(remotePath), buffer);
        transport.sendStream(new ByteArrayInputStream(buffer.toByteArray()));
        transport.sendStatus("DONE", 0);
    }

    private void syncSend(DataOutput output, DataInput input, int length) throws IOException, JadbException {
        String remotePath = this.readString(input, length);
        int idx = remotePath.lastIndexOf(44);
        String path = remotePath;
        int mode = 438;
        if (idx > 0) {
            path = remotePath.substring(0, idx);
            mode = Integer.parseInt(remotePath.substring(idx + 1));
        }
        SyncTransport transport = this.getSyncTransport(output, input);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        transport.readChunksTo(buffer);
        this.selected.filePushed(new RemoteFile(path), mode, buffer);
        transport.sendStatus("OKAY", 0);
    }

    private void syncList(DataOutput output, DataInput input, int length) throws IOException, JadbException {
        String remotePath = this.readString(input, length);
        SyncTransport transport = this.getSyncTransport(output, input);
        for (RemoteFile file : this.selected.list(remotePath)) {
            transport.sendDirectoryEntry(file);
        }
        transport.sendDirectoryEntryDone();
    }

    private String getCommandLength(String command) {
        return String.format("%04x", command.length());
    }

    private void send(DataOutput writer, String response) throws IOException {
        writer.writeBytes(this.getCommandLength(response));
        writer.writeBytes(response);
    }

    private SyncTransport getSyncTransport(DataOutput output, DataInput input) {
        return new SyncTransport(output, input);
    }
}

