/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled.spi;

import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;

public abstract class FormatConversionProvider {
    public abstract AudioFormat.Encoding[] getSourceEncodings();

    public abstract AudioFormat.Encoding[] getTargetEncodings();

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        return Arrays.stream(this.getSourceEncodings()).anyMatch(sourceEncoding::equals);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        return Arrays.stream(this.getTargetEncodings()).anyMatch(targetEncoding::equals);
    }

    public abstract AudioFormat.Encoding[] getTargetEncodings(AudioFormat var1);

    public boolean isConversionSupported(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        return Arrays.stream(this.getTargetEncodings(sourceFormat)).anyMatch(targetEncoding::equals);
    }

    public abstract AudioFormat[] getTargetFormats(AudioFormat.Encoding var1, AudioFormat var2);

    public boolean isConversionSupported(AudioFormat targetFormat, AudioFormat sourceFormat) {
        AudioFormat.Encoding targetEncoding = targetFormat.getEncoding();
        return Arrays.stream(this.getTargetFormats(targetEncoding, sourceFormat)).anyMatch(targetFormat::matches);
    }

    public abstract AudioInputStream getAudioInputStream(AudioFormat.Encoding var1, AudioInputStream var2);

    public abstract AudioInputStream getAudioInputStream(AudioFormat var1, AudioInputStream var2);
}

