/*
 * Decompiled with CFR 0.152.
 */
package java.awt.print;

import java.awt.AWTError;
import java.awt.HeadlessException;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;

public abstract class PrinterJob {
    public static PrinterJob getPrinterJob() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPrintJobAccess();
        }
        return AccessController.doPrivileged(new PrivilegedAction<PrinterJob>(){

            @Override
            public PrinterJob run() {
                String nm = System.getProperty("java.awt.printerjob", null);
                try {
                    return (PrinterJob)Class.forName(nm).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ClassNotFoundException e) {
                    throw new AWTError("PrinterJob not found: " + nm);
                }
                catch (ReflectiveOperationException e) {
                    throw new AWTError("Could not instantiate PrinterJob: " + nm);
                }
            }
        });
    }

    public static PrintService[] lookupPrintServices() {
        return PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null);
    }

    public static StreamPrintServiceFactory[] lookupStreamPrintServices(String mimeType) {
        return StreamPrintServiceFactory.lookupStreamPrintServiceFactories(DocFlavor.SERVICE_FORMATTED.PAGEABLE, mimeType);
    }

    public PrintService getPrintService() {
        return null;
    }

    public void setPrintService(PrintService service) throws PrinterException {
        throw new PrinterException("Setting a service is not supported on this class");
    }

    public abstract void setPrintable(Printable var1);

    public abstract void setPrintable(Printable var1, PageFormat var2);

    public abstract void setPageable(Pageable var1) throws NullPointerException;

    public abstract boolean printDialog() throws HeadlessException;

    public boolean printDialog(PrintRequestAttributeSet attributes) throws HeadlessException {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        return this.printDialog();
    }

    public abstract PageFormat pageDialog(PageFormat var1) throws HeadlessException;

    public PageFormat pageDialog(PrintRequestAttributeSet attributes) throws HeadlessException {
        if (attributes == null) {
            throw new NullPointerException("attributes");
        }
        return this.pageDialog(this.defaultPage());
    }

    public abstract PageFormat defaultPage(PageFormat var1);

    public PageFormat defaultPage() {
        return this.defaultPage(new PageFormat());
    }

    public PageFormat getPageFormat(PrintRequestAttributeSet attributes) {
        MediaSizeName msn;
        MediaSize msz;
        Object mpaVals;
        PrintService service = this.getPrintService();
        PageFormat pf = this.defaultPage();
        if (service == null || attributes == null) {
            return pf;
        }
        Media media = (Media)attributes.get(Media.class);
        MediaPrintableArea mpa = (MediaPrintableArea)attributes.get(MediaPrintableArea.class);
        OrientationRequested orientReq = (OrientationRequested)attributes.get(OrientationRequested.class);
        if (media == null && mpa == null && orientReq == null) {
            return pf;
        }
        Paper paper = pf.getPaper();
        if (mpa == null && media != null && service.isAttributeCategorySupported(MediaPrintableArea.class) && (mpaVals = service.getSupportedAttributeValues(MediaPrintableArea.class, null, attributes)) instanceof MediaPrintableArea[] && ((MediaPrintableArea[])mpaVals).length > 0) {
            mpa = ((MediaPrintableArea[])mpaVals)[0];
        }
        if (media != null && service.isAttributeValueSupported(media, null, attributes) && media instanceof MediaSizeName && (msz = MediaSize.getMediaSizeForName(msn = (MediaSizeName)media)) != null) {
            double inch = 72.0;
            double paperWid = (double)msz.getX(25400) * inch;
            double paperHgt = (double)msz.getY(25400) * inch;
            paper.setSize(paperWid, paperHgt);
            if (mpa == null) {
                paper.setImageableArea(inch, inch, paperWid - 2.0 * inch, paperHgt - 2.0 * inch);
            }
        }
        if (mpa != null && service.isAttributeValueSupported(mpa, null, attributes)) {
            float[] printableArea = mpa.getPrintableArea(25400);
            for (int i = 0; i < printableArea.length; ++i) {
                printableArea[i] = printableArea[i] * 72.0f;
            }
            paper.setImageableArea(printableArea[0], printableArea[1], printableArea[2], printableArea[3]);
        }
        if (orientReq != null && service.isAttributeValueSupported(orientReq, null, attributes)) {
            int orient = orientReq.equals(OrientationRequested.REVERSE_LANDSCAPE) ? 2 : (orientReq.equals(OrientationRequested.LANDSCAPE) ? 0 : 1);
            pf.setOrientation(orient);
        }
        pf.setPaper(paper);
        pf = this.validatePage(pf);
        return pf;
    }

    public abstract PageFormat validatePage(PageFormat var1);

    public abstract void print() throws PrinterException;

    public void print(PrintRequestAttributeSet attributes) throws PrinterException {
        this.print();
    }

    public abstract void setCopies(int var1);

    public abstract int getCopies();

    public abstract String getUserName();

    public abstract void setJobName(String var1);

    public abstract String getJobName();

    public abstract void cancel();

    public abstract boolean isCancelled();
}

