/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaSplitPaneDividerUI;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSplitPaneDivider;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class AquaSplitPaneUI
extends BasicSplitPaneUI
implements MouseListener,
PropertyChangeListener {
    static final String DIVIDER_PAINTER_KEY = "JSplitPane.dividerPainter";

    public static ComponentUI createUI(JComponent x) {
        return new AquaSplitPaneUI();
    }

    @Override
    public BasicSplitPaneDivider createDefaultDivider() {
        return new AquaSplitPaneDividerUI(this);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.splitPane.addPropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        this.divider.addMouseListener(this);
    }

    @Override
    protected void uninstallListeners() {
        this.divider.removeMouseListener(this);
        this.splitPane.removePropertyChangeListener(DIVIDER_PAINTER_KEY, this);
        super.uninstallListeners();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        if (!this.splitPane.isOneTouchExpandable()) {
            return;
        }
        double resizeWeight = this.splitPane.getResizeWeight();
        int paneWidth = this.splitPane.getWidth();
        int divSize = this.splitPane.getDividerSize();
        int divLocation = this.splitPane.getDividerLocation();
        int lastDivLocation = this.splitPane.getLastDividerLocation();
        if (paneWidth - divSize <= divLocation + 5) {
            this.splitPane.setDividerLocation(lastDivLocation);
            return;
        }
        if (divSize >= divLocation - 5) {
            this.splitPane.setDividerLocation(lastDivLocation);
            return;
        }
        if (resizeWeight > 0.5) {
            this.splitPane.setDividerLocation(0);
        } else {
            this.splitPane.setDividerLocation(paneWidth);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!DIVIDER_PAINTER_KEY.equals(evt.getPropertyName())) {
            return;
        }
        Object value = evt.getNewValue();
        if (value instanceof Border) {
            this.divider.setBorder((Border)value);
        } else {
            this.divider.setBorder(null);
        }
    }
}

