/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.ScreenPopupFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.PopupFactory;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicPopupMenuUI;

public class AquaPopupMenuUI
extends BasicPopupMenuUI {
    static final int OVERLAP_SLACK = 10;

    public static ComponentUI createUI(JComponent x) {
        return new AquaPopupMenuUI();
    }

    @Override
    public boolean isPopupTrigger(MouseEvent e) {
        return e.isPopupTrigger();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(g instanceof Graphics2D)) {
            super.paint(g, c);
            return;
        }
        if (!(PopupFactory.getSharedInstance() instanceof ScreenPopupFactory)) {
            super.paint(g, c);
            return;
        }
        Graphics2D g2d = (Graphics2D)g.create();
        Rectangle popupBounds = this.popupMenu.getBounds();
        this.paintRoundRect(g2d, popupBounds);
        this.clipEdges(g2d, popupBounds);
        g2d.dispose();
        super.paint(g, c);
    }

    protected void paintRoundRect(Graphics2D g2d, Rectangle popupBounds) {
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.Clear);
        g2d.setStroke(new BasicStroke(3.0f));
        g2d.drawRoundRect(-2, -2, popupBounds.width + 3, popupBounds.height + 3, 12, 12);
    }

    protected void clipEdges(Graphics2D g2d, Rectangle popupBounds) {
        boolean invokerMidpointAbovePopupMidpoint;
        Component invoker = this.popupMenu.getInvoker();
        if (!(invoker instanceof JMenu)) {
            return;
        }
        Rectangle invokerBounds = invoker.getBounds();
        invokerBounds.setLocation(invoker.getLocationOnScreen());
        popupBounds.setLocation(this.popupMenu.getLocationOnScreen());
        Point invokerCenter = new Point((int)invokerBounds.getCenterX(), (int)invokerBounds.getCenterY());
        if (popupBounds.contains(invokerCenter)) {
            return;
        }
        g2d.setComposite(AlphaComposite.SrcOver);
        g2d.setColor(this.popupMenu.getBackground());
        Point popupCenter = new Point((int)popupBounds.getCenterX(), (int)popupBounds.getCenterY());
        boolean bl = invokerMidpointAbovePopupMidpoint = invokerCenter.y <= popupCenter.y;
        if (invokerBounds.x + invokerBounds.width < popupBounds.x + 10) {
            if (invokerMidpointAbovePopupMidpoint) {
                g2d.fillRect(-2, -2, 8, 8);
                return;
            }
            g2d.fillRect(-2, popupBounds.height - 6, 8, 8);
            return;
        }
        if (popupBounds.x + popupBounds.width < invokerBounds.x + 10) {
            if (invokerMidpointAbovePopupMidpoint) {
                g2d.fillRect(popupBounds.width - 6, -2, 8, 8);
                return;
            }
            g2d.fillRect(popupBounds.width - 6, popupBounds.height - 6, 8, 8);
            return;
        }
        if (invokerBounds.y + invokerBounds.height < popupBounds.y + 10) {
            g2d.fillRect(-2, -2, popupBounds.width + 4, 8);
            return;
        }
    }
}

