/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaComboBoxButton;
import com.apple.laf.AquaComboBoxPopup;
import com.apple.laf.AquaComboBoxRenderer;
import com.apple.laf.AquaListUI;
import com.apple.laf.AquaUtilControlSize;
import com.apple.laf.AquaUtils;
import com.apple.laf.ClientPropertyApplicator;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleState;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComboBoxEditor;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ListUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class AquaComboBoxUI
extends BasicComboBoxUI
implements AquaUtilControlSize.Sizeable {
    static final String POPDOWN_CLIENT_PROPERTY_KEY = "JComboBox.isPopDown";
    static final String ISSQUARE_CLIENT_PROPERTY_KEY = "JComboBox.isSquare";
    private boolean wasOpaque;
    private Action highlightNextAction = new ComboBoxAction(){

        @Override
        public void performComboBoxAction(AquaComboBoxUI ui) {
            int si = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (si < AquaComboBoxUI.this.comboBox.getModel().getSize() - 1) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(si + 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(si + 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    private Action highlightPreviousAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int si = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (si > 0) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(si - 1);
                AquaComboBoxUI.this.listBox.ensureIndexIsVisible(si - 1);
            }
            AquaComboBoxUI.this.comboBox.repaint();
        }
    };
    private Action highlightFirstAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            AquaComboBoxUI.this.listBox.setSelectedIndex(0);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(0);
        }
    };
    private Action highlightLastAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int size = AquaComboBoxUI.this.listBox.getModel().getSize();
            AquaComboBoxUI.this.listBox.setSelectedIndex(size - 1);
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(size - 1);
        }
    };
    private Action highlightPageUpAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int first;
            int current = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (current != (first = AquaComboBoxUI.this.listBox.getFirstVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(first);
                return;
            }
            int page = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int target = first - page;
            if (target < 0) {
                target = 0;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(target);
            AquaComboBoxUI.this.listBox.setSelectedIndex(target);
        }
    };
    private Action highlightPageDownAction = new ComboBoxAction(){

        @Override
        void performComboBoxAction(AquaComboBoxUI ui) {
            int last;
            int current = AquaComboBoxUI.this.listBox.getSelectedIndex();
            if (current != (last = AquaComboBoxUI.this.listBox.getLastVisibleIndex())) {
                AquaComboBoxUI.this.listBox.setSelectedIndex(last);
                return;
            }
            int page = ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getVisibleRect().height / ((AquaComboBoxUI)AquaComboBoxUI.this).listBox.getCellBounds((int)0, (int)0).height;
            int target = last + page;
            int end = AquaComboBoxUI.this.listBox.getModel().getSize() - 1;
            if (target > end) {
                target = end;
            }
            AquaComboBoxUI.this.listBox.ensureIndexIsVisible(target);
            AquaComboBoxUI.this.listBox.setSelectedIndex(target);
        }
    };
    protected static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";
    private final Action triggerSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AquaComboBoxUI.triggerSelectionEvent((JComboBox)e.getSource(), e);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    private static final Action toggleSelectionAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (!comboBox.isEnabled()) {
                return;
            }
            if (comboBox.isEditable()) {
                return;
            }
            AquaComboBoxUI aquaUi = (AquaComboBoxUI)comboBox.getUI();
            if (comboBox.isPopupVisible()) {
                comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
                comboBox.setPopupVisible(false);
                return;
            }
            comboBox.setPopupVisible(true);
        }
    };
    private final Action hideAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            comboBox.firePopupMenuCanceled();
            comboBox.setPopupVisible(false);
        }

        @Override
        public boolean isEnabled() {
            return AquaComboBoxUI.this.comboBox.isPopupVisible() && super.isEnabled();
        }
    };
    private static final AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>> APPLICATOR = new AquaUtils.RecyclableSingleton<ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>>(){

        @Override
        protected ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getInstance() {
            return new ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI>(new ClientPropertyApplicator.Property[]{new ClientPropertyApplicator.Property<AquaComboBoxUI>("Frame.active"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    if (Boolean.FALSE.equals(value) && target.comboBox != null) {
                        target.comboBox.hidePopup();
                    }
                    if (target.listBox != null) {
                        target.listBox.repaint();
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("editable"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    if (target.comboBox == null) {
                        return;
                    }
                    target.comboBox.repaint();
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("background"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    Color color = (Color)value;
                    if (target.arrowButton != null) {
                        target.arrowButton.setBackground(color);
                    }
                    if (target.listBox != null) {
                        target.listBox.setBackground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>("foreground"){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    Color color = (Color)value;
                    if (target.arrowButton != null) {
                        target.arrowButton.setForeground(color);
                    }
                    if (target.listBox != null) {
                        target.listBox.setForeground(color);
                    }
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.POPDOWN_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    if (!(target.arrowButton instanceof AquaComboBoxButton)) {
                        return;
                    }
                    ((AquaComboBoxButton)target.arrowButton).setIsPopDown(Boolean.TRUE.equals(value));
                }
            }, new ClientPropertyApplicator.Property<AquaComboBoxUI>(AquaComboBoxUI.ISSQUARE_CLIENT_PROPERTY_KEY){

                @Override
                public void applyProperty(AquaComboBoxUI target, Object value) {
                    if (!(target.arrowButton instanceof AquaComboBoxButton)) {
                        return;
                    }
                    ((AquaComboBoxButton)target.arrowButton).setIsSquare(Boolean.TRUE.equals(value));
                }
            }}){

                @Override
                public AquaComboBoxUI convertJComponentToTarget(JComboBox<?> combo) {
                    ComboBoxUI comboUI = combo.getUI();
                    if (comboUI instanceof AquaComboBoxUI) {
                        return (AquaComboBoxUI)comboUI;
                    }
                    return null;
                }
            };
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new AquaComboBoxUI();
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        LookAndFeel.installProperty(c, "opaque", Boolean.FALSE);
        this.wasOpaque = c.isOpaque();
        c.setOpaque(false);
    }

    @Override
    public void uninstallUI(JComponent c) {
        c.setOpaque(this.wasOpaque);
        super.uninstallUI(c);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        AquaUtilControlSize.addSizePropertyListener(this.comboBox);
    }

    @Override
    protected void uninstallListeners() {
        AquaUtilControlSize.removeSizePropertyListener(this.comboBox);
        super.uninstallListeners();
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        AquaComboBoxUI.getApplicator().attachAndApplyClientProperties(this.comboBox);
    }

    @Override
    protected void uninstallComponents() {
        AquaComboBoxUI.getApplicator().removeFrom(this.comboBox);
        super.uninstallComponents();
    }

    @Override
    protected ItemListener createItemListener() {
        return new ItemListener(){
            long lastBlink = 0L;

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                if (!AquaComboBoxUI.this.popup.isVisible()) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - 1000L < this.lastBlink) {
                    return;
                }
                this.lastBlink = now;
                JList<Object> itemList = AquaComboBoxUI.this.popup.getList();
                ListUI listUI = itemList.getUI();
                if (!(listUI instanceof AquaListUI)) {
                    return;
                }
                final AquaListUI aquaListUI = (AquaListUI)listUI;
                final int selectedIndex = AquaComboBoxUI.this.comboBox.getSelectedIndex();
                ListModel<Object> dataModel = itemList.getModel();
                if (dataModel == null) {
                    return;
                }
                final Object value = dataModel.getElementAt(selectedIndex);
                AquaUtils.blinkMenu(new AquaUtils.Selectable(){

                    @Override
                    public void paintSelected(boolean selected) {
                        aquaListUI.repaintCell(value, selectedIndex, selected);
                    }
                });
            }
        };
    }

    @Override
    public void paint(Graphics g, JComponent c) {
    }

    @Override
    protected ListCellRenderer<Object> createRenderer() {
        return new AquaComboBoxRenderer(this.comboBox);
    }

    @Override
    protected ComboPopup createPopup() {
        return new AquaComboBoxPopup(this.comboBox);
    }

    @Override
    protected JButton createArrowButton() {
        return new AquaComboBoxButton(this, this.comboBox, this.currentValuePane, this.listBox);
    }

    @Override
    protected ComboBoxEditor createEditor() {
        return new AquaComboBoxEditor();
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicComboBoxUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent e) {
                super.focusGained(e);
                if (AquaComboBoxUI.this.arrowButton != null) {
                    AquaComboBoxUI.this.arrowButton.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                AquaComboBoxUI.this.hasFocus = false;
                if (!e.isTemporary()) {
                    AquaComboBoxUI.this.setPopupVisible(AquaComboBoxUI.this.comboBox, false);
                }
                AquaComboBoxUI.this.comboBox.repaint();
                AccessibleContext ac = AquaComboBoxUI.this.comboBox.getAccessibleContext();
                if (ac != null) {
                    ac.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
                if (AquaComboBoxUI.this.arrowButton != null) {
                    AquaComboBoxUI.this.arrowButton.repaint();
                }
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMapUIResource actionMap = new ActionMapUIResource();
        actionMap.put("aquaSelectNext", this.highlightNextAction);
        actionMap.put("aquaSelectPrevious", this.highlightPreviousAction);
        actionMap.put("enterPressed", this.triggerSelectionAction);
        actionMap.put("aquaSpacePressed", toggleSelectionAction);
        actionMap.put("aquaSelectHome", this.highlightFirstAction);
        actionMap.put("aquaSelectEnd", this.highlightLastAction);
        actionMap.put("aquaSelectPageUp", this.highlightPageUpAction);
        actionMap.put("aquaSelectPageDown", this.highlightPageDownAction);
        actionMap.put("aquaHidePopup", this.hideAction);
        SwingUtilities.replaceUIActionMap(this.comboBox, actionMap);
    }

    public ComboPopup getPopup() {
        return this.popup;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        return new AquaComboBoxLayoutManager();
    }

    protected static boolean isTableCellEditor(JComponent c) {
        return Boolean.TRUE.equals(c.getClientProperty(IS_TABLE_CELL_EDITOR));
    }

    protected static boolean isPopdown(JComboBox<?> c) {
        return c.isEditable() || Boolean.TRUE.equals(c.getClientProperty(POPDOWN_CLIENT_PROPERTY_KEY));
    }

    protected static void triggerSelectionEvent(JComboBox<?> comboBox, ActionEvent e) {
        if (!comboBox.isEnabled()) {
            return;
        }
        AquaComboBoxUI aquaUi = (AquaComboBoxUI)comboBox.getUI();
        if (aquaUi.getPopup().getList().getSelectedIndex() < 0) {
            comboBox.setPopupVisible(false);
        }
        if (AquaComboBoxUI.isTableCellEditor(comboBox)) {
            comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
            return;
        }
        if (comboBox.isPopupVisible()) {
            comboBox.setSelectedIndex(aquaUi.getPopup().getList().getSelectedIndex());
            comboBox.setPopupVisible(false);
            return;
        }
        JRootPane root = SwingUtilities.getRootPane(comboBox);
        if (root == null) {
            return;
        }
        InputMap im = root.getInputMap(2);
        ActionMap am = root.getActionMap();
        if (im == null || am == null) {
            return;
        }
        Object obj = im.get(KeyStroke.getKeyStroke(10, 0));
        if (obj == null) {
            return;
        }
        Action action = am.get(obj);
        if (action == null) {
            return;
        }
        action.actionPerformed(new ActionEvent(root, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers()));
    }

    @Override
    public void applySizeFor(JComponent c, JRSUIConstants.Size size) {
        if (this.arrowButton == null) {
            return;
        }
        Border border = this.arrowButton.getBorder();
        if (!(border instanceof AquaButtonBorder)) {
            return;
        }
        AquaButtonBorder aquaBorder = (AquaButtonBorder)border;
        this.arrowButton.setBorder(aquaBorder.deriveBorderForSize(size));
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        Dimension size;
        if (!this.isMinimumSizeDirty) {
            return new Dimension(this.cachedMinimumSize);
        }
        boolean editable = this.comboBox.isEditable();
        if (!editable && this.arrowButton != null && this.arrowButton instanceof AquaComboBoxButton) {
            AquaComboBoxButton button = (AquaComboBoxButton)this.arrowButton;
            Insets buttonInsets = button.getInsets();
            Insets insets = new Insets(0, 5, 0, 25);
            size = this.getDisplaySize();
            size.width += insets.left + insets.right;
            size.width += buttonInsets.left + buttonInsets.right;
            size.width += buttonInsets.right + 10;
            size.height += insets.top + insets.bottom;
            size.height += buttonInsets.top + buttonInsets.bottom;
            size.height = Math.max(27, size.height);
        } else if (editable && this.arrowButton != null && this.editor != null) {
            size = super.getMinimumSize(c);
            Insets margin = this.arrowButton.getMargin();
            size.height += margin.top + margin.bottom;
        } else {
            size = super.getMinimumSize(c);
        }
        Border border = c.getBorder();
        if (border != null) {
            Insets insets = border.getBorderInsets(c);
            size.height += insets.top + insets.bottom;
            size.width += insets.left + insets.right;
        }
        this.cachedMinimumSize.setSize(size.width, size.height);
        this.isMinimumSizeDirty = false;
        return new Dimension(this.cachedMinimumSize);
    }

    static ClientPropertyApplicator<JComboBox<?>, AquaComboBoxUI> getApplicator() {
        return APPLICATOR.get();
    }

    class AquaComboBoxLayoutManager
    extends BasicComboBoxUI.ComboBoxLayoutManager {
        AquaComboBoxLayoutManager() {
        }

        @Override
        public void layoutContainer(Container parent) {
            if (AquaComboBoxUI.this.arrowButton != null && !AquaComboBoxUI.this.comboBox.isEditable()) {
                Insets insets = AquaComboBoxUI.this.comboBox.getInsets();
                int width = AquaComboBoxUI.this.comboBox.getWidth();
                int height = AquaComboBoxUI.this.comboBox.getHeight();
                AquaComboBoxUI.this.arrowButton.setBounds(insets.left, insets.top, width - (insets.left + insets.right), height - (insets.top + insets.bottom));
                return;
            }
            JComboBox cb = (JComboBox)parent;
            int width = cb.getWidth();
            int height = cb.getHeight();
            Insets insets = AquaComboBoxUI.this.getInsets();
            int buttonHeight = height - (insets.top + insets.bottom);
            int buttonWidth = 20;
            if (AquaComboBoxUI.this.arrowButton != null) {
                AquaComboBoxUI.this.arrowButton.setBounds(width - (insets.right + 20), insets.top, 20, buttonHeight);
            }
            if (AquaComboBoxUI.this.editor != null) {
                Rectangle editorRect = AquaComboBoxUI.this.rectangleForCurrentValue();
                editorRect.width += 4;
                ++editorRect.height;
                AquaComboBoxUI.this.editor.setBounds(editorRect);
            }
        }
    }

    private abstract class ComboBoxAction
    extends AbstractAction {
        private ComboBoxAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!AquaComboBoxUI.this.comboBox.isEnabled() || !AquaComboBoxUI.this.comboBox.isShowing()) {
                return;
            }
            if (AquaComboBoxUI.this.comboBox.isPopupVisible()) {
                AquaComboBoxUI ui = (AquaComboBoxUI)AquaComboBoxUI.this.comboBox.getUI();
                this.performComboBoxAction(ui);
            } else {
                AquaComboBoxUI.this.comboBox.setPopupVisible(true);
            }
        }

        abstract void performComboBoxAction(AquaComboBoxUI var1);
    }

    class AquaCustomComboTextField
    extends JTextField {
        public AquaCustomComboTextField() {
            InputMap inputMap = this.getInputMap();
            inputMap.put(KeyStroke.getKeyStroke("DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_DOWN"), AquaComboBoxUI.this.highlightNextAction);
            inputMap.put(KeyStroke.getKeyStroke("UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("KP_UP"), AquaComboBoxUI.this.highlightPreviousAction);
            inputMap.put(KeyStroke.getKeyStroke("HOME"), AquaComboBoxUI.this.highlightFirstAction);
            inputMap.put(KeyStroke.getKeyStroke("END"), AquaComboBoxUI.this.highlightLastAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_UP"), AquaComboBoxUI.this.highlightPageUpAction);
            inputMap.put(KeyStroke.getKeyStroke("PAGE_DOWN"), AquaComboBoxUI.this.highlightPageDownAction);
            final Action action = this.getActionMap().get("notify-field-accept");
            inputMap.put(KeyStroke.getKeyStroke("ENTER"), new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AquaComboBoxUI.this.popup.isVisible()) {
                        AquaComboBoxUI.triggerSelectionEvent(AquaComboBoxUI.this.comboBox, e);
                        if (AquaComboBoxUI.this.editor instanceof AquaCustomComboTextField) {
                            ((AquaCustomComboTextField)AquaComboBoxUI.this.editor).selectAll();
                        }
                    } else {
                        action.actionPerformed(e);
                    }
                }
            });
        }

        @Override
        public void setText(String s) {
            if (this.getText().equals(s)) {
                return;
            }
            super.setText(s);
        }
    }

    final class AquaComboBoxEditor
    extends BasicComboBoxEditor
    implements UIResource,
    DocumentListener {
        AquaComboBoxEditor() {
            this.editor = new AquaCustomComboTextField();
            this.editor.addFocusListener(this);
            this.editor.getDocument().addDocumentListener(this);
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.editorTextChanged();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.editorTextChanged();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.editorTextChanged();
        }

        private void editorTextChanged() {
            if (!AquaComboBoxUI.this.popup.isVisible()) {
                return;
            }
            String text = this.editor.getText();
            ListModel model = AquaComboBoxUI.this.listBox.getModel();
            int items = model.getSize();
            for (int i = 0; i < items; ++i) {
                String asString;
                Object element = model.getElementAt(i);
                if (element == null || (asString = element.toString()) == null || !asString.equals(text)) continue;
                AquaComboBoxUI.this.popup.getList().setSelectedIndex(i);
                return;
            }
            AquaComboBoxUI.this.popup.getList().clearSelection();
        }
    }
}

