/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public final class StringContent
implements AbstractDocument.Content,
Serializable {
    private static final char[] empty = new char[0];
    private char[] data;
    private int count;
    transient Vector<PosRec> marks;

    public StringContent() {
        this(10);
    }

    public StringContent(int initialLength) {
        if (initialLength < 1) {
            initialLength = 1;
        }
        this.data = new char[initialLength];
        this.data[0] = 10;
        this.count = 1;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public UndoableEdit insertString(int where, String str) throws BadLocationException {
        if (where >= this.count || where < 0) {
            throw new BadLocationException("Invalid location", this.count);
        }
        char[] chars = str.toCharArray();
        this.replace(where, 0, chars, 0, chars.length);
        if (this.marks != null) {
            this.updateMarksForInsert(where, str.length());
        }
        return new InsertUndo(where, str.length());
    }

    @Override
    public UndoableEdit remove(int where, int nitems) throws BadLocationException {
        if (where + nitems >= this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        String removedString = this.getString(where, nitems);
        RemoveUndo edit = new RemoveUndo(where, removedString);
        this.replace(where, nitems, empty, 0, 0);
        if (this.marks != null) {
            this.updateMarksForRemove(where, nitems);
        }
        return edit;
    }

    @Override
    public String getString(int where, int len) throws BadLocationException {
        if (where + len > this.count) {
            throw new BadLocationException("Invalid range", this.count);
        }
        return new String(this.data, where, len);
    }

    @Override
    public void getChars(int where, int len, Segment chars) throws BadLocationException {
        if (where + len > this.count) {
            throw new BadLocationException("Invalid location", this.count);
        }
        chars.array = this.data;
        chars.offset = where;
        chars.count = len;
    }

    @Override
    public Position createPosition(int offset) throws BadLocationException {
        if (this.marks == null) {
            this.marks = new Vector();
        }
        return new StickyPosition(offset);
    }

    void replace(int offset, int length, char[] replArray, int replOffset, int replLength) {
        int delta = replLength - length;
        int src = offset + length;
        int nmove = this.count - src;
        int dest = src + delta;
        if (this.count + delta >= this.data.length) {
            int newLength = Math.max(2 * this.data.length, this.count + delta);
            char[] newData = new char[newLength];
            System.arraycopy(this.data, 0, newData, 0, offset);
            System.arraycopy(replArray, replOffset, newData, offset, replLength);
            System.arraycopy(this.data, src, newData, dest, nmove);
            this.data = newData;
        } else {
            System.arraycopy(this.data, src, this.data, dest, nmove);
            System.arraycopy(replArray, replOffset, this.data, offset, replLength);
        }
        this.count += delta;
    }

    void resize(int ncount) {
        char[] ndata = new char[ncount];
        System.arraycopy(this.data, 0, ndata, 0, Math.min(ncount, this.count));
        this.data = ndata;
    }

    synchronized void updateMarksForInsert(int offset, int length) {
        if (offset == 0) {
            offset = 1;
        }
        int n = this.marks.size();
        for (int i = 0; i < n; ++i) {
            PosRec mark = this.marks.elementAt(i);
            if (mark.unused) {
                this.marks.removeElementAt(i);
                --i;
                --n;
                continue;
            }
            if (mark.offset < offset) continue;
            mark.offset += length;
        }
    }

    synchronized void updateMarksForRemove(int offset, int length) {
        int n = this.marks.size();
        for (int i = 0; i < n; ++i) {
            PosRec mark = this.marks.elementAt(i);
            if (mark.unused) {
                this.marks.removeElementAt(i);
                --i;
                --n;
                continue;
            }
            if (mark.offset >= offset + length) {
                mark.offset -= length;
                continue;
            }
            if (mark.offset < offset) continue;
            mark.offset = offset;
        }
    }

    protected Vector getPositionsInRange(Vector v, int offset, int length) {
        int n = this.marks.size();
        int end = offset + length;
        Vector placeIn = v == null ? new Vector() : v;
        for (int i = 0; i < n; ++i) {
            PosRec mark = this.marks.elementAt(i);
            if (mark.unused) {
                this.marks.removeElementAt(i);
                --i;
                --n;
                continue;
            }
            if (mark.offset < offset || mark.offset > end) continue;
            placeIn.addElement(new UndoPosRef(mark));
        }
        return placeIn;
    }

    protected void updateUndoPositions(Vector positions) {
        for (int counter = positions.size() - 1; counter >= 0; --counter) {
            UndoPosRef ref = (UndoPosRef)positions.elementAt(counter);
            if (ref.rec.unused) {
                positions.removeElementAt(counter);
                continue;
            }
            ref.resetLocation();
        }
    }

    class RemoveUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector<UndoPosRef> posRefs;

        protected RemoveUndo(int offset, String string) {
            this.offset = offset;
            this.string = string;
            this.length = string.length();
            if (StringContent.this.marks != null) {
                this.posRefs = StringContent.this.getPositionsInRange(null, offset, this.length);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                    this.string = null;
                }
            }
            catch (BadLocationException bl) {
                throw new CannotUndoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    this.string = StringContent.this.getString(this.offset, this.length);
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException bl) {
                throw new CannotRedoException();
            }
        }
    }

    class InsertUndo
    extends AbstractUndoableEdit {
        protected int offset;
        protected int length;
        protected String string;
        protected Vector posRefs;

        protected InsertUndo(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    if (StringContent.this.marks != null) {
                        this.posRefs = StringContent.this.getPositionsInRange(null, this.offset, this.length);
                    }
                    this.string = StringContent.this.getString(this.offset, this.length);
                    StringContent.this.remove(this.offset, this.length);
                }
            }
            catch (BadLocationException bl) {
                throw new CannotUndoException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            try {
                StringContent stringContent = StringContent.this;
                synchronized (stringContent) {
                    StringContent.this.insertString(this.offset, this.string);
                    this.string = null;
                    if (this.posRefs != null) {
                        StringContent.this.updateUndoPositions(this.posRefs);
                        this.posRefs = null;
                    }
                }
            }
            catch (BadLocationException bl) {
                throw new CannotRedoException();
            }
        }
    }

    final class UndoPosRef {
        protected int undoLocation;
        protected PosRec rec;

        UndoPosRef(PosRec rec) {
            this.rec = rec;
            this.undoLocation = rec.offset;
        }

        protected void resetLocation() {
            this.rec.offset = this.undoLocation;
        }
    }

    final class StickyPosition
    implements Position {
        PosRec rec;

        StickyPosition(int offset) {
            this.rec = new PosRec(offset);
            StringContent.this.marks.addElement(this.rec);
        }

        @Override
        public int getOffset() {
            return this.rec.offset;
        }

        protected void finalize() throws Throwable {
            this.rec.unused = true;
        }

        public String toString() {
            return Integer.toString(this.getOffset());
        }
    }

    final class PosRec {
        int offset;
        boolean unused;

        PosRec(int offset) {
            this.offset = offset;
        }
    }
}

