/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.beans.BeanProperty;
import java.beans.JavaBean;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

@JavaBean(defaultProperty="UI")
public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final String uiClassID = "DesktopPaneUI";
    transient DesktopManager desktopManager;
    private transient JInternalFrame selectedFrame = null;
    public static final int LIVE_DRAG_MODE = 0;
    public static final int OUTLINE_DRAG_MODE = 1;
    private int dragMode = 0;
    private boolean dragModeSet = false;
    private transient List<JInternalFrame> framesCache;
    private boolean componentOrderCheckingEnabled = true;
    private boolean componentOrderChanged = false;

    public JDesktopPane() {
        this.setUIProperty("opaque", Boolean.TRUE);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getDefaultComponent(Container c) {
                JInternalFrame jif;
                JInternalFrame[] jifArray = JDesktopPane.this.getAllFrames();
                Component comp = null;
                JInternalFrame[] jInternalFrameArray = jifArray;
                int n = jInternalFrameArray.length;
                for (int i = 0; i < n && (comp = (jif = jInternalFrameArray[i]).getFocusTraversalPolicy().getDefaultComponent(jif)) == null; ++i) {
                }
                return comp;
            }
        });
        this.updateUI();
    }

    @Override
    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    @BeanProperty(hidden=true, visualUpdate=true, description="The UI object that implements the Component's LookAndFeel.")
    public void setUI(DesktopPaneUI ui) {
        super.setUI(ui);
    }

    @BeanProperty(enumerationValues={"JDesktopPane.LIVE_DRAG_MODE", "JDesktopPane.OUTLINE_DRAG_MODE"}, description="Dragging style for internal frame children.")
    public void setDragMode(int dragMode) {
        int oldDragMode = this.dragMode;
        this.dragMode = dragMode;
        this.firePropertyChange("dragMode", oldDragMode, this.dragMode);
        this.dragModeSet = true;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    @BeanProperty(description="Desktop manager to handle the internal frames in the desktop pane.")
    public void setDesktopManager(DesktopManager d) {
        DesktopManager oldValue = this.desktopManager;
        this.desktopManager = d;
        this.firePropertyChange("desktopManager", oldValue, this.desktopManager);
    }

    @Override
    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
    }

    @Override
    @BeanProperty(bound=false)
    public String getUIClassID() {
        return uiClassID;
    }

    @BeanProperty(bound=false)
    public JInternalFrame[] getAllFrames() {
        return JDesktopPane.getAllFrames(this).toArray(new JInternalFrame[0]);
    }

    private static Collection<JInternalFrame> getAllFrames(Container parent) {
        LinkedHashSet<JInternalFrame> results = new LinkedHashSet<JInternalFrame>();
        int count = parent.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component next = parent.getComponent(i);
            if (next instanceof JInternalFrame) {
                results.add((JInternalFrame)next);
                continue;
            }
            if (next instanceof JInternalFrame.JDesktopIcon) {
                JInternalFrame tmp = ((JInternalFrame.JDesktopIcon)next).getInternalFrame();
                if (tmp == null) continue;
                results.add(tmp);
                continue;
            }
            if (!(next instanceof Container)) continue;
            results.addAll(JDesktopPane.getAllFrames((Container)next));
        }
        return results;
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(JInternalFrame f) {
        this.selectedFrame = f;
    }

    public JInternalFrame[] getAllFramesInLayer(int layer) {
        Collection<JInternalFrame> allFrames = JDesktopPane.getAllFrames(this);
        Iterator<JInternalFrame> iterator = allFrames.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getLayer() == layer) continue;
            iterator.remove();
        }
        return allFrames.toArray(new JInternalFrame[0]);
    }

    private List<JInternalFrame> getFrames() {
        TreeSet<ComponentPosition> set = new TreeSet<ComponentPosition>();
        for (int i = 0; i < this.getComponentCount(); ++i) {
            Component c = this.getComponent(i);
            if (c instanceof JInternalFrame) {
                set.add(new ComponentPosition((JInternalFrame)c, this.getLayer(c), i));
                continue;
            }
            if (!(c instanceof JInternalFrame.JDesktopIcon)) continue;
            c = ((JInternalFrame.JDesktopIcon)c).getInternalFrame();
            set.add(new ComponentPosition((JInternalFrame)c, this.getLayer(c), i));
        }
        ArrayList<JInternalFrame> frames = new ArrayList<JInternalFrame>(set.size());
        for (ComponentPosition position : set) {
            frames.add(position.component);
        }
        return frames;
    }

    private JInternalFrame getNextFrame(JInternalFrame f, boolean forward) {
        this.verifyFramesCache();
        if (f == null) {
            return this.getTopInternalFrame();
        }
        int i = this.framesCache.indexOf(f);
        if (i == -1 || this.framesCache.size() == 1) {
            return null;
        }
        if (forward) {
            if (++i == this.framesCache.size()) {
                i = 0;
            }
        } else if (--i == -1) {
            i = this.framesCache.size() - 1;
        }
        return this.framesCache.get(i);
    }

    JInternalFrame getNextFrame(JInternalFrame f) {
        return this.getNextFrame(f, true);
    }

    private JInternalFrame getTopInternalFrame() {
        if (this.framesCache.size() == 0) {
            return null;
        }
        return this.framesCache.get(0);
    }

    private void updateFramesCache() {
        this.framesCache = this.getFrames();
    }

    private void verifyFramesCache() {
        if (this.componentOrderChanged) {
            this.componentOrderChanged = false;
            this.updateFramesCache();
        }
    }

    @Override
    public void remove(Component comp) {
        super.remove(comp);
        this.updateFramesCache();
    }

    public JInternalFrame selectFrame(boolean forward) {
        JInternalFrame selectedFrame = this.getSelectedFrame();
        JInternalFrame frameToSelect = this.getNextFrame(selectedFrame, forward);
        if (frameToSelect == null) {
            return null;
        }
        this.setComponentOrderCheckingEnabled(false);
        if (forward && selectedFrame != null) {
            selectedFrame.moveToBack();
        }
        try {
            frameToSelect.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.setComponentOrderCheckingEnabled(true);
        return frameToSelect;
    }

    void setComponentOrderCheckingEnabled(boolean enable) {
        this.componentOrderCheckingEnabled = enable;
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        this.checkComponentAttributes(comp);
        super.addImpl(comp, constraints, index);
        if (this.componentOrderCheckingEnabled && (comp instanceof JInternalFrame || comp instanceof JInternalFrame.JDesktopIcon)) {
            this.componentOrderChanged = true;
        }
    }

    private void checkComponentAttributes(Component comp) {
        if (comp instanceof JInternalFrame && ((JInternalFrame)comp).isIcon()) {
            ((JInternalFrame)comp).putClientProperty("wasIconOnce", Boolean.FALSE);
        }
    }

    @Override
    public void remove(int index) {
        Component comp;
        if (this.componentOrderCheckingEnabled && ((comp = this.getComponent(index)) instanceof JInternalFrame || comp instanceof JInternalFrame.JDesktopIcon)) {
            this.componentOrderChanged = true;
        }
        super.remove(index);
    }

    @Override
    public void removeAll() {
        if (this.componentOrderCheckingEnabled) {
            int count = this.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component comp = this.getComponent(i);
                if (!(comp instanceof JInternalFrame) && !(comp instanceof JInternalFrame.JDesktopIcon)) continue;
                this.componentOrderChanged = true;
                break;
            }
        }
        super.removeAll();
    }

    @Override
    public void setComponentZOrder(Component comp, int index) {
        super.setComponentZOrder(comp, index);
        if (this.componentOrderCheckingEnabled && (comp instanceof JInternalFrame || comp instanceof JInternalFrame.JDesktopIcon)) {
            this.componentOrderChanged = true;
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte count = JComponent.getWriteObjCounter(this);
            count = (byte)(count - 1);
            JComponent.setWriteObjCounter(this, count);
            if (count == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    void setUIProperty(String propertyName, Object value) {
        if (propertyName == "dragMode") {
            if (!this.dragModeSet) {
                this.setDragMode((Integer)value);
                this.dragModeSet = false;
            }
        } else {
            super.setUIProperty(propertyName, value);
        }
    }

    @Override
    protected String paramString() {
        String desktopManagerString = this.desktopManager != null ? this.desktopManager.toString() : "";
        return super.paramString() + ",desktopManager=" + desktopManagerString;
    }

    @Override
    @BeanProperty(bound=false)
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleJDesktopPane() {
            super(JDesktopPane.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }

    private static class ComponentPosition
    implements Comparable<ComponentPosition> {
        private final JInternalFrame component;
        private final int layer;
        private final int zOrder;

        ComponentPosition(JInternalFrame component, int layer, int zOrder) {
            this.component = component;
            this.layer = layer;
            this.zOrder = zOrder;
        }

        @Override
        public int compareTo(ComponentPosition o) {
            int delta = o.layer - this.layer;
            if (delta == 0) {
                return this.zOrder - o.zOrder;
            }
            return delta;
        }
    }
}

