/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.peer.TaskbarPeer;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class Taskbar {
    private TaskbarPeer peer;

    public boolean isSupported(Feature feature) {
        return this.peer.isSupported(feature);
    }

    private void checkFeatureSupport(Feature featureType) {
        if (!this.isSupported(featureType)) {
            throw new UnsupportedOperationException("The " + featureType.name() + " feature is not supported on the current platform!");
        }
    }

    private void checkEventsProcessingPermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("canProcessApplicationEvents"));
        }
    }

    private Taskbar() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        if (defaultToolkit instanceof SunToolkit) {
            this.peer = ((SunToolkit)defaultToolkit).createTaskbarPeer(this);
        }
    }

    public static synchronized Taskbar getTaskbar() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (!Taskbar.isTaskbarSupported()) {
            throw new UnsupportedOperationException("Taskbar API is not supported on the current platform");
        }
        AppContext context = AppContext.getAppContext();
        Taskbar taskbar = (Taskbar)context.get(Taskbar.class);
        if (taskbar == null) {
            taskbar = new Taskbar();
            context.put(Taskbar.class, taskbar);
        }
        return taskbar;
    }

    public static boolean isTaskbarSupported() {
        Toolkit defaultToolkit = Toolkit.getDefaultToolkit();
        if (defaultToolkit instanceof SunToolkit) {
            return ((SunToolkit)defaultToolkit).isTaskbarSupported();
        }
        return false;
    }

    public void requestUserAttention(boolean enabled, boolean critical) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.USER_ATTENTION);
        this.peer.requestUserAttention(enabled, critical);
    }

    public void requestWindowUserAttention(Window w) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.USER_ATTENTION_WINDOW);
        this.peer.requestWindowUserAttention(w);
    }

    public void setMenu(PopupMenu menu) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.MENU);
        this.peer.setMenu(menu);
    }

    public PopupMenu getMenu() {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.MENU);
        return this.peer.getMenu();
    }

    public void setIconImage(Image image) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.ICON_IMAGE);
        this.peer.setIconImage(image);
    }

    public Image getIconImage() {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.ICON_IMAGE);
        return this.peer.getIconImage();
    }

    public void setIconBadge(String badge) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.ICON_BADGE_NUMBER);
        this.peer.setIconBadge(badge);
    }

    public void setWindowIconBadge(Window w, Image badge) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.ICON_BADGE_IMAGE_WINDOW);
        if (w != null) {
            this.peer.setWindowIconBadge(w, badge);
        }
    }

    public void setProgressValue(int value) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.PROGRESS_VALUE);
        this.peer.setProgressValue(value);
    }

    public void setWindowProgressValue(Window w, int value) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.PROGRESS_VALUE_WINDOW);
        if (w != null) {
            this.peer.setWindowProgressValue(w, value);
        }
    }

    public void setWindowProgressState(Window w, State state) {
        this.checkEventsProcessingPermission();
        this.checkFeatureSupport(Feature.PROGRESS_STATE_WINDOW);
        if (w != null) {
            this.peer.setWindowProgressState(w, state);
        }
    }

    public static enum State {
        OFF,
        NORMAL,
        PAUSED,
        INDETERMINATE,
        ERROR;

    }

    public static enum Feature {
        ICON_BADGE_TEXT,
        ICON_BADGE_NUMBER,
        ICON_BADGE_IMAGE_WINDOW,
        ICON_IMAGE,
        MENU,
        PROGRESS_STATE_WINDOW,
        PROGRESS_VALUE,
        PROGRESS_VALUE_WINDOW,
        USER_ATTENTION,
        USER_ATTENTION_WINDOW;

    }
}

