/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaTabbedPaneUI;
import java.awt.Dimension;
import java.awt.Rectangle;

class AquaTabbedPaneTabState {
    static final int FIXED_SCROLL_TAB_LENGTH = 27;
    protected final Rectangle leftScrollTabRect = new Rectangle();
    protected final Rectangle rightScrollTabRect = new Rectangle();
    protected int numberOfVisibleTabs = 0;
    protected int[] visibleTabList = new int[10];
    protected int lastLeftmostTab;
    protected int lastReturnAt;
    private boolean needsScrollers;
    private boolean hasMoreLeftTabs;
    private boolean hasMoreRightTabs;
    private final AquaTabbedPaneUI pane;

    protected AquaTabbedPaneTabState(AquaTabbedPaneUI pane) {
        this.pane = pane;
    }

    protected int getIndex(int i) {
        if (i >= this.visibleTabList.length) {
            return Integer.MIN_VALUE;
        }
        return this.visibleTabList[i];
    }

    protected void init(int tabCount) {
        if (tabCount < 1) {
            this.needsScrollers = false;
        }
        if (tabCount == this.visibleTabList.length) {
            return;
        }
        int[] tempVisibleTabs = new int[tabCount];
        System.arraycopy(this.visibleTabList, 0, tempVisibleTabs, 0, Math.min(this.visibleTabList.length, tabCount));
        this.visibleTabList = tempVisibleTabs;
    }

    int getTotal() {
        return this.numberOfVisibleTabs;
    }

    boolean needsScrollTabs() {
        return this.needsScrollers;
    }

    void setNeedsScrollers(boolean needsScrollers) {
        this.needsScrollers = needsScrollers;
    }

    boolean needsLeftScrollTab() {
        return this.hasMoreLeftTabs;
    }

    boolean needsRightScrollTab() {
        return this.hasMoreRightTabs;
    }

    Rectangle getLeftScrollTabRect() {
        return this.leftScrollTabRect;
    }

    Rectangle getRightScrollTabRect() {
        return this.rightScrollTabRect;
    }

    boolean isBefore(int i) {
        if (this.numberOfVisibleTabs == 0) {
            return true;
        }
        return i < this.visibleTabList[0];
    }

    boolean isAfter(int i) {
        return i > this.visibleTabList[this.numberOfVisibleTabs - 1];
    }

    private void addToEnd(int idToAdd, int length) {
        this.visibleTabList[length] = idToAdd;
    }

    private void addToBeginning(int idToAdd, int length) {
        System.arraycopy(this.visibleTabList, 0, this.visibleTabList, 1, length);
        this.visibleTabList[0] = idToAdd;
    }

    /*
     * Enabled aggressive block sorting
     */
    void relayoutForScrolling(Rectangle[] rects, int startX, int startY, int returnAt, int selectedIndex, boolean verticalTabRuns, int tabCount, boolean isLeftToRight) {
        boolean sizeChanged;
        if (!this.needsScrollers) {
            this.hasMoreLeftTabs = false;
            this.hasMoreRightTabs = false;
            return;
        }
        if (verticalTabRuns) {
            this.rightScrollTabRect.height = 27;
            this.leftScrollTabRect.height = 27;
        } else {
            this.rightScrollTabRect.width = 27;
            this.leftScrollTabRect.width = 27;
        }
        boolean bl = sizeChanged = returnAt != this.lastReturnAt;
        if (this.pane.popupSelectionChanged || sizeChanged) {
            this.pane.popupSelectionChanged = false;
            this.lastLeftmostTab = -1;
        }
        int right = selectedIndex;
        int left = selectedIndex - 1;
        if (this.lastLeftmostTab >= 0) {
            right = this.lastLeftmostTab;
            left = -1;
        } else if (selectedIndex < 0) {
            right = 0;
            left = -1;
        }
        int remainingSpace = returnAt - this.pane.tabAreaInsets.right - this.pane.tabAreaInsets.left - 54;
        int visibleCount = 0;
        Rectangle firstRect = rects[right];
        if ((verticalTabRuns ? firstRect.height : firstRect.width) > remainingSpace) {
            this.addToEnd(right, visibleCount);
            if (verticalTabRuns) {
                firstRect.height = remainingSpace;
            } else {
                firstRect.width = remainingSpace;
            }
            ++visibleCount;
        } else {
            boolean rightDone = false;
            boolean leftDone = false;
            while (!(visibleCount >= tabCount || rightDone && leftDone)) {
                block21: {
                    if (!rightDone && right >= 0 && right < tabCount) {
                        Rectangle rightRect = rects[right];
                        if ((verticalTabRuns ? rightRect.height : rightRect.width) > remainingSpace) {
                            rightDone = true;
                            break block21;
                        } else {
                            this.addToEnd(right, visibleCount);
                            ++visibleCount;
                            remainingSpace -= verticalTabRuns ? rightRect.height : rightRect.width;
                            ++right;
                            continue;
                        }
                    }
                    rightDone = true;
                }
                if (!leftDone && left >= 0 && left < tabCount) {
                    Rectangle leftRect = rects[left];
                    if ((verticalTabRuns ? leftRect.height : leftRect.width) > remainingSpace) {
                        leftDone = true;
                        continue;
                    }
                    this.addToBeginning(left, visibleCount);
                    ++visibleCount;
                    remainingSpace -= verticalTabRuns ? leftRect.height : leftRect.width;
                    --left;
                    continue;
                }
                leftDone = true;
            }
        }
        if (visibleCount > this.visibleTabList.length) {
            visibleCount = this.visibleTabList.length;
        }
        this.hasMoreLeftTabs = this.visibleTabList[0] > 0;
        this.hasMoreRightTabs = this.visibleTabList[visibleCount - 1] < this.visibleTabList.length - 1;
        this.numberOfVisibleTabs = visibleCount;
        this.lastLeftmostTab = this.getIndex(0);
        this.lastReturnAt = returnAt;
        int firstTabIndex = this.getIndex(0);
        int lastTabIndex = this.getIndex(visibleCount - 1);
        int i = 0;
        while (i < tabCount) {
            if (i < firstTabIndex || i > lastTabIndex) {
                Rectangle rect = rects[i];
                rect.x = Short.MAX_VALUE;
                rect.y = Short.MAX_VALUE;
            }
            ++i;
        }
        return;
    }

    protected void alignRectsRunFor(Rectangle[] rects, Dimension tabPaneSize, int tabPlacement, boolean isRightToLeft) {
        boolean isVertical;
        boolean bl = isVertical = tabPlacement == 2 || tabPlacement == 4;
        if (isVertical) {
            if (this.needsScrollers) {
                this.stretchScrollingVerticalRun(rects, tabPaneSize);
            } else {
                this.centerVerticalRun(rects, tabPaneSize);
            }
        } else if (this.needsScrollers) {
            this.stretchScrollingHorizontalRun(rects, tabPaneSize, isRightToLeft);
        } else {
            this.centerHorizontalRun(rects, tabPaneSize, isRightToLeft);
        }
    }

    private void centerHorizontalRun(Rectangle[] rects, Dimension size, boolean isRightToLeft) {
        int totalLength = 0;
        for (Rectangle element : rects) {
            totalLength += element.width;
        }
        int x = size.width / 2 - totalLength / 2;
        if (isRightToLeft) {
            for (Rectangle rect : rects) {
                rect.x = x;
                x += rect.width;
            }
        } else {
            for (int i = rects.length - 1; i >= 0; --i) {
                Rectangle rect = rects[i];
                rect.x = x;
                x += rect.width;
            }
        }
    }

    private void centerVerticalRun(Rectangle[] rects, Dimension size) {
        int totalLength = 0;
        for (Rectangle element : rects) {
            totalLength += element.height;
        }
        int y = size.height / 2 - totalLength / 2;
        for (Rectangle rect : rects) {
            rect.y = y;
            y += rect.height;
        }
    }

    private void stretchScrollingHorizontalRun(Rectangle[] rects, Dimension size, boolean isRightToLeft) {
        int slackToAdd;
        Rectangle rect;
        int i;
        int totalTabs = this.getTotal();
        int firstTabIndex = this.getIndex(0);
        int lastTabIndex = this.getIndex(totalTabs - 1);
        int totalRunLength = 0;
        for (int i2 = firstTabIndex; i2 <= lastTabIndex; ++i2) {
            totalRunLength += rects[i2].width;
        }
        int slack = size.width - totalRunLength - this.pane.tabAreaInsets.left - this.pane.tabAreaInsets.right;
        if (this.needsLeftScrollTab()) {
            slack -= 27;
        }
        if (this.needsRightScrollTab()) {
            slack -= 27;
        }
        int minSlack = (int)((float)slack / (float)totalTabs);
        int extraSlack = slack - minSlack * totalTabs;
        int runningLength = 0;
        int xOffset = this.pane.tabAreaInsets.left + (this.needsLeftScrollTab() ? 27 : 0);
        if (isRightToLeft) {
            for (i = firstTabIndex; i <= lastTabIndex; ++i) {
                rect = rects[i];
                slackToAdd = minSlack;
                if (extraSlack > 0) {
                    ++slackToAdd;
                    --extraSlack;
                }
                rect.x = runningLength + xOffset;
                rect.width += slackToAdd;
                runningLength += rect.width;
            }
        } else {
            for (i = lastTabIndex; i >= firstTabIndex; --i) {
                rect = rects[i];
                slackToAdd = minSlack;
                if (extraSlack > 0) {
                    ++slackToAdd;
                    --extraSlack;
                }
                rect.x = runningLength + xOffset;
                rect.width += slackToAdd;
                runningLength += rect.width;
            }
        }
        if (isRightToLeft) {
            this.leftScrollTabRect.x = this.pane.tabAreaInsets.left;
            this.leftScrollTabRect.y = rects[firstTabIndex].y;
            this.leftScrollTabRect.height = rects[firstTabIndex].height;
            this.rightScrollTabRect.x = size.width - this.pane.tabAreaInsets.right - this.rightScrollTabRect.width;
            this.rightScrollTabRect.y = rects[lastTabIndex].y;
            this.rightScrollTabRect.height = rects[lastTabIndex].height;
        } else {
            this.rightScrollTabRect.x = this.pane.tabAreaInsets.left;
            this.rightScrollTabRect.y = rects[firstTabIndex].y;
            this.rightScrollTabRect.height = rects[firstTabIndex].height;
            this.leftScrollTabRect.x = size.width - this.pane.tabAreaInsets.right - this.rightScrollTabRect.width;
            this.leftScrollTabRect.y = rects[lastTabIndex].y;
            this.leftScrollTabRect.height = rects[lastTabIndex].height;
            if (this.needsLeftScrollTab()) {
                for (i = lastTabIndex; i >= firstTabIndex; --i) {
                    rect = rects[i];
                    rect.x -= 27;
                }
            }
            if (this.needsRightScrollTab()) {
                for (i = lastTabIndex; i >= firstTabIndex; --i) {
                    rect = rects[i];
                    rect.x += 27;
                }
            }
        }
    }

    private void stretchScrollingVerticalRun(Rectangle[] rects, Dimension size) {
        int totalTabs = this.getTotal();
        int firstTabIndex = this.getIndex(0);
        int lastTabIndex = this.getIndex(totalTabs - 1);
        int totalRunLength = 0;
        for (int i = firstTabIndex; i <= lastTabIndex; ++i) {
            totalRunLength += rects[i].height;
        }
        int slack = size.height - totalRunLength - this.pane.tabAreaInsets.top - this.pane.tabAreaInsets.bottom;
        if (this.needsLeftScrollTab()) {
            slack -= 27;
        }
        if (this.needsRightScrollTab()) {
            slack -= 27;
        }
        int minSlack = (int)((float)slack / (float)totalTabs);
        int extraSlack = slack - minSlack * totalTabs;
        int runningLength = 0;
        int yOffset = this.pane.tabAreaInsets.top + (this.needsLeftScrollTab() ? 27 : 0);
        for (int i = firstTabIndex; i <= lastTabIndex; ++i) {
            Rectangle rect = rects[i];
            int slackToAdd = minSlack;
            if (extraSlack > 0) {
                ++slackToAdd;
                --extraSlack;
            }
            rect.y = runningLength + yOffset;
            rect.height += slackToAdd;
            runningLength += rect.height;
        }
        this.leftScrollTabRect.x = rects[firstTabIndex].x;
        this.leftScrollTabRect.y = this.pane.tabAreaInsets.top;
        this.leftScrollTabRect.width = rects[firstTabIndex].width;
        this.rightScrollTabRect.x = rects[lastTabIndex].x;
        this.rightScrollTabRect.y = size.height - this.pane.tabAreaInsets.bottom - this.rightScrollTabRect.height;
        this.rightScrollTabRect.width = rects[lastTabIndex].width;
    }
}

