/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIControl;
import apple.laf.JRSUIUtils;
import com.apple.laf.AquaButtonBorder;
import com.apple.laf.AquaButtonCheckBoxUI;
import com.apple.laf.AquaButtonRadioUI;
import com.apple.laf.AquaFonts;
import com.apple.laf.AquaGroupBorder;
import com.apple.laf.AquaIcon;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.AquaInternalFrameUI;
import com.apple.laf.AquaKeyBindings;
import com.apple.laf.AquaListUI;
import com.apple.laf.AquaMenuBarBorder;
import com.apple.laf.AquaMenuBorder;
import com.apple.laf.AquaMenuPainter;
import com.apple.laf.AquaMnemonicHandler;
import com.apple.laf.AquaScrollRegionBorder;
import com.apple.laf.AquaSplitPaneDividerUI;
import com.apple.laf.AquaTableHeaderBorder;
import com.apple.laf.AquaTextFieldBorder;
import com.apple.laf.AquaToolBarUI;
import com.apple.laf.AquaUtils;
import com.apple.laf.ScreenPopupFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.PopupFactory;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicLookAndFeel;
import sun.swing.SwingAccessor;
import sun.swing.SwingUtilities2;

public class AquaLookAndFeel
extends BasicLookAndFeel {
    static final String sOldPropertyPrefix = "com.apple.macos.";
    static final String sPropertyPrefix = "apple.laf.";
    private static final String PKG_PREFIX = "com.apple.laf.";

    @Override
    public String getName() {
        return "Mac OS X";
    }

    @Override
    public String getID() {
        return "Aqua";
    }

    @Override
    public String getDescription() {
        return "Aqua Look and Feel for Mac OS X";
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return false;
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    public void initialize() {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("osxui");
                return null;
            }
        });
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                JRSUIControl.initJRSUI();
                return null;
            }
        });
        super.initialize();
        ScreenPopupFactory spf = new ScreenPopupFactory();
        spf.setActive(true);
        PopupFactory.setSharedInstance(spf);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
    }

    @Override
    public void uninitialize() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(AquaMnemonicHandler.getInstance());
        PopupFactory popupFactory = PopupFactory.getSharedInstance();
        if (popupFactory != null && popupFactory instanceof ScreenPopupFactory) {
            ((ScreenPopupFactory)popupFactory).setActive(false);
        }
        super.uninitialize();
    }

    @Override
    protected ActionMap getAudioActionMap() {
        ActionMap audioActionMap = (ActionMap)UIManager.get("AuditoryCues.actionMap");
        if (audioActionMap != null) {
            return audioActionMap;
        }
        Object[] acList = (Object[])UIManager.get("AuditoryCues.cueList");
        if (acList != null) {
            audioActionMap = new ActionMapUIResource();
            for (int counter = acList.length - 1; counter >= 0; --counter) {
                audioActionMap.put(acList[counter], this.createAudioAction(acList[counter]));
            }
        }
        UIManager.getLookAndFeelDefaults().put("AuditoryCues.actionMap", audioActionMap);
        return audioActionMap;
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = new UIDefaults();
        try {
            this.initClassDefaults(table);
            super.initSystemColorDefaults(table);
            super.initComponentDefaults(table);
            this.initSystemColorDefaults(table);
            this.initComponentDefaults(table);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return table;
    }

    private void initResourceBundle(UIDefaults table) {
        table.setDefaultLocale(Locale.getDefault());
        SwingAccessor.getUIDefaultsAccessor().addInternalBundle(table, "com.apple.laf.resources.aqua");
        try {
            ResourceBundle aquaProperties = ResourceBundle.getBundle("com.apple.laf.resources.aqua");
            Enumeration<String> propertyKeys = aquaProperties.getKeys();
            while (propertyKeys.hasMoreElements()) {
                String key = propertyKeys.nextElement();
                table.put(key, aquaProperties.getString(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        Color windowBackgroundColor;
        InsetsUIResource zeroInsets;
        this.initResourceBundle(table);
        InsetsUIResource menuItemMargin = zeroInsets = new InsetsUIResource(0, 0, 0, 0);
        Boolean useOpaqueComponents = Boolean.TRUE;
        Boolean buttonShouldBeOpaque = AquaUtils.shouldUseOpaqueButtons() ? Boolean.TRUE : Boolean.FALSE;
        UIDefaults.ActiveValue listCellRendererActiveValue = new UIDefaults.ActiveValue(){

            @Override
            public Object createValue(UIDefaults defaultsTable) {
                return new DefaultListCellRenderer.UIResource();
            }
        };
        BorderUIResource.EmptyBorderUIResource toolTipBorder = new BorderUIResource.EmptyBorderUIResource(2, 0, 2, 0);
        ColorUIResource toolTipBackground = new ColorUIResource(255, 255, 204);
        ColorUIResource black = new ColorUIResource(Color.black);
        ColorUIResource white = new ColorUIResource(Color.white);
        ColorUIResource smokyGlass = new ColorUIResource(new Color(0, 0, 0, 152));
        ColorUIResource dockIconRim = new ColorUIResource(new Color(192, 192, 192, 192));
        ColorUIResource mediumTranslucentBlack = new ColorUIResource(new Color(0, 0, 0, 100));
        ColorUIResource translucentWhite = new ColorUIResource(new Color(255, 255, 255, 254));
        ColorUIResource disabled = new ColorUIResource(0.5f, 0.5f, 0.5f);
        ColorUIResource disabledShadow = new ColorUIResource(0.25f, 0.25f, 0.25f);
        ColorUIResource selected = new ColorUIResource(1.0f, 0.4f, 0.4f);
        ColorUIResource selectedTabTitlePressedColor = new ColorUIResource(240, 240, 240);
        ColorUIResource selectedTabTitleDisabledColor = new ColorUIResource(new Color(1.0f, 1.0f, 1.0f, 0.55f));
        ColorUIResource selectedTabTitleNormalColor = white;
        ColorUIResource selectedTabTitleShadowDisabledColor = new ColorUIResource(new Color(0.0f, 0.0f, 0.0f, 0.25f));
        ColorUIResource selectedTabTitleShadowNormalColor = mediumTranslucentBlack;
        ColorUIResource nonSelectedTabTitleNormalColor = black;
        ColorUIResource toolbarDragHandleColor = new ColorUIResource(140, 140, 140);
        UIDefaults.LazyValue marginBorder = t -> new BasicBorders.MarginBorder();
        boolean zero = false;
        InsetsUIResource editorMargin = zeroInsets;
        int textCaretBlinkRate = 500;
        UIDefaults.LazyValue textFieldBorder = t -> AquaTextFieldBorder.getTextFieldBorder();
        UIDefaults.LazyValue textAreaBorder = marginBorder;
        UIDefaults.LazyValue scollListBorder = t -> AquaScrollRegionBorder.getScrollRegionBorder();
        UIDefaults.LazyValue aquaTitledBorder = t -> AquaGroupBorder.getBorderForTitledBorder();
        UIDefaults.LazyValue aquaInsetBorder = t -> AquaGroupBorder.getTitlelessBorder();
        AquaTableHeaderBorder listHeaderBorder = AquaTableHeaderBorder.getListHeaderBorder();
        BorderUIResource.EmptyBorderUIResource zeroBorder = new BorderUIResource.EmptyBorderUIResource(0, 0, 0, 0);
        Color selectionBackground = AquaImageFactory.getSelectionBackgroundColorUIResource();
        Color selectionForeground = AquaImageFactory.getSelectionForegroundColorUIResource();
        Color selectionInactiveBackground = AquaImageFactory.getSelectionInactiveBackgroundColorUIResource();
        Color selectionInactiveForeground = AquaImageFactory.getSelectionInactiveForegroundColorUIResource();
        Color textHighlightText = AquaImageFactory.getTextSelectionForegroundColorUIResource();
        Color textHighlight = AquaImageFactory.getTextSelectionBackgroundColorUIResource();
        ColorUIResource textHighlightInactive = new ColorUIResource(212, 212, 212);
        ColorUIResource textInactiveText = disabled;
        ColorUIResource textForeground = black;
        ColorUIResource textBackground = white;
        ColorUIResource textInactiveBackground = white;
        ColorUIResource textPasswordFieldCapsLockIconColor = mediumTranslucentBlack;
        UIDefaults.LazyValue internalFrameBorder = t -> BasicBorders.getInternalFrameBorder();
        ColorUIResource desktopBackgroundColor = new ColorUIResource(new Color(65, 105, 170));
        Color focusRingColor = AquaImageFactory.getFocusRingColorUIResource();
        BorderUIResource.LineBorderUIResource focusCellHighlightBorder = new BorderUIResource.LineBorderUIResource(focusRingColor);
        Color panelBackgroundColor = windowBackgroundColor = AquaImageFactory.getWindowBackgroundColorUIResource();
        Color tabBackgroundColor = windowBackgroundColor;
        Color controlBackgroundColor = windowBackgroundColor;
        UIDefaults.LazyValue controlFont = t -> AquaFonts.getControlTextFont();
        UIDefaults.LazyValue controlSmallFont = t -> AquaFonts.getControlTextSmallFont();
        UIDefaults.LazyValue alertHeaderFont = t -> AquaFonts.getAlertHeaderFont();
        UIDefaults.LazyValue menuFont = t -> AquaFonts.getMenuFont();
        UIDefaults.LazyValue viewFont = t -> AquaFonts.getViewFont();
        ColorUIResource menuBackgroundColor = new ColorUIResource(Color.white);
        ColorUIResource menuForegroundColor = black;
        ColorUIResource menuSelectedForegroundColor = white;
        Color menuSelectedBackgroundColor = focusRingColor;
        ColorUIResource menuDisabledBackgroundColor = menuBackgroundColor;
        ColorUIResource menuDisabledForegroundColor = disabled;
        ColorUIResource menuAccelForegroundColor = black;
        ColorUIResource menuAccelSelectionForegroundColor = black;
        AquaMenuBorder menuBorder = new AquaMenuBorder();
        UIDefaults.LazyInputMap controlFocusInputMap = new UIDefaults.LazyInputMap(new Object[]{"SPACE", "pressed", "released SPACE", "released"});
        UIDefaults.LazyValue confirmIcon = t -> AquaImageFactory.getConfirmImageIcon();
        UIDefaults.LazyValue cautionIcon = t -> AquaImageFactory.getCautionImageIcon();
        UIDefaults.LazyValue stopIcon = t -> AquaImageFactory.getStopImageIcon();
        UIDefaults.LazyValue securityIcon = t -> AquaImageFactory.getLockImageIcon();
        AquaKeyBindings aquaKeyBindings = AquaKeyBindings.instance();
        Object[] defaults = new Object[]{"control", windowBackgroundColor, "Button.background", controlBackgroundColor, "Button.foreground", black, "Button.disabledText", disabled, "Button.select", selected, "Button.border", t -> AquaButtonBorder.getDynamicButtonBorder(), "Button.font", controlFont, "Button.textIconGap", 4, "Button.textShiftOffset", 0, "Button.focusInputMap", controlFocusInputMap, "Button.margin", new InsetsUIResource(0, 2, 0, 2), "Button.opaque", buttonShouldBeOpaque, "CheckBox.background", controlBackgroundColor, "CheckBox.foreground", black, "CheckBox.disabledText", disabled, "CheckBox.select", selected, "CheckBox.icon", t -> AquaButtonCheckBoxUI.getSizingCheckBoxIcon(), "CheckBox.font", controlFont, "CheckBox.border", AquaButtonBorder.getBevelButtonBorder(), "CheckBox.margin", new InsetsUIResource(1, 1, 0, 1), "CheckBox.focusInputMap", controlFocusInputMap, "CheckBoxMenuItem.font", menuFont, "CheckBoxMenuItem.acceleratorFont", menuFont, "CheckBoxMenuItem.background", menuBackgroundColor, "CheckBoxMenuItem.foreground", menuForegroundColor, "CheckBoxMenuItem.selectionBackground", menuSelectedBackgroundColor, "CheckBoxMenuItem.selectionForeground", menuSelectedForegroundColor, "CheckBoxMenuItem.disabledBackground", menuDisabledBackgroundColor, "CheckBoxMenuItem.disabledForeground", menuDisabledForegroundColor, "CheckBoxMenuItem.acceleratorForeground", menuAccelForegroundColor, "CheckBoxMenuItem.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "CheckBoxMenuItem.acceleratorDelimiter", "", "CheckBoxMenuItem.border", menuBorder, "CheckBoxMenuItem.margin", menuItemMargin, "CheckBoxMenuItem.borderPainted", Boolean.TRUE, "CheckBoxMenuItem.checkIcon", t -> AquaImageFactory.getMenuItemCheckIcon(), "CheckBoxMenuItem.dashIcon", t -> AquaImageFactory.getMenuItemDashIcon(), "ColorChooser.background", panelBackgroundColor, "ComboBox.font", controlFont, "ComboBox.background", controlBackgroundColor, "ComboBox.foreground", menuForegroundColor, "ComboBox.selectionBackground", menuSelectedBackgroundColor, "ComboBox.selectionForeground", menuSelectedForegroundColor, "ComboBox.disabledBackground", menuDisabledBackgroundColor, "ComboBox.disabledForeground", menuDisabledForegroundColor, "ComboBox.ancestorInputMap", aquaKeyBindings.getComboBoxInputMap(), "DesktopIcon.border", internalFrameBorder, "DesktopIcon.borderColor", smokyGlass, "DesktopIcon.borderRimColor", dockIconRim, "DesktopIcon.labelBackground", mediumTranslucentBlack, "Desktop.background", desktopBackgroundColor, "EditorPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "EditorPane.font", controlFont, "EditorPane.background", textBackground, "EditorPane.foreground", textForeground, "EditorPane.selectionBackground", textHighlight, "EditorPane.selectionForeground", textHighlightText, "EditorPane.caretForeground", textForeground, "EditorPane.caretBlinkRate", 500, "EditorPane.inactiveForeground", textInactiveText, "EditorPane.inactiveBackground", textInactiveBackground, "EditorPane.border", textAreaBorder, "EditorPane.margin", editorMargin, "FileChooser.newFolderIcon", AquaIcon.SystemIcon.getFolderIconUIResource(), "FileChooser.upFolderIcon", AquaIcon.SystemIcon.getFolderIconUIResource(), "FileChooser.homeFolderIcon", AquaIcon.SystemIcon.getDesktopIconUIResource(), "FileChooser.detailsViewIcon", AquaIcon.SystemIcon.getComputerIconUIResource(), "FileChooser.listViewIcon", AquaIcon.SystemIcon.getComputerIconUIResource(), "FileView.directoryIcon", AquaIcon.SystemIcon.getFolderIconUIResource(), "FileView.fileIcon", AquaIcon.SystemIcon.getDocumentIconUIResource(), "FileView.computerIcon", AquaIcon.SystemIcon.getDesktopIconUIResource(), "FileView.hardDriveIcon", AquaIcon.SystemIcon.getHardDriveIconUIResource(), "FileView.floppyDriveIcon", AquaIcon.SystemIcon.getFloppyIconUIResource(), "FileChooser.cancelButtonMnemonic", 0, "FileChooser.saveButtonMnemonic", 0, "FileChooser.openButtonMnemonic", 0, "FileChooser.updateButtonMnemonic", 0, "FileChooser.helpButtonMnemonic", 0, "FileChooser.directoryOpenButtonMnemonic", 0, "FileChooser.lookInLabelMnemonic", 0, "FileChooser.fileNameLabelMnemonic", 0, "FileChooser.filesOfTypeLabelMnemonic", 0, "Focus.color", focusRingColor, "FormattedTextField.focusInputMap", aquaKeyBindings.getFormattedTextFieldInputMap(), "FormattedTextField.font", controlFont, "FormattedTextField.background", textBackground, "FormattedTextField.foreground", textForeground, "FormattedTextField.inactiveForeground", textInactiveText, "FormattedTextField.inactiveBackground", textInactiveBackground, "FormattedTextField.selectionBackground", textHighlight, "FormattedTextField.selectionForeground", textHighlightText, "FormattedTextField.caretForeground", textForeground, "FormattedTextField.caretBlinkRate", 500, "FormattedTextField.border", textFieldBorder, "FormattedTextField.margin", zeroInsets, "IconButton.font", controlSmallFont, "InternalFrame.titleFont", menuFont, "InternalFrame.background", windowBackgroundColor, "InternalFrame.borderColor", windowBackgroundColor, "InternalFrame.borderShadow", Color.red, "InternalFrame.borderDarkShadow", Color.green, "InternalFrame.borderHighlight", Color.blue, "InternalFrame.borderLight", Color.yellow, "InternalFrame.opaque", Boolean.FALSE, "InternalFrame.border", null, "InternalFrame.icon", null, "InternalFrame.paletteBorder", null, "InternalFrame.paletteTitleFont", menuFont, "InternalFrame.paletteBackground", windowBackgroundColor, "InternalFrame.optionDialogBorder", null, "InternalFrame.optionDialogTitleFont", menuFont, "InternalFrame.optionDialogBackground", windowBackgroundColor, "InternalFrame.closeIcon", t -> AquaInternalFrameUI.exportCloseIcon(), "InternalFrame.maximizeIcon", t -> AquaInternalFrameUI.exportZoomIcon(), "InternalFrame.iconifyIcon", t -> AquaInternalFrameUI.exportMinimizeIcon(), "InternalFrame.minimizeIcon", t -> AquaInternalFrameUI.exportMinimizeIcon(), "InternalFrame.closeSound", null, "InternalFrame.maximizeSound", null, "InternalFrame.minimizeSound", null, "InternalFrame.restoreDownSound", null, "InternalFrame.restoreUpSound", null, "InternalFrame.activeTitleBackground", windowBackgroundColor, "InternalFrame.activeTitleForeground", textForeground, "InternalFrame.inactiveTitleBackground", windowBackgroundColor, "InternalFrame.inactiveTitleForeground", textInactiveText, "InternalFrame.windowBindings", new Object[]{"shift ESCAPE", "showSystemMenu", "ctrl SPACE", "showSystemMenu", "ESCAPE", "hideSystemMenu"}, "TitledBorder.font", controlFont, "TitledBorder.titleColor", black, "TitledBorder.aquaVariant", aquaTitledBorder, "InsetBorder.aquaVariant", aquaInsetBorder, "Label.font", controlFont, "Label.background", controlBackgroundColor, "Label.foreground", black, "Label.disabledForeground", disabled, "Label.disabledShadow", disabledShadow, "Label.opaque", useOpaqueComponents, "Label.border", null, "List.font", viewFont, "List.background", white, "List.foreground", black, "List.selectionBackground", selectionBackground, "List.selectionForeground", selectionForeground, "List.selectionInactiveBackground", selectionInactiveBackground, "List.selectionInactiveForeground", selectionInactiveForeground, "List.focusCellHighlightBorder", focusCellHighlightBorder, "List.border", null, "List.cellRenderer", listCellRendererActiveValue, "List.sourceListBackgroundPainter", t -> AquaListUI.getSourceListBackgroundPainter(), "List.sourceListSelectionBackgroundPainter", t -> AquaListUI.getSourceListSelectionBackgroundPainter(), "List.sourceListFocusedSelectionBackgroundPainter", t -> AquaListUI.getSourceListFocusedSelectionBackgroundPainter(), "List.evenRowBackgroundPainter", t -> AquaListUI.getListEvenBackgroundPainter(), "List.oddRowBackgroundPainter", t -> AquaListUI.getListOddBackgroundPainter(), "List.focusInputMap", aquaKeyBindings.getListInputMap(), "Menu.font", menuFont, "Menu.acceleratorFont", menuFont, "Menu.background", menuBackgroundColor, "Menu.foreground", menuForegroundColor, "Menu.selectionBackground", menuSelectedBackgroundColor, "Menu.selectionForeground", menuSelectedForegroundColor, "Menu.disabledBackground", menuDisabledBackgroundColor, "Menu.disabledForeground", menuDisabledForegroundColor, "Menu.acceleratorForeground", menuAccelForegroundColor, "Menu.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "Menu.border", menuBorder, "Menu.borderPainted", Boolean.FALSE, "Menu.margin", menuItemMargin, "Menu.arrowIcon", t -> AquaImageFactory.getMenuArrowIcon(), "Menu.consumesTabs", Boolean.TRUE, "Menu.menuPopupOffsetY", 1, "Menu.submenuPopupOffsetY", -4, "MenuBar.font", menuFont, "MenuBar.background", menuBackgroundColor, "MenuBar.foreground", menuForegroundColor, "MenuBar.border", new AquaMenuBarBorder(), "MenuBar.margin", new InsetsUIResource(0, 8, 0, 8), "MenuBar.selectionBackground", menuSelectedBackgroundColor, "MenuBar.selectionForeground", menuSelectedForegroundColor, "MenuBar.disabledBackground", menuDisabledBackgroundColor, "MenuBar.disabledForeground", menuDisabledForegroundColor, "MenuBar.backgroundPainter", t -> AquaMenuPainter.getMenuBarPainter(), "MenuBar.selectedBackgroundPainter", t -> AquaMenuPainter.getSelectedMenuBarItemPainter(), "MenuItem.font", menuFont, "MenuItem.acceleratorFont", menuFont, "MenuItem.background", menuBackgroundColor, "MenuItem.foreground", menuForegroundColor, "MenuItem.selectionBackground", menuSelectedBackgroundColor, "MenuItem.selectionForeground", menuSelectedForegroundColor, "MenuItem.disabledBackground", menuDisabledBackgroundColor, "MenuItem.disabledForeground", menuDisabledForegroundColor, "MenuItem.acceleratorForeground", menuAccelForegroundColor, "MenuItem.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "MenuItem.acceleratorDelimiter", "", "MenuItem.border", menuBorder, "MenuItem.margin", menuItemMargin, "MenuItem.borderPainted", Boolean.TRUE, "MenuItem.selectedBackgroundPainter", t -> AquaMenuPainter.getSelectedMenuItemPainter(), "OptionPane.font", alertHeaderFont, "OptionPane.messageFont", controlFont, "OptionPane.buttonFont", controlFont, "OptionPane.background", windowBackgroundColor, "OptionPane.foreground", black, "OptionPane.messageForeground", black, "OptionPane.border", new BorderUIResource.EmptyBorderUIResource(12, 21, 17, 21), "OptionPane.messageAreaBorder", zeroBorder, "OptionPane.buttonAreaBorder", new BorderUIResource.EmptyBorderUIResource(13, 0, 0, 0), "OptionPane.minimumSize", new DimensionUIResource(262, 90), "OptionPane.errorIcon", stopIcon, "OptionPane.informationIcon", confirmIcon, "OptionPane.warningIcon", cautionIcon, "OptionPane.questionIcon", confirmIcon, "_SecurityDecisionIcon", securityIcon, "OptionPane.windowBindings", new Object[]{"ESCAPE", "close"}, "OptionPane.errorSound", null, "OptionPane.informationSound", null, "OptionPane.questionSound", null, "OptionPane.warningSound", null, "OptionPane.buttonClickThreshhold", 500, "OptionPane.yesButtonMnemonic", "", "OptionPane.noButtonMnemonic", "", "OptionPane.okButtonMnemonic", "", "OptionPane.cancelButtonMnemonic", "", "Panel.font", controlFont, "Panel.background", panelBackgroundColor, "Panel.foreground", black, "Panel.opaque", useOpaqueComponents, "PasswordField.focusInputMap", aquaKeyBindings.getPasswordFieldInputMap(), "PasswordField.font", controlFont, "PasswordField.background", textBackground, "PasswordField.foreground", textForeground, "PasswordField.inactiveForeground", textInactiveText, "PasswordField.inactiveBackground", textInactiveBackground, "PasswordField.selectionBackground", textHighlight, "PasswordField.selectionForeground", textHighlightText, "PasswordField.caretForeground", textForeground, "PasswordField.caretBlinkRate", 500, "PasswordField.border", textFieldBorder, "PasswordField.margin", zeroInsets, "PasswordField.echoChar", Character.valueOf('\u25cf'), "PasswordField.capsLockIconColor", textPasswordFieldCapsLockIconColor, "PopupMenu.font", menuFont, "PopupMenu.background", menuBackgroundColor, "PopupMenu.translucentBackground", white, "PopupMenu.foreground", menuForegroundColor, "PopupMenu.selectionBackground", menuSelectedBackgroundColor, "PopupMenu.selectionForeground", menuSelectedForegroundColor, "PopupMenu.border", menuBorder, "ProgressBar.font", controlFont, "ProgressBar.foreground", black, "ProgressBar.background", controlBackgroundColor, "ProgressBar.selectionForeground", black, "ProgressBar.selectionBackground", white, "ProgressBar.border", new BorderUIResource(BorderFactory.createEmptyBorder()), "ProgressBar.repaintInterval", 20, "RadioButton.background", controlBackgroundColor, "RadioButton.foreground", black, "RadioButton.disabledText", disabled, "RadioButton.select", selected, "RadioButton.icon", t -> AquaButtonRadioUI.getSizingRadioButtonIcon(), "RadioButton.font", controlFont, "RadioButton.border", AquaButtonBorder.getBevelButtonBorder(), "RadioButton.margin", new InsetsUIResource(1, 1, 0, 1), "RadioButton.focusInputMap", controlFocusInputMap, "RadioButtonMenuItem.font", menuFont, "RadioButtonMenuItem.acceleratorFont", menuFont, "RadioButtonMenuItem.background", menuBackgroundColor, "RadioButtonMenuItem.foreground", menuForegroundColor, "RadioButtonMenuItem.selectionBackground", menuSelectedBackgroundColor, "RadioButtonMenuItem.selectionForeground", menuSelectedForegroundColor, "RadioButtonMenuItem.disabledBackground", menuDisabledBackgroundColor, "RadioButtonMenuItem.disabledForeground", menuDisabledForegroundColor, "RadioButtonMenuItem.acceleratorForeground", menuAccelForegroundColor, "RadioButtonMenuItem.acceleratorSelectionForeground", menuAccelSelectionForegroundColor, "RadioButtonMenuItem.acceleratorDelimiter", "", "RadioButtonMenuItem.border", menuBorder, "RadioButtonMenuItem.margin", menuItemMargin, "RadioButtonMenuItem.borderPainted", Boolean.TRUE, "RadioButtonMenuItem.checkIcon", t -> AquaImageFactory.getMenuItemCheckIcon(), "RadioButtonMenuItem.dashIcon", t -> AquaImageFactory.getMenuItemDashIcon(), "Separator.background", null, "Separator.foreground", new ColorUIResource(212, 212, 212), "ScrollBar.border", null, "ScrollBar.focusInputMap", aquaKeyBindings.getScrollBarInputMap(), "ScrollBar.focusInputMap.RightToLeft", aquaKeyBindings.getScrollBarRightToLeftInputMap(), "ScrollBar.width", 16, "ScrollBar.background", white, "ScrollBar.foreground", black, "ScrollPane.font", controlFont, "ScrollPane.background", white, "ScrollPane.foreground", black, "ScrollPane.border", scollListBorder, "ScrollPane.viewportBorder", null, "ScrollPane.ancestorInputMap", aquaKeyBindings.getScrollPaneInputMap(), "ScrollPane.ancestorInputMap.RightToLeft", new UIDefaults.LazyInputMap(new Object[0]), "Viewport.font", controlFont, "Viewport.background", white, "Viewport.foreground", black, "Slider.foreground", black, "Slider.background", controlBackgroundColor, "Slider.font", controlSmallFont, "Slider.tickColor", new ColorUIResource(Color.GRAY), "Slider.border", null, "Slider.focusInsets", new InsetsUIResource(2, 2, 2, 2), "Slider.focusInputMap", aquaKeyBindings.getSliderInputMap(), "Slider.focusInputMap.RightToLeft", aquaKeyBindings.getSliderRightToLeftInputMap(), "Spinner.font", controlFont, "Spinner.background", controlBackgroundColor, "Spinner.foreground", black, "Spinner.border", null, "Spinner.arrowButtonSize", new Dimension(16, 5), "Spinner.ancestorInputMap", aquaKeyBindings.getSpinnerInputMap(), "Spinner.editorBorderPainted", Boolean.TRUE, "Spinner.editorAlignment", 11, "SplitPane.background", panelBackgroundColor, "SplitPane.border", scollListBorder, "SplitPane.dividerSize", 9, "SplitPaneDivider.border", null, "SplitPaneDivider.horizontalGradientVariant", t -> AquaSplitPaneDividerUI.getHorizontalSplitDividerGradientVariant(), "TabbedPane.font", controlFont, "TabbedPane.smallFont", controlSmallFont, "TabbedPane.useSmallLayout", Boolean.FALSE, "TabbedPane.background", tabBackgroundColor, "TabbedPane.foreground", black, "TabbedPane.opaque", useOpaqueComponents, "TabbedPane.textIconGap", 4, "TabbedPane.tabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.leftTabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.rightTabInsets", new InsetsUIResource(0, 10, 3, 10), "TabbedPane.tabAreaInsets", new InsetsUIResource(3, 9, -1, 9), "TabbedPane.contentBorderInsets", new InsetsUIResource(8, 0, 0, 0), "TabbedPane.selectedTabPadInsets", new InsetsUIResource(0, 0, 0, 0), "TabbedPane.tabsOverlapBorder", Boolean.TRUE, "TabbedPane.selectedTabTitlePressedColor", selectedTabTitlePressedColor, "TabbedPane.selectedTabTitleDisabledColor", selectedTabTitleDisabledColor, "TabbedPane.selectedTabTitleNormalColor", selectedTabTitleNormalColor, "TabbedPane.selectedTabTitleShadowDisabledColor", selectedTabTitleShadowDisabledColor, "TabbedPane.selectedTabTitleShadowNormalColor", selectedTabTitleShadowNormalColor, "TabbedPane.nonSelectedTabTitleNormalColor", nonSelectedTabTitleNormalColor, "Table.font", viewFont, "Table.foreground", black, "Table.background", white, "Table.selectionForeground", selectionForeground, "Table.selectionBackground", selectionBackground, "Table.selectionInactiveBackground", selectionInactiveBackground, "Table.selectionInactiveForeground", selectionInactiveForeground, "Table.gridColor", white, "Table.focusCellBackground", textHighlightText, "Table.focusCellForeground", textHighlight, "Table.focusCellHighlightBorder", focusCellHighlightBorder, "Table.scrollPaneBorder", scollListBorder, "Table.ancestorInputMap", aquaKeyBindings.getTableInputMap(), "Table.ancestorInputMap.RightToLeft", aquaKeyBindings.getTableRightToLeftInputMap(), "TableHeader.font", controlSmallFont, "TableHeader.foreground", black, "TableHeader.background", white, "TableHeader.cellBorder", listHeaderBorder, "TextArea.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextArea.font", controlFont, "TextArea.background", textBackground, "TextArea.foreground", textForeground, "TextArea.inactiveForeground", textInactiveText, "TextArea.inactiveBackground", textInactiveBackground, "TextArea.selectionBackground", textHighlight, "TextArea.selectionForeground", textHighlightText, "TextArea.caretForeground", textForeground, "TextArea.caretBlinkRate", 500, "TextArea.border", textAreaBorder, "TextArea.margin", zeroInsets, "TextComponent.selectionBackgroundInactive", textHighlightInactive, "TextField.focusInputMap", aquaKeyBindings.getTextFieldInputMap(), "TextField.font", controlFont, "TextField.background", textBackground, "TextField.foreground", textForeground, "TextField.inactiveForeground", textInactiveText, "TextField.inactiveBackground", textInactiveBackground, "TextField.selectionBackground", textHighlight, "TextField.selectionForeground", textHighlightText, "TextField.caretForeground", textForeground, "TextField.caretBlinkRate", 500, "TextField.border", textFieldBorder, "TextField.margin", zeroInsets, "TextPane.focusInputMap", aquaKeyBindings.getMultiLineTextInputMap(), "TextPane.font", controlFont, "TextPane.background", textBackground, "TextPane.foreground", textForeground, "TextPane.selectionBackground", textHighlight, "TextPane.selectionForeground", textHighlightText, "TextPane.caretForeground", textForeground, "TextPane.caretBlinkRate", 500, "TextPane.inactiveForeground", textInactiveText, "TextPane.inactiveBackground", textInactiveBackground, "TextPane.border", textAreaBorder, "TextPane.margin", editorMargin, "ToggleButton.background", controlBackgroundColor, "ToggleButton.foreground", black, "ToggleButton.disabledText", disabled, "ToggleButton.border", t -> AquaButtonBorder.getDynamicButtonBorder(), "ToggleButton.font", controlFont, "ToggleButton.focusInputMap", controlFocusInputMap, "ToggleButton.margin", new InsetsUIResource(2, 2, 2, 2), "ToolBar.font", controlFont, "ToolBar.background", panelBackgroundColor, "ToolBar.foreground", new ColorUIResource(Color.gray), "ToolBar.dockingBackground", panelBackgroundColor, "ToolBar.dockingForeground", selectionBackground, "ToolBar.floatingBackground", panelBackgroundColor, "ToolBar.floatingForeground", new ColorUIResource(Color.darkGray), "ToolBar.border", t -> AquaToolBarUI.getToolBarBorder(), "ToolBar.borderHandleColor", toolbarDragHandleColor, "ToolBar.separatorSize", null, "ToolBarButton.margin", new InsetsUIResource(3, 3, 3, 3), "ToolBarButton.insets", new InsetsUIResource(1, 1, 1, 1), "ToolTip.font", controlSmallFont, "ToolTip.background", toolTipBackground, "ToolTip.foreground", black, "ToolTip.border", toolTipBorder, "Tree.font", viewFont, "Tree.background", white, "Tree.foreground", black, "Tree.hash", white, "Tree.line", white, "Tree.textForeground", black, "Tree.textBackground", white, "Tree.selectionForeground", selectionForeground, "Tree.selectionBackground", selectionBackground, "Tree.selectionInactiveBackground", selectionInactiveBackground, "Tree.selectionInactiveForeground", selectionInactiveForeground, "Tree.selectionBorderColor", selectionBackground, "Tree.editorBorderSelectionColor", null, "Tree.leftChildIndent", 7, "Tree.rightChildIndent", 13, "Tree.rowHeight", 19, "Tree.scrollsOnExpand", Boolean.FALSE, "Tree.openIcon", t -> AquaImageFactory.getTreeOpenFolderIcon(), "Tree.closedIcon", t -> AquaImageFactory.getTreeFolderIcon(), "Tree.leafIcon", t -> AquaImageFactory.getTreeDocumentIcon(), "Tree.expandedIcon", t -> AquaImageFactory.getTreeExpandedIcon(), "Tree.collapsedIcon", t -> AquaImageFactory.getTreeCollapsedIcon(), "Tree.rightToLeftCollapsedIcon", t -> AquaImageFactory.getTreeRightToLeftCollapsedIcon(), "Tree.changeSelectionWithFocus", Boolean.TRUE, "Tree.drawsFocusBorderAroundIcon", Boolean.FALSE, "Tree.focusInputMap", aquaKeyBindings.getTreeInputMap(), "Tree.focusInputMap.RightToLeft", aquaKeyBindings.getTreeRightToLeftInputMap(), "Tree.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ESCAPE", "cancel"})};
        table.putDefaults(defaults);
        SwingUtilities2.putAATextInfo(true, table);
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        String basicPackageName = "javax.swing.plaf.basic.";
        Object[] uiDefaults = new Object[]{"ButtonUI", "com.apple.laf.AquaButtonUI", "CheckBoxUI", "com.apple.laf.AquaButtonCheckBoxUI", "CheckBoxMenuItemUI", "com.apple.laf.AquaMenuItemUI", "LabelUI", "com.apple.laf.AquaLabelUI", "ListUI", "com.apple.laf.AquaListUI", "MenuUI", "com.apple.laf.AquaMenuUI", "MenuItemUI", "com.apple.laf.AquaMenuItemUI", "OptionPaneUI", "com.apple.laf.AquaOptionPaneUI", "PanelUI", "com.apple.laf.AquaPanelUI", "RadioButtonMenuItemUI", "com.apple.laf.AquaMenuItemUI", "RadioButtonUI", "com.apple.laf.AquaButtonRadioUI", "ProgressBarUI", "com.apple.laf.AquaProgressBarUI", "RootPaneUI", "com.apple.laf.AquaRootPaneUI", "SliderUI", "com.apple.laf.AquaSliderUI", "ScrollBarUI", "com.apple.laf.AquaScrollBarUI", "TabbedPaneUI", PKG_PREFIX + (JRSUIUtils.TabbedPane.shouldUseTabbedPaneContrastUI() ? "AquaTabbedPaneContrastUI" : "AquaTabbedPaneUI"), "TableUI", "com.apple.laf.AquaTableUI", "ToggleButtonUI", "com.apple.laf.AquaButtonToggleUI", "ToolBarUI", "com.apple.laf.AquaToolBarUI", "ToolTipUI", "com.apple.laf.AquaToolTipUI", "TreeUI", "com.apple.laf.AquaTreeUI", "InternalFrameUI", "com.apple.laf.AquaInternalFrameUI", "DesktopIconUI", "com.apple.laf.AquaInternalFrameDockIconUI", "DesktopPaneUI", "com.apple.laf.AquaInternalFramePaneUI", "EditorPaneUI", "com.apple.laf.AquaEditorPaneUI", "TextFieldUI", "com.apple.laf.AquaTextFieldUI", "TextPaneUI", "com.apple.laf.AquaTextPaneUI", "ComboBoxUI", "com.apple.laf.AquaComboBoxUI", "PopupMenuUI", "com.apple.laf.AquaPopupMenuUI", "TextAreaUI", "com.apple.laf.AquaTextAreaUI", "MenuBarUI", "com.apple.laf.AquaMenuBarUI", "FileChooserUI", "com.apple.laf.AquaFileChooserUI", "PasswordFieldUI", "com.apple.laf.AquaTextPasswordFieldUI", "TableHeaderUI", "com.apple.laf.AquaTableHeaderUI", "FormattedTextFieldUI", "com.apple.laf.AquaTextFieldFormattedUI", "SpinnerUI", "com.apple.laf.AquaSpinnerUI", "SplitPaneUI", "com.apple.laf.AquaSplitPaneUI", "ScrollPaneUI", "com.apple.laf.AquaScrollPaneUI", "PopupMenuSeparatorUI", "com.apple.laf.AquaPopupMenuSeparatorUI", "SeparatorUI", "com.apple.laf.AquaPopupMenuSeparatorUI", "ToolBarSeparatorUI", "com.apple.laf.AquaToolBarSeparatorUI", "ColorChooserUI", "javax.swing.plaf.basic.BasicColorChooserUI", "ViewportUI", "javax.swing.plaf.basic.BasicViewportUI"};
        table.putDefaults(uiDefaults);
    }
}

