/*
 * Decompiled with CFR 0.152.
 */
package se.vidstige.jadb;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayDeque;

public class LookBackFilteringOutputStream
extends FilterOutputStream {
    private final ArrayDeque<Byte> buffer;
    private final int lookBackBufferSize;

    protected LookBackFilteringOutputStream(OutputStream inner, int lookBackBufferSize) {
        super(inner);
        this.lookBackBufferSize = lookBackBufferSize;
        this.buffer = new ArrayDeque(lookBackBufferSize);
    }

    protected void unwrite() {
        this.buffer.removeFirst();
    }

    protected ArrayDeque<Byte> lookback() {
        return this.buffer;
    }

    @Override
    public void write(int c) throws IOException {
        this.buffer.addLast((byte)c);
        this.flushBuffer(this.lookBackBufferSize);
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer(0);
        this.out.flush();
    }

    private void flushBuffer(int size) throws IOException {
        while (this.buffer.size() > size) {
            Byte b = this.buffer.removeFirst();
            this.out.write(b.byteValue());
        }
    }
}

