/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.awt.OSXSurfaceData;
import apple.laf.JRSUIControl;
import apple.laf.JRSUIState;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;
import sun.print.PeekGraphics;
import sun.print.ProxyGraphics2D;

abstract class AquaPainter<T extends JRSUIState> {
    final Rectangle boundsRect = new Rectangle();
    final JRSUIControl control;
    T state;

    static <T extends JRSUIState> AquaPainter<T> create(T t) {
        return new DirectOSXSurfacePainter<T>(t);
    }

    abstract void paint(SunGraphics2D var1, T var2, Component var3);

    public AquaPainter(JRSUIControl jRSUIControl, T t) {
        this.control = jRSUIControl;
        this.state = t;
    }

    JRSUIControl getControl() {
        this.state = ((JRSUIState)this.state).derive();
        this.control.set((JRSUIState)this.state);
        return this.control;
    }

    void paint(Graphics graphics, Component component, int n, int n2, int n3, int n4) {
        this.boundsRect.setBounds(n, n2, n3, n4);
        Object t = ((JRSUIState)this.state).derive();
        SunGraphics2D sunGraphics2D = this.getGraphics2D(graphics);
        if (sunGraphics2D != null) {
            this.paint(sunGraphics2D, t, component);
        }
        this.state = t;
    }

    protected SunGraphics2D getGraphics2D(Graphics graphics) {
        try {
            return (SunGraphics2D)graphics;
        }
        catch (Exception exception) {
            ProxyGraphics2D proxyGraphics2D;
            Graphics2D graphics2D;
            if (graphics instanceof PeekGraphics) {
                graphics.fillRect(this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
            } else if (graphics instanceof ProxyGraphics2D && (graphics2D = (proxyGraphics2D = (ProxyGraphics2D)graphics).getDelegate()) instanceof SunGraphics2D) {
                return (SunGraphics2D)graphics2D;
            }
            return null;
        }
    }

    static class DirectOSXSurfacePainter<T extends JRSUIState>
    extends AquaPainter<T>
    implements OSXSurfaceData.CGContextDrawable {
        public DirectOSXSurfacePainter(T t) {
            super(new JRSUIControl(true), t);
        }

        @Override
        void paint(SunGraphics2D sunGraphics2D, T t, Component component) {
            SurfaceData surfaceData = sunGraphics2D.getSurfaceData();
            if (!(surfaceData instanceof OSXSurfaceData)) {
                return;
            }
            this.control.set((JRSUIState)t);
            ((OSXSurfaceData)surfaceData).performCocoaDrawing(sunGraphics2D, this, component);
        }

        @Override
        public void drawIntoCGContext(long l) {
            this.control.paint(l, this.boundsRect.x, this.boundsRect.y, this.boundsRect.width, this.boundsRect.height);
        }
    }
}

