/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CGraphicsConfig;
import apple.awt.CWindow;
import apple.awt.ComponentModel;
import apple.awt.RuntimeOptions;
import java.awt.AWTPermission;
import java.awt.Component;
import java.awt.DisplayMode;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunDisplayChanger;
import sun.java2d.SurfaceData;
import sun.java2d.opengl.CGLGraphicsConfig;
import sun.security.action.GetPropertyAction;

public class CGraphicsDevice
extends GraphicsDevice
implements DisplayChangedListener {
    int screen;
    ColorModel dynamicColorModel;
    ColorModel colorModel;
    GraphicsConfiguration[] configs;
    GraphicsConfiguration defaultConfig;
    boolean offscreenAccelerationEnabled = true;
    private SunDisplayChanger topLevels = new SunDisplayChanger();
    private static boolean pfDisabled;
    private static AWTPermission fullScreenExclusivePermission;
    private Rectangle ownerWindowedModeBounds = null;
    private DisplayMode defaultDisplayMode;
    int displayID;
    int fadeToken;
    long windowID = 0L;
    private int screenResolution;

    private static native void initIDs();

    public boolean isOffscreenAccelerationEnabled() {
        return this.offscreenAccelerationEnabled;
    }

    native void initDevice(int var1);

    public CGraphicsDevice(int n) {
        this.screen = n;
        this.initDevice(n);
    }

    @Override
    public int getType() {
        return 0;
    }

    public int getScreen() {
        return this.screen;
    }

    @Override
    public String getIDstring() {
        return "\\Display" + this.screen;
    }

    @Override
    public GraphicsConfiguration[] getConfigurations() {
        if (this.configs == null) {
            if (RuntimeOptions.getRenderer() == 3 && this.isDefaultDevice()) {
                this.defaultConfig = this.getDefaultConfiguration();
                if (this.defaultConfig != null) {
                    this.configs = new GraphicsConfiguration[1];
                    this.configs[0] = this.defaultConfig;
                    return (GraphicsConfiguration[])this.configs.clone();
                }
            }
            int n = this.getMaxConfigs(this.screen);
            int n2 = this.getDefaultPixID(this.screen);
            Vector<GraphicsConfiguration> vector = new Vector<GraphicsConfiguration>(n);
            if (n2 == 0) {
                this.defaultConfig = CGraphicsConfig.getConfig(this, n2);
                vector.addElement(this.defaultConfig);
            } else {
                for (int i = 1; i <= n; ++i) {
                    if (!this.isPixFmtSupported(i, this.screen)) continue;
                    if (i == n2) {
                        this.defaultConfig = CGraphicsConfig.getConfig(this, i);
                        vector.addElement(this.defaultConfig);
                        continue;
                    }
                    vector.addElement(CGraphicsConfig.getConfig(this, i));
                }
            }
            this.configs = new GraphicsConfiguration[vector.size()];
            vector.copyInto(this.configs);
        }
        return (GraphicsConfiguration[])this.configs.clone();
    }

    private native int getMaxConfigsImpl(int var1);

    protected int getMaxConfigs(int n) {
        if (pfDisabled) {
            return 1;
        }
        return this.getMaxConfigsImpl(n);
    }

    protected native boolean isPixFmtSupported(int var1, int var2);

    protected int getDefaultPixID(int n) {
        if (pfDisabled) {
            return 0;
        }
        return this.getDefaultPixIDImpl(n);
    }

    private native int getDefaultPixIDImpl(int var1);

    private boolean isOGLVerbose() {
        return false;
    }

    @Override
    public GraphicsConfiguration getDefaultConfiguration() {
        if (this.defaultConfig == null) {
            if (RuntimeOptions.getRenderer() == 3 && this.isDefaultDevice()) {
                int n = CGLGraphicsConfig.getDefaultPixFmt((int)this.screen);
                this.defaultConfig = CGLGraphicsConfig.getConfig((CGraphicsDevice)this, (int)n);
                if (this.isOGLVerbose()) {
                    if (this.defaultConfig != null) {
                        System.out.print("OpenGL pipeline enabled");
                    } else {
                        System.out.print("Could not enable OpenGL pipeline");
                    }
                    System.out.println(" for default config on screen " + this.screen);
                }
            }
            if (this.defaultConfig == null) {
                this.defaultConfig = CGraphicsConfig.getConfig(this, 0);
            }
        }
        return this.defaultConfig;
    }

    public String toString() {
        return "CGraphicsDevice[screen=" + this.screen + "]";
    }

    private boolean isDefaultDevice() {
        return this == GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
    }

    private static boolean isFSExclusiveModeAllowed() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            if (fullScreenExclusivePermission == null) {
                fullScreenExclusivePermission = new AWTPermission("fullScreenExclusive");
            }
            try {
                securityManager.checkPermission(fullScreenExclusivePermission);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isFullScreenSupported() {
        return CGraphicsDevice.isFSExclusiveModeAllowed();
    }

    private Frame getToplevelOwner(Window window) {
        Window window2 = window;
        while (window2 != null) {
            if (!((window2 = window2.getOwner()) instanceof Frame)) continue;
            return (Frame)window2;
        }
        return null;
    }

    @Override
    public void setFullScreenWindow(final Window window) {
        class SetFullScreenAction
        implements Runnable {
            SetFullScreenAction() {
            }

            @Override
            public void run() {
                CGraphicsDevice.this.setFullScreenWindowSynchronized(window);
            }
        }
        SetFullScreenAction setFullScreenAction = new SetFullScreenAction();
        if (EventQueue.isDispatchThread()) {
            setFullScreenAction.run();
        } else {
            try {
                EventQueue.invokeAndWait(setFullScreenAction);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void setFullScreenWindowSynchronized(Window window) {
        Object object;
        Object object2;
        Window window2 = this.getFullScreenWindow();
        if (window == window2) {
            return;
        }
        if (!this.isFullScreenSupported()) {
            super.setFullScreenWindow(window);
            return;
        }
        if (window2 != null) {
            if (this.defaultDisplayMode != null) {
                this.setDisplayMode(this.defaultDisplayMode);
                this.defaultDisplayMode = null;
            }
            if ((object2 = (CWindow)window2.getPeer()) != null) {
                object = object2;
                synchronized (object) {
                    ((ComponentModel)object2).destroyBuffers();
                    this.exitFullScreenExclusive(this.screen, (CWindow)object2);
                }
            }
            if (!(window2 instanceof Frame)) {
                object = this.getToplevelOwner(window2);
                if (object != null && this.ownerWindowedModeBounds != null) {
                    ((Window)object).setBounds(this.ownerWindowedModeBounds);
                }
                this.ownerWindowedModeBounds = null;
            }
        }
        super.setFullScreenWindow(window);
        if (window != null) {
            this.defaultDisplayMode = this.getDisplayMode();
            if (!(window instanceof Frame) && (object2 = this.getToplevelOwner(window)) != null) {
                this.ownerWindowedModeBounds = ((Component)object2).getBounds();
                ((Window)object2).setBounds(window.getBounds());
            }
            object = object2 = (CWindow)window.getPeer();
            synchronized (object) {
                this.enterFullScreenExclusive(this.screen, (CWindow)object2);
            }
        }
    }

    public native void enterFullScreen(SurfaceData var1, int var2, long var3);

    public native void exitFullScreen(SurfaceData var1, int var2);

    private void enterFullScreenExclusive(int n, CWindow cWindow) {
        this.windowID = cWindow.getWindowID();
        if (this.windowID != 0L) {
            this.enterFullScreen(cWindow.getSurfaceData(), n, this.windowID);
        }
    }

    private void exitFullScreenExclusive(int n, CWindow cWindow) {
        if (this.windowID != 0L) {
            this.exitFullScreen(cWindow.getSurfaceData(), n);
        }
        this.windowID = 0L;
    }

    @Override
    public boolean isDisplayChangeSupported() {
        return this.isFullScreenSupported() && this.getFullScreenWindow() != null;
    }

    @Override
    public synchronized void setDisplayMode(DisplayMode displayMode) {
        if (!this.isDisplayChangeSupported()) {
            super.setDisplayMode(displayMode);
            return;
        }
        if (displayMode == null || (displayMode = this.getMatchingDisplayMode(displayMode)) == null) {
            throw new IllegalArgumentException("Invalid display mode");
        }
        if (this.getDisplayMode().equals(displayMode)) {
            return;
        }
        Window window = this.getFullScreenWindow();
        if (window != null) {
            if (displayMode.getBitDepth() == 8) {
                throw new IllegalStateException("Full Screen doesn't support 8- bit DisplayMode");
            }
        } else {
            throw new IllegalStateException("Must be in fullscreen mode in order to set display mode");
        }
        this.configDisplayMode(this.screen, ((CWindow)window.getPeer()).getModelPtr(), displayMode.getWidth(), displayMode.getHeight(), displayMode.getBitDepth(), displayMode.getRefreshRate());
        Rectangle rectangle = this.getDefaultConfiguration().getBounds();
        window.setBounds(rectangle.x, rectangle.y, displayMode.getWidth(), displayMode.getHeight());
    }

    private native DisplayMode getCurrentDisplayMode(int var1);

    private native void configDisplayMode(int var1, long var2, int var4, int var5, int var6, int var7);

    private native void enumDisplayModes(int var1, ArrayList var2);

    @Override
    public synchronized DisplayMode getDisplayMode() {
        this.getDisplayModes();
        DisplayMode displayMode = this.getCurrentDisplayMode(this.screen);
        return displayMode;
    }

    @Override
    public synchronized DisplayMode[] getDisplayModes() {
        ArrayList arrayList = new ArrayList();
        this.enumDisplayModes(this.screen, arrayList);
        int n = arrayList.size();
        DisplayMode[] displayModeArray = new DisplayMode[n];
        for (int i = 0; i < n; ++i) {
            displayModeArray[i] = (DisplayMode)arrayList.get(i);
        }
        return displayModeArray;
    }

    private synchronized DisplayMode getMatchingDisplayMode(DisplayMode displayMode) {
        DisplayMode[] displayModeArray;
        if (!this.isDisplayChangeSupported()) {
            return null;
        }
        for (DisplayMode displayMode2 : displayModeArray = this.getDisplayModes()) {
            if (!displayMode.equals(displayMode2) && (displayMode.getRefreshRate() != 0 || displayMode.getWidth() != displayMode2.getWidth() || displayMode.getHeight() != displayMode2.getHeight() || displayMode.getBitDepth() != displayMode2.getBitDepth())) continue;
            return displayMode2;
        }
        return null;
    }

    @Override
    public void displayChanged() {
        this.dynamicColorModel = null;
        this.defaultConfig = null;
        this.configs = null;
        this.topLevels.notifyListeners();
    }

    @Override
    public void paletteChanged() {
    }

    public void addDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.add(displayChangedListener);
    }

    public void removeDisplayChangedListener(DisplayChangedListener displayChangedListener) {
        this.topLevels.remove(displayChangedListener);
    }

    private native ColorModel makeColorModel(int var1, boolean var2);

    public ColorModel getDynamicColorModel() {
        if (this.dynamicColorModel == null) {
            this.dynamicColorModel = this.makeColorModel(this.screen, true);
            if (this.dynamicColorModel == null) {
                this.dynamicColorModel = this.getColorModel();
            }
        }
        return this.dynamicColorModel;
    }

    public ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel(this.screen, false);
            if (this.colorModel == null) {
                BufferedImage bufferedImage = null;
                switch (this.getDisplayMode().getBitDepth()) {
                    case 16: {
                        bufferedImage = new BufferedImage(1, 1, 9);
                        break;
                    }
                    default: {
                        bufferedImage = new BufferedImage(1, 1, 1);
                    }
                }
                this.colorModel = bufferedImage.getColorModel();
                bufferedImage = null;
            }
        }
        return this.colorModel;
    }

    private native int getDeviceMemoryNative(int var1);

    @Override
    public int getAvailableAcceleratedMemory() {
        return this.getDeviceMemoryNative(this.screen);
    }

    native int getScreenResolution(int var1);

    int getScreenResolution() {
        if (this.screenResolution == 0) {
            this.screenResolution = this.getScreenResolution(this.screen);
        }
        return this.screenResolution;
    }

    native Insets getScreenInsets(int var1);

    Insets getScreenInsets() {
        return this.getScreenInsets(this.screen);
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.awt.nopixfmt"));
        pfDisabled = string != null;
        pfDisabled = true;
    }
}

