/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;
import sun.awt.AppContext;
import sun.swing.SwingUtilities2;

public class BasicRadioButtonUI
extends BasicToggleButtonUI {
    private static final Object BASIC_RADIO_BUTTON_UI_KEY = new Object();
    protected Icon icon;
    private boolean defaults_initialized = false;
    private static final String propertyPrefix = "RadioButton.";
    private KeyListener keyListener = null;
    private static Dimension size = new Dimension();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle prefViewRect = new Rectangle();
    private static Rectangle prefIconRect = new Rectangle();
    private static Rectangle prefTextRect = new Rectangle();
    private static Insets prefInsets = new Insets(0, 0, 0, 0);

    public static ComponentUI createUI(JComponent b) {
        AppContext appContext = AppContext.getAppContext();
        BasicRadioButtonUI radioButtonUI = (BasicRadioButtonUI)appContext.get(BASIC_RADIO_BUTTON_UI_KEY);
        if (radioButtonUI == null) {
            radioButtonUI = new BasicRadioButtonUI();
            appContext.put(BASIC_RADIO_BUTTON_UI_KEY, radioButtonUI);
        }
        return radioButtonUI;
    }

    @Override
    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        if (!this.defaults_initialized) {
            this.icon = UIManager.getIcon(this.getPropertyPrefix() + "icon");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
        this.defaults_initialized = false;
    }

    public Icon getDefaultIcon() {
        return this.icon;
    }

    @Override
    protected void installListeners(AbstractButton button) {
        super.installListeners(button);
        if (!(button instanceof JRadioButton)) {
            return;
        }
        this.keyListener = this.createKeyListener();
        button.addKeyListener(this.keyListener);
        button.setFocusTraversalKeysEnabled(false);
        button.getActionMap().put("Previous", new SelectPreviousBtn());
        button.getActionMap().put("Next", new SelectNextBtn());
        button.getInputMap(1).put(KeyStroke.getKeyStroke("UP"), "Previous");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("DOWN"), "Next");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("LEFT"), "Previous");
        button.getInputMap(1).put(KeyStroke.getKeyStroke("RIGHT"), "Next");
    }

    @Override
    protected void uninstallListeners(AbstractButton button) {
        super.uninstallListeners(button);
        if (!(button instanceof JRadioButton)) {
            return;
        }
        button.getActionMap().remove("Previous");
        button.getActionMap().remove("Next");
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("UP"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("DOWN"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("LEFT"));
        button.getInputMap(1).remove(KeyStroke.getKeyStroke("RIGHT"));
        if (this.keyListener != null) {
            button.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
    }

    @Override
    public synchronized void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Font f = c.getFont();
        g.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g, f);
        Insets i = c.getInsets();
        size = b.getSize(size);
        BasicRadioButtonUI.viewRect.x = i.left;
        BasicRadioButtonUI.viewRect.y = i.top;
        BasicRadioButtonUI.viewRect.width = BasicRadioButtonUI.size.width - (i.right + BasicRadioButtonUI.viewRect.x);
        BasicRadioButtonUI.viewRect.height = BasicRadioButtonUI.size.height - (i.bottom + BasicRadioButtonUI.viewRect.y);
        BasicRadioButtonUI.iconRect.height = 0;
        BasicRadioButtonUI.iconRect.width = 0;
        BasicRadioButtonUI.iconRect.y = 0;
        BasicRadioButtonUI.iconRect.x = 0;
        BasicRadioButtonUI.textRect.height = 0;
        BasicRadioButtonUI.textRect.width = 0;
        BasicRadioButtonUI.textRect.y = 0;
        BasicRadioButtonUI.textRect.x = 0;
        Icon altIcon = b.getIcon();
        Object selectedIcon = null;
        Object disabledIcon = null;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), altIcon != null ? altIcon : this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        if (c.isOpaque()) {
            g.setColor(b.getBackground());
            g.fillRect(0, 0, BasicRadioButtonUI.size.width, BasicRadioButtonUI.size.height);
        }
        if (altIcon != null) {
            if (!model.isEnabled()) {
                altIcon = model.isSelected() ? b.getDisabledSelectedIcon() : b.getDisabledIcon();
            } else if (model.isPressed() && model.isArmed()) {
                altIcon = b.getPressedIcon();
                if (altIcon == null) {
                    altIcon = b.getSelectedIcon();
                }
            } else if (model.isSelected()) {
                if (b.isRolloverEnabled() && model.isRollover()) {
                    altIcon = b.getRolloverSelectedIcon();
                    if (altIcon == null) {
                        altIcon = b.getSelectedIcon();
                    }
                } else {
                    altIcon = b.getSelectedIcon();
                }
            } else if (b.isRolloverEnabled() && model.isRollover()) {
                altIcon = b.getRolloverIcon();
            }
            if (altIcon == null) {
                altIcon = b.getIcon();
            }
            altIcon.paintIcon(c, g, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        } else {
            this.getDefaultIcon().paintIcon(c, g, BasicRadioButtonUI.iconRect.x, BasicRadioButtonUI.iconRect.y);
        }
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g, textRect);
            } else {
                this.paintText(g, b, textRect, text);
            }
            if (b.hasFocus() && b.isFocusPainted() && BasicRadioButtonUI.textRect.width > 0 && BasicRadioButtonUI.textRect.height > 0) {
                this.paintFocus(g, textRect, size);
            }
        }
    }

    protected void paintFocus(Graphics g, Rectangle textRect, Dimension size) {
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        if (c.getComponentCount() > 0) {
            return null;
        }
        AbstractButton b = (AbstractButton)c;
        String text = b.getText();
        Icon buttonIcon = b.getIcon();
        if (buttonIcon == null) {
            buttonIcon = this.getDefaultIcon();
        }
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        BasicRadioButtonUI.prefViewRect.y = 0;
        BasicRadioButtonUI.prefViewRect.x = 0;
        BasicRadioButtonUI.prefViewRect.width = Short.MAX_VALUE;
        BasicRadioButtonUI.prefViewRect.height = Short.MAX_VALUE;
        BasicRadioButtonUI.prefIconRect.height = 0;
        BasicRadioButtonUI.prefIconRect.width = 0;
        BasicRadioButtonUI.prefIconRect.y = 0;
        BasicRadioButtonUI.prefIconRect.x = 0;
        BasicRadioButtonUI.prefTextRect.height = 0;
        BasicRadioButtonUI.prefTextRect.width = 0;
        BasicRadioButtonUI.prefTextRect.y = 0;
        BasicRadioButtonUI.prefTextRect.x = 0;
        SwingUtilities.layoutCompoundLabel(c, fm, text, buttonIcon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), prefViewRect, prefIconRect, prefTextRect, text == null ? 0 : b.getIconTextGap());
        int x1 = Math.min(BasicRadioButtonUI.prefIconRect.x, BasicRadioButtonUI.prefTextRect.x);
        int x2 = Math.max(BasicRadioButtonUI.prefIconRect.x + BasicRadioButtonUI.prefIconRect.width, BasicRadioButtonUI.prefTextRect.x + BasicRadioButtonUI.prefTextRect.width);
        int y1 = Math.min(BasicRadioButtonUI.prefIconRect.y, BasicRadioButtonUI.prefTextRect.y);
        int y2 = Math.max(BasicRadioButtonUI.prefIconRect.y + BasicRadioButtonUI.prefIconRect.height, BasicRadioButtonUI.prefTextRect.y + BasicRadioButtonUI.prefTextRect.height);
        int width = x2 - x1;
        int height = y2 - y1;
        prefInsets = b.getInsets(prefInsets);
        return new Dimension(width += BasicRadioButtonUI.prefInsets.left + BasicRadioButtonUI.prefInsets.right, height += BasicRadioButtonUI.prefInsets.top + BasicRadioButtonUI.prefInsets.bottom);
    }

    private KeyListener createKeyListener() {
        if (this.keyListener == null) {
            this.keyListener = new KeyHandler();
        }
        return this.keyListener;
    }

    private boolean isValidRadioButtonObj(Object obj) {
        return obj instanceof JRadioButton && ((JRadioButton)obj).isVisible() && ((JRadioButton)obj).isEnabled();
    }

    private void selectRadioButton(ActionEvent event, boolean next) {
        Object eventSrc = event.getSource();
        if (!this.isValidRadioButtonObj(eventSrc)) {
            return;
        }
        ButtonGroupInfo btnGroupInfo = new ButtonGroupInfo((JRadioButton)eventSrc);
        btnGroupInfo.selectNewButton(next);
    }

    private class KeyHandler
    implements KeyListener {
        private KeyHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            JRadioButton source;
            boolean next;
            AWTKeyStroke stroke = AWTKeyStroke.getAWTKeyStrokeForEvent(e);
            if (stroke != null && e.getSource() instanceof JRadioButton && ((next = this.isFocusTraversalKey(source = (JRadioButton)e.getSource(), 0, stroke)) || this.isFocusTraversalKey(source, 1, stroke))) {
                e.consume();
                ButtonGroupInfo btnGroupInfo = new ButtonGroupInfo(source);
                btnGroupInfo.jumpToNextComponent(next);
            }
        }

        private boolean isFocusTraversalKey(JComponent c, int id, AWTKeyStroke stroke) {
            Set<AWTKeyStroke> keys = c.getFocusTraversalKeys(id);
            return keys != null && keys.contains(stroke);
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    private class ButtonGroupInfo {
        JRadioButton activeBtn = null;
        JRadioButton firstBtn = null;
        JRadioButton lastBtn = null;
        JRadioButton previousBtn = null;
        JRadioButton nextBtn = null;
        HashSet<JRadioButton> btnsInGroup = null;
        boolean srcFound = false;

        public ButtonGroupInfo(JRadioButton btn) {
            this.activeBtn = btn;
            this.btnsInGroup = new HashSet();
        }

        boolean containsInGroup(Object obj) {
            return this.btnsInGroup.contains(obj);
        }

        Component getFocusTransferBaseComponent(boolean next) {
            return this.firstBtn;
        }

        boolean getButtonGroupInfo() {
            if (this.activeBtn == null) {
                return false;
            }
            this.btnsInGroup.clear();
            ButtonModel model = this.activeBtn.getModel();
            if (!(model instanceof DefaultButtonModel)) {
                return false;
            }
            DefaultButtonModel bm = (DefaultButtonModel)model;
            ButtonGroup group = bm.getGroup();
            if (group == null) {
                return false;
            }
            Enumeration<AbstractButton> e = group.getElements();
            if (e == null) {
                return false;
            }
            while (e.hasMoreElements()) {
                AbstractButton curElement = e.nextElement();
                if (!BasicRadioButtonUI.this.isValidRadioButtonObj(curElement)) continue;
                this.btnsInGroup.add((JRadioButton)curElement);
                if (null == this.firstBtn) {
                    this.firstBtn = (JRadioButton)curElement;
                }
                if (this.activeBtn == curElement) {
                    this.srcFound = true;
                } else if (!this.srcFound) {
                    this.previousBtn = (JRadioButton)curElement;
                } else if (this.nextBtn == null) {
                    this.nextBtn = (JRadioButton)curElement;
                }
                this.lastBtn = (JRadioButton)curElement;
            }
            return true;
        }

        void selectNewButton(boolean next) {
            if (!this.getButtonGroupInfo()) {
                return;
            }
            if (this.srcFound) {
                JRadioButton newSelectedBtn = null;
                if (next) {
                    newSelectedBtn = null == this.nextBtn ? this.firstBtn : this.nextBtn;
                } else {
                    JRadioButton jRadioButton = newSelectedBtn = null == this.previousBtn ? this.lastBtn : this.previousBtn;
                }
                if (newSelectedBtn != null && newSelectedBtn != this.activeBtn) {
                    newSelectedBtn.requestFocusInWindow();
                    newSelectedBtn.setSelected(true);
                }
            }
        }

        void jumpToNextComponent(boolean next) {
            if (!this.getButtonGroupInfo()) {
                if (this.activeBtn != null) {
                    this.lastBtn = this.activeBtn;
                    this.firstBtn = this.activeBtn;
                } else {
                    return;
                }
            }
            JRadioButton compTransferFocusFrom = this.activeBtn;
            Component focusBase = this.getFocusTransferBaseComponent(next);
            if (focusBase != null) {
                if (next) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(focusBase);
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(focusBase);
                }
            }
        }
    }

    private class SelectNextBtn
    extends AbstractAction {
        public SelectNextBtn() {
            super("Next");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicRadioButtonUI.this.selectRadioButton(e, true);
        }
    }

    private class SelectPreviousBtn
    extends AbstractAction {
        public SelectPreviousBtn() {
            super("Previous");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicRadioButtonUI.this.selectRadioButton(e, false);
        }
    }
}

