/*
 * Decompiled with CFR 0.152.
 */
package javax.print.attribute.standard;

import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.Severity;

public final class PrinterStateReasons
extends HashMap<PrinterStateReason, Severity>
implements PrintServiceAttribute {
    private static final long serialVersionUID = -3731791085163619457L;

    public PrinterStateReasons() {
    }

    public PrinterStateReasons(int initialCapacity) {
        super(initialCapacity);
    }

    public PrinterStateReasons(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public PrinterStateReasons(Map<PrinterStateReason, Severity> map) {
        this();
        for (Map.Entry<PrinterStateReason, Severity> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    @Override
    public Severity put(PrinterStateReason reason, Severity severity) {
        if (reason == null) {
            throw new NullPointerException("reason is null");
        }
        if (severity == null) {
            throw new NullPointerException("severity is null");
        }
        return super.put(reason, severity);
    }

    @Override
    public final Class<? extends Attribute> getCategory() {
        return PrinterStateReasons.class;
    }

    @Override
    public final String getName() {
        return "printer-state-reasons";
    }

    public Set<PrinterStateReason> printerStateReasonSet(Severity severity) {
        if (severity == null) {
            throw new NullPointerException("severity is null");
        }
        return new PrinterStateReasonSet(severity, this.entrySet());
    }

    private class PrinterStateReasonSetIterator
    implements Iterator<PrinterStateReason> {
        private Severity mySeverity;
        private Iterator<Map.Entry<PrinterStateReason, Severity>> myIterator;
        private Map.Entry<PrinterStateReason, Severity> myEntry;

        public PrinterStateReasonSetIterator(Severity severity, Iterator<Map.Entry<PrinterStateReason, Severity>> iterator) {
            this.mySeverity = severity;
            this.myIterator = iterator;
            this.goToNext();
        }

        private void goToNext() {
            this.myEntry = null;
            while (this.myEntry == null && this.myIterator.hasNext()) {
                this.myEntry = this.myIterator.next();
                if (this.myEntry.getValue() == this.mySeverity) continue;
                this.myEntry = null;
            }
        }

        @Override
        public boolean hasNext() {
            return this.myEntry != null;
        }

        @Override
        public PrinterStateReason next() {
            if (this.myEntry == null) {
                throw new NoSuchElementException();
            }
            PrinterStateReason result = this.myEntry.getKey();
            this.goToNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class PrinterStateReasonSet
    extends AbstractSet<PrinterStateReason> {
        private Severity mySeverity;
        private Set<Map.Entry<PrinterStateReason, Severity>> myEntrySet;

        public PrinterStateReasonSet(Severity severity, Set<Map.Entry<PrinterStateReason, Severity>> entrySet) {
            this.mySeverity = severity;
            this.myEntrySet = entrySet;
        }

        @Override
        public int size() {
            int result = 0;
            Iterator<PrinterStateReason> iter = this.iterator();
            while (iter.hasNext()) {
                iter.next();
                ++result;
            }
            return result;
        }

        @Override
        public Iterator<PrinterStateReason> iterator() {
            return new PrinterStateReasonSetIterator(this.mySeverity, this.myEntrySet.iterator());
        }
    }
}

