/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.plugins.tiff;

import java.util.ArrayList;
import java.util.List;
import javax.imageio.plugins.tiff.TIFFTag;
import javax.imageio.plugins.tiff.TIFFTagSet;

public final class FaxTIFFTagSet
extends TIFFTagSet {
    private static FaxTIFFTagSet theInstance = null;
    public static final int TAG_BAD_FAX_LINES = 326;
    public static final int TAG_CLEAN_FAX_DATA = 327;
    public static final int CLEAN_FAX_DATA_NO_ERRORS = 0;
    public static final int CLEAN_FAX_DATA_ERRORS_CORRECTED = 1;
    public static final int CLEAN_FAX_DATA_ERRORS_UNCORRECTED = 2;
    public static final int TAG_CONSECUTIVE_BAD_LINES = 328;
    private static List<TIFFTag> tags;

    private static void initTags() {
        tags = new ArrayList<TIFFTag>(42);
        tags.add(new BadFaxLines());
        tags.add(new CleanFaxData());
        tags.add(new ConsecutiveBadFaxLines());
    }

    private FaxTIFFTagSet() {
        super(tags);
    }

    public static synchronized FaxTIFFTagSet getInstance() {
        if (theInstance == null) {
            FaxTIFFTagSet.initTags();
            theInstance = new FaxTIFFTagSet();
            tags = null;
        }
        return theInstance;
    }

    static class ConsecutiveBadFaxLines
    extends TIFFTag {
        public ConsecutiveBadFaxLines() {
            super("ConsecutiveBadFaxLines", 328, 24, 1);
        }
    }

    static class CleanFaxData
    extends TIFFTag {
        public CleanFaxData() {
            super("CleanFaxData", 327, 8, 1);
            this.addValueName(0, "No errors");
            this.addValueName(1, "Errors corrected");
            this.addValueName(2, "Errors uncorrected");
        }
    }

    static class BadFaxLines
    extends TIFFTag {
        public BadFaxLines() {
            super("BadFaxLines", 326, 24, 1);
        }
    }
}

