/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import java.awt.Component;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.swing.SwingAccessor;

class ScreenPopupFactory
extends PopupFactory {
    static final Float TRANSLUCENT = Float.valueOf(0.972549f);
    static final Float OPAQUE = Float.valueOf(1.0f);
    boolean fIsActive = true;

    ScreenPopupFactory() {
    }

    void setActive(boolean b) {
        this.fIsActive = b;
    }

    private static Window getWindow(Component c) {
        Component w;
        for (w = c; !(w instanceof Window) && w != null; w = w.getParent()) {
        }
        return (Window)w;
    }

    @Override
    public Popup getPopup(Component comp, Component invoker, int x, int y) {
        if (invoker == null) {
            throw new IllegalArgumentException("Popup.getPopup must be passed non-null contents");
        }
        Popup popup = this.fIsActive ? SwingAccessor.getPopupFactoryAccessor().getHeavyWeightPopup(this, comp, invoker, x, y) : super.getPopup(comp, invoker, x, y);
        Window w = ScreenPopupFactory.getWindow(invoker);
        if (w == null) {
            return popup;
        }
        if (!(w instanceof RootPaneContainer)) {
            return popup;
        }
        final JRootPane popupRootPane = ((RootPaneContainer)((Object)w)).getRootPane();
        if (this.fIsActive) {
            popupRootPane.putClientProperty("Window.alpha", TRANSLUCENT);
            popupRootPane.putClientProperty("Window.shadow", Boolean.TRUE);
            popupRootPane.putClientProperty("apple.awt._windowFadeDelegate", invoker);
            w.setBackground(UIManager.getColor("PopupMenu.translucentBackground"));
            popupRootPane.putClientProperty("apple.awt.draggableWindowBackground", Boolean.FALSE);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    popupRootPane.putClientProperty("apple.awt.windowShadow.revalidateNow", Math.random());
                }
            });
        } else {
            popupRootPane.putClientProperty("Window.alpha", OPAQUE);
            popupRootPane.putClientProperty("Window.shadow", Boolean.FALSE);
        }
        return popup;
    }
}

