/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import com.apple.laf.AquaIcon;
import com.apple.laf.ScreenMenuItemUI;
import com.apple.laf.ScreenMenuPropertyHandler;
import com.apple.laf.ScreenMenuPropertyListener;
import java.awt.Image;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.plaf.ButtonUI;
import sun.awt.AWTAccessor;
import sun.lwawt.macosx.CMenuItem;

final class ScreenMenuItem
extends MenuItem
implements ActionListener,
ComponentListener,
ScreenMenuPropertyHandler {
    ScreenMenuPropertyListener fListener;
    JMenuItem fMenuItem;

    ScreenMenuItem(JMenuItem mi) {
        super(mi.getText());
        this.fMenuItem = mi;
        this.setEnabled(this.fMenuItem.isEnabled());
        ButtonUI ui = this.fMenuItem.getUI();
        if (ui instanceof ScreenMenuItemUI) {
            ((ScreenMenuItemUI)((Object)ui)).updateListenersForScreenMenuItem();
        }
    }

    @Override
    public void addNotify() {
        ButtonUI ui;
        String tooltipText;
        Icon icon;
        super.addNotify();
        this.fMenuItem.addComponentListener(this);
        this.fListener = new ScreenMenuPropertyListener(this);
        this.fMenuItem.addPropertyChangeListener(this.fListener);
        this.addActionListener(this);
        this.setEnabled(this.fMenuItem.isEnabled());
        this.setAccelerator(this.fMenuItem.getAccelerator());
        String label = this.fMenuItem.getText();
        if (label != null) {
            this.setLabel(label);
        }
        if ((icon = this.fMenuItem.getIcon()) != null) {
            this.setIcon(icon);
        }
        if ((tooltipText = this.fMenuItem.getToolTipText()) != null) {
            this.setToolTipText(tooltipText);
        }
        if (this.fMenuItem instanceof JRadioButtonMenuItem && (ui = this.fMenuItem.getUI()) instanceof ScreenMenuItemUI) {
            ((ScreenMenuItemUI)((Object)ui)).updateListenersForScreenMenuItem();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.removeActionListener(this);
        this.fMenuItem.removePropertyChangeListener(this.fListener);
        this.fListener = null;
        this.fMenuItem.removeComponentListener(this);
    }

    static void syncLabelAndKS(MenuItem menuItem, String label, KeyStroke ks) {
        Object peer = AWTAccessor.getMenuComponentAccessor().getPeer(menuItem);
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cmi = (CMenuItem)peer;
        if (ks == null) {
            cmi.setLabel(label);
        } else {
            cmi.setLabel(label, ks.getKeyChar(), ks.getKeyCode(), ks.getModifiers());
        }
    }

    @Override
    public synchronized void setLabel(String label) {
        ScreenMenuItem.syncLabelAndKS(this, label, this.fMenuItem.getAccelerator());
    }

    @Override
    public void setAccelerator(KeyStroke ks) {
        ScreenMenuItem.syncLabelAndKS(this, this.fMenuItem.getText(), ks);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.fMenuItem.doClick(0);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.setVisible(true);
    }

    @Override
    public void componentHidden(ComponentEvent e) {
        this.setVisible(false);
    }

    public void setVisible(boolean b) {
        MenuContainer parent = this.getParent();
        if (parent != null) {
            ((ScreenMenuPropertyHandler)((Object)parent)).setChildVisible(this.fMenuItem, b);
        }
    }

    @Override
    public void setToolTipText(String text) {
        Object peer = AWTAccessor.getMenuComponentAccessor().getPeer(this);
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cmi = (CMenuItem)peer;
        cmi.setToolTipText(text);
    }

    @Override
    public void setIcon(Icon i) {
        Object peer = AWTAccessor.getMenuComponentAccessor().getPeer(this);
        if (!(peer instanceof CMenuItem)) {
            return;
        }
        CMenuItem cmi = (CMenuItem)peer;
        Image img = null;
        if (i != null && i.getIconWidth() > 0 && i.getIconHeight() > 0) {
            img = AquaIcon.getImageForIcon(i);
        }
        cmi.setImage(img);
    }

    @Override
    public void setChildVisible(JMenuItem child, boolean b) {
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }
}

