/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import com.apple.laf.AquaFocusHandler;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class AquaTableHeaderBorder
extends AbstractBorder {
    protected static final int SORT_NONE = 0;
    protected static final int SORT_ASCENDING = 1;
    protected static final int SORT_DECENDING = -1;
    protected final Insets editorBorderInsets = new Insets(1, 3, 1, 3);
    protected final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIState.getInstance());
    protected boolean doPaint = true;
    private static final AquaUtils.RecyclableSingleton<Border> alternateBorder = new AquaUtils.RecyclableSingleton<Border>(){

        @Override
        protected Border getInstance() {
            return BorderFactory.createRaisedBevelBorder();
        }
    };
    private boolean selected = false;
    private int fHorizontalShift = 0;
    private int sortOrder = 0;

    protected static AquaTableHeaderBorder getListHeaderBorder() {
        return new AquaTableHeaderBorder();
    }

    protected AquaTableHeaderBorder() {
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentHorizontal.LEFT);
        ((JRSUIState)this.painter.state).set(JRSUIConstants.AlignmentVertical.TOP);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        if (!this.doPaint) {
            return;
        }
        JComponent jc = (JComponent)c;
        Color componentBackground = jc.getBackground();
        if (!(componentBackground instanceof UIResource)) {
            this.doPaint = false;
            jc.paint(g);
            AquaTableHeaderBorder.getAlternateBorder().paintBorder(jc, g, x, y, width, height);
            this.doPaint = true;
            return;
        }
        JRSUIConstants.State state = this.getState(jc);
        ((JRSUIState)this.painter.state).set(state);
        ((JRSUIState)this.painter.state).set(jc.hasFocus() ? JRSUIConstants.Focused.YES : JRSUIConstants.Focused.NO);
        ((JRSUIState)this.painter.state).set(height > 16 ? JRSUIConstants.Widget.BUTTON_BEVEL : JRSUIConstants.Widget.BUTTON_LIST_HEADER);
        ((JRSUIState)this.painter.state).set(this.selected ? JRSUIConstants.BooleanValue.YES : JRSUIConstants.BooleanValue.NO);
        switch (this.sortOrder) {
            case 1: {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Direction.UP);
                break;
            }
            case -1: {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Direction.DOWN);
                break;
            }
            default: {
                ((JRSUIState)this.painter.state).set(JRSUIConstants.Direction.NONE);
            }
        }
        int newX = x;
        int newY = y;
        int newWidth = width;
        int newHeight = height;
        this.painter.paint(g, c, newX - 1, newY - 1, newWidth + 1, newHeight);
        g.clipRect(newX, y, newWidth, height);
        g.translate(this.fHorizontalShift, -1);
        this.doPaint = false;
        jc.paint(g);
        this.doPaint = true;
    }

    protected JRSUIConstants.State getState(JComponent jc) {
        if (!jc.isEnabled()) {
            return JRSUIConstants.State.DISABLED;
        }
        JRootPane rootPane = jc.getRootPane();
        if (rootPane == null) {
            return JRSUIConstants.State.ACTIVE;
        }
        if (!AquaFocusHandler.isActive(rootPane)) {
            return JRSUIConstants.State.INACTIVE;
        }
        return JRSUIConstants.State.ACTIVE;
    }

    protected static Border getAlternateBorder() {
        return alternateBorder.get();
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.editorBorderInsets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.left = this.editorBorderInsets.left;
        insets.top = this.editorBorderInsets.top;
        insets.right = this.editorBorderInsets.right;
        insets.bottom = this.editorBorderInsets.bottom;
        return insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    protected void setSelected(boolean inSelected) {
        this.selected = inSelected;
    }

    protected void setHorizontalShift(int inShift) {
        this.fHorizontalShift = inShift;
    }

    protected void setSortOrder(int inSortOrder) {
        if (inSortOrder < -1 || inSortOrder > 1) {
            throw new IllegalArgumentException("Invalid sort order constant: " + inSortOrder);
        }
        this.sortOrder = inSortOrder;
    }
}

