/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xfile;

import com.sun.xfile.XFile;
import com.sun.xfile.XFileAccessor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class XFileInputStream
extends InputStream {
    private long fp;
    private XFileAccessor xfa;

    public XFileInputStream(XFile xfile) throws IOException {
        this.xfa = xfile.newAccessor();
        if (!this.xfa.open(xfile, true, true)) {
            throw new FileNotFoundException("no file");
        }
        if (!this.xfa.canRead()) {
            throw new IOException("no read permission");
        }
    }

    public XFileInputStream(String name) throws IOException {
        this(new XFile(name));
    }

    private synchronized int XFAread(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (len == 0) {
            return 0;
        }
        if (off < 0 || len < 0 || off >= b.length || off + len > b.length) {
            throw new IllegalArgumentException("Invalid argument");
        }
        int c = this.xfa.read(b, off, len, this.fp);
        if (c <= 0) {
            return -1;
        }
        this.fp += (long)c;
        return c;
    }

    @Override
    public int read() throws IOException {
        byte[] b = new byte[1];
        if (this.XFAread(b, 0, 1) != 1) {
            return -1;
        }
        return b[0] & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.XFAread(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.XFAread(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return (int)(this.xfa.length() - this.fp);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n < 0L) {
            throw new IllegalArgumentException("illegal skip: " + n);
        }
        this.fp += n;
        return n;
    }

    @Override
    public void close() throws IOException {
        this.xfa.close();
    }
}

