/*
 * Decompiled with CFR 0.152.
 */
package com.sun.rpc;

import com.sun.rpc.Connection;
import com.sun.rpc.Cred;
import com.sun.rpc.MsgAcceptedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;
import java.net.UnknownHostException;

public class CredUnix
extends Cred {
    private int uid;
    private int gid;
    private int[] gids;
    private String home;
    private int def_umask;
    public int status;
    static final int AUTH_UNIX = 1;
    static final int UID_NOBODY = 60001;
    static final int GID_NOBODY = 60001;
    private static final int PCNFSDPROG = 150001;
    private static final int PCNFSD_AUTH = 1;
    private static final int PCNFSD2_AUTH = 13;
    private static final int MAXREPLY = 512;
    static final int AUTH_RES_OK = 0;
    static final int AUTH_RES_FAKE = 1;
    static final int AUTH_RES_FAIL = 2;
    private Xdr cr = new Xdr(64);

    public CredUnix(int uid, int gid) {
        this.uid = uid;
        this.gid = gid;
    }

    public CredUnix() {
        this(60001, 60001);
    }

    @Override
    synchronized void putCred(Xdr x) {
        x.xdr_int(1);
        this.cr.xdr_offset(0);
        this.cr.xdr_int((int)(System.currentTimeMillis() / 1000L));
        this.cr.xdr_string("javaclient");
        this.cr.xdr_int(this.uid);
        this.cr.xdr_int(this.gid);
        if (this.gids == null) {
            this.cr.xdr_int(0);
        } else {
            this.cr.xdr_int(this.gids.length);
            for (int i = 0; i < this.gids.length; ++i) {
                this.cr.xdr_int(this.gids[i]);
            }
        }
        x.xdr_bytes(this.cr);
        x.xdr_int(0);
        x.xdr_int(0);
    }

    @Override
    void getCred(Xdr x) {
        x.xdr_int();
        x.xdr_int();
        x.xdr_int();
        x.xdr_string();
        this.uid = x.xdr_int();
        this.gid = x.xdr_int();
        int count = x.xdr_int();
        if (count > 0) {
            this.gids = new int[count];
            for (int i = 0; i < count; ++i) {
                this.gids[i] = x.xdr_int();
            }
        }
        x.xdr_int();
        x.xdr_int();
    }

    public boolean fetchCred(String server, String username, String passwd) {
        username = this.disguise(username);
        passwd = this.disguise(passwd);
        try {
            try {
                return this.callV2(server, username, passwd);
            }
            catch (MsgAcceptedException e) {
                if (e.error != 2) {
                    return false;
                }
                return this.callV1(server, username, passwd);
            }
        }
        catch (IOException e) {
            return false;
        }
    }

    public void setCred() {
        this.uid = 60001;
        this.gid = 60001;
        this.gids = null;
    }

    public void setCred(int uid, int gid, int[] gids) {
        this.uid = uid;
        this.gid = gid;
        this.gids = gids;
    }

    private String disguise(String s) {
        byte[] b = s.getBytes();
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(b[i] & 0x7F ^ 0x5B);
        }
        return new String(b);
    }

    public int getUid() {
        return this.uid;
    }

    public int getGid() {
        return this.gid;
    }

    public int[] getGids() {
        return this.gids;
    }

    public String getHome() {
        return this.home;
    }

    public int getUmask() {
        return this.def_umask;
    }

    private boolean callV1(String server, String username, String passwd) throws UnknownHostException, IOException {
        Rpc pc = new Rpc(server, 0, 150001, 1, "udp", 512);
        Xdr call = new Xdr(512);
        pc.rpc_header(call, 1);
        call.xdr_string(username);
        call.xdr_string(passwd);
        Xdr reply = pc.rpc_call(call, 10000, 2);
        this.status = reply.xdr_int();
        if (this.status == 2) {
            return false;
        }
        this.uid = reply.xdr_int();
        this.gid = reply.xdr_int();
        this.gids = null;
        this.home = null;
        this.def_umask = 0;
        return true;
    }

    private boolean callV2(String server, String username, String passwd) throws UnknownHostException, IOException {
        Rpc pc = new Rpc(server, 0, 150001, 2, "udp", 512);
        Xdr call = new Xdr(512);
        pc.rpc_header(call, 13);
        call.xdr_string("(anyhost)");
        call.xdr_string(username);
        call.xdr_string(passwd);
        call.xdr_string("Java client");
        Xdr reply = pc.rpc_call(call, 10000, 2);
        this.status = reply.xdr_int();
        if (this.status == 2) {
            return false;
        }
        this.uid = reply.xdr_int();
        this.gid = reply.xdr_int();
        this.gids = new int[reply.xdr_int()];
        for (int i = 0; i < this.gids.length; ++i) {
            this.gids[i] = reply.xdr_int();
        }
        this.home = reply.xdr_string();
        this.def_umask = reply.xdr_int();
        return true;
    }

    public String toString() {
        String s = "AUTH_UNIX:\n   uid=" + this.uid + ",gid=" + this.gid + "\n";
        if (this.gids != null) {
            s = s + "   gids=";
            for (int i = 0; i < this.gids.length; ++i) {
                s = s + this.gids[i] + " ";
            }
        }
        if (this.home != null) {
            s = s + "\n   home=" + this.home;
        }
        if (this.def_umask != 0) {
            s = s + "\n   umask=0" + Long.toOctalString(this.def_umask);
        }
        return s;
    }

    @Override
    public void init(Connection conn, int prog, int vers) {
    }

    @Override
    public boolean refresh(Connection conn, int prog, int vers) {
        return true;
    }

    @Override
    public void wrap(Xdr x, byte[] arg) {
    }

    @Override
    public int unwrap(Xdr x) {
        return 0;
    }

    @Override
    public void validate(byte[] verifier, int verifiee) {
    }

    @Override
    public void destroy(Rpc rpc) {
    }
}

