/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Buffer;
import com.sun.nfs.Fattr;
import com.sun.nfs.Fattr3;
import com.sun.nfs.Nfs;
import com.sun.nfs.NfsConnect;
import com.sun.nfs.NfsException;
import com.sun.nfs.NfsSecurity;
import com.sun.rpc.CredGss;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;

class Nfs3
extends Nfs {
    Fattr3 attr;
    int accessBits = -1;
    long accessTime;
    private static final int NFSPROC3_NULL = 0;
    private static final int NFSPROC3_GETATTR = 1;
    private static final int NFSPROC3_SETATTR = 2;
    private static final int NFSPROC3_LOOKUP = 3;
    private static final int NFSPROC3_ACCESS = 4;
    private static final int NFSPROC3_READLINK = 5;
    private static final int NFSPROC3_READ = 6;
    private static final int NFSPROC3_WRITE = 7;
    private static final int NFSPROC3_CREATE = 8;
    private static final int NFSPROC3_MKDIR = 9;
    private static final int NFSPROC3_SYMLINK = 10;
    private static final int NFSPROC3_MKNOD = 11;
    private static final int NFSPROC3_REMOVE = 12;
    private static final int NFSPROC3_RMDIR = 13;
    private static final int NFSPROC3_RENAME = 14;
    private static final int NFSPROC3_LINK = 15;
    private static final int NFSPROC3_READDIR = 16;
    private static final int NFSPROC3_READDIRPLUS = 17;
    private static final int NFSPROC3_FSSTAT = 18;
    private static final int NFSPROC3_FSINFO = 19;
    private static final int NFSPROC3_PATHCONF = 20;
    private static final int NFSPROC3_COMMIT = 21;
    private static final int NFS_OK = 0;
    private static final int NFS3ERR_NOTSUPP = 10004;
    private static final int RWSIZE = 32768;
    private static final int DIRCOUNT = 1024;
    private static final int MAXBSIZE = 8192;
    private static final int DONT_CHANGE = 0;
    private static final int SERVER_TIME = 1;
    private static final int CLIENT_TIME = 2;
    private static final int ACCESS3_READ = 1;
    private static final int ACCESS3_LOOKUP = 2;
    private static final int ACCESS3_MODIFY = 4;
    private static final int ACCESS3_EXTEND = 8;
    private static final int ACCESS3_DELETE = 16;
    private static final int ACCESS3_EXECUTE = 32;
    private static final int UNCHECKED = 0;
    private static final int GUARDED = 1;
    private static final int EXCLUSIVE = 2;
    private static final int UNSTABLE = 0;
    private static final int DATA_SYNC = 1;
    private static final int FILE_SYNC = 2;
    int nra;
    int nwb;
    int prevWriteIndex = -1;

    Nfs3(Rpc rpc, byte[] fh, String name, Fattr3 attr) {
        this.rpc = rpc;
        this.fh = fh;
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        this.name = name;
        this.attr = attr == null ? new Fattr3() : attr;
        this.rsize = 32768;
        this.NRA = 1;
        this.NWB = 4;
        this.NWC = 10;
    }

    @Override
    void getattr() throws IOException {
        Xdr reply;
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 1);
        call.xdr_bytes(this.fh);
        try {
            reply = this.rpc.rpc_call(call, 2000, 2);
        }
        catch (IOException e) {
            return;
        }
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        this.attr.getFattr(reply);
    }

    @Override
    void checkAttr() throws IOException {
        if (!this.attr.valid()) {
            this.getattr();
        }
    }

    @Override
    boolean cacheOK(long t) throws IOException {
        this.checkAttr();
        return t == this.attr.mtime;
    }

    @Override
    void invalidate() {
        this.attr.validtime = 0L;
    }

    @Override
    long mtime() throws IOException {
        this.checkAttr();
        return this.attr.mtime;
    }

    @Override
    long length() throws IOException {
        this.checkAttr();
        return this.maxLength > this.attr.size ? this.maxLength : this.attr.size;
    }

    @Override
    boolean exists() throws IOException {
        this.checkAttr();
        return true;
    }

    private boolean check_access(int mode) throws IOException {
        int rBits = 1;
        int wBits = 28;
        if (this.accessBits < 0 || !this.cacheOK(this.accessTime)) {
            Xdr call = new Xdr(this.rsize + 512);
            this.rpc.rpc_header(call, 4);
            call.xdr_bytes(this.fh);
            call.xdr_int(rBits | wBits);
            Xdr reply = this.rpc.rpc_call(call, 5000, 0);
            int status = reply.xdr_int();
            if (reply.xdr_bool()) {
                this.attr.getFattr(reply);
            }
            if (status != 0) {
                throw new NfsException(status);
            }
            this.accessBits = reply.xdr_int();
            this.accessTime = this.attr.mtime;
        }
        if ((mode & 4) != 0) {
            return (this.accessBits & rBits) != 0;
        }
        if ((mode & 2) != 0) {
            return (this.accessBits & wBits) != 0;
        }
        return true;
    }

    @Override
    boolean canWrite() throws IOException {
        return this.check_access(2);
    }

    @Override
    boolean canRead() throws IOException {
        return this.check_access(4);
    }

    @Override
    boolean isFile() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 1;
    }

    @Override
    boolean isDirectory() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 2;
    }

    @Override
    boolean isSymlink() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 5;
    }

    @Override
    Fattr getAttr() throws IOException {
        this.checkAttr();
        return this.attr;
    }

    @Override
    Nfs lookup(String name) throws IOException {
        int status;
        String pathname;
        Fattr3 newattrs = null;
        if (name == null) {
            pathname = this.name;
            name = this.name;
        } else {
            pathname = this.name == null ? name : this.name + "/" + name;
        }
        Nfs nfs = Nfs3.cache_get(this.rpc.conn.server, pathname);
        if (nfs != null && nfs.cacheOK(this.cacheTime)) {
            if (((Nfs3)nfs).attr.ftype == 5) {
                nfs = NfsConnect.followLink(nfs);
            }
            return nfs;
        }
        Xdr call = new Xdr(this.rsize + 512);
        Xdr reply = null;
        for (int sec_tries = 1; sec_tries >= 0; --sec_tries) {
            this.rpc.rpc_header(call, 3);
            call.xdr_bytes(this.fh);
            call.xdr_string(name);
            try {
                reply = this.rpc.rpc_call(call, 5000, 0);
                break;
            }
            catch (MsgRejectedException e) {
                if (this.fh.length == 0 && e.why == 5) {
                    String secKey = this.lookupSec();
                    if (secKey != null && NfsSecurity.getMech(secKey) != null) {
                        this.rpc.setCred(new CredGss("nfs", NfsSecurity.getMech(secKey), NfsSecurity.getService(secKey), NfsSecurity.getQop(secKey)));
                        continue;
                    }
                    if (secKey != null && secKey.equals("1")) {
                        this.rpc.setCred(new CredUnix());
                        continue;
                    }
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        if ((status = reply.xdr_int()) != 0) {
            if (reply.xdr_bool()) {
                this.attr.getFattr(reply);
            }
            throw new NfsException(status);
        }
        byte[] newFh = reply.xdr_bytes();
        if (reply.xdr_bool()) {
            newattrs = new Fattr3(reply);
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        nfs = new Nfs3(this.rpc, newFh, pathname, newattrs);
        Nfs3.cache_put(nfs);
        if (((Nfs3)nfs).attr.ftype == 5) {
            nfs = NfsConnect.followLink(nfs);
        }
        return nfs;
    }

    @Override
    public String lookupSec() throws IOException {
        int sec_index = 1;
        boolean more = false;
        String first_secmode = null;
        Xdr call = new Xdr(this.rsize + 512);
        do {
            this.rpc.rpc_header(call, 3);
            call.xdr_bytes(new byte[0]);
            int len = this.name.getBytes().length + 2;
            byte[] b = new byte[len];
            b[0] = -127;
            b[1] = (byte)sec_index;
            System.arraycopy(this.name.getBytes(), 0, b, 2, this.name.getBytes().length);
            call.xdr_bytes(b);
            Xdr reply = this.rpc.rpc_call(call, 5000, 3);
            int status = reply.xdr_int();
            if (status != 0) {
                return null;
            }
            int numsec = reply.xdr_int() / 4 - 1;
            byte[] s = reply.xdr_raw(1);
            if (s[0] == 0) {
                more = false;
            } else {
                more = true;
                sec_index += numsec;
            }
            String prefer = NfsSecurity.getPrefer();
            while (numsec-- > 0) {
                String secmode = Integer.toString(reply.xdr_int());
                if (prefer != null && prefer.equals(secmode)) {
                    return prefer;
                }
                if (first_secmode != null || !NfsSecurity.hasValue(secmode)) continue;
                first_secmode = secmode;
            }
        } while (more);
        return first_secmode;
    }

    @Override
    void read_otw(Buffer buf) throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 6);
        call.xdr_bytes(this.fh);
        call.xdr_hyper(buf.foffset);
        call.xdr_int(this.rsize);
        Xdr reply = this.rpc.rpc_call(call, 1000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        int bytesread = reply.xdr_int();
        buf.eof = reply.xdr_bool();
        if ((long)bytesread != reply.xdr_u_int()) {
            throw new NfsException(10005);
        }
        buf.buf = reply.xdr_buf();
        buf.bufoff = reply.xdr_offset();
        buf.buflen = bytesread;
        this.cacheTime = this.attr.mtime;
    }

    @Override
    int write_otw(Buffer buf) throws IOException {
        Xdr call = new Xdr(this.wsize + 512);
        this.rpc.rpc_header(call, 7);
        call.xdr_bytes(this.fh);
        call.xdr_hyper(buf.foffset + (long)buf.minOffset);
        call.xdr_u_int(buf.maxOffset - buf.minOffset);
        call.xdr_int(buf.syncType);
        call.xdr_bytes(buf.buf, buf.bufoff + buf.minOffset, buf.maxOffset - buf.minOffset);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            reply.xdr_hyper();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
            this.cacheTime = this.attr.mtime;
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        int bytesWritten = reply.xdr_int();
        buf.status = reply.xdr_int() == 2 ? 1 : 3;
        buf.writeVerifier = reply.xdr_hyper();
        return bytesWritten;
    }

    @Override
    String[] readdir() throws IOException {
        long cookie = 0L;
        long cookieverf = 0L;
        boolean eof = false;
        String[] s = new String[32];
        int i = 0;
        if (this.dircache != null) {
            if (this.cacheOK(this.cacheTime)) {
                return this.dircache;
            }
            this.dircache = null;
            return this.readdir_old();
        }
        Xdr call = new Xdr(this.rsize + 512);
        while (!eof) {
            this.rpc.rpc_header(call, 17);
            call.xdr_bytes(this.fh);
            call.xdr_hyper(cookie);
            call.xdr_hyper(cookieverf);
            call.xdr_u_int(1024L);
            call.xdr_u_int(8192L);
            Xdr reply = this.rpc.rpc_call(call, 3000, 0);
            int status = reply.xdr_int();
            if (reply.xdr_bool()) {
                this.attr.getFattr(reply);
            }
            if (status == 10004) {
                return this.readdir_old();
            }
            if (status != 0) {
                throw new NfsException(status);
            }
            cookieverf = reply.xdr_hyper();
            while (reply.xdr_bool()) {
                reply.xdr_hyper();
                String ename = reply.xdr_string();
                cookie = reply.xdr_hyper();
                Fattr3 eattr = null;
                byte[] efh = null;
                if (reply.xdr_bool()) {
                    eattr = new Fattr3(reply);
                }
                if (reply.xdr_bool()) {
                    efh = reply.xdr_bytes();
                }
                if (ename.equals(".") || ename.equals("..")) continue;
                s[i++] = ename;
                if (i >= s.length) {
                    String[] tmp = s;
                    s = new String[i * 2];
                    System.arraycopy(tmp, 0, s, 0, i);
                }
                if (efh == null || eattr == null) continue;
                String pathname = this.name == null ? ename : this.name + "/" + ename;
                Nfs3.cache_put(new Nfs3(this.rpc, efh, pathname, eattr));
            }
            eof = reply.xdr_bool();
        }
        if (i < s.length) {
            String[] tmp = s;
            s = new String[i];
            System.arraycopy(tmp, 0, s, 0, i);
        }
        this.dircache = s;
        this.cacheTime = this.attr.mtime;
        return s;
    }

    String[] readdir_old() throws IOException {
        long cookie = 0L;
        long cookieverf = 0L;
        boolean eof = false;
        String[] s = new String[32];
        int i = 0;
        if (this.dircache != null && this.cacheOK(this.cacheTime)) {
            return this.dircache;
        }
        Xdr call = new Xdr(this.rsize + 512);
        while (!eof) {
            this.rpc.rpc_header(call, 16);
            call.xdr_bytes(this.fh);
            call.xdr_hyper(cookie);
            call.xdr_hyper(cookieverf);
            call.xdr_u_int(8192L);
            Xdr reply = this.rpc.rpc_call(call, 3000, 0);
            int status = reply.xdr_int();
            if (reply.xdr_bool()) {
                this.attr.getFattr(reply);
            }
            if (status != 0) {
                throw new NfsException(status);
            }
            cookieverf = reply.xdr_hyper();
            while (reply.xdr_bool()) {
                reply.xdr_hyper();
                String ename = reply.xdr_string();
                if (!ename.equals(".") && !ename.equals("..")) {
                    s[i++] = ename;
                }
                if (i >= s.length) {
                    String[] tmp = s;
                    s = new String[i * 2];
                    System.arraycopy(tmp, 0, s, 0, i);
                }
                cookie = reply.xdr_hyper();
            }
            eof = reply.xdr_bool();
        }
        if (i == 0) {
            return null;
        }
        if (i < s.length) {
            String[] tmp = s;
            s = new String[i];
            System.arraycopy(tmp, 0, s, 0, i);
        }
        this.dircache = s;
        this.cacheTime = this.attr.mtime;
        return s;
    }

    @Override
    String readlink() throws IOException {
        if (this.symlink != null && this.cacheOK(this.cacheTime)) {
            return this.symlink;
        }
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 5);
        call.xdr_bytes(this.fh);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        this.symlink = reply.xdr_string();
        this.cacheTime = this.attr.mtime;
        return this.symlink;
    }

    @Override
    Nfs create(String name, long mode) throws IOException {
        Nfs3 nfs;
        byte[] newFh = null;
        Fattr3 newattrs = null;
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 8);
        call.xdr_bytes(this.fh);
        call.xdr_string(name);
        call.xdr_int(0);
        call.xdr_bool(true);
        call.xdr_u_int(mode);
        call.xdr_bool(true);
        call.xdr_u_int(NfsConnect.getCred().getUid());
        call.xdr_bool(true);
        call.xdr_u_int(NfsConnect.getCred().getGid());
        call.xdr_bool(true);
        call.xdr_hyper(0L);
        call.xdr_int(1);
        call.xdr_int(1);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            if (reply.xdr_bool()) {
                reply.xdr_hyper();
                reply.xdr_u_int();
                reply.xdr_u_int();
                reply.xdr_u_int();
                reply.xdr_u_int();
            }
            if (reply.xdr_bool()) {
                this.attr.getFattr(reply);
            }
            throw new NfsException(status);
        }
        if (reply.xdr_bool()) {
            newFh = reply.xdr_bytes();
        }
        if (reply.xdr_bool()) {
            newattrs = new Fattr3(reply);
        }
        if (reply.xdr_bool()) {
            reply.xdr_hyper();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (newFh != null && newattrs != null) {
            String pathname = this.name + "/" + name;
            nfs = new Nfs3(this.rpc, newFh, pathname, newattrs);
            Nfs3.cache_put(nfs);
        } else {
            nfs = null;
        }
        return nfs;
    }

    @Override
    Nfs mkdir(String name, long mode) throws IOException {
        byte[] newFh = null;
        Fattr3 newattrs = null;
        Nfs3 nfs = null;
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 9);
        call.xdr_bytes(this.fh);
        call.xdr_string(name);
        call.xdr_bool(true);
        call.xdr_u_int(mode);
        call.xdr_bool(true);
        call.xdr_u_int(NfsConnect.getCred().getUid());
        call.xdr_bool(true);
        call.xdr_u_int(NfsConnect.getCred().getGid());
        call.xdr_bool(true);
        call.xdr_hyper(0L);
        call.xdr_int(1);
        call.xdr_int(1);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            if (reply.xdr_bool()) {
                reply.xdr_hyper();
                reply.xdr_u_int();
                reply.xdr_u_int();
                reply.xdr_u_int();
                reply.xdr_u_int();
            }
            if (reply.xdr_bool()) {
                this.attr.getFattr(reply);
            }
            throw new NfsException(status);
        }
        if (reply.xdr_bool()) {
            newFh = reply.xdr_bytes();
        }
        if (reply.xdr_bool()) {
            newattrs = new Fattr3(reply);
        }
        if (reply.xdr_bool()) {
            reply.xdr_hyper();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (newFh != null && newattrs != null) {
            String pathname = this.name + "/" + name;
            nfs = new Nfs3(this.rpc, newFh, pathname, newattrs);
            Nfs3.cache_put(nfs);
        }
        this.dircache = null;
        return nfs;
    }

    @Override
    void fsinfo() throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 19);
        call.xdr_bytes(this.fh);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        reply.xdr_u_int();
        reply.xdr_u_int();
        reply.xdr_u_int();
        reply.xdr_u_int();
        this.wsize = reply.xdr_int();
    }

    @Override
    long commit(int foffset, int length) throws IOException {
        Xdr call = new Xdr(this.wsize + 512);
        this.rpc.rpc_header(call, 21);
        call.xdr_bytes(this.fh);
        call.xdr_hyper(foffset);
        call.xdr_u_int(length);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            reply.xdr_hyper();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        return reply.xdr_hyper();
    }

    @Override
    boolean remove(String name) throws IOException {
        return this.remove_otw(12, name);
    }

    @Override
    boolean rmdir(String name) throws IOException {
        return this.remove_otw(13, name);
    }

    private boolean remove_otw(int NfsOperation, String name) throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, NfsOperation);
        call.xdr_bytes(this.fh);
        call.xdr_string(name);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            reply.xdr_hyper();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        Nfs3.cache_remove(this, name);
        this.dircache = null;
        return true;
    }

    @Override
    boolean rename(Nfs dstP, String sName, String dName) throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 14);
        call.xdr_bytes(this.fh);
        call.xdr_string(sName);
        call.xdr_bytes(dstP.getFH());
        call.xdr_string(dName);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (reply.xdr_bool()) {
            reply.xdr_hyper();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
            reply.xdr_u_int();
        }
        if (reply.xdr_bool()) {
            this.attr.getFattr(reply);
        }
        if (status != 0) {
            throw new NfsException(status);
        }
        Nfs3.cache_remove(this, sName);
        this.dircache = null;
        dstP.dircache = null;
        return true;
    }
}

