/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Buffer;
import com.sun.nfs.Fattr;
import com.sun.nfs.Fattr2;
import com.sun.nfs.Nfs;
import com.sun.nfs.NfsConnect;
import com.sun.nfs.NfsException;
import com.sun.nfs.NfsSecurity;
import com.sun.rpc.CredGss;
import com.sun.rpc.CredUnix;
import com.sun.rpc.MsgRejectedException;
import com.sun.rpc.Rpc;
import com.sun.rpc.Xdr;
import java.io.IOException;

public class Nfs2
extends Nfs {
    Fattr2 attr;
    private static final int NFSPROC2_NULL = 0;
    private static final int NFSPROC2_GETATTR = 1;
    private static final int NFSPROC2_SETATTR = 2;
    private static final int NFSPROC2_LOOKUP = 4;
    private static final int NFSPROC2_READLINK = 5;
    private static final int NFSPROC2_READ = 6;
    private static final int NFSPROC2_WRITE = 8;
    private static final int NFSPROC2_CREATE = 9;
    private static final int NFSPROC2_REMOVE = 10;
    private static final int NFSPROC2_RENAME = 11;
    private static final int NFSPROC2_LINK = 12;
    private static final int NFSPROC2_SYMLINK = 13;
    private static final int NFSPROC2_MKDIR = 14;
    private static final int NFSPROC2_RMDIR = 15;
    private static final int NFSPROC2_READDIR = 16;
    private static final int NFSPROC2_STATFS = 17;
    private static final int NFS_OK = 0;
    private static final int RWSIZE = 8192;
    private static final int FHSIZE = 32;
    int nwb;

    public Nfs2(Rpc rpc, byte[] fh, String name, Fattr2 attr) {
        this.rpc = rpc;
        this.fh = fh;
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        this.name = name;
        this.attr = attr == null ? new Fattr2() : attr;
        this.rsize = 8192;
        this.NRA = 2;
        this.NWB = 8;
    }

    @Override
    void getattr() throws IOException {
        Xdr reply;
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 1);
        call.xdr_raw(this.fh);
        try {
            reply = this.rpc.rpc_call(call, 2000, 2);
        }
        catch (IOException e) {
            return;
        }
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        this.attr.getFattr(reply);
    }

    @Override
    void checkAttr() throws IOException {
        if (!this.attr.valid()) {
            this.getattr();
        }
    }

    @Override
    boolean cacheOK(long t) throws IOException {
        this.checkAttr();
        return t == this.attr.mtime;
    }

    @Override
    void invalidate() {
        this.attr.validtime = 0L;
    }

    @Override
    long mtime() throws IOException {
        this.checkAttr();
        return this.attr.mtime;
    }

    @Override
    long length() throws IOException {
        this.checkAttr();
        return this.maxLength > this.attr.size ? this.maxLength : this.attr.size;
    }

    @Override
    boolean exists() throws IOException {
        this.checkAttr();
        return true;
    }

    private boolean check_access(long mode) {
        boolean found = false;
        long uid = NfsConnect.getCred().getUid();
        long gid = NfsConnect.getCred().getGid();
        int[] gids = NfsConnect.getCred().getGids();
        mode <<= 6;
        if (uid != this.attr.uid) {
            mode >>= 3;
            if (gid != this.attr.gid) {
                int gidsLength = 0;
                if (gids != null) {
                    gidsLength = gids.length;
                }
                for (int i = 0; i < gidsLength && !(found = (long)gids[i] == this.attr.gid); ++i) {
                }
                if (!found) {
                    mode >>= 3;
                }
            }
        }
        return (this.attr.mode & mode) == mode;
    }

    @Override
    boolean canWrite() throws IOException {
        this.checkAttr();
        return this.check_access(2L);
    }

    @Override
    boolean canRead() throws IOException {
        this.checkAttr();
        return this.check_access(4L);
    }

    @Override
    boolean isFile() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 1;
    }

    @Override
    boolean isDirectory() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 2;
    }

    @Override
    boolean isSymlink() throws IOException {
        this.checkAttr();
        return this.attr.ftype == 5;
    }

    @Override
    Fattr getAttr() throws IOException {
        this.checkAttr();
        return this.attr;
    }

    @Override
    Nfs lookup(String name) throws IOException {
        int status;
        String pathname;
        if (name == null) {
            pathname = this.name;
            name = this.name;
        } else {
            pathname = this.name == null ? name : this.name + "/" + name;
        }
        Nfs nfs = Nfs2.cache_get(this.rpc.conn.server, pathname);
        if (nfs != null && nfs.cacheOK(this.cacheTime)) {
            if (((Nfs2)nfs).attr.ftype == 5) {
                nfs = NfsConnect.followLink(nfs);
            }
            return nfs;
        }
        Xdr call = new Xdr(this.rsize + 512);
        Xdr reply = null;
        for (int sec_tries = 1; sec_tries >= 0; --sec_tries) {
            this.rpc.rpc_header(call, 4);
            call.xdr_raw(this.fh);
            call.xdr_string(name);
            try {
                reply = this.rpc.rpc_call(call, 5000, 0);
                break;
            }
            catch (MsgRejectedException e) {
                boolean is_v2pubfh = true;
                for (int i = 0; i < 32; ++i) {
                    if (this.fh[i] == 0) continue;
                    is_v2pubfh = false;
                    break;
                }
                if (is_v2pubfh && e.why == 5) {
                    String secKey = this.lookupSec();
                    if (secKey != null && NfsSecurity.getMech(secKey) != null) {
                        this.rpc.setCred(new CredGss("nfs", NfsSecurity.getMech(secKey), NfsSecurity.getService(secKey), NfsSecurity.getQop(secKey)));
                        continue;
                    }
                    if (secKey != null && secKey.equals("1")) {
                        this.rpc.setCred(new CredUnix());
                        continue;
                    }
                }
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
        }
        if ((status = reply.xdr_int()) != 0) {
            throw new NfsException(status);
        }
        byte[] newfh = reply.xdr_raw(32);
        Fattr2 newattrs = new Fattr2(reply);
        nfs = new Nfs2(this.rpc, newfh, pathname, newattrs);
        Nfs2.cache_put(nfs);
        if (((Nfs2)nfs).attr.ftype == 5) {
            nfs = NfsConnect.followLink(nfs);
        }
        return nfs;
    }

    @Override
    public String lookupSec() throws IOException {
        int sec_index = 1;
        boolean more = false;
        String first_secmode = null;
        Xdr call = new Xdr(this.rsize + 512);
        do {
            this.rpc.rpc_header(call, 4);
            call.xdr_raw(new byte[32]);
            int len = this.name.getBytes().length + 2;
            byte[] b = new byte[len];
            b[0] = -127;
            b[1] = (byte)sec_index;
            System.arraycopy(this.name.getBytes(), 0, b, 2, this.name.getBytes().length);
            call.xdr_bytes(b);
            Xdr reply = this.rpc.rpc_call(call, 5000, 3);
            int status = reply.xdr_int();
            if (status != 0) {
                return NfsSecurity.getDefault();
            }
            byte[] s = reply.xdr_raw(4);
            int numsec = s[0] / 4;
            if (s[1] == 0) {
                more = false;
            } else {
                more = true;
                sec_index += numsec;
            }
            String prefer = NfsSecurity.getPrefer();
            while (numsec-- > 0) {
                String secmode = Integer.toString(reply.xdr_int());
                if (prefer != null && prefer.equals(secmode)) {
                    return prefer;
                }
                if (first_secmode != null || !NfsSecurity.hasValue(secmode)) continue;
                first_secmode = secmode;
            }
        } while (more);
        return first_secmode;
    }

    @Override
    void read_otw(Buffer buf) throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 6);
        call.xdr_raw(this.fh);
        call.xdr_u_int(buf.foffset);
        call.xdr_u_int(this.rsize);
        call.xdr_u_int(this.rsize);
        Xdr reply = this.rpc.rpc_call(call, 1000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        this.attr.getFattr(reply);
        int bytesread = reply.xdr_int();
        buf.eof = buf.foffset + (long)this.rsize >= this.attr.size;
        buf.buf = reply.xdr_buf();
        buf.bufoff = reply.xdr_offset();
        buf.buflen = bytesread;
        this.cacheTime = this.attr.mtime;
    }

    @Override
    int write_otw(Buffer buf) throws IOException {
        Xdr call = new Xdr(this.wsize + 512);
        int fileOffset = (int)buf.foffset + buf.minOffset;
        int writeLength = buf.maxOffset - buf.minOffset;
        this.rpc.rpc_header(call, 8);
        call.xdr_raw(this.fh);
        call.xdr_u_int(fileOffset);
        call.xdr_u_int(fileOffset);
        call.xdr_u_int(writeLength);
        call.xdr_bytes(buf.buf, buf.bufoff + buf.minOffset, writeLength);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        this.attr.getFattr(reply);
        buf.status = 1;
        buf.writeVerifier = 0L;
        this.cacheTime = this.attr.mtime;
        return writeLength;
    }

    @Override
    String[] readdir() throws IOException {
        long cookie = 0L;
        boolean eof = false;
        String[] s = new String[32];
        int i = 0;
        if (this.dircache != null && this.cacheOK(this.cacheTime)) {
            return this.dircache;
        }
        Xdr call = new Xdr(this.rsize + 512);
        while (!eof) {
            this.rpc.rpc_header(call, 16);
            call.xdr_raw(this.fh);
            call.xdr_u_int(cookie);
            call.xdr_u_int(4096L);
            Xdr reply = this.rpc.rpc_call(call, 2000, 0);
            int status = reply.xdr_int();
            if (status != 0) {
                throw new NfsException(status);
            }
            while (reply.xdr_bool()) {
                reply.xdr_u_int();
                String ename = reply.xdr_string();
                cookie = reply.xdr_u_int();
                if (ename.equals(".") || ename.equals("..")) continue;
                s[i++] = ename;
                if (i < s.length) continue;
                String[] tmp = s;
                s = new String[i * 2];
                System.arraycopy(tmp, 0, s, 0, i);
            }
            eof = reply.xdr_bool();
        }
        if (i < s.length) {
            String[] tmp = s;
            s = new String[i];
            System.arraycopy(tmp, 0, s, 0, i);
        }
        this.dircache = s;
        this.cacheTime = this.attr.mtime;
        return s;
    }

    @Override
    String readlink() throws IOException {
        if (this.symlink != null && this.cacheOK(this.cacheTime)) {
            return this.symlink;
        }
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 5);
        call.xdr_raw(this.fh);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        this.symlink = reply.xdr_string();
        this.cacheTime = this.attr.mtime;
        return this.symlink;
    }

    @Override
    Nfs create(String name, long mode) throws IOException {
        return this.create_otw(9, name, mode);
    }

    @Override
    Nfs mkdir(String name, long mode) throws IOException {
        return this.create_otw(14, name, mode);
    }

    private Nfs create_otw(int nfsOp, String name, long mode) throws IOException {
        long currTime = System.currentTimeMillis();
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, nfsOp);
        call.xdr_raw(this.fh);
        call.xdr_string(name);
        call.xdr_u_int(mode);
        call.xdr_u_int(NfsConnect.getCred().getUid());
        call.xdr_u_int(NfsConnect.getCred().getGid());
        call.xdr_u_int(0L);
        call.xdr_u_int(currTime / 1000L);
        call.xdr_u_int(currTime % 1000L);
        call.xdr_u_int(currTime / 1000L);
        call.xdr_u_int(currTime % 1000L);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        byte[] newfh = reply.xdr_raw(32);
        Fattr2 newattrs = new Fattr2(reply);
        String pathname = this.name + "/" + name;
        Nfs2 nfs = new Nfs2(this.rpc, newfh, pathname, newattrs);
        Nfs2.cache_put(nfs);
        this.dircache = null;
        return nfs;
    }

    @Override
    void fsinfo() throws IOException {
        this.wsize = 8192;
    }

    @Override
    long commit(int foffset, int length) throws IOException {
        return 0L;
    }

    @Override
    boolean remove(String name) throws IOException {
        return this.remove_otw(10, name);
    }

    @Override
    boolean rmdir(String name) throws IOException {
        return this.remove_otw(15, name);
    }

    private boolean remove_otw(int nfsOp, String name) throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, nfsOp);
        call.xdr_raw(this.fh);
        call.xdr_string(name);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        Nfs2.cache_remove(this, name);
        this.dircache = null;
        return true;
    }

    @Override
    boolean rename(Nfs dstP, String sName, String dName) throws IOException {
        Xdr call = new Xdr(this.rsize + 512);
        this.rpc.rpc_header(call, 11);
        call.xdr_raw(this.fh);
        call.xdr_string(sName);
        call.xdr_raw(dstP.getFH());
        call.xdr_string(dName);
        Xdr reply = this.rpc.rpc_call(call, 2000, 0);
        int status = reply.xdr_int();
        if (status != 0) {
            throw new NfsException(status);
        }
        Nfs2.cache_remove(this, sName);
        this.dircache = null;
        dstP.dircache = null;
        return true;
    }
}

