/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSNameSpi;
import com.sun.gssapi.Oid;
import java.util.Enumeration;
import java.util.Vector;

public class GSSName {
    public static final Oid NT_HOSTBASED_SERVICE;
    public static final Oid NT_USER_NAME;
    public static final Oid NT_MACHINE_UID_NAME;
    public static final Oid NT_STRING_UID_NAME;
    public static final Oid NT_ANONYMOUS;
    public static final Oid NT_EXPORT_NAME;
    Vector m_mechNames = new Vector(3, 2);
    Oid m_nameType;
    String m_nameStr;
    byte[] m_nameBytes;

    public GSSName(String nameStr, Oid type) {
        this.m_nameStr = nameStr;
        this.m_nameType = type;
    }

    public GSSName(byte[] name, Oid type) throws GSSException {
        this.m_nameType = type;
        this.m_nameBytes = new byte[name.length];
        System.arraycopy(name, 0, this.m_nameBytes, 0, name.length);
        if (type.equals(NT_EXPORT_NAME)) {
            if (name[0] != 4 && name[1] != 1) {
                throw new GSSException(3);
            }
            Oid mechOid = new Oid(name, 2);
            GSSNameSpi mn = GSSManager.getNameInstance(mechOid);
            mn.init(name, type);
            this.addMechName(mn);
        }
    }

    public GSSName(String nameStr, Oid nameType, Oid mechType) throws GSSException {
        this.m_nameStr = nameStr;
        this.m_nameType = nameType;
        GSSNameSpi mn = GSSManager.getNameInstance(mechType);
        mn.init(nameStr, nameType);
        this.addMechName(mn);
    }

    public GSSName(byte[] name, Oid nameType, Oid mechType) throws GSSException {
        this.m_nameType = nameType;
        this.m_nameBytes = new byte[name.length];
        System.arraycopy(name, 0, this.m_nameBytes, 0, name.length);
        GSSNameSpi mn = GSSManager.getNameInstance(mechType);
        mn.init(name, nameType);
        this.addMechName(mn);
    }

    GSSName() {
    }

    GSSName(GSSNameSpi mechName) {
        this.addMechName(mechName);
        this.m_nameType = mechName.getNameType();
    }

    public boolean equals(Object another) {
        if (!(another instanceof GSSName)) {
            return false;
        }
        try {
            return this.equals((GSSName)another);
        }
        catch (GSSException e) {
            return false;
        }
    }

    public boolean equals(GSSName another) throws GSSException {
        if (this.isAnonymousName() || another.isAnonymousName()) {
            return false;
        }
        if (this.m_mechNames.size() != another.m_mechNames.size()) {
            return false;
        }
        if (this.m_mechNames.size() < 1) {
            if (!this.m_nameType.equals(another.m_nameType)) {
                return false;
            }
            if (this.m_nameStr != null && another.m_nameStr != null) {
                return this.m_nameStr.equals(another.m_nameStr);
            }
            if (this.m_nameBytes != null && another.m_nameBytes != null) {
                return this.m_nameBytes.equals(another.m_nameBytes);
            }
            return false;
        }
        Enumeration e = this.m_mechNames.elements();
        while (e.hasMoreElements()) {
            GSSNameSpi mechName1 = (GSSNameSpi)e.nextElement();
            GSSNameSpi mechName2 = another.getMechName(mechName1.getMech());
            if (mechName2 == null) {
                return false;
            }
            if (mechName1.equals(mechName2)) continue;
            return false;
        }
        return true;
    }

    public GSSName canonicalize(Oid mechOid) throws GSSException {
        GSSNameSpi mechName = this.getMechName(mechOid);
        if (mechName != null) {
            if (this.isMechName()) {
                return this;
            }
            return new GSSName((GSSNameSpi)mechName.clone());
        }
        if (this.m_nameStr != null) {
            return new GSSName(this.m_nameStr, this.m_nameType, mechOid);
        }
        return new GSSName(this.m_nameBytes, this.m_nameType, mechOid);
    }

    public byte[] export() throws GSSException {
        if (!this.isMechName()) {
            throw new GSSException(18);
        }
        return this.getMechName(null).export();
    }

    public String toString() {
        if (this.isMechName()) {
            return this.getMechName(null).toString();
        }
        if (this.m_nameStr != null) {
            return this.m_nameStr;
        }
        if (this.m_mechNames.size() > 0) {
            return this.getMechName(null).toString();
        }
        return "Unknown name";
    }

    public Oid getStringNameType() throws GSSException {
        if (this.isMechName()) {
            return this.getMechName(null).getStringNameType();
        }
        if (this.m_nameStr != null) {
            return this.m_nameType;
        }
        if (this.m_mechNames.size() > 0) {
            return this.getMechName(null).getStringNameType();
        }
        throw new GSSException(3);
    }

    public Object clone() throws CloneNotSupportedException {
        GSSName newName;
        try {
            newName = this.m_nameStr != null ? new GSSName(this.m_nameStr, this.m_nameType) : (this.m_nameBytes != null ? new GSSName(this.m_nameBytes, this.m_nameType) : new GSSName());
            Enumeration e = this.m_mechNames.elements();
            while (e.hasMoreElements()) {
                newName.addMechName((GSSNameSpi)((GSSNameSpi)e.nextElement()).clone());
            }
        }
        catch (Exception e) {
            throw new CloneNotSupportedException();
        }
        return newName;
    }

    public boolean isAnonymousName() {
        if (this.m_nameType.equals(NT_ANONYMOUS)) {
            return true;
        }
        if (this.m_mechNames.size() > 0) {
            return this.getMechName(null).isAnonymousName();
        }
        return false;
    }

    void addMechName(GSSNameSpi mechName) {
        this.m_mechNames.addElement(mechName);
    }

    private boolean isMechName() {
        return this.m_mechNames.size() == 1;
    }

    GSSNameSpi getMechName(Oid mechOid) {
        if (mechOid == null) {
            if (this.m_mechNames.size() < 1) {
                return null;
            }
            return (GSSNameSpi)this.m_mechNames.firstElement();
        }
        Enumeration e = this.m_mechNames.elements();
        while (e.hasMoreElements()) {
            GSSNameSpi mechName = (GSSNameSpi)e.nextElement();
            if (!mechName.getMech().equals(mechOid)) continue;
            return mechName;
        }
        return null;
    }

    GSSNameSpi canonicalizeInPlace(Oid mechOid) throws GSSException {
        GSSNameSpi mechName = this.getMechName(mechOid);
        if (mechName != null) {
            return mechName;
        }
        mechName = GSSManager.getNameInstance(mechOid);
        if (this.m_nameStr != null) {
            mechName.init(this.m_nameStr, this.m_nameType);
        } else {
            mechName.init(this.m_nameBytes, this.m_nameType);
        }
        this.addMechName(mechName);
        return mechName;
    }

    static {
        try {
            NT_HOSTBASED_SERVICE = new Oid("1.3.6.1.5.6.2");
            NT_USER_NAME = new Oid("1.2.840.113554.1.2.1.1");
            NT_MACHINE_UID_NAME = new Oid("1.2.840.113554.1.2.1.2");
            NT_STRING_UID_NAME = new Oid("1.2.840.113554.1.2.1.3");
            NT_ANONYMOUS = new Oid("1.3.6.1.5.6.3");
            NT_EXPORT_NAME = new Oid("1.3.6.1.5.6.4");
        }
        catch (GSSException e) {
            throw new NumberFormatException();
        }
    }
}

