/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.GSSException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

class DERParser {
    DERParser() {
    }

    static int readLength(InputStream is) throws GSSException {
        int length;
        try {
            int tmp = is.read();
            if ((tmp & 0x80) == 0) {
                length = tmp;
            } else {
                tmp &= 0x7F;
                length = 0;
                while (tmp > 0) {
                    length <<= 8;
                    length += 0xFF & is.read();
                    --tmp;
                }
            }
        }
        catch (IOException e) {
            throw new GSSException(10);
        }
        return length;
    }

    static Vector decodeOid(InputStream is) throws GSSException {
        try {
            if (is.read() != 6) {
                throw new GSSException(10);
            }
        }
        catch (IOException e) {
            throw new GSSException(10);
        }
        return DERParser.decodeOidOctets(is, DERParser.readLength(is));
    }

    static Vector decodeOidOctets(InputStream is, int numOfOctets) throws GSSException {
        Vector<Integer> v = new Vector<Integer>(9, 3);
        try {
            int tmp = is.read();
            int comp = tmp < 40 ? 0 : (tmp < 80 ? 1 : 2);
            v.addElement(new Integer(comp));
            v.addElement(new Integer(tmp - 40 * comp));
            for (int i = 1; i < numOfOctets; ++i) {
                comp = 0;
                for (int j = 0; j < 4; ++j) {
                    comp <<= 7;
                    tmp = is.read();
                    comp |= tmp & 0x7F;
                    if ((tmp & 0x80) == 0) break;
                    ++i;
                }
                v.addElement(new Integer(comp));
            }
        }
        catch (IOException e) {
            throw new GSSException(10);
        }
        return v;
    }

    static void writeLength(OutputStream os, int len) throws IOException {
        if (len < 128) {
            os.write(len);
        } else if (len < 256) {
            os.write(129);
            os.write(len);
        } else if (len < 524288) {
            os.write(130);
            os.write(len >> 8);
            os.write(len & 0xFF);
        } else if (len < 0x1000000) {
            os.write(131);
            os.write(len >> 16);
            os.write(len >> 8 & 0xFF);
            os.write(len & 0xFF);
        } else {
            os.write(132);
            os.write(len >>> 24);
            os.write(len >> 16 & 0xFF);
            os.write(len >> 8 & 0xFF);
            os.write(len & 0xFF);
        }
    }

    static byte[] encodeOid(Vector v) throws GSSException {
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        int length = 1;
        try {
            o.write(6);
            if (v.size() < 2) {
                throw new IllegalArgumentException();
            }
            for (int i = 2; i < v.size(); ++i) {
                int compLen = 0;
                int nextComp = (Integer)v.elementAt(i);
                compLen = 0;
                while (nextComp > 0) {
                    nextComp >>= 7;
                    ++compLen;
                }
                if (compLen == 0) {
                    ++length;
                    continue;
                }
                length += compLen;
            }
            DERParser.writeLength(o, length);
            DERParser.writeOidOctets(o, v);
        }
        catch (IOException e) {
            throw new GSSException(10);
        }
        return o.toByteArray();
    }

    static void writeOidOctets(OutputStream o, Vector v) throws IOException {
        o.write((Integer)v.elementAt(0) * 40 + (Integer)v.elementAt(1));
        block0: for (int i = 2; i < v.size(); ++i) {
            int nextComp = (Integer)v.elementAt(i);
            for (int c = 0; c < 4; ++c) {
                int tmp = nextComp & 0x7F;
                if ((nextComp >>>= 7) <= 0) {
                    o.write(tmp);
                    continue block0;
                }
                o.write(tmp | 0x80);
            }
        }
    }
}

