/*
 * Decompiled with CFR 0.152.
 */
package org.exbin.auxiliary.paged_data;

import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.exbin.auxiliary.paged_data.ByteArrayData;
import org.exbin.auxiliary.paged_data.FinishableStream;
import org.exbin.auxiliary.paged_data.SeekableStream;

@ParametersAreNonnullByDefault
public class ByteArrayDataInputStream
extends InputStream
implements SeekableStream,
FinishableStream {
    @Nonnull
    private final ByteArrayData data;
    private long position = 0L;

    public ByteArrayDataInputStream(ByteArrayData data) {
        this.data = data;
    }

    @Override
    public int read() throws IOException {
        try {
            return this.data.getByte(this.position++);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    @Override
    public void close() throws IOException {
        this.finish();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.data.getDataSize() - this.position);
    }

    @Override
    public int read(byte[] output, int off, int len) throws IOException {
        if (output.length == 0 || len == 0) {
            return 0;
        }
        byte[] byteArray = this.data.getData();
        if (off + len > byteArray.length && (len = byteArray.length - off) <= 0) {
            return -1;
        }
        System.arraycopy(byteArray, (int)this.position, output, off, len);
        this.position += (long)len;
        return len;
    }

    @Override
    public void seek(long position) throws IOException {
        this.position = position;
    }

    @Override
    public long finish() throws IOException {
        this.position = this.data.getDataSize();
        return this.position;
    }

    @Override
    public long getProcessedSize() {
        return this.position;
    }

    @Override
    public long getStreamSize() {
        return this.data.getDataSize();
    }
}

