/*
 * Decompiled with CFR 0.152.
 */
package com.sun.nfs;

import com.sun.nfs.Buffer;
import com.sun.nfs.Fattr;
import com.sun.nfs.NfsException;
import com.sun.rpc.Rpc;
import java.io.IOException;
import java.util.Hashtable;

public abstract class Nfs {
    byte[] fh;
    Rpc rpc;
    String name;
    String[] dircache;
    String symlink;
    Buffer[] bufferList;
    long cacheTime;
    int rsize;
    int wsize;
    private Object wbLock = new Object();
    static Hashtable cacheNfs = new Hashtable();
    static final int NFREG = 1;
    static final int NFDIR = 2;
    static final int NFLNK = 5;
    private static final int ASYNC = 0;
    private static final int SYNC = 2;
    int NRA;
    int NWB;
    int NWC;
    int nwb;
    int prevReadIndex = -1;
    int prevWriteIndex = -1;
    int maxIndexRead = 0;
    long maxLength = 0L;
    static final int RBIT = 4;
    static final int WBIT = 2;

    abstract void checkAttr() throws IOException;

    abstract boolean cacheOK(long var1) throws IOException;

    abstract void getattr() throws IOException;

    abstract long mtime() throws IOException;

    abstract long length() throws IOException;

    abstract boolean exists() throws IOException;

    abstract boolean canWrite() throws IOException;

    abstract boolean canRead() throws IOException;

    abstract boolean isFile() throws IOException;

    abstract boolean isDirectory() throws IOException;

    abstract boolean isSymlink() throws IOException;

    abstract Fattr getAttr() throws IOException;

    abstract Nfs lookup(String var1) throws IOException;

    abstract String lookupSec() throws IOException;

    abstract void read_otw(Buffer var1) throws IOException;

    abstract int write_otw(Buffer var1) throws IOException;

    abstract String[] readdir() throws IOException;

    abstract String readlink() throws IOException;

    abstract Nfs create(String var1, long var2) throws IOException;

    abstract Nfs mkdir(String var1, long var2) throws IOException;

    abstract boolean remove(String var1) throws IOException;

    abstract boolean rename(Nfs var1, String var2, String var3) throws IOException;

    abstract boolean rmdir(String var1) throws IOException;

    abstract void fsinfo() throws IOException;

    abstract long commit(int var1, int var2) throws IOException;

    abstract void invalidate();

    byte[] getFH() {
        return this.fh;
    }

    static void cache_put(Nfs n) {
        cacheNfs.put(n.rpc.conn.server + ":" + n.name, n);
    }

    static Nfs cache_get(String server, String name) {
        return (Nfs)cacheNfs.get(server + ":" + name);
    }

    static void cache_remove(Nfs n, String name) {
        if (n.name.equals(".")) {
            cacheNfs.remove(n.rpc.conn.server + ":" + name);
        } else {
            cacheNfs.remove(n.rpc.conn.server + ":" + n.name + "/" + name);
        }
    }

    synchronized int read(byte[] buf, int boff, int length, long foffset) throws IOException {
        Buffer b = null;
        int readAhead = 0;
        int bytesRead = 0;
        if (!this.cacheOK(this.cacheTime) && this.bufferList != null) {
            for (int i = 0; i < this.bufferList.length; ++i) {
                if (i == this.prevWriteIndex) continue;
                this.bufferList[i] = null;
            }
            this.prevReadIndex = -1;
        }
        if (foffset >= this.length()) {
            return -1;
        }
        while (length > 0 && foffset < this.length()) {
            int index;
            if (this.bufferList == null) {
                this.bufferList = new Buffer[(int)this.length() / this.rsize + 1];
            }
            if ((index = (int)foffset / this.rsize) > this.maxIndexRead) {
                this.maxIndexRead = index;
            }
            if (index != this.prevReadIndex) {
                if (this.prevReadIndex >= 0 && this.prevReadIndex != this.prevWriteIndex) {
                    b = this.bufferList[this.prevReadIndex];
                    if (b.status == 1) {
                        this.bufferList[this.prevReadIndex] = null;
                        b.exit();
                    }
                    if (index == this.prevReadIndex + 1 && index >= this.maxIndexRead) {
                        readAhead = this.NRA;
                    }
                }
                this.prevReadIndex = index;
            }
            for (int n = index; n <= index + readAhead && n < this.bufferList.length; ++n) {
                b = this.bufferList[n];
                if (b != null) continue;
                b = new Buffer(this, n * this.rsize, this.rsize);
                b.startLoad();
                this.bufferList[n] = b;
            }
            b = this.bufferList[index];
            try {
                b.waitLoaded();
            }
            catch (NfsException n) {
                if (n.error == 72) {
                    this.rsize = 8192;
                    this.bufferList = new Buffer[(int)this.length() / this.rsize + 1];
                    continue;
                }
                throw n;
            }
            int bufflen = b.buflen;
            if (bufflen < this.rsize && !b.eof) {
                this.rsize = bufflen;
                this.bufferList = null;
                this.prevReadIndex = -1;
                this.prevWriteIndex = -1;
                continue;
            }
            int cc = b.copyFrom(buf, boff, foffset, length);
            boff += cc;
            foffset += (long)cc;
            length -= cc;
            bytesRead += cc;
        }
        return bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void beginWrite() {
        Object object = this.wbLock;
        synchronized (object) {
            while (this.nwb >= this.NWB) {
                try {
                    this.wbLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            ++this.nwb;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endWrite() {
        Object object = this.wbLock;
        synchronized (object) {
            --this.nwb;
            this.wbLock.notify();
        }
    }

    synchronized void write(byte[] buf, int boff, int length, long foffset) throws IOException {
        if (this.wsize == 0) {
            this.fsinfo();
        }
        if (this.bufferList == null) {
            long fileSize = Math.max(this.length(), (long)(50 * this.wsize));
            this.bufferList = new Buffer[(int)fileSize / this.wsize + 1];
        }
        while (length > 0) {
            Buffer b;
            int index = (int)foffset / this.wsize;
            if (index != this.prevWriteIndex) {
                if (this.prevWriteIndex >= 0) {
                    this.bufferList[this.prevWriteIndex].startUnload(0);
                    this.checkCommit(false);
                }
                this.prevWriteIndex = index;
            }
            if (index >= this.bufferList.length) {
                Buffer[] tlist = new Buffer[this.bufferList.length * 2];
                for (int i = 0; i < this.bufferList.length; ++i) {
                    tlist[i] = this.bufferList[i];
                }
                this.bufferList = tlist;
            }
            if ((b = this.bufferList[index]) == null) {
                this.bufferList[index] = b = new Buffer(this, index * this.wsize, this.wsize);
            }
            int cc = b.copyTo(buf, boff, foffset, length);
            boff += cc;
            length -= cc;
            if ((foffset += (long)cc) <= this.maxLength) continue;
            this.maxLength = foffset;
        }
    }

    void checkCommit(boolean flushing) throws IOException {
        Buffer b;
        int minIndex = Integer.MAX_VALUE;
        int maxIndex = 0;
        int nwc = 0;
        for (int i = 0; i < this.bufferList.length; ++i) {
            Buffer b2 = this.bufferList[i];
            if (b2 == null) continue;
            if (flushing) {
                b2.waitUnloaded();
            }
            if (b2.status == 1) {
                if (i == this.prevReadIndex || i == this.prevWriteIndex) continue;
                this.bufferList[i] = null;
                b2.exit();
                continue;
            }
            if (b2.status != 3) continue;
            ++nwc;
            if (i < minIndex) {
                minIndex = i;
            }
            if (i <= maxIndex) continue;
            maxIndex = i;
        }
        if (flushing && (b = this.bufferList[this.prevWriteIndex]) != null) {
            if (b.status == 2) {
                if (nwc == 0) {
                    b.startUnload(2);
                    b.waitUnloaded();
                } else {
                    b.startUnload(0);
                    b.waitUnloaded();
                    if (this.prevWriteIndex < minIndex) {
                        minIndex = this.prevWriteIndex;
                    }
                    if (this.prevWriteIndex > maxIndex) {
                        maxIndex = this.prevWriteIndex;
                    }
                }
            }
        }
        if (nwc > 0 && (flushing || nwc >= this.NWC)) {
            int commitOffset = minIndex * this.rsize + this.bufferList[minIndex].minOffset;
            int commitLength = maxIndex * this.rsize + this.bufferList[maxIndex].maxOffset - commitOffset;
            long verf = this.commit(commitOffset, commitLength);
            for (int i = minIndex; i <= maxIndex; ++i) {
                Buffer b3 = this.bufferList[i];
                if (b3 == null) continue;
                if (flushing) {
                    b3.waitUnloaded();
                }
                if (b3.status != 3) continue;
                if (b3.writeVerifier == verf) {
                    if (i == this.prevReadIndex || i == this.prevWriteIndex) {
                        b3.status = 1;
                        continue;
                    }
                    this.bufferList[i] = null;
                    b3.exit();
                    continue;
                }
                if (flushing) {
                    b3.startUnload(2);
                    b3.waitUnloaded();
                    continue;
                }
                b3.startUnload(0);
            }
        }
    }

    public synchronized void flush() throws IOException {
        if (this.prevWriteIndex >= 0) {
            this.checkCommit(true);
        }
    }

    public synchronized void close() throws IOException {
        boolean n = false;
        if (this.bufferList == null) {
            return;
        }
        this.flush();
        for (int i = 0; i < this.bufferList.length; ++i) {
            if (this.bufferList[i] == null) continue;
            Buffer b = this.bufferList[i];
            this.bufferList[i] = null;
            b.exit();
        }
        this.prevReadIndex = -1;
        this.prevWriteIndex = -1;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    public String toString() {
        try {
            if (this.isSymlink()) {
                if (this.symlink != null) {
                    return "\"" + this.name + "\": symlink -> \"" + this.symlink + "\"";
                }
                return "\"" + this.name + "\": symlink";
            }
            if (this.isDirectory()) {
                String s = "\":" + this.name + "\" directory";
                if (this.dircache != null) {
                    return s + "(" + this.dircache.length + " entries)";
                }
                return s;
            }
            return "\"" + this.name + "\": file (" + this.length() + " bytes)";
        }
        catch (IOException e) {
            return e.getMessage();
        }
    }
}

