/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.DERParser;
import com.sun.gssapi.GSSException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class Oid {
    private Vector m_v;
    byte[] m_der;

    static Oid getFromDEROctets(InputStream is, int len) throws GSSException {
        return new Oid(DERParser.decodeOidOctets(is, len));
    }

    private Oid(Vector v) {
        this.m_v = v;
    }

    public Oid(String strOid) throws GSSException {
        this.m_v = new Vector(8, 3);
        this.parseFromStr(strOid);
    }

    public Oid(InputStream derOid) throws GSSException {
        this.m_v = DERParser.decodeOid(derOid);
    }

    public Oid(byte[] data, int offset) throws GSSException {
        this.m_v = DERParser.decodeOid(new ByteArrayInputStream(data, offset, data.length - offset));
    }

    public Oid(byte[] DEROid) throws GSSException {
        this.m_v = DERParser.decodeOid(new ByteArrayInputStream(DEROid));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(50);
        if (this.m_v.size() < 1) {
            return new String("");
        }
        Enumeration e = this.m_v.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement().toString());
            if (!e.hasMoreElements()) continue;
            sb.append(".");
        }
        return sb.toString();
    }

    public String toRFC2078String() {
        StringBuffer sb = new StringBuffer(50);
        if (this.m_v.size() < 1) {
            return new String("");
        }
        sb.append("{ ");
        Enumeration e = this.m_v.elements();
        while (e.hasMoreElements()) {
            sb.append(e.nextElement().toString());
            sb.append(" ");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object Obj) {
        if (!(Obj instanceof Oid)) {
            return false;
        }
        if (this == Obj) {
            return true;
        }
        Oid anOid = (Oid)Obj;
        if (this.m_v.size() != anOid.m_v.size()) {
            return false;
        }
        Enumeration e1 = this.m_v.elements();
        Enumeration e2 = anOid.m_v.elements();
        while (e1.hasMoreElements()) {
            if (e1.nextElement().equals(e2.nextElement())) continue;
            return false;
        }
        return true;
    }

    public byte[] getDER() throws GSSException {
        if (this.m_der != null) {
            return this.m_der;
        }
        this.m_der = DERParser.encodeOid(this.m_v);
        return this.m_der;
    }

    public boolean containedIn(Oid[] oids) {
        for (int i = 0; i < oids.length; ++i) {
            if (!oids[i].equals(this)) continue;
            return true;
        }
        return false;
    }

    private void parseFromStr(String src) throws GSSException {
        int firstIndex = src.indexOf("{");
        try {
            if (firstIndex != -1) {
                src = src.substring(firstIndex, src.lastIndexOf("}"));
            }
            StringTokenizer st = new StringTokenizer(src, " .");
            while (st.hasMoreTokens()) {
                this.m_v.addElement(new Integer(st.nextToken()));
            }
        }
        catch (Exception e) {
            throw new GSSException(11);
        }
    }
}

