/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gssapi;

import com.sun.gssapi.C018FE95;
import com.sun.gssapi.ChannelBinding;
import com.sun.gssapi.DERParser;
import com.sun.gssapi.GSSCredSpi;
import com.sun.gssapi.GSSCredential;
import com.sun.gssapi.GSSException;
import com.sun.gssapi.GSSManager;
import com.sun.gssapi.GSSName;
import com.sun.gssapi.MessageProp;
import com.sun.gssapi.Oid;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GSSContext {
    public static final int INDEFINITE = Integer.MAX_VALUE;
    public static final int COMPLETE = 0;
    public static final int CONTINUE_NEEDED = 1;
    public static final int CRED_DELEG = 1;
    public static final int MUTUAL_AUTH = 2;
    public static final int REPLAY_DET = 4;
    public static final int SEQUENCE_DET = 8;
    public static final int ANON = 16;
    public static final int CONF = 32;
    public static final int INTG = 64;
    public static final int TRANS = 128;
    private static final int PRE_INIT = 1;
    private static final int IN_PROGRESS = 2;
    private static final int READY = 3;
    private static final int DELETED = 4;
    private C018FE95 m_mechCtxt;
    private int m_reqFlags;
    private GSSCredential m_myCred;
    private int m_reqLifetime;
    private int m_curState;
    private Oid m_mechOid;
    private GSSName m_targName;
    private ChannelBinding m_chB;

    public GSSContext(GSSName peer, Oid mechOid, GSSCredential myCred, int lifetime) throws GSSException {
        this.initialize();
        this.m_myCred = myCred;
        this.m_reqLifetime = lifetime;
        this.m_targName = peer;
        this.m_mechOid = mechOid == null ? GSSManager.getDefaultMech() : mechOid;
    }

    public GSSContext(GSSCredential myCred) throws GSSException {
        this.initialize();
        this.m_myCred = myCred;
    }

    public GSSContext(byte[] interProcessToken) throws GSSException {
        this.initialize();
        try {
            int length = interProcessToken[0] & 0xFF;
            for (int i = 1; i < 4; ++i) {
                length <<= 8;
                length += interProcessToken[i] & 0xFF;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(interProcessToken);
            this.m_mechCtxt = GSSManager._M4092FBA(Oid.getFromDEROctets(is, length));
            this.m_mechCtxt._S0AC8F9E(interProcessToken);
            this.m_curState = 3;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GSSException(10);
        }
    }

    public byte[] init(byte[] inputBuf, int offset, int length) throws GSSException {
        ByteArrayInputStream is = null;
        if (inputBuf != null) {
            is = new ByteArrayInputStream(inputBuf, offset, length);
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.init(is, os);
        if (os.size() == 0) {
            return null;
        }
        return os.toByteArray();
    }

    public int init(InputStream inputBuf, OutputStream outputBuf) throws GSSException {
        if (this.m_mechCtxt == null) {
            this.m_mechCtxt = GSSManager._M4092FBA(this.m_mechOid);
            GSSCredSpi mechCred = null;
            if (this.m_myCred != null) {
                mechCred = this.m_myCred.getMechCred(this.m_mechOid, true);
            }
            this.m_mechCtxt._S235D9C1(mechCred, this.m_targName.canonicalizeInPlace(this.m_mechOid), this.m_reqLifetime, this.m_reqFlags);
            if (this.m_chB != null) {
                this.m_mechCtxt._S9B00AB2(this.m_chB);
            }
            this.m_curState = 2;
        }
        if (this.m_curState != 2) {
            throw new GSSException(11, -1, "wrong status in init");
        }
        int retStatus = this.m_mechCtxt._S0E039DB(inputBuf, outputBuf);
        if (retStatus == 0) {
            this.m_curState = 3;
        }
        return retStatus;
    }

    public byte[] accept(byte[] inTok, int offset, int length) throws GSSException {
        ByteArrayInputStream is = new ByteArrayInputStream(inTok, offset, length);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.accept(is, os);
        if (os.size() == 0) {
            return null;
        }
        return os.toByteArray();
    }

    public int accept(InputStream inputBuf, OutputStream outputBuf) throws GSSException {
        if (this.m_mechCtxt == null) {
            Oid mechOid = this.getTokenMech(inputBuf);
            this.m_mechCtxt = GSSManager._M4092FBA(mechOid);
            if (this.m_myCred != null) {
                this.m_mechCtxt._S90010CC(this.m_myCred.getMechCred(mechOid, true));
            }
            if (this.m_chB != null) {
                this.m_mechCtxt._S9B00AB2(this.m_chB);
            }
            this.m_curState = 2;
        }
        if (this.m_curState != 2) {
            throw new GSSException(11, -1, "wrong status in accept");
        }
        int retStatus = this.m_mechCtxt._S80A2F2C(inputBuf, outputBuf);
        if (retStatus == 0) {
            this.m_curState = 3;
        }
        return retStatus;
    }

    public boolean isEstablished() {
        return this.m_curState == 3;
    }

    public void dispose() throws GSSException {
        this.checkState(2);
        this.m_mechCtxt._S020B957();
        this.m_curState = 4;
    }

    public int getWrapSizeLimit(int qop, boolean confReq, int maxTokenSize) throws GSSException {
        this.checkState(3);
        return this.m_mechCtxt._S808028B(qop, confReq, maxTokenSize);
    }

    public byte[] wrap(byte[] inBuf, int offset, int length, MessageProp msgProp) throws GSSException {
        throw new GSSException(11);
    }

    public void wrap(InputStream inBuf, OutputStream outBuf, MessageProp msgProp) throws GSSException {
        throw new GSSException(11);
    }

    public byte[] unwrap(byte[] inBuf, int offset, int length, MessageProp msgProp) throws GSSException {
        throw new GSSException(11);
    }

    public void unwrap(InputStream inBuf, OutputStream outBuf, MessageProp msgProp) throws GSSException {
        throw new GSSException(11);
    }

    public byte[] getMIC(byte[] inMsg, int offset, int length, MessageProp msgProp) throws GSSException {
        ByteArrayInputStream is = new ByteArrayInputStream(inMsg, offset, length);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.getMIC(is, os, msgProp);
        return os.toByteArray();
    }

    public void getMIC(InputStream inBuf, OutputStream outBuf, MessageProp msgProp) throws GSSException {
        msgProp.resetStatusValues();
        this.checkState(3);
        this.m_mechCtxt._S1513DBA(inBuf, outBuf, msgProp);
    }

    public void verifyMIC(byte[] inTok, int tokOffset, int tokLen, byte[] inMsg, int msgOffset, int msgLen, MessageProp msgProp) throws GSSException {
        ByteArrayInputStream sTok = new ByteArrayInputStream(inTok, tokOffset, tokLen);
        ByteArrayInputStream sMsg = new ByteArrayInputStream(inMsg, msgOffset, msgLen);
        this.verifyMIC(sTok, sMsg, msgProp);
    }

    public void verifyMIC(InputStream inTok, InputStream inMsg, MessageProp msgProp) throws GSSException {
        msgProp.resetStatusValues();
        this.checkState(3);
        this.m_mechCtxt._S00256CF(inTok, inMsg, msgProp);
    }

    public byte[] export() throws GSSException {
        this.checkState(3);
        byte[] outTok = this.m_mechCtxt._S725B2DA();
        this.dispose();
        return outTok;
    }

    public void requestMutualAuth(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 2) : (this.m_reqFlags ^= 2);
    }

    public void requestReplayDet(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 4) : (this.m_reqFlags ^= 4);
    }

    public void requestSequenceDet(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 8) : (this.m_reqFlags ^= 8);
    }

    public void requestCredDeleg(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 1) : (this.m_reqFlags ^= 1);
    }

    public void requestAnonymity(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 0x10) : (this.m_reqFlags ^= 0x10);
    }

    public void requestConf(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 0x20) : (this.m_reqFlags ^= 0x20);
    }

    public void requestInteg(boolean state) throws GSSException {
        this.checkState(1);
        this.m_reqFlags = state ? (this.m_reqFlags |= 0x40) : (this.m_reqFlags ^= 0x40);
    }

    public void requestLifetime(int lifetime) throws GSSException {
        this.checkState(1);
        this.m_reqLifetime = lifetime;
    }

    public void setChannelBinding(ChannelBinding cb) throws GSSException {
        this.checkState(1);
        this.m_chB = cb;
    }

    public boolean getDelegCredState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 1) == 1;
        }
        return (this.m_mechCtxt._S00027C3() & 1) == 1;
    }

    public boolean getMutualAuthState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 2) == 2;
        }
        return (this.m_mechCtxt._S00027C3() & 2) == 2;
    }

    public boolean getReplayDetState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 4) == 4;
        }
        return (this.m_mechCtxt._S00027C3() & 4) == 4;
    }

    public boolean getSequenceDetState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 8) == 8;
        }
        return (this.m_mechCtxt._S00027C3() & 8) == 8;
    }

    public boolean getAnonymityState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 0x10) == 16;
        }
        return (this.m_mechCtxt._S00027C3() & 0x10) == 16;
    }

    public boolean isTransferable() throws GSSException {
        this.checkState(3);
        return (this.m_mechCtxt._S00027C3() & 0x80) == 128;
    }

    public boolean isProtReady() {
        if (this.m_mechCtxt == null) {
            return false;
        }
        return this.m_mechCtxt._S1116FAA();
    }

    public boolean getConfState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 0x20) == 32;
        }
        return (this.m_mechCtxt._S00027C3() & 0x20) == 32;
    }

    public boolean getIntegState() {
        if (this.m_curState < 3) {
            return (this.m_reqFlags & 0x40) == 64;
        }
        return (this.m_mechCtxt._S00027C3() & 0x40) == 64;
    }

    public int getLifetime() {
        if (this.m_curState < 3) {
            return this.m_reqLifetime;
        }
        return this.m_mechCtxt._S4080EED();
    }

    public GSSName getSrcName() throws GSSException {
        this.checkState(2);
        return new GSSName(this.m_mechCtxt._S000EEFF());
    }

    public GSSName getTargName() throws GSSException {
        this.checkState(2);
        return new GSSName(this.m_mechCtxt._S011CEF9());
    }

    public Oid getMech() throws GSSException {
        this.checkState(2);
        return this.m_mechCtxt._S0200735();
    }

    public GSSCredential getDelegCred() throws GSSException {
        this.checkState(2);
        return new GSSCredential(this.m_mechCtxt._S0293FFA());
    }

    public boolean isInitiator() throws GSSException {
        this.checkState(2);
        return this.m_mechCtxt._S123049E();
    }

    private void checkState(int minimumState) throws GSSException {
        if (this.m_curState < minimumState) {
            throw new GSSException(12);
        }
        if (minimumState > 1 && this.m_mechCtxt == null) {
            throw new GSSException(12, -1, "error in checkState");
        }
    }

    private void initialize() {
        this.m_reqFlags = 14;
        this.m_myCred = null;
        this.m_reqLifetime = Integer.MAX_VALUE;
        this.m_curState = 1;
        this.m_mechOid = null;
        this.m_targName = null;
        this.m_chB = null;
    }

    private Oid getTokenMech(InputStream is) throws GSSException {
        try {
            is.mark(100);
            if (is.read() != 96) {
                throw new GSSException(10);
            }
            DERParser.readLength(is);
            Oid res = new Oid(is);
            is.reset();
            return res;
        }
        catch (IOException e) {
            throw new GSSException(10);
        }
    }
}

